% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitsort.R
\name{bit_sort}
\alias{bit_sort}
\title{bit sort}
\usage{
bit_sort(x, decreasing = FALSE, na.last = NA, has.dup = TRUE)
}
\arguments{
\item{x}{an integer vector}

\item{decreasing}{(currently only \code{FALSE} is supported)}

\item{na.last}{\code{NA} removes NAs, \code{FALSE} puts NAs at the beginning,
\code{TRUE} puts NAs at the end}

\item{has.dup}{TRUE (the default) assumes that \code{x} might have
duplicates, set to \code{FALSE} if duplicates are impossible}
}
\value{
a sorted vector
}
\description{
fast sorting of integers
}
\details{
determines the range of the integers and checks if the density justifies use
of a bit vector; if yes, sorts the first occurences of each integer in the
range using a bit vector, sorts the rest and merges; if no, falls back to quicksort.
}
\examples{
bit_sort(c(2L, 1L, NA, NA, 1L, 2L))
bit_sort(c(2L, 1L, NA, NA, 1L, 2L), na.last=FALSE)
bit_sort(c(2L, 1L, NA, NA, 1L, 2L), na.last=TRUE)

\dontrun{
x <- sample(1e7, replace=TRUE)
system.time(bit_sort(x))
system.time(sort(x))
}
}
\seealso{
\code{\link[=sort]{sort()}}, \code{\link[=ramsort]{ramsort()}},
\code{\link[=bit_sort_unique]{bit_sort_unique()}}
}
