% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_methods.R
\name{get_factors}
\alias{get_factors}
\title{Get factors}
\usage{
get_factors(
  object,
  groups = "all",
  factors = "all",
  scale = FALSE,
  as.data.frame = FALSE
)
}
\arguments{
\item{object}{a trained \code{\link{MOFA}} object.}

\item{groups}{character vector with the group name(s), or numeric vector with the group index(es).
Default is "all".}

\item{factors}{character vector with the factor name(s), or numeric vector with the factor index(es).
Default is "all".}

\item{scale}{logical indicating whether to scale factor values.}

\item{as.data.frame}{logical indicating whether to return a long data frame instead of a matrix.
Default is \code{FALSE}.}
}
\value{
By default it returns the latent factor matrix of dimensionality (N,K), where N is number of samples and K is number of factors. \cr
Alternatively, if \code{as.data.frame} is \code{TRUE}, returns a long-formatted data frame with columns (sample,factor,value).
}
\description{
Extract the latent factors from the model.
}
\examples{
# Using an existing trained model on simulated data
file <- system.file("extdata", "model.hdf5", package = "MOFA2")
model <- load_model(file)

# Fetch factors in matrix format (a list, one matrix per group)
factors <- get_factors(model)

# Concatenate groups
factors <- do.call("rbind",factors)

# Fetch factors in data.frame format instead of matrix format
factors <- get_factors(model, as.data.frame = TRUE)
}
