# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class ActivationLinks(_serialization.Model):
    """Activation Links model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar new_cloud_account_activation_link: New Cloud Account Activation Link.
    :vartype new_cloud_account_activation_link: str
    :ivar existing_cloud_account_activation_link: Existing Cloud Account Activation Link.
    :vartype existing_cloud_account_activation_link: str
    """

    _validation = {
        "new_cloud_account_activation_link": {"readonly": True},
        "existing_cloud_account_activation_link": {"readonly": True},
    }

    _attribute_map = {
        "new_cloud_account_activation_link": {"key": "newCloudAccountActivationLink", "type": "str"},
        "existing_cloud_account_activation_link": {"key": "existingCloudAccountActivationLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.new_cloud_account_activation_link = None
        self.existing_cloud_account_activation_link = None


class AddRemoveDbNode(_serialization.Model):
    """Add/Remove (Virtual Machine) DbNode model.

    All required parameters must be populated in order to send to server.

    :ivar db_servers: Db servers ocids. Required.
    :vartype db_servers: list[str]
    """

    _validation = {
        "db_servers": {"required": True},
    }

    _attribute_map = {
        "db_servers": {"key": "dbServers", "type": "[str]"},
    }

    def __init__(self, *, db_servers: List[str], **kwargs: Any) -> None:
        """
        :keyword db_servers: Db servers ocids. Required.
        :paramtype db_servers: list[str]
        """
        super().__init__(**kwargs)
        self.db_servers = db_servers


class AllConnectionStringType(_serialization.Model):
    """The connection string profile to allow clients to group, filter and select connection string
    values based on structured metadata.

    :ivar high: The High database service provides the highest level of resources to each SQL
     statement resulting in the highest performance, but supports the fewest number of concurrent
     SQL statements.
    :vartype high: str
    :ivar low: The Low database service provides the least level of resources to each SQL
     statement, but supports the most number of concurrent SQL statements.
    :vartype low: str
    :ivar medium: The Medium database service provides a lower level of resources to each SQL
     statement potentially resulting a lower level of performance, but supports more concurrent SQL
     statements.
    :vartype medium: str
    """

    _validation = {
        "high": {"max_length": 255, "min_length": 10},
        "low": {"max_length": 255, "min_length": 10},
        "medium": {"max_length": 255, "min_length": 10},
    }

    _attribute_map = {
        "high": {"key": "high", "type": "str"},
        "low": {"key": "low", "type": "str"},
        "medium": {"key": "medium", "type": "str"},
    }

    def __init__(
        self, *, high: Optional[str] = None, low: Optional[str] = None, medium: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword high: The High database service provides the highest level of resources to each SQL
         statement resulting in the highest performance, but supports the fewest number of concurrent
         SQL statements.
        :paramtype high: str
        :keyword low: The Low database service provides the least level of resources to each SQL
         statement, but supports the most number of concurrent SQL statements.
        :paramtype low: str
        :keyword medium: The Medium database service provides a lower level of resources to each SQL
         statement potentially resulting a lower level of performance, but supports more concurrent SQL
         statements.
        :paramtype medium: str
        """
        super().__init__(**kwargs)
        self.high = high
        self.low = low
        self.medium = medium


class ApexDetailsType(_serialization.Model):
    """Information about Oracle APEX Application Development.

    :ivar apex_version: The Oracle APEX Application Development version.
    :vartype apex_version: str
    :ivar ords_version: The Oracle REST Data Services (ORDS) version.
    :vartype ords_version: str
    """

    _attribute_map = {
        "apex_version": {"key": "apexVersion", "type": "str"},
        "ords_version": {"key": "ordsVersion", "type": "str"},
    }

    def __init__(
        self, *, apex_version: Optional[str] = None, ords_version: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword apex_version: The Oracle APEX Application Development version.
        :paramtype apex_version: str
        :keyword ords_version: The Oracle REST Data Services (ORDS) version.
        :paramtype ords_version: str
        """
        super().__init__(**kwargs)
        self.apex_version = apex_version
        self.ords_version = ords_version


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class AutonomousDatabase(TrackedResource):
    """Autonomous Database  resource model.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.AutonomousDatabaseBaseProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "AutonomousDatabaseBaseProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.AutonomousDatabaseBaseProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.oracledatabase.models.AutonomousDatabaseBaseProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    """


class AutonomousDatabaseBackup(ProxyResource):
    """AutonomousDatabaseBackup resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.AutonomousDatabaseBackupProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "AutonomousDatabaseBackupProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.AutonomousDatabaseBackupProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.oracledatabase.models.AutonomousDatabaseBackupProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class AutonomousDatabaseBackupListResult(_serialization.Model):
    """The response of a AutonomousDatabaseBackup list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The AutonomousDatabaseBackup items on this page. Required.
    :vartype value: list[~azure.mgmt.oracledatabase.models.AutonomousDatabaseBackup]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AutonomousDatabaseBackup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.AutonomousDatabaseBackup"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The AutonomousDatabaseBackup items on this page. Required.
        :paramtype value: list[~azure.mgmt.oracledatabase.models.AutonomousDatabaseBackup]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AutonomousDatabaseBackupProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """AutonomousDatabaseBackup resource model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar autonomous_database_ocid: The OCID of the Autonomous Database.
    :vartype autonomous_database_ocid: str
    :ivar database_size_in_tbs: The size of the database in terabytes at the time the backup was
     taken.
    :vartype database_size_in_tbs: float
    :ivar db_version: A valid Oracle Database version for Autonomous Database.
    :vartype db_version: str
    :ivar display_name: The user-friendly name for the backup. The name does not have to be unique.
    :vartype display_name: str
    :ivar ocid: The OCID of the Autonomous Database backup.
    :vartype ocid: str
    :ivar is_automatic: Indicates whether the backup is user-initiated or automatic.
    :vartype is_automatic: bool
    :ivar is_restorable: Indicates whether the backup can be used to restore the associated
     Autonomous Database.
    :vartype is_restorable: bool
    :ivar lifecycle_details: Additional information about the current lifecycle state.
    :vartype lifecycle_details: str
    :ivar lifecycle_state: The current state of the backup. Known values are: "Creating", "Active",
     "Deleting", "Failed", and "Updating".
    :vartype lifecycle_state: str or
     ~azure.mgmt.oracledatabase.models.AutonomousDatabaseBackupLifecycleState
    :ivar retention_period_in_days: Retention period, in days, for long-term backups.
    :vartype retention_period_in_days: int
    :ivar size_in_tbs: The backup size in terabytes (TB).
    :vartype size_in_tbs: float
    :ivar time_available_til: Timestamp until when the backup will be available.
    :vartype time_available_til: ~datetime.datetime
    :ivar time_started: The date and time the backup started.
    :vartype time_started: str
    :ivar time_ended: The date and time the backup completed.
    :vartype time_ended: str
    :ivar backup_type: The type of backup. Known values are: "Incremental", "Full", and "LongTerm".
    :vartype backup_type: str or ~azure.mgmt.oracledatabase.models.AutonomousDatabaseBackupType
    :ivar provisioning_state: Azure resource provisioning state. Known values are: "Succeeded",
     "Failed", "Canceled", and "Provisioning".
    :vartype provisioning_state: str or
     ~azure.mgmt.oracledatabase.models.AzureResourceProvisioningState
    """

    _validation = {
        "autonomous_database_ocid": {"readonly": True, "max_length": 255, "min_length": 1},
        "database_size_in_tbs": {"readonly": True},
        "db_version": {"readonly": True},
        "ocid": {"readonly": True, "max_length": 255, "min_length": 1},
        "is_automatic": {"readonly": True},
        "is_restorable": {"readonly": True},
        "lifecycle_details": {"readonly": True},
        "lifecycle_state": {"readonly": True},
        "retention_period_in_days": {"maximum": 3650, "minimum": 60},
        "size_in_tbs": {"readonly": True},
        "time_available_til": {"readonly": True},
        "time_started": {"readonly": True},
        "time_ended": {"readonly": True},
        "backup_type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "autonomous_database_ocid": {"key": "autonomousDatabaseOcid", "type": "str"},
        "database_size_in_tbs": {"key": "databaseSizeInTbs", "type": "float"},
        "db_version": {"key": "dbVersion", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "ocid": {"key": "ocid", "type": "str"},
        "is_automatic": {"key": "isAutomatic", "type": "bool"},
        "is_restorable": {"key": "isRestorable", "type": "bool"},
        "lifecycle_details": {"key": "lifecycleDetails", "type": "str"},
        "lifecycle_state": {"key": "lifecycleState", "type": "str"},
        "retention_period_in_days": {"key": "retentionPeriodInDays", "type": "int"},
        "size_in_tbs": {"key": "sizeInTbs", "type": "float"},
        "time_available_til": {"key": "timeAvailableTil", "type": "iso-8601"},
        "time_started": {"key": "timeStarted", "type": "str"},
        "time_ended": {"key": "timeEnded", "type": "str"},
        "backup_type": {"key": "backupType", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self, *, display_name: Optional[str] = None, retention_period_in_days: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword display_name: The user-friendly name for the backup. The name does not have to be
         unique.
        :paramtype display_name: str
        :keyword retention_period_in_days: Retention period, in days, for long-term backups.
        :paramtype retention_period_in_days: int
        """
        super().__init__(**kwargs)
        self.autonomous_database_ocid = None
        self.database_size_in_tbs = None
        self.db_version = None
        self.display_name = display_name
        self.ocid = None
        self.is_automatic = None
        self.is_restorable = None
        self.lifecycle_details = None
        self.lifecycle_state = None
        self.retention_period_in_days = retention_period_in_days
        self.size_in_tbs = None
        self.time_available_til = None
        self.time_started = None
        self.time_ended = None
        self.backup_type = None
        self.provisioning_state = None


class AutonomousDatabaseBackupUpdate(_serialization.Model):
    """The type used for update operations of the AutonomousDatabaseBackup.

    :ivar properties: The updatable properties of the AutonomousDatabaseBackup.
    :vartype properties: ~azure.mgmt.oracledatabase.models.AutonomousDatabaseBackupUpdateProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "AutonomousDatabaseBackupUpdateProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.AutonomousDatabaseBackupUpdateProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: The updatable properties of the AutonomousDatabaseBackup.
        :paramtype properties:
         ~azure.mgmt.oracledatabase.models.AutonomousDatabaseBackupUpdateProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class AutonomousDatabaseBackupUpdateProperties(_serialization.Model):
    """The updatable properties of the AutonomousDatabaseBackup.

    :ivar retention_period_in_days: Retention period, in days, for long-term backups.
    :vartype retention_period_in_days: int
    """

    _validation = {
        "retention_period_in_days": {"maximum": 3650, "minimum": 60},
    }

    _attribute_map = {
        "retention_period_in_days": {"key": "retentionPeriodInDays", "type": "int"},
    }

    def __init__(self, *, retention_period_in_days: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword retention_period_in_days: Retention period, in days, for long-term backups.
        :paramtype retention_period_in_days: int
        """
        super().__init__(**kwargs)
        self.retention_period_in_days = retention_period_in_days


class AutonomousDatabaseBaseProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Autonomous Database base resource model.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AutonomousDatabaseCloneProperties, AutonomousDatabaseProperties

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar admin_password: Admin password.
    :vartype admin_password: str
    :ivar data_base_type: Database type to be created. Required. Known values are: "Regular" and
     "Clone".
    :vartype data_base_type: str or ~azure.mgmt.oracledatabase.models.DataBaseType
    :ivar autonomous_maintenance_schedule_type: The maintenance schedule type of the Autonomous
     Database Serverless. Known values are: "Early" and "Regular".
    :vartype autonomous_maintenance_schedule_type: str or
     ~azure.mgmt.oracledatabase.models.AutonomousMaintenanceScheduleType
    :ivar character_set: The character set for the autonomous database.
    :vartype character_set: str
    :ivar compute_count: The compute amount (CPUs) available to the database.
    :vartype compute_count: float
    :ivar compute_model: The compute model of the Autonomous Database. Known values are: "ECPU" and
     "OCPU".
    :vartype compute_model: str or ~azure.mgmt.oracledatabase.models.ComputeModel
    :ivar cpu_core_count: The number of CPU cores to be made available to the database.
    :vartype cpu_core_count: int
    :ivar customer_contacts: Customer Contacts.
    :vartype customer_contacts: list[~azure.mgmt.oracledatabase.models.CustomerContact]
    :ivar data_storage_size_in_tbs: The quantity of data in the database, in terabytes.
    :vartype data_storage_size_in_tbs: int
    :ivar data_storage_size_in_gbs: The size, in gigabytes, of the data volume that will be created
     and attached to the database.
    :vartype data_storage_size_in_gbs: int
    :ivar db_version: A valid Oracle Database version for Autonomous Database.
    :vartype db_version: str
    :ivar db_workload: The Autonomous Database workload type. Known values are: "OLTP", "DW",
     "AJD", and "APEX".
    :vartype db_workload: str or ~azure.mgmt.oracledatabase.models.WorkloadType
    :ivar display_name: The user-friendly name for the Autonomous Database.
    :vartype display_name: str
    :ivar is_auto_scaling_enabled: Indicates if auto scaling is enabled for the Autonomous Database
     CPU core count.
    :vartype is_auto_scaling_enabled: bool
    :ivar is_auto_scaling_for_storage_enabled: Indicates if auto scaling is enabled for the
     Autonomous Database storage.
    :vartype is_auto_scaling_for_storage_enabled: bool
    :ivar peer_db_ids: The list of `OCIDs
     <https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm>`_ of standby databases
     located in Autonomous Data Guard remote regions that are associated with the source database.
     Note that for Autonomous Database Serverless instances, standby databases located in the same
     region as the source primary database do not have OCIDs.
    :vartype peer_db_ids: list[str]
    :ivar peer_db_id: The database OCID of the Disaster Recovery peer database, which is located in
     a different region from the current peer database.
    :vartype peer_db_id: str
    :ivar is_local_data_guard_enabled: Indicates whether the Autonomous Database has local or
     called in-region Data Guard enabled.
    :vartype is_local_data_guard_enabled: bool
    :ivar is_remote_data_guard_enabled: Indicates whether the Autonomous Database has Cross Region
     Data Guard enabled.
    :vartype is_remote_data_guard_enabled: bool
    :ivar local_disaster_recovery_type: Indicates the local disaster recovery (DR) type of the
     Autonomous Database Serverless instance.Autonomous Data Guard (ADG) DR type provides business
     critical DR with a faster recovery time objective (RTO) during failover or
     switchover.Backup-based DR type provides lower cost DR with a slower RTO during failover or
     switchover. Known values are: "Adg" and "BackupBased".
    :vartype local_disaster_recovery_type: str or
     ~azure.mgmt.oracledatabase.models.DisasterRecoveryType
    :ivar local_standby_db: Local Autonomous Disaster Recovery standby database details.
    :vartype local_standby_db: ~azure.mgmt.oracledatabase.models.AutonomousDatabaseStandbySummary
    :ivar failed_data_recovery_in_seconds: Indicates the number of seconds of data loss for a Data
     Guard failover.
    :vartype failed_data_recovery_in_seconds: int
    :ivar is_mtls_connection_required: Specifies if the Autonomous Database requires mTLS
     connections.
    :vartype is_mtls_connection_required: bool
    :ivar is_preview_version_with_service_terms_accepted: Specifies if the Autonomous Database
     preview version is being provisioned.
    :vartype is_preview_version_with_service_terms_accepted: bool
    :ivar license_model: The Oracle license model that applies to the Oracle Autonomous Database.
     The default is LICENSE_INCLUDED. Known values are: "LicenseIncluded" and "BringYourOwnLicense".
    :vartype license_model: str or ~azure.mgmt.oracledatabase.models.LicenseModel
    :ivar ncharacter_set: The character set for the Autonomous Database.
    :vartype ncharacter_set: str
    :ivar lifecycle_details: Additional information about the current lifecycle state.
    :vartype lifecycle_details: str
    :ivar provisioning_state: Azure resource provisioning state. Known values are: "Succeeded",
     "Failed", "Canceled", and "Provisioning".
    :vartype provisioning_state: str or
     ~azure.mgmt.oracledatabase.models.AzureResourceProvisioningState
    :ivar lifecycle_state: Views lifecycleState. Known values are: "Provisioning", "Available",
     "Stopping", "Stopped", "Starting", "Terminating", "Terminated", "Unavailable",
     "RestoreInProgress", "RestoreFailed", "BackupInProgress", "ScaleInProgress",
     "AvailableNeedsAttention", "Updating", "MaintenanceInProgress", "Restarting", "Recreating",
     "RoleChangeInProgress", "Upgrading", "Inaccessible", and "Standby".
    :vartype lifecycle_state: str or
     ~azure.mgmt.oracledatabase.models.AutonomousDatabaseLifecycleState
    :ivar scheduled_operations: The list of scheduled operations.
    :vartype scheduled_operations: ~azure.mgmt.oracledatabase.models.ScheduledOperationsType
    :ivar private_endpoint_ip: The private endpoint Ip address for the resource.
    :vartype private_endpoint_ip: str
    :ivar private_endpoint_label: The resource's private endpoint label.
    :vartype private_endpoint_label: str
    :ivar oci_url: HTTPS link to OCI resources exposed to Azure Customer via Azure Interface.
    :vartype oci_url: str
    :ivar subnet_id: Client subnet.
    :vartype subnet_id: str
    :ivar vnet_id: VNET for network connectivity.
    :vartype vnet_id: str
    :ivar time_created: The date and time that the database was created.
    :vartype time_created: ~datetime.datetime
    :ivar time_maintenance_begin: The date and time when maintenance will begin.
    :vartype time_maintenance_begin: ~datetime.datetime
    :ivar time_maintenance_end: The date and time when maintenance will end.
    :vartype time_maintenance_end: ~datetime.datetime
    :ivar actual_used_data_storage_size_in_tbs: The current amount of storage in use for user and
     system data, in terabytes (TB).
    :vartype actual_used_data_storage_size_in_tbs: float
    :ivar allocated_storage_size_in_tbs: The amount of storage currently allocated for the database
     tables and billed for, rounded up.
    :vartype allocated_storage_size_in_tbs: float
    :ivar apex_details: Information about Oracle APEX Application Development.
    :vartype apex_details: ~azure.mgmt.oracledatabase.models.ApexDetailsType
    :ivar available_upgrade_versions: List of Oracle Database versions available for a database
     upgrade. If there are no version upgrades available, this list is empty.
    :vartype available_upgrade_versions: list[str]
    :ivar connection_strings: The connection string used to connect to the Autonomous Database.
    :vartype connection_strings: ~azure.mgmt.oracledatabase.models.ConnectionStringType
    :ivar connection_urls: The URLs for accessing Oracle Application Express (APEX) and SQL
     Developer Web with a browser from a Compute instance within your VCN or that has a direct
     connection to your VCN.
    :vartype connection_urls: ~azure.mgmt.oracledatabase.models.ConnectionUrlType
    :ivar data_safe_status: Status of the Data Safe registration for this Autonomous Database.
     Known values are: "Registering", "Registered", "Deregistering", "NotRegistered", and "Failed".
    :vartype data_safe_status: str or ~azure.mgmt.oracledatabase.models.DataSafeStatusType
    :ivar database_edition: The Oracle Database Edition that applies to the Autonomous databases.
     Known values are: "StandardEdition" and "EnterpriseEdition".
    :vartype database_edition: str or ~azure.mgmt.oracledatabase.models.DatabaseEditionType
    :ivar autonomous_database_id: Autonomous Database ID.
    :vartype autonomous_database_id: str
    :ivar in_memory_area_in_gbs: The area assigned to In-Memory tables in Autonomous Database.
    :vartype in_memory_area_in_gbs: int
    :ivar next_long_term_backup_time_stamp: The date and time when the next long-term backup would
     be created.
    :vartype next_long_term_backup_time_stamp: ~datetime.datetime
    :ivar long_term_backup_schedule: Details for the long-term backup schedule.
    :vartype long_term_backup_schedule:
     ~azure.mgmt.oracledatabase.models.LongTermBackUpScheduleDetails
    :ivar is_preview: Indicates if the Autonomous Database version is a preview version.
    :vartype is_preview: bool
    :ivar local_adg_auto_failover_max_data_loss_limit: Parameter that allows users to select an
     acceptable maximum data loss limit in seconds, up to which Automatic Failover will be triggered
     when necessary for a Local Autonomous Data Guard.
    :vartype local_adg_auto_failover_max_data_loss_limit: int
    :ivar memory_per_oracle_compute_unit_in_gbs: The amount of memory (in GBs) enabled per ECPU or
     OCPU.
    :vartype memory_per_oracle_compute_unit_in_gbs: int
    :ivar open_mode: Indicates the Autonomous Database mode. Known values are: "ReadOnly" and
     "ReadWrite".
    :vartype open_mode: str or ~azure.mgmt.oracledatabase.models.OpenModeType
    :ivar operations_insights_status: Status of Operations Insights for this Autonomous Database.
     Known values are: "Enabling", "Enabled", "Disabling", "NotEnabled", "FailedEnabling", and
     "FailedDisabling".
    :vartype operations_insights_status: str or
     ~azure.mgmt.oracledatabase.models.OperationsInsightsStatusType
    :ivar permission_level: The Autonomous Database permission level. Known values are:
     "Restricted" and "Unrestricted".
    :vartype permission_level: str or ~azure.mgmt.oracledatabase.models.PermissionLevelType
    :ivar private_endpoint: The private endpoint for the resource.
    :vartype private_endpoint: str
    :ivar provisionable_cpus: An array of CPU values that an Autonomous Database can be scaled to.
    :vartype provisionable_cpus: list[int]
    :ivar role: The Data Guard role of the Autonomous Container Database or Autonomous Database, if
     Autonomous Data Guard is enabled. Known values are: "Primary", "Standby", "DisabledStandby",
     "BackupCopy", and "SnapshotStandby".
    :vartype role: str or ~azure.mgmt.oracledatabase.models.RoleType
    :ivar service_console_url: The URL of the Service Console for the Autonomous Database.
    :vartype service_console_url: str
    :ivar sql_web_developer_url: The SQL Web Developer URL for the Oracle Autonomous Database.
    :vartype sql_web_developer_url: str
    :ivar supported_regions_to_clone_to: The list of regions that support the creation of an
     Autonomous Database clone or an Autonomous Data Guard standby database.
    :vartype supported_regions_to_clone_to: list[str]
    :ivar time_data_guard_role_changed: The date and time the Autonomous Data Guard role was
     switched for the Autonomous Database.
    :vartype time_data_guard_role_changed: str
    :ivar time_deletion_of_free_autonomous_database: The date and time the Always Free database
     will be automatically deleted because of inactivity.
    :vartype time_deletion_of_free_autonomous_database: str
    :ivar time_local_data_guard_enabled: The date and time that Autonomous Data Guard was enabled
     for an Autonomous Database where the standby was provisioned in the same region as the primary
     database.
    :vartype time_local_data_guard_enabled: str
    :ivar time_of_last_failover: The timestamp of the last failover operation.
    :vartype time_of_last_failover: str
    :ivar time_of_last_refresh: The date and time when last refresh happened.
    :vartype time_of_last_refresh: str
    :ivar time_of_last_refresh_point: The refresh point timestamp (UTC).
    :vartype time_of_last_refresh_point: str
    :ivar time_of_last_switchover: The timestamp of the last switchover operation for the
     Autonomous Database.
    :vartype time_of_last_switchover: str
    :ivar time_reclamation_of_free_autonomous_database: The date and time the Always Free database
     will be stopped because of inactivity.
    :vartype time_reclamation_of_free_autonomous_database: str
    :ivar used_data_storage_size_in_gbs: The storage space consumed by Autonomous Database in GBs.
    :vartype used_data_storage_size_in_gbs: int
    :ivar used_data_storage_size_in_tbs: The amount of storage that has been used, in terabytes.
    :vartype used_data_storage_size_in_tbs: int
    :ivar ocid: Database ocid.
    :vartype ocid: str
    :ivar backup_retention_period_in_days: Retention period, in days, for long-term backups.
    :vartype backup_retention_period_in_days: int
    :ivar whitelisted_ips: The client IP access control list (ACL). This is an array of CIDR
     notations and/or IP addresses. Values should be separate strings, separated by commas. Example:
     ['1.1.1.1','1.1.1.0/24','1.1.2.25'].
    :vartype whitelisted_ips: list[str]
    """

    _validation = {
        "data_base_type": {"required": True},
        "character_set": {"max_length": 255, "min_length": 1},
        "compute_count": {"maximum": 512, "minimum": 0.1},
        "cpu_core_count": {"maximum": 128, "minimum": 1},
        "data_storage_size_in_tbs": {"maximum": 384, "minimum": 1},
        "data_storage_size_in_gbs": {"maximum": 393216, "minimum": 20},
        "db_version": {"max_length": 255, "min_length": 1},
        "display_name": {"max_length": 255, "min_length": 1},
        "peer_db_ids": {"readonly": True},
        "peer_db_id": {"max_length": 255, "min_length": 1},
        "is_remote_data_guard_enabled": {"readonly": True},
        "local_disaster_recovery_type": {"readonly": True},
        "local_standby_db": {"readonly": True},
        "failed_data_recovery_in_seconds": {"readonly": True},
        "ncharacter_set": {"max_length": 255, "min_length": 1},
        "lifecycle_details": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "lifecycle_state": {"readonly": True},
        "oci_url": {"readonly": True},
        "time_created": {"readonly": True},
        "time_maintenance_begin": {"readonly": True},
        "time_maintenance_end": {"readonly": True},
        "actual_used_data_storage_size_in_tbs": {"readonly": True},
        "allocated_storage_size_in_tbs": {"readonly": True},
        "apex_details": {"readonly": True},
        "available_upgrade_versions": {"readonly": True},
        "connection_strings": {"readonly": True},
        "connection_urls": {"readonly": True},
        "data_safe_status": {"readonly": True},
        "in_memory_area_in_gbs": {"readonly": True},
        "next_long_term_backup_time_stamp": {"readonly": True},
        "is_preview": {"readonly": True},
        "local_adg_auto_failover_max_data_loss_limit": {"maximum": 3600, "minimum": 0},
        "memory_per_oracle_compute_unit_in_gbs": {"readonly": True},
        "operations_insights_status": {"readonly": True},
        "private_endpoint": {"readonly": True},
        "provisionable_cpus": {"readonly": True},
        "service_console_url": {"readonly": True, "max_length": 255, "min_length": 10},
        "sql_web_developer_url": {"readonly": True, "max_length": 2048, "min_length": 10},
        "supported_regions_to_clone_to": {"readonly": True, "max_items": 50, "min_items": 0},
        "time_data_guard_role_changed": {"readonly": True},
        "time_deletion_of_free_autonomous_database": {"readonly": True},
        "time_local_data_guard_enabled": {"readonly": True},
        "time_of_last_failover": {"readonly": True},
        "time_of_last_refresh": {"readonly": True},
        "time_of_last_refresh_point": {"readonly": True},
        "time_of_last_switchover": {"readonly": True},
        "time_reclamation_of_free_autonomous_database": {"readonly": True},
        "used_data_storage_size_in_gbs": {"readonly": True},
        "used_data_storage_size_in_tbs": {"readonly": True},
        "ocid": {"readonly": True, "max_length": 255, "min_length": 1},
    }

    _attribute_map = {
        "admin_password": {"key": "adminPassword", "type": "str"},
        "data_base_type": {"key": "dataBaseType", "type": "str"},
        "autonomous_maintenance_schedule_type": {"key": "autonomousMaintenanceScheduleType", "type": "str"},
        "character_set": {"key": "characterSet", "type": "str"},
        "compute_count": {"key": "computeCount", "type": "float"},
        "compute_model": {"key": "computeModel", "type": "str"},
        "cpu_core_count": {"key": "cpuCoreCount", "type": "int"},
        "customer_contacts": {"key": "customerContacts", "type": "[CustomerContact]"},
        "data_storage_size_in_tbs": {"key": "dataStorageSizeInTbs", "type": "int"},
        "data_storage_size_in_gbs": {"key": "dataStorageSizeInGbs", "type": "int"},
        "db_version": {"key": "dbVersion", "type": "str"},
        "db_workload": {"key": "dbWorkload", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "is_auto_scaling_enabled": {"key": "isAutoScalingEnabled", "type": "bool"},
        "is_auto_scaling_for_storage_enabled": {"key": "isAutoScalingForStorageEnabled", "type": "bool"},
        "peer_db_ids": {"key": "peerDbIds", "type": "[str]"},
        "peer_db_id": {"key": "peerDbId", "type": "str"},
        "is_local_data_guard_enabled": {"key": "isLocalDataGuardEnabled", "type": "bool"},
        "is_remote_data_guard_enabled": {"key": "isRemoteDataGuardEnabled", "type": "bool"},
        "local_disaster_recovery_type": {"key": "localDisasterRecoveryType", "type": "str"},
        "local_standby_db": {"key": "localStandbyDb", "type": "AutonomousDatabaseStandbySummary"},
        "failed_data_recovery_in_seconds": {"key": "failedDataRecoveryInSeconds", "type": "int"},
        "is_mtls_connection_required": {"key": "isMtlsConnectionRequired", "type": "bool"},
        "is_preview_version_with_service_terms_accepted": {
            "key": "isPreviewVersionWithServiceTermsAccepted",
            "type": "bool",
        },
        "license_model": {"key": "licenseModel", "type": "str"},
        "ncharacter_set": {"key": "ncharacterSet", "type": "str"},
        "lifecycle_details": {"key": "lifecycleDetails", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "lifecycle_state": {"key": "lifecycleState", "type": "str"},
        "scheduled_operations": {"key": "scheduledOperations", "type": "ScheduledOperationsType"},
        "private_endpoint_ip": {"key": "privateEndpointIp", "type": "str"},
        "private_endpoint_label": {"key": "privateEndpointLabel", "type": "str"},
        "oci_url": {"key": "ociUrl", "type": "str"},
        "subnet_id": {"key": "subnetId", "type": "str"},
        "vnet_id": {"key": "vnetId", "type": "str"},
        "time_created": {"key": "timeCreated", "type": "iso-8601"},
        "time_maintenance_begin": {"key": "timeMaintenanceBegin", "type": "iso-8601"},
        "time_maintenance_end": {"key": "timeMaintenanceEnd", "type": "iso-8601"},
        "actual_used_data_storage_size_in_tbs": {"key": "actualUsedDataStorageSizeInTbs", "type": "float"},
        "allocated_storage_size_in_tbs": {"key": "allocatedStorageSizeInTbs", "type": "float"},
        "apex_details": {"key": "apexDetails", "type": "ApexDetailsType"},
        "available_upgrade_versions": {"key": "availableUpgradeVersions", "type": "[str]"},
        "connection_strings": {"key": "connectionStrings", "type": "ConnectionStringType"},
        "connection_urls": {"key": "connectionUrls", "type": "ConnectionUrlType"},
        "data_safe_status": {"key": "dataSafeStatus", "type": "str"},
        "database_edition": {"key": "databaseEdition", "type": "str"},
        "autonomous_database_id": {"key": "autonomousDatabaseId", "type": "str"},
        "in_memory_area_in_gbs": {"key": "inMemoryAreaInGbs", "type": "int"},
        "next_long_term_backup_time_stamp": {"key": "nextLongTermBackupTimeStamp", "type": "iso-8601"},
        "long_term_backup_schedule": {"key": "longTermBackupSchedule", "type": "LongTermBackUpScheduleDetails"},
        "is_preview": {"key": "isPreview", "type": "bool"},
        "local_adg_auto_failover_max_data_loss_limit": {"key": "localAdgAutoFailoverMaxDataLossLimit", "type": "int"},
        "memory_per_oracle_compute_unit_in_gbs": {"key": "memoryPerOracleComputeUnitInGbs", "type": "int"},
        "open_mode": {"key": "openMode", "type": "str"},
        "operations_insights_status": {"key": "operationsInsightsStatus", "type": "str"},
        "permission_level": {"key": "permissionLevel", "type": "str"},
        "private_endpoint": {"key": "privateEndpoint", "type": "str"},
        "provisionable_cpus": {"key": "provisionableCpus", "type": "[int]"},
        "role": {"key": "role", "type": "str"},
        "service_console_url": {"key": "serviceConsoleUrl", "type": "str"},
        "sql_web_developer_url": {"key": "sqlWebDeveloperUrl", "type": "str"},
        "supported_regions_to_clone_to": {"key": "supportedRegionsToCloneTo", "type": "[str]"},
        "time_data_guard_role_changed": {"key": "timeDataGuardRoleChanged", "type": "str"},
        "time_deletion_of_free_autonomous_database": {"key": "timeDeletionOfFreeAutonomousDatabase", "type": "str"},
        "time_local_data_guard_enabled": {"key": "timeLocalDataGuardEnabled", "type": "str"},
        "time_of_last_failover": {"key": "timeOfLastFailover", "type": "str"},
        "time_of_last_refresh": {"key": "timeOfLastRefresh", "type": "str"},
        "time_of_last_refresh_point": {"key": "timeOfLastRefreshPoint", "type": "str"},
        "time_of_last_switchover": {"key": "timeOfLastSwitchover", "type": "str"},
        "time_reclamation_of_free_autonomous_database": {
            "key": "timeReclamationOfFreeAutonomousDatabase",
            "type": "str",
        },
        "used_data_storage_size_in_gbs": {"key": "usedDataStorageSizeInGbs", "type": "int"},
        "used_data_storage_size_in_tbs": {"key": "usedDataStorageSizeInTbs", "type": "int"},
        "ocid": {"key": "ocid", "type": "str"},
        "backup_retention_period_in_days": {"key": "backupRetentionPeriodInDays", "type": "int"},
        "whitelisted_ips": {"key": "whitelistedIps", "type": "[str]"},
    }

    _subtype_map = {
        "data_base_type": {"Clone": "AutonomousDatabaseCloneProperties", "Regular": "AutonomousDatabaseProperties"}
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        admin_password: Optional[str] = None,
        autonomous_maintenance_schedule_type: Optional[Union[str, "_models.AutonomousMaintenanceScheduleType"]] = None,
        character_set: Optional[str] = None,
        compute_count: Optional[float] = None,
        compute_model: Optional[Union[str, "_models.ComputeModel"]] = None,
        cpu_core_count: Optional[int] = None,
        customer_contacts: Optional[List["_models.CustomerContact"]] = None,
        data_storage_size_in_tbs: Optional[int] = None,
        data_storage_size_in_gbs: Optional[int] = None,
        db_version: Optional[str] = None,
        db_workload: Optional[Union[str, "_models.WorkloadType"]] = None,
        display_name: Optional[str] = None,
        is_auto_scaling_enabled: Optional[bool] = None,
        is_auto_scaling_for_storage_enabled: Optional[bool] = None,
        peer_db_id: Optional[str] = None,
        is_local_data_guard_enabled: Optional[bool] = None,
        is_mtls_connection_required: Optional[bool] = None,
        is_preview_version_with_service_terms_accepted: Optional[bool] = None,
        license_model: Optional[Union[str, "_models.LicenseModel"]] = None,
        ncharacter_set: Optional[str] = None,
        scheduled_operations: Optional["_models.ScheduledOperationsType"] = None,
        private_endpoint_ip: Optional[str] = None,
        private_endpoint_label: Optional[str] = None,
        subnet_id: Optional[str] = None,
        vnet_id: Optional[str] = None,
        database_edition: Optional[Union[str, "_models.DatabaseEditionType"]] = None,
        autonomous_database_id: Optional[str] = None,
        long_term_backup_schedule: Optional["_models.LongTermBackUpScheduleDetails"] = None,
        local_adg_auto_failover_max_data_loss_limit: Optional[int] = None,
        open_mode: Optional[Union[str, "_models.OpenModeType"]] = None,
        permission_level: Optional[Union[str, "_models.PermissionLevelType"]] = None,
        role: Optional[Union[str, "_models.RoleType"]] = None,
        backup_retention_period_in_days: Optional[int] = None,
        whitelisted_ips: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword admin_password: Admin password.
        :paramtype admin_password: str
        :keyword autonomous_maintenance_schedule_type: The maintenance schedule type of the Autonomous
         Database Serverless. Known values are: "Early" and "Regular".
        :paramtype autonomous_maintenance_schedule_type: str or
         ~azure.mgmt.oracledatabase.models.AutonomousMaintenanceScheduleType
        :keyword character_set: The character set for the autonomous database.
        :paramtype character_set: str
        :keyword compute_count: The compute amount (CPUs) available to the database.
        :paramtype compute_count: float
        :keyword compute_model: The compute model of the Autonomous Database. Known values are: "ECPU"
         and "OCPU".
        :paramtype compute_model: str or ~azure.mgmt.oracledatabase.models.ComputeModel
        :keyword cpu_core_count: The number of CPU cores to be made available to the database.
        :paramtype cpu_core_count: int
        :keyword customer_contacts: Customer Contacts.
        :paramtype customer_contacts: list[~azure.mgmt.oracledatabase.models.CustomerContact]
        :keyword data_storage_size_in_tbs: The quantity of data in the database, in terabytes.
        :paramtype data_storage_size_in_tbs: int
        :keyword data_storage_size_in_gbs: The size, in gigabytes, of the data volume that will be
         created and attached to the database.
        :paramtype data_storage_size_in_gbs: int
        :keyword db_version: A valid Oracle Database version for Autonomous Database.
        :paramtype db_version: str
        :keyword db_workload: The Autonomous Database workload type. Known values are: "OLTP", "DW",
         "AJD", and "APEX".
        :paramtype db_workload: str or ~azure.mgmt.oracledatabase.models.WorkloadType
        :keyword display_name: The user-friendly name for the Autonomous Database.
        :paramtype display_name: str
        :keyword is_auto_scaling_enabled: Indicates if auto scaling is enabled for the Autonomous
         Database CPU core count.
        :paramtype is_auto_scaling_enabled: bool
        :keyword is_auto_scaling_for_storage_enabled: Indicates if auto scaling is enabled for the
         Autonomous Database storage.
        :paramtype is_auto_scaling_for_storage_enabled: bool
        :keyword peer_db_id: The database OCID of the Disaster Recovery peer database, which is located
         in a different region from the current peer database.
        :paramtype peer_db_id: str
        :keyword is_local_data_guard_enabled: Indicates whether the Autonomous Database has local or
         called in-region Data Guard enabled.
        :paramtype is_local_data_guard_enabled: bool
        :keyword is_mtls_connection_required: Specifies if the Autonomous Database requires mTLS
         connections.
        :paramtype is_mtls_connection_required: bool
        :keyword is_preview_version_with_service_terms_accepted: Specifies if the Autonomous Database
         preview version is being provisioned.
        :paramtype is_preview_version_with_service_terms_accepted: bool
        :keyword license_model: The Oracle license model that applies to the Oracle Autonomous
         Database. The default is LICENSE_INCLUDED. Known values are: "LicenseIncluded" and
         "BringYourOwnLicense".
        :paramtype license_model: str or ~azure.mgmt.oracledatabase.models.LicenseModel
        :keyword ncharacter_set: The character set for the Autonomous Database.
        :paramtype ncharacter_set: str
        :keyword scheduled_operations: The list of scheduled operations.
        :paramtype scheduled_operations: ~azure.mgmt.oracledatabase.models.ScheduledOperationsType
        :keyword private_endpoint_ip: The private endpoint Ip address for the resource.
        :paramtype private_endpoint_ip: str
        :keyword private_endpoint_label: The resource's private endpoint label.
        :paramtype private_endpoint_label: str
        :keyword subnet_id: Client subnet.
        :paramtype subnet_id: str
        :keyword vnet_id: VNET for network connectivity.
        :paramtype vnet_id: str
        :keyword database_edition: The Oracle Database Edition that applies to the Autonomous
         databases. Known values are: "StandardEdition" and "EnterpriseEdition".
        :paramtype database_edition: str or ~azure.mgmt.oracledatabase.models.DatabaseEditionType
        :keyword autonomous_database_id: Autonomous Database ID.
        :paramtype autonomous_database_id: str
        :keyword long_term_backup_schedule: Details for the long-term backup schedule.
        :paramtype long_term_backup_schedule:
         ~azure.mgmt.oracledatabase.models.LongTermBackUpScheduleDetails
        :keyword local_adg_auto_failover_max_data_loss_limit: Parameter that allows users to select an
         acceptable maximum data loss limit in seconds, up to which Automatic Failover will be triggered
         when necessary for a Local Autonomous Data Guard.
        :paramtype local_adg_auto_failover_max_data_loss_limit: int
        :keyword open_mode: Indicates the Autonomous Database mode. Known values are: "ReadOnly" and
         "ReadWrite".
        :paramtype open_mode: str or ~azure.mgmt.oracledatabase.models.OpenModeType
        :keyword permission_level: The Autonomous Database permission level. Known values are:
         "Restricted" and "Unrestricted".
        :paramtype permission_level: str or ~azure.mgmt.oracledatabase.models.PermissionLevelType
        :keyword role: The Data Guard role of the Autonomous Container Database or Autonomous Database,
         if Autonomous Data Guard is enabled. Known values are: "Primary", "Standby", "DisabledStandby",
         "BackupCopy", and "SnapshotStandby".
        :paramtype role: str or ~azure.mgmt.oracledatabase.models.RoleType
        :keyword backup_retention_period_in_days: Retention period, in days, for long-term backups.
        :paramtype backup_retention_period_in_days: int
        :keyword whitelisted_ips: The client IP access control list (ACL). This is an array of CIDR
         notations and/or IP addresses. Values should be separate strings, separated by commas. Example:
         ['1.1.1.1','1.1.1.0/24','1.1.2.25'].
        :paramtype whitelisted_ips: list[str]
        """
        super().__init__(**kwargs)
        self.admin_password = admin_password
        self.data_base_type: Optional[str] = None
        self.autonomous_maintenance_schedule_type = autonomous_maintenance_schedule_type
        self.character_set = character_set
        self.compute_count = compute_count
        self.compute_model = compute_model
        self.cpu_core_count = cpu_core_count
        self.customer_contacts = customer_contacts
        self.data_storage_size_in_tbs = data_storage_size_in_tbs
        self.data_storage_size_in_gbs = data_storage_size_in_gbs
        self.db_version = db_version
        self.db_workload = db_workload
        self.display_name = display_name
        self.is_auto_scaling_enabled = is_auto_scaling_enabled
        self.is_auto_scaling_for_storage_enabled = is_auto_scaling_for_storage_enabled
        self.peer_db_ids = None
        self.peer_db_id = peer_db_id
        self.is_local_data_guard_enabled = is_local_data_guard_enabled
        self.is_remote_data_guard_enabled = None
        self.local_disaster_recovery_type = None
        self.local_standby_db = None
        self.failed_data_recovery_in_seconds = None
        self.is_mtls_connection_required = is_mtls_connection_required
        self.is_preview_version_with_service_terms_accepted = is_preview_version_with_service_terms_accepted
        self.license_model = license_model
        self.ncharacter_set = ncharacter_set
        self.lifecycle_details = None
        self.provisioning_state = None
        self.lifecycle_state = None
        self.scheduled_operations = scheduled_operations
        self.private_endpoint_ip = private_endpoint_ip
        self.private_endpoint_label = private_endpoint_label
        self.oci_url = None
        self.subnet_id = subnet_id
        self.vnet_id = vnet_id
        self.time_created = None
        self.time_maintenance_begin = None
        self.time_maintenance_end = None
        self.actual_used_data_storage_size_in_tbs = None
        self.allocated_storage_size_in_tbs = None
        self.apex_details = None
        self.available_upgrade_versions = None
        self.connection_strings = None
        self.connection_urls = None
        self.data_safe_status = None
        self.database_edition = database_edition
        self.autonomous_database_id = autonomous_database_id
        self.in_memory_area_in_gbs = None
        self.next_long_term_backup_time_stamp = None
        self.long_term_backup_schedule = long_term_backup_schedule
        self.is_preview = None
        self.local_adg_auto_failover_max_data_loss_limit = local_adg_auto_failover_max_data_loss_limit
        self.memory_per_oracle_compute_unit_in_gbs = None
        self.open_mode = open_mode
        self.operations_insights_status = None
        self.permission_level = permission_level
        self.private_endpoint = None
        self.provisionable_cpus = None
        self.role = role
        self.service_console_url = None
        self.sql_web_developer_url = None
        self.supported_regions_to_clone_to = None
        self.time_data_guard_role_changed = None
        self.time_deletion_of_free_autonomous_database = None
        self.time_local_data_guard_enabled = None
        self.time_of_last_failover = None
        self.time_of_last_refresh = None
        self.time_of_last_refresh_point = None
        self.time_of_last_switchover = None
        self.time_reclamation_of_free_autonomous_database = None
        self.used_data_storage_size_in_gbs = None
        self.used_data_storage_size_in_tbs = None
        self.ocid = None
        self.backup_retention_period_in_days = backup_retention_period_in_days
        self.whitelisted_ips = whitelisted_ips


class AutonomousDatabaseCharacterSet(ProxyResource):
    """AutonomousDatabaseCharacterSets resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.AutonomousDatabaseCharacterSetProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "AutonomousDatabaseCharacterSetProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.AutonomousDatabaseCharacterSetProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties:
         ~azure.mgmt.oracledatabase.models.AutonomousDatabaseCharacterSetProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class AutonomousDatabaseCharacterSetListResult(_serialization.Model):
    """The response of a AutonomousDatabaseCharacterSet list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The AutonomousDatabaseCharacterSet items on this page. Required.
    :vartype value: list[~azure.mgmt.oracledatabase.models.AutonomousDatabaseCharacterSet]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AutonomousDatabaseCharacterSet]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.AutonomousDatabaseCharacterSet"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The AutonomousDatabaseCharacterSet items on this page. Required.
        :paramtype value: list[~azure.mgmt.oracledatabase.models.AutonomousDatabaseCharacterSet]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AutonomousDatabaseCharacterSetProperties(_serialization.Model):
    """AutonomousDatabaseCharacterSet resource model.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar character_set: The Oracle Autonomous Database supported character sets. Required.
    :vartype character_set: str
    """

    _validation = {
        "character_set": {"required": True, "readonly": True, "max_length": 255, "min_length": 1},
    }

    _attribute_map = {
        "character_set": {"key": "characterSet", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.character_set = None


class AutonomousDatabaseCloneProperties(
    AutonomousDatabaseBaseProperties
):  # pylint: disable=too-many-instance-attributes
    """Autonomous Database clone resource model.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar admin_password: Admin password.
    :vartype admin_password: str
    :ivar data_base_type: Database type to be created. Required. Known values are: "Regular" and
     "Clone".
    :vartype data_base_type: str or ~azure.mgmt.oracledatabase.models.DataBaseType
    :ivar autonomous_maintenance_schedule_type: The maintenance schedule type of the Autonomous
     Database Serverless. Known values are: "Early" and "Regular".
    :vartype autonomous_maintenance_schedule_type: str or
     ~azure.mgmt.oracledatabase.models.AutonomousMaintenanceScheduleType
    :ivar character_set: The character set for the autonomous database.
    :vartype character_set: str
    :ivar compute_count: The compute amount (CPUs) available to the database.
    :vartype compute_count: float
    :ivar compute_model: The compute model of the Autonomous Database. Known values are: "ECPU" and
     "OCPU".
    :vartype compute_model: str or ~azure.mgmt.oracledatabase.models.ComputeModel
    :ivar cpu_core_count: The number of CPU cores to be made available to the database.
    :vartype cpu_core_count: int
    :ivar customer_contacts: Customer Contacts.
    :vartype customer_contacts: list[~azure.mgmt.oracledatabase.models.CustomerContact]
    :ivar data_storage_size_in_tbs: The quantity of data in the database, in terabytes.
    :vartype data_storage_size_in_tbs: int
    :ivar data_storage_size_in_gbs: The size, in gigabytes, of the data volume that will be created
     and attached to the database.
    :vartype data_storage_size_in_gbs: int
    :ivar db_version: A valid Oracle Database version for Autonomous Database.
    :vartype db_version: str
    :ivar db_workload: The Autonomous Database workload type. Known values are: "OLTP", "DW",
     "AJD", and "APEX".
    :vartype db_workload: str or ~azure.mgmt.oracledatabase.models.WorkloadType
    :ivar display_name: The user-friendly name for the Autonomous Database.
    :vartype display_name: str
    :ivar is_auto_scaling_enabled: Indicates if auto scaling is enabled for the Autonomous Database
     CPU core count.
    :vartype is_auto_scaling_enabled: bool
    :ivar is_auto_scaling_for_storage_enabled: Indicates if auto scaling is enabled for the
     Autonomous Database storage.
    :vartype is_auto_scaling_for_storage_enabled: bool
    :ivar peer_db_ids: The list of `OCIDs
     <https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm>`_ of standby databases
     located in Autonomous Data Guard remote regions that are associated with the source database.
     Note that for Autonomous Database Serverless instances, standby databases located in the same
     region as the source primary database do not have OCIDs.
    :vartype peer_db_ids: list[str]
    :ivar peer_db_id: The database OCID of the Disaster Recovery peer database, which is located in
     a different region from the current peer database.
    :vartype peer_db_id: str
    :ivar is_local_data_guard_enabled: Indicates whether the Autonomous Database has local or
     called in-region Data Guard enabled.
    :vartype is_local_data_guard_enabled: bool
    :ivar is_remote_data_guard_enabled: Indicates whether the Autonomous Database has Cross Region
     Data Guard enabled.
    :vartype is_remote_data_guard_enabled: bool
    :ivar local_disaster_recovery_type: Indicates the local disaster recovery (DR) type of the
     Autonomous Database Serverless instance.Autonomous Data Guard (ADG) DR type provides business
     critical DR with a faster recovery time objective (RTO) during failover or
     switchover.Backup-based DR type provides lower cost DR with a slower RTO during failover or
     switchover. Known values are: "Adg" and "BackupBased".
    :vartype local_disaster_recovery_type: str or
     ~azure.mgmt.oracledatabase.models.DisasterRecoveryType
    :ivar local_standby_db: Local Autonomous Disaster Recovery standby database details.
    :vartype local_standby_db: ~azure.mgmt.oracledatabase.models.AutonomousDatabaseStandbySummary
    :ivar failed_data_recovery_in_seconds: Indicates the number of seconds of data loss for a Data
     Guard failover.
    :vartype failed_data_recovery_in_seconds: int
    :ivar is_mtls_connection_required: Specifies if the Autonomous Database requires mTLS
     connections.
    :vartype is_mtls_connection_required: bool
    :ivar is_preview_version_with_service_terms_accepted: Specifies if the Autonomous Database
     preview version is being provisioned.
    :vartype is_preview_version_with_service_terms_accepted: bool
    :ivar license_model: The Oracle license model that applies to the Oracle Autonomous Database.
     The default is LICENSE_INCLUDED. Known values are: "LicenseIncluded" and "BringYourOwnLicense".
    :vartype license_model: str or ~azure.mgmt.oracledatabase.models.LicenseModel
    :ivar ncharacter_set: The character set for the Autonomous Database.
    :vartype ncharacter_set: str
    :ivar lifecycle_details: Additional information about the current lifecycle state.
    :vartype lifecycle_details: str
    :ivar provisioning_state: Azure resource provisioning state. Known values are: "Succeeded",
     "Failed", "Canceled", and "Provisioning".
    :vartype provisioning_state: str or
     ~azure.mgmt.oracledatabase.models.AzureResourceProvisioningState
    :ivar lifecycle_state: Views lifecycleState. Known values are: "Provisioning", "Available",
     "Stopping", "Stopped", "Starting", "Terminating", "Terminated", "Unavailable",
     "RestoreInProgress", "RestoreFailed", "BackupInProgress", "ScaleInProgress",
     "AvailableNeedsAttention", "Updating", "MaintenanceInProgress", "Restarting", "Recreating",
     "RoleChangeInProgress", "Upgrading", "Inaccessible", and "Standby".
    :vartype lifecycle_state: str or
     ~azure.mgmt.oracledatabase.models.AutonomousDatabaseLifecycleState
    :ivar scheduled_operations: The list of scheduled operations.
    :vartype scheduled_operations: ~azure.mgmt.oracledatabase.models.ScheduledOperationsType
    :ivar private_endpoint_ip: The private endpoint Ip address for the resource.
    :vartype private_endpoint_ip: str
    :ivar private_endpoint_label: The resource's private endpoint label.
    :vartype private_endpoint_label: str
    :ivar oci_url: HTTPS link to OCI resources exposed to Azure Customer via Azure Interface.
    :vartype oci_url: str
    :ivar subnet_id: Client subnet.
    :vartype subnet_id: str
    :ivar vnet_id: VNET for network connectivity.
    :vartype vnet_id: str
    :ivar time_created: The date and time that the database was created.
    :vartype time_created: ~datetime.datetime
    :ivar time_maintenance_begin: The date and time when maintenance will begin.
    :vartype time_maintenance_begin: ~datetime.datetime
    :ivar time_maintenance_end: The date and time when maintenance will end.
    :vartype time_maintenance_end: ~datetime.datetime
    :ivar actual_used_data_storage_size_in_tbs: The current amount of storage in use for user and
     system data, in terabytes (TB).
    :vartype actual_used_data_storage_size_in_tbs: float
    :ivar allocated_storage_size_in_tbs: The amount of storage currently allocated for the database
     tables and billed for, rounded up.
    :vartype allocated_storage_size_in_tbs: float
    :ivar apex_details: Information about Oracle APEX Application Development.
    :vartype apex_details: ~azure.mgmt.oracledatabase.models.ApexDetailsType
    :ivar available_upgrade_versions: List of Oracle Database versions available for a database
     upgrade. If there are no version upgrades available, this list is empty.
    :vartype available_upgrade_versions: list[str]
    :ivar connection_strings: The connection string used to connect to the Autonomous Database.
    :vartype connection_strings: ~azure.mgmt.oracledatabase.models.ConnectionStringType
    :ivar connection_urls: The URLs for accessing Oracle Application Express (APEX) and SQL
     Developer Web with a browser from a Compute instance within your VCN or that has a direct
     connection to your VCN.
    :vartype connection_urls: ~azure.mgmt.oracledatabase.models.ConnectionUrlType
    :ivar data_safe_status: Status of the Data Safe registration for this Autonomous Database.
     Known values are: "Registering", "Registered", "Deregistering", "NotRegistered", and "Failed".
    :vartype data_safe_status: str or ~azure.mgmt.oracledatabase.models.DataSafeStatusType
    :ivar database_edition: The Oracle Database Edition that applies to the Autonomous databases.
     Known values are: "StandardEdition" and "EnterpriseEdition".
    :vartype database_edition: str or ~azure.mgmt.oracledatabase.models.DatabaseEditionType
    :ivar autonomous_database_id: Autonomous Database ID.
    :vartype autonomous_database_id: str
    :ivar in_memory_area_in_gbs: The area assigned to In-Memory tables in Autonomous Database.
    :vartype in_memory_area_in_gbs: int
    :ivar next_long_term_backup_time_stamp: The date and time when the next long-term backup would
     be created.
    :vartype next_long_term_backup_time_stamp: ~datetime.datetime
    :ivar long_term_backup_schedule: Details for the long-term backup schedule.
    :vartype long_term_backup_schedule:
     ~azure.mgmt.oracledatabase.models.LongTermBackUpScheduleDetails
    :ivar is_preview: Indicates if the Autonomous Database version is a preview version.
    :vartype is_preview: bool
    :ivar local_adg_auto_failover_max_data_loss_limit: Parameter that allows users to select an
     acceptable maximum data loss limit in seconds, up to which Automatic Failover will be triggered
     when necessary for a Local Autonomous Data Guard.
    :vartype local_adg_auto_failover_max_data_loss_limit: int
    :ivar memory_per_oracle_compute_unit_in_gbs: The amount of memory (in GBs) enabled per ECPU or
     OCPU.
    :vartype memory_per_oracle_compute_unit_in_gbs: int
    :ivar open_mode: Indicates the Autonomous Database mode. Known values are: "ReadOnly" and
     "ReadWrite".
    :vartype open_mode: str or ~azure.mgmt.oracledatabase.models.OpenModeType
    :ivar operations_insights_status: Status of Operations Insights for this Autonomous Database.
     Known values are: "Enabling", "Enabled", "Disabling", "NotEnabled", "FailedEnabling", and
     "FailedDisabling".
    :vartype operations_insights_status: str or
     ~azure.mgmt.oracledatabase.models.OperationsInsightsStatusType
    :ivar permission_level: The Autonomous Database permission level. Known values are:
     "Restricted" and "Unrestricted".
    :vartype permission_level: str or ~azure.mgmt.oracledatabase.models.PermissionLevelType
    :ivar private_endpoint: The private endpoint for the resource.
    :vartype private_endpoint: str
    :ivar provisionable_cpus: An array of CPU values that an Autonomous Database can be scaled to.
    :vartype provisionable_cpus: list[int]
    :ivar role: The Data Guard role of the Autonomous Container Database or Autonomous Database, if
     Autonomous Data Guard is enabled. Known values are: "Primary", "Standby", "DisabledStandby",
     "BackupCopy", and "SnapshotStandby".
    :vartype role: str or ~azure.mgmt.oracledatabase.models.RoleType
    :ivar service_console_url: The URL of the Service Console for the Autonomous Database.
    :vartype service_console_url: str
    :ivar sql_web_developer_url: The SQL Web Developer URL for the Oracle Autonomous Database.
    :vartype sql_web_developer_url: str
    :ivar supported_regions_to_clone_to: The list of regions that support the creation of an
     Autonomous Database clone or an Autonomous Data Guard standby database.
    :vartype supported_regions_to_clone_to: list[str]
    :ivar time_data_guard_role_changed: The date and time the Autonomous Data Guard role was
     switched for the Autonomous Database.
    :vartype time_data_guard_role_changed: str
    :ivar time_deletion_of_free_autonomous_database: The date and time the Always Free database
     will be automatically deleted because of inactivity.
    :vartype time_deletion_of_free_autonomous_database: str
    :ivar time_local_data_guard_enabled: The date and time that Autonomous Data Guard was enabled
     for an Autonomous Database where the standby was provisioned in the same region as the primary
     database.
    :vartype time_local_data_guard_enabled: str
    :ivar time_of_last_failover: The timestamp of the last failover operation.
    :vartype time_of_last_failover: str
    :ivar time_of_last_refresh: The date and time when last refresh happened.
    :vartype time_of_last_refresh: str
    :ivar time_of_last_refresh_point: The refresh point timestamp (UTC).
    :vartype time_of_last_refresh_point: str
    :ivar time_of_last_switchover: The timestamp of the last switchover operation for the
     Autonomous Database.
    :vartype time_of_last_switchover: str
    :ivar time_reclamation_of_free_autonomous_database: The date and time the Always Free database
     will be stopped because of inactivity.
    :vartype time_reclamation_of_free_autonomous_database: str
    :ivar used_data_storage_size_in_gbs: The storage space consumed by Autonomous Database in GBs.
    :vartype used_data_storage_size_in_gbs: int
    :ivar used_data_storage_size_in_tbs: The amount of storage that has been used, in terabytes.
    :vartype used_data_storage_size_in_tbs: int
    :ivar ocid: Database ocid.
    :vartype ocid: str
    :ivar backup_retention_period_in_days: Retention period, in days, for long-term backups.
    :vartype backup_retention_period_in_days: int
    :ivar whitelisted_ips: The client IP access control list (ACL). This is an array of CIDR
     notations and/or IP addresses. Values should be separate strings, separated by commas. Example:
     ['1.1.1.1','1.1.1.0/24','1.1.2.25'].
    :vartype whitelisted_ips: list[str]
    :ivar source: The source of the database. Known values are: "None", "Database", "BackupFromId",
     "BackupFromTimestamp", "CloneToRefreshable", "CrossRegionDataguard", and
     "CrossRegionDisasterRecovery".
    :vartype source: str or ~azure.mgmt.oracledatabase.models.SourceType
    :ivar source_id: The Azure ID of the Autonomous Database that was cloned to create the current
     Autonomous Database. Required.
    :vartype source_id: str
    :ivar clone_type: The Autonomous Database clone type. Required. Known values are: "Full" and
     "Metadata".
    :vartype clone_type: str or ~azure.mgmt.oracledatabase.models.CloneType
    :ivar is_reconnect_clone_enabled: Indicates if the refreshable clone can be reconnected to its
     source database.
    :vartype is_reconnect_clone_enabled: bool
    :ivar is_refreshable_clone: Indicates if the Autonomous Database is a refreshable clone.
    :vartype is_refreshable_clone: bool
    :ivar refreshable_model: The refresh mode of the clone. Known values are: "Automatic" and
     "Manual".
    :vartype refreshable_model: str or ~azure.mgmt.oracledatabase.models.RefreshableModelType
    :ivar refreshable_status: The refresh status of the clone. Known values are: "Refreshing" and
     "NotRefreshing".
    :vartype refreshable_status: str or ~azure.mgmt.oracledatabase.models.RefreshableStatusType
    :ivar time_until_reconnect_clone_enabled: The time and date as an RFC3339 formatted string,
     e.g., 2022-01-01T12:00:00.000Z, to set the limit for a refreshable clone to be reconnected to
     its source database.
    :vartype time_until_reconnect_clone_enabled: str
    """

    _validation = {
        "data_base_type": {"required": True},
        "character_set": {"max_length": 255, "min_length": 1},
        "compute_count": {"maximum": 512, "minimum": 0.1},
        "cpu_core_count": {"maximum": 128, "minimum": 1},
        "data_storage_size_in_tbs": {"maximum": 384, "minimum": 1},
        "data_storage_size_in_gbs": {"maximum": 393216, "minimum": 20},
        "db_version": {"max_length": 255, "min_length": 1},
        "display_name": {"max_length": 255, "min_length": 1},
        "peer_db_ids": {"readonly": True},
        "peer_db_id": {"max_length": 255, "min_length": 1},
        "is_remote_data_guard_enabled": {"readonly": True},
        "local_disaster_recovery_type": {"readonly": True},
        "local_standby_db": {"readonly": True},
        "failed_data_recovery_in_seconds": {"readonly": True},
        "ncharacter_set": {"max_length": 255, "min_length": 1},
        "lifecycle_details": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "lifecycle_state": {"readonly": True},
        "oci_url": {"readonly": True},
        "time_created": {"readonly": True},
        "time_maintenance_begin": {"readonly": True},
        "time_maintenance_end": {"readonly": True},
        "actual_used_data_storage_size_in_tbs": {"readonly": True},
        "allocated_storage_size_in_tbs": {"readonly": True},
        "apex_details": {"readonly": True},
        "available_upgrade_versions": {"readonly": True},
        "connection_strings": {"readonly": True},
        "connection_urls": {"readonly": True},
        "data_safe_status": {"readonly": True},
        "in_memory_area_in_gbs": {"readonly": True},
        "next_long_term_backup_time_stamp": {"readonly": True},
        "is_preview": {"readonly": True},
        "local_adg_auto_failover_max_data_loss_limit": {"maximum": 3600, "minimum": 0},
        "memory_per_oracle_compute_unit_in_gbs": {"readonly": True},
        "operations_insights_status": {"readonly": True},
        "private_endpoint": {"readonly": True},
        "provisionable_cpus": {"readonly": True},
        "service_console_url": {"readonly": True, "max_length": 255, "min_length": 10},
        "sql_web_developer_url": {"readonly": True, "max_length": 2048, "min_length": 10},
        "supported_regions_to_clone_to": {"readonly": True, "max_items": 50, "min_items": 0},
        "time_data_guard_role_changed": {"readonly": True},
        "time_deletion_of_free_autonomous_database": {"readonly": True},
        "time_local_data_guard_enabled": {"readonly": True},
        "time_of_last_failover": {"readonly": True},
        "time_of_last_refresh": {"readonly": True},
        "time_of_last_refresh_point": {"readonly": True},
        "time_of_last_switchover": {"readonly": True},
        "time_reclamation_of_free_autonomous_database": {"readonly": True},
        "used_data_storage_size_in_gbs": {"readonly": True},
        "used_data_storage_size_in_tbs": {"readonly": True},
        "ocid": {"readonly": True, "max_length": 255, "min_length": 1},
        "source_id": {"required": True},
        "clone_type": {"required": True},
        "is_reconnect_clone_enabled": {"readonly": True},
        "is_refreshable_clone": {"readonly": True},
        "refreshable_status": {"readonly": True},
    }

    _attribute_map = {
        "admin_password": {"key": "adminPassword", "type": "str"},
        "data_base_type": {"key": "dataBaseType", "type": "str"},
        "autonomous_maintenance_schedule_type": {"key": "autonomousMaintenanceScheduleType", "type": "str"},
        "character_set": {"key": "characterSet", "type": "str"},
        "compute_count": {"key": "computeCount", "type": "float"},
        "compute_model": {"key": "computeModel", "type": "str"},
        "cpu_core_count": {"key": "cpuCoreCount", "type": "int"},
        "customer_contacts": {"key": "customerContacts", "type": "[CustomerContact]"},
        "data_storage_size_in_tbs": {"key": "dataStorageSizeInTbs", "type": "int"},
        "data_storage_size_in_gbs": {"key": "dataStorageSizeInGbs", "type": "int"},
        "db_version": {"key": "dbVersion", "type": "str"},
        "db_workload": {"key": "dbWorkload", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "is_auto_scaling_enabled": {"key": "isAutoScalingEnabled", "type": "bool"},
        "is_auto_scaling_for_storage_enabled": {"key": "isAutoScalingForStorageEnabled", "type": "bool"},
        "peer_db_ids": {"key": "peerDbIds", "type": "[str]"},
        "peer_db_id": {"key": "peerDbId", "type": "str"},
        "is_local_data_guard_enabled": {"key": "isLocalDataGuardEnabled", "type": "bool"},
        "is_remote_data_guard_enabled": {"key": "isRemoteDataGuardEnabled", "type": "bool"},
        "local_disaster_recovery_type": {"key": "localDisasterRecoveryType", "type": "str"},
        "local_standby_db": {"key": "localStandbyDb", "type": "AutonomousDatabaseStandbySummary"},
        "failed_data_recovery_in_seconds": {"key": "failedDataRecoveryInSeconds", "type": "int"},
        "is_mtls_connection_required": {"key": "isMtlsConnectionRequired", "type": "bool"},
        "is_preview_version_with_service_terms_accepted": {
            "key": "isPreviewVersionWithServiceTermsAccepted",
            "type": "bool",
        },
        "license_model": {"key": "licenseModel", "type": "str"},
        "ncharacter_set": {"key": "ncharacterSet", "type": "str"},
        "lifecycle_details": {"key": "lifecycleDetails", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "lifecycle_state": {"key": "lifecycleState", "type": "str"},
        "scheduled_operations": {"key": "scheduledOperations", "type": "ScheduledOperationsType"},
        "private_endpoint_ip": {"key": "privateEndpointIp", "type": "str"},
        "private_endpoint_label": {"key": "privateEndpointLabel", "type": "str"},
        "oci_url": {"key": "ociUrl", "type": "str"},
        "subnet_id": {"key": "subnetId", "type": "str"},
        "vnet_id": {"key": "vnetId", "type": "str"},
        "time_created": {"key": "timeCreated", "type": "iso-8601"},
        "time_maintenance_begin": {"key": "timeMaintenanceBegin", "type": "iso-8601"},
        "time_maintenance_end": {"key": "timeMaintenanceEnd", "type": "iso-8601"},
        "actual_used_data_storage_size_in_tbs": {"key": "actualUsedDataStorageSizeInTbs", "type": "float"},
        "allocated_storage_size_in_tbs": {"key": "allocatedStorageSizeInTbs", "type": "float"},
        "apex_details": {"key": "apexDetails", "type": "ApexDetailsType"},
        "available_upgrade_versions": {"key": "availableUpgradeVersions", "type": "[str]"},
        "connection_strings": {"key": "connectionStrings", "type": "ConnectionStringType"},
        "connection_urls": {"key": "connectionUrls", "type": "ConnectionUrlType"},
        "data_safe_status": {"key": "dataSafeStatus", "type": "str"},
        "database_edition": {"key": "databaseEdition", "type": "str"},
        "autonomous_database_id": {"key": "autonomousDatabaseId", "type": "str"},
        "in_memory_area_in_gbs": {"key": "inMemoryAreaInGbs", "type": "int"},
        "next_long_term_backup_time_stamp": {"key": "nextLongTermBackupTimeStamp", "type": "iso-8601"},
        "long_term_backup_schedule": {"key": "longTermBackupSchedule", "type": "LongTermBackUpScheduleDetails"},
        "is_preview": {"key": "isPreview", "type": "bool"},
        "local_adg_auto_failover_max_data_loss_limit": {"key": "localAdgAutoFailoverMaxDataLossLimit", "type": "int"},
        "memory_per_oracle_compute_unit_in_gbs": {"key": "memoryPerOracleComputeUnitInGbs", "type": "int"},
        "open_mode": {"key": "openMode", "type": "str"},
        "operations_insights_status": {"key": "operationsInsightsStatus", "type": "str"},
        "permission_level": {"key": "permissionLevel", "type": "str"},
        "private_endpoint": {"key": "privateEndpoint", "type": "str"},
        "provisionable_cpus": {"key": "provisionableCpus", "type": "[int]"},
        "role": {"key": "role", "type": "str"},
        "service_console_url": {"key": "serviceConsoleUrl", "type": "str"},
        "sql_web_developer_url": {"key": "sqlWebDeveloperUrl", "type": "str"},
        "supported_regions_to_clone_to": {"key": "supportedRegionsToCloneTo", "type": "[str]"},
        "time_data_guard_role_changed": {"key": "timeDataGuardRoleChanged", "type": "str"},
        "time_deletion_of_free_autonomous_database": {"key": "timeDeletionOfFreeAutonomousDatabase", "type": "str"},
        "time_local_data_guard_enabled": {"key": "timeLocalDataGuardEnabled", "type": "str"},
        "time_of_last_failover": {"key": "timeOfLastFailover", "type": "str"},
        "time_of_last_refresh": {"key": "timeOfLastRefresh", "type": "str"},
        "time_of_last_refresh_point": {"key": "timeOfLastRefreshPoint", "type": "str"},
        "time_of_last_switchover": {"key": "timeOfLastSwitchover", "type": "str"},
        "time_reclamation_of_free_autonomous_database": {
            "key": "timeReclamationOfFreeAutonomousDatabase",
            "type": "str",
        },
        "used_data_storage_size_in_gbs": {"key": "usedDataStorageSizeInGbs", "type": "int"},
        "used_data_storage_size_in_tbs": {"key": "usedDataStorageSizeInTbs", "type": "int"},
        "ocid": {"key": "ocid", "type": "str"},
        "backup_retention_period_in_days": {"key": "backupRetentionPeriodInDays", "type": "int"},
        "whitelisted_ips": {"key": "whitelistedIps", "type": "[str]"},
        "source": {"key": "source", "type": "str"},
        "source_id": {"key": "sourceId", "type": "str"},
        "clone_type": {"key": "cloneType", "type": "str"},
        "is_reconnect_clone_enabled": {"key": "isReconnectCloneEnabled", "type": "bool"},
        "is_refreshable_clone": {"key": "isRefreshableClone", "type": "bool"},
        "refreshable_model": {"key": "refreshableModel", "type": "str"},
        "refreshable_status": {"key": "refreshableStatus", "type": "str"},
        "time_until_reconnect_clone_enabled": {"key": "timeUntilReconnectCloneEnabled", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        source_id: str,
        clone_type: Union[str, "_models.CloneType"],
        admin_password: Optional[str] = None,
        autonomous_maintenance_schedule_type: Optional[Union[str, "_models.AutonomousMaintenanceScheduleType"]] = None,
        character_set: Optional[str] = None,
        compute_count: Optional[float] = None,
        compute_model: Optional[Union[str, "_models.ComputeModel"]] = None,
        cpu_core_count: Optional[int] = None,
        customer_contacts: Optional[List["_models.CustomerContact"]] = None,
        data_storage_size_in_tbs: Optional[int] = None,
        data_storage_size_in_gbs: Optional[int] = None,
        db_version: Optional[str] = None,
        db_workload: Optional[Union[str, "_models.WorkloadType"]] = None,
        display_name: Optional[str] = None,
        is_auto_scaling_enabled: Optional[bool] = None,
        is_auto_scaling_for_storage_enabled: Optional[bool] = None,
        peer_db_id: Optional[str] = None,
        is_local_data_guard_enabled: Optional[bool] = None,
        is_mtls_connection_required: Optional[bool] = None,
        is_preview_version_with_service_terms_accepted: Optional[bool] = None,
        license_model: Optional[Union[str, "_models.LicenseModel"]] = None,
        ncharacter_set: Optional[str] = None,
        scheduled_operations: Optional["_models.ScheduledOperationsType"] = None,
        private_endpoint_ip: Optional[str] = None,
        private_endpoint_label: Optional[str] = None,
        subnet_id: Optional[str] = None,
        vnet_id: Optional[str] = None,
        database_edition: Optional[Union[str, "_models.DatabaseEditionType"]] = None,
        autonomous_database_id: Optional[str] = None,
        long_term_backup_schedule: Optional["_models.LongTermBackUpScheduleDetails"] = None,
        local_adg_auto_failover_max_data_loss_limit: Optional[int] = None,
        open_mode: Optional[Union[str, "_models.OpenModeType"]] = None,
        permission_level: Optional[Union[str, "_models.PermissionLevelType"]] = None,
        role: Optional[Union[str, "_models.RoleType"]] = None,
        backup_retention_period_in_days: Optional[int] = None,
        whitelisted_ips: Optional[List[str]] = None,
        source: Optional[Union[str, "_models.SourceType"]] = None,
        refreshable_model: Optional[Union[str, "_models.RefreshableModelType"]] = None,
        time_until_reconnect_clone_enabled: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword admin_password: Admin password.
        :paramtype admin_password: str
        :keyword autonomous_maintenance_schedule_type: The maintenance schedule type of the Autonomous
         Database Serverless. Known values are: "Early" and "Regular".
        :paramtype autonomous_maintenance_schedule_type: str or
         ~azure.mgmt.oracledatabase.models.AutonomousMaintenanceScheduleType
        :keyword character_set: The character set for the autonomous database.
        :paramtype character_set: str
        :keyword compute_count: The compute amount (CPUs) available to the database.
        :paramtype compute_count: float
        :keyword compute_model: The compute model of the Autonomous Database. Known values are: "ECPU"
         and "OCPU".
        :paramtype compute_model: str or ~azure.mgmt.oracledatabase.models.ComputeModel
        :keyword cpu_core_count: The number of CPU cores to be made available to the database.
        :paramtype cpu_core_count: int
        :keyword customer_contacts: Customer Contacts.
        :paramtype customer_contacts: list[~azure.mgmt.oracledatabase.models.CustomerContact]
        :keyword data_storage_size_in_tbs: The quantity of data in the database, in terabytes.
        :paramtype data_storage_size_in_tbs: int
        :keyword data_storage_size_in_gbs: The size, in gigabytes, of the data volume that will be
         created and attached to the database.
        :paramtype data_storage_size_in_gbs: int
        :keyword db_version: A valid Oracle Database version for Autonomous Database.
        :paramtype db_version: str
        :keyword db_workload: The Autonomous Database workload type. Known values are: "OLTP", "DW",
         "AJD", and "APEX".
        :paramtype db_workload: str or ~azure.mgmt.oracledatabase.models.WorkloadType
        :keyword display_name: The user-friendly name for the Autonomous Database.
        :paramtype display_name: str
        :keyword is_auto_scaling_enabled: Indicates if auto scaling is enabled for the Autonomous
         Database CPU core count.
        :paramtype is_auto_scaling_enabled: bool
        :keyword is_auto_scaling_for_storage_enabled: Indicates if auto scaling is enabled for the
         Autonomous Database storage.
        :paramtype is_auto_scaling_for_storage_enabled: bool
        :keyword peer_db_id: The database OCID of the Disaster Recovery peer database, which is located
         in a different region from the current peer database.
        :paramtype peer_db_id: str
        :keyword is_local_data_guard_enabled: Indicates whether the Autonomous Database has local or
         called in-region Data Guard enabled.
        :paramtype is_local_data_guard_enabled: bool
        :keyword is_mtls_connection_required: Specifies if the Autonomous Database requires mTLS
         connections.
        :paramtype is_mtls_connection_required: bool
        :keyword is_preview_version_with_service_terms_accepted: Specifies if the Autonomous Database
         preview version is being provisioned.
        :paramtype is_preview_version_with_service_terms_accepted: bool
        :keyword license_model: The Oracle license model that applies to the Oracle Autonomous
         Database. The default is LICENSE_INCLUDED. Known values are: "LicenseIncluded" and
         "BringYourOwnLicense".
        :paramtype license_model: str or ~azure.mgmt.oracledatabase.models.LicenseModel
        :keyword ncharacter_set: The character set for the Autonomous Database.
        :paramtype ncharacter_set: str
        :keyword scheduled_operations: The list of scheduled operations.
        :paramtype scheduled_operations: ~azure.mgmt.oracledatabase.models.ScheduledOperationsType
        :keyword private_endpoint_ip: The private endpoint Ip address for the resource.
        :paramtype private_endpoint_ip: str
        :keyword private_endpoint_label: The resource's private endpoint label.
        :paramtype private_endpoint_label: str
        :keyword subnet_id: Client subnet.
        :paramtype subnet_id: str
        :keyword vnet_id: VNET for network connectivity.
        :paramtype vnet_id: str
        :keyword database_edition: The Oracle Database Edition that applies to the Autonomous
         databases. Known values are: "StandardEdition" and "EnterpriseEdition".
        :paramtype database_edition: str or ~azure.mgmt.oracledatabase.models.DatabaseEditionType
        :keyword autonomous_database_id: Autonomous Database ID.
        :paramtype autonomous_database_id: str
        :keyword long_term_backup_schedule: Details for the long-term backup schedule.
        :paramtype long_term_backup_schedule:
         ~azure.mgmt.oracledatabase.models.LongTermBackUpScheduleDetails
        :keyword local_adg_auto_failover_max_data_loss_limit: Parameter that allows users to select an
         acceptable maximum data loss limit in seconds, up to which Automatic Failover will be triggered
         when necessary for a Local Autonomous Data Guard.
        :paramtype local_adg_auto_failover_max_data_loss_limit: int
        :keyword open_mode: Indicates the Autonomous Database mode. Known values are: "ReadOnly" and
         "ReadWrite".
        :paramtype open_mode: str or ~azure.mgmt.oracledatabase.models.OpenModeType
        :keyword permission_level: The Autonomous Database permission level. Known values are:
         "Restricted" and "Unrestricted".
        :paramtype permission_level: str or ~azure.mgmt.oracledatabase.models.PermissionLevelType
        :keyword role: The Data Guard role of the Autonomous Container Database or Autonomous Database,
         if Autonomous Data Guard is enabled. Known values are: "Primary", "Standby", "DisabledStandby",
         "BackupCopy", and "SnapshotStandby".
        :paramtype role: str or ~azure.mgmt.oracledatabase.models.RoleType
        :keyword backup_retention_period_in_days: Retention period, in days, for long-term backups.
        :paramtype backup_retention_period_in_days: int
        :keyword whitelisted_ips: The client IP access control list (ACL). This is an array of CIDR
         notations and/or IP addresses. Values should be separate strings, separated by commas. Example:
         ['1.1.1.1','1.1.1.0/24','1.1.2.25'].
        :paramtype whitelisted_ips: list[str]
        :keyword source: The source of the database. Known values are: "None", "Database",
         "BackupFromId", "BackupFromTimestamp", "CloneToRefreshable", "CrossRegionDataguard", and
         "CrossRegionDisasterRecovery".
        :paramtype source: str or ~azure.mgmt.oracledatabase.models.SourceType
        :keyword source_id: The Azure ID of the Autonomous Database that was cloned to create the
         current Autonomous Database. Required.
        :paramtype source_id: str
        :keyword clone_type: The Autonomous Database clone type. Required. Known values are: "Full" and
         "Metadata".
        :paramtype clone_type: str or ~azure.mgmt.oracledatabase.models.CloneType
        :keyword refreshable_model: The refresh mode of the clone. Known values are: "Automatic" and
         "Manual".
        :paramtype refreshable_model: str or ~azure.mgmt.oracledatabase.models.RefreshableModelType
        :keyword time_until_reconnect_clone_enabled: The time and date as an RFC3339 formatted string,
         e.g., 2022-01-01T12:00:00.000Z, to set the limit for a refreshable clone to be reconnected to
         its source database.
        :paramtype time_until_reconnect_clone_enabled: str
        """
        super().__init__(
            admin_password=admin_password,
            autonomous_maintenance_schedule_type=autonomous_maintenance_schedule_type,
            character_set=character_set,
            compute_count=compute_count,
            compute_model=compute_model,
            cpu_core_count=cpu_core_count,
            customer_contacts=customer_contacts,
            data_storage_size_in_tbs=data_storage_size_in_tbs,
            data_storage_size_in_gbs=data_storage_size_in_gbs,
            db_version=db_version,
            db_workload=db_workload,
            display_name=display_name,
            is_auto_scaling_enabled=is_auto_scaling_enabled,
            is_auto_scaling_for_storage_enabled=is_auto_scaling_for_storage_enabled,
            peer_db_id=peer_db_id,
            is_local_data_guard_enabled=is_local_data_guard_enabled,
            is_mtls_connection_required=is_mtls_connection_required,
            is_preview_version_with_service_terms_accepted=is_preview_version_with_service_terms_accepted,
            license_model=license_model,
            ncharacter_set=ncharacter_set,
            scheduled_operations=scheduled_operations,
            private_endpoint_ip=private_endpoint_ip,
            private_endpoint_label=private_endpoint_label,
            subnet_id=subnet_id,
            vnet_id=vnet_id,
            database_edition=database_edition,
            autonomous_database_id=autonomous_database_id,
            long_term_backup_schedule=long_term_backup_schedule,
            local_adg_auto_failover_max_data_loss_limit=local_adg_auto_failover_max_data_loss_limit,
            open_mode=open_mode,
            permission_level=permission_level,
            role=role,
            backup_retention_period_in_days=backup_retention_period_in_days,
            whitelisted_ips=whitelisted_ips,
            **kwargs
        )
        self.data_base_type: str = "Clone"
        self.source = source
        self.source_id = source_id
        self.clone_type = clone_type
        self.is_reconnect_clone_enabled = None
        self.is_refreshable_clone = None
        self.refreshable_model = refreshable_model
        self.refreshable_status = None
        self.time_until_reconnect_clone_enabled = time_until_reconnect_clone_enabled


class AutonomousDatabaseListResult(_serialization.Model):
    """The response of a AutonomousDatabase list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The AutonomousDatabase items on this page. Required.
    :vartype value: list[~azure.mgmt.oracledatabase.models.AutonomousDatabase]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AutonomousDatabase]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.AutonomousDatabase"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The AutonomousDatabase items on this page. Required.
        :paramtype value: list[~azure.mgmt.oracledatabase.models.AutonomousDatabase]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AutonomousDatabaseNationalCharacterSet(ProxyResource):
    """AutonomousDatabaseNationalCharacterSets resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties:
     ~azure.mgmt.oracledatabase.models.AutonomousDatabaseNationalCharacterSetProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "AutonomousDatabaseNationalCharacterSetProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.AutonomousDatabaseNationalCharacterSetProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties:
         ~azure.mgmt.oracledatabase.models.AutonomousDatabaseNationalCharacterSetProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class AutonomousDatabaseNationalCharacterSetListResult(_serialization.Model):  # pylint: disable=name-too-long
    """The response of a AutonomousDatabaseNationalCharacterSet list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The AutonomousDatabaseNationalCharacterSet items on this page. Required.
    :vartype value: list[~azure.mgmt.oracledatabase.models.AutonomousDatabaseNationalCharacterSet]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AutonomousDatabaseNationalCharacterSet]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: List["_models.AutonomousDatabaseNationalCharacterSet"],
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The AutonomousDatabaseNationalCharacterSet items on this page. Required.
        :paramtype value:
         list[~azure.mgmt.oracledatabase.models.AutonomousDatabaseNationalCharacterSet]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AutonomousDatabaseNationalCharacterSetProperties(_serialization.Model):  # pylint: disable=name-too-long
    """AutonomousDatabaseNationalCharacterSet resource model.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar character_set: The Oracle Autonomous Database supported national character sets.
     Required.
    :vartype character_set: str
    """

    _validation = {
        "character_set": {"required": True, "readonly": True, "max_length": 255, "min_length": 1},
    }

    _attribute_map = {
        "character_set": {"key": "characterSet", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.character_set = None


class AutonomousDatabaseProperties(AutonomousDatabaseBaseProperties):  # pylint: disable=too-many-instance-attributes
    """Autonomous Database resource model.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar admin_password: Admin password.
    :vartype admin_password: str
    :ivar data_base_type: Database type to be created. Required. Known values are: "Regular" and
     "Clone".
    :vartype data_base_type: str or ~azure.mgmt.oracledatabase.models.DataBaseType
    :ivar autonomous_maintenance_schedule_type: The maintenance schedule type of the Autonomous
     Database Serverless. Known values are: "Early" and "Regular".
    :vartype autonomous_maintenance_schedule_type: str or
     ~azure.mgmt.oracledatabase.models.AutonomousMaintenanceScheduleType
    :ivar character_set: The character set for the autonomous database.
    :vartype character_set: str
    :ivar compute_count: The compute amount (CPUs) available to the database.
    :vartype compute_count: float
    :ivar compute_model: The compute model of the Autonomous Database. Known values are: "ECPU" and
     "OCPU".
    :vartype compute_model: str or ~azure.mgmt.oracledatabase.models.ComputeModel
    :ivar cpu_core_count: The number of CPU cores to be made available to the database.
    :vartype cpu_core_count: int
    :ivar customer_contacts: Customer Contacts.
    :vartype customer_contacts: list[~azure.mgmt.oracledatabase.models.CustomerContact]
    :ivar data_storage_size_in_tbs: The quantity of data in the database, in terabytes.
    :vartype data_storage_size_in_tbs: int
    :ivar data_storage_size_in_gbs: The size, in gigabytes, of the data volume that will be created
     and attached to the database.
    :vartype data_storage_size_in_gbs: int
    :ivar db_version: A valid Oracle Database version for Autonomous Database.
    :vartype db_version: str
    :ivar db_workload: The Autonomous Database workload type. Known values are: "OLTP", "DW",
     "AJD", and "APEX".
    :vartype db_workload: str or ~azure.mgmt.oracledatabase.models.WorkloadType
    :ivar display_name: The user-friendly name for the Autonomous Database.
    :vartype display_name: str
    :ivar is_auto_scaling_enabled: Indicates if auto scaling is enabled for the Autonomous Database
     CPU core count.
    :vartype is_auto_scaling_enabled: bool
    :ivar is_auto_scaling_for_storage_enabled: Indicates if auto scaling is enabled for the
     Autonomous Database storage.
    :vartype is_auto_scaling_for_storage_enabled: bool
    :ivar peer_db_ids: The list of `OCIDs
     <https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm>`_ of standby databases
     located in Autonomous Data Guard remote regions that are associated with the source database.
     Note that for Autonomous Database Serverless instances, standby databases located in the same
     region as the source primary database do not have OCIDs.
    :vartype peer_db_ids: list[str]
    :ivar peer_db_id: The database OCID of the Disaster Recovery peer database, which is located in
     a different region from the current peer database.
    :vartype peer_db_id: str
    :ivar is_local_data_guard_enabled: Indicates whether the Autonomous Database has local or
     called in-region Data Guard enabled.
    :vartype is_local_data_guard_enabled: bool
    :ivar is_remote_data_guard_enabled: Indicates whether the Autonomous Database has Cross Region
     Data Guard enabled.
    :vartype is_remote_data_guard_enabled: bool
    :ivar local_disaster_recovery_type: Indicates the local disaster recovery (DR) type of the
     Autonomous Database Serverless instance.Autonomous Data Guard (ADG) DR type provides business
     critical DR with a faster recovery time objective (RTO) during failover or
     switchover.Backup-based DR type provides lower cost DR with a slower RTO during failover or
     switchover. Known values are: "Adg" and "BackupBased".
    :vartype local_disaster_recovery_type: str or
     ~azure.mgmt.oracledatabase.models.DisasterRecoveryType
    :ivar local_standby_db: Local Autonomous Disaster Recovery standby database details.
    :vartype local_standby_db: ~azure.mgmt.oracledatabase.models.AutonomousDatabaseStandbySummary
    :ivar failed_data_recovery_in_seconds: Indicates the number of seconds of data loss for a Data
     Guard failover.
    :vartype failed_data_recovery_in_seconds: int
    :ivar is_mtls_connection_required: Specifies if the Autonomous Database requires mTLS
     connections.
    :vartype is_mtls_connection_required: bool
    :ivar is_preview_version_with_service_terms_accepted: Specifies if the Autonomous Database
     preview version is being provisioned.
    :vartype is_preview_version_with_service_terms_accepted: bool
    :ivar license_model: The Oracle license model that applies to the Oracle Autonomous Database.
     The default is LICENSE_INCLUDED. Known values are: "LicenseIncluded" and "BringYourOwnLicense".
    :vartype license_model: str or ~azure.mgmt.oracledatabase.models.LicenseModel
    :ivar ncharacter_set: The character set for the Autonomous Database.
    :vartype ncharacter_set: str
    :ivar lifecycle_details: Additional information about the current lifecycle state.
    :vartype lifecycle_details: str
    :ivar provisioning_state: Azure resource provisioning state. Known values are: "Succeeded",
     "Failed", "Canceled", and "Provisioning".
    :vartype provisioning_state: str or
     ~azure.mgmt.oracledatabase.models.AzureResourceProvisioningState
    :ivar lifecycle_state: Views lifecycleState. Known values are: "Provisioning", "Available",
     "Stopping", "Stopped", "Starting", "Terminating", "Terminated", "Unavailable",
     "RestoreInProgress", "RestoreFailed", "BackupInProgress", "ScaleInProgress",
     "AvailableNeedsAttention", "Updating", "MaintenanceInProgress", "Restarting", "Recreating",
     "RoleChangeInProgress", "Upgrading", "Inaccessible", and "Standby".
    :vartype lifecycle_state: str or
     ~azure.mgmt.oracledatabase.models.AutonomousDatabaseLifecycleState
    :ivar scheduled_operations: The list of scheduled operations.
    :vartype scheduled_operations: ~azure.mgmt.oracledatabase.models.ScheduledOperationsType
    :ivar private_endpoint_ip: The private endpoint Ip address for the resource.
    :vartype private_endpoint_ip: str
    :ivar private_endpoint_label: The resource's private endpoint label.
    :vartype private_endpoint_label: str
    :ivar oci_url: HTTPS link to OCI resources exposed to Azure Customer via Azure Interface.
    :vartype oci_url: str
    :ivar subnet_id: Client subnet.
    :vartype subnet_id: str
    :ivar vnet_id: VNET for network connectivity.
    :vartype vnet_id: str
    :ivar time_created: The date and time that the database was created.
    :vartype time_created: ~datetime.datetime
    :ivar time_maintenance_begin: The date and time when maintenance will begin.
    :vartype time_maintenance_begin: ~datetime.datetime
    :ivar time_maintenance_end: The date and time when maintenance will end.
    :vartype time_maintenance_end: ~datetime.datetime
    :ivar actual_used_data_storage_size_in_tbs: The current amount of storage in use for user and
     system data, in terabytes (TB).
    :vartype actual_used_data_storage_size_in_tbs: float
    :ivar allocated_storage_size_in_tbs: The amount of storage currently allocated for the database
     tables and billed for, rounded up.
    :vartype allocated_storage_size_in_tbs: float
    :ivar apex_details: Information about Oracle APEX Application Development.
    :vartype apex_details: ~azure.mgmt.oracledatabase.models.ApexDetailsType
    :ivar available_upgrade_versions: List of Oracle Database versions available for a database
     upgrade. If there are no version upgrades available, this list is empty.
    :vartype available_upgrade_versions: list[str]
    :ivar connection_strings: The connection string used to connect to the Autonomous Database.
    :vartype connection_strings: ~azure.mgmt.oracledatabase.models.ConnectionStringType
    :ivar connection_urls: The URLs for accessing Oracle Application Express (APEX) and SQL
     Developer Web with a browser from a Compute instance within your VCN or that has a direct
     connection to your VCN.
    :vartype connection_urls: ~azure.mgmt.oracledatabase.models.ConnectionUrlType
    :ivar data_safe_status: Status of the Data Safe registration for this Autonomous Database.
     Known values are: "Registering", "Registered", "Deregistering", "NotRegistered", and "Failed".
    :vartype data_safe_status: str or ~azure.mgmt.oracledatabase.models.DataSafeStatusType
    :ivar database_edition: The Oracle Database Edition that applies to the Autonomous databases.
     Known values are: "StandardEdition" and "EnterpriseEdition".
    :vartype database_edition: str or ~azure.mgmt.oracledatabase.models.DatabaseEditionType
    :ivar autonomous_database_id: Autonomous Database ID.
    :vartype autonomous_database_id: str
    :ivar in_memory_area_in_gbs: The area assigned to In-Memory tables in Autonomous Database.
    :vartype in_memory_area_in_gbs: int
    :ivar next_long_term_backup_time_stamp: The date and time when the next long-term backup would
     be created.
    :vartype next_long_term_backup_time_stamp: ~datetime.datetime
    :ivar long_term_backup_schedule: Details for the long-term backup schedule.
    :vartype long_term_backup_schedule:
     ~azure.mgmt.oracledatabase.models.LongTermBackUpScheduleDetails
    :ivar is_preview: Indicates if the Autonomous Database version is a preview version.
    :vartype is_preview: bool
    :ivar local_adg_auto_failover_max_data_loss_limit: Parameter that allows users to select an
     acceptable maximum data loss limit in seconds, up to which Automatic Failover will be triggered
     when necessary for a Local Autonomous Data Guard.
    :vartype local_adg_auto_failover_max_data_loss_limit: int
    :ivar memory_per_oracle_compute_unit_in_gbs: The amount of memory (in GBs) enabled per ECPU or
     OCPU.
    :vartype memory_per_oracle_compute_unit_in_gbs: int
    :ivar open_mode: Indicates the Autonomous Database mode. Known values are: "ReadOnly" and
     "ReadWrite".
    :vartype open_mode: str or ~azure.mgmt.oracledatabase.models.OpenModeType
    :ivar operations_insights_status: Status of Operations Insights for this Autonomous Database.
     Known values are: "Enabling", "Enabled", "Disabling", "NotEnabled", "FailedEnabling", and
     "FailedDisabling".
    :vartype operations_insights_status: str or
     ~azure.mgmt.oracledatabase.models.OperationsInsightsStatusType
    :ivar permission_level: The Autonomous Database permission level. Known values are:
     "Restricted" and "Unrestricted".
    :vartype permission_level: str or ~azure.mgmt.oracledatabase.models.PermissionLevelType
    :ivar private_endpoint: The private endpoint for the resource.
    :vartype private_endpoint: str
    :ivar provisionable_cpus: An array of CPU values that an Autonomous Database can be scaled to.
    :vartype provisionable_cpus: list[int]
    :ivar role: The Data Guard role of the Autonomous Container Database or Autonomous Database, if
     Autonomous Data Guard is enabled. Known values are: "Primary", "Standby", "DisabledStandby",
     "BackupCopy", and "SnapshotStandby".
    :vartype role: str or ~azure.mgmt.oracledatabase.models.RoleType
    :ivar service_console_url: The URL of the Service Console for the Autonomous Database.
    :vartype service_console_url: str
    :ivar sql_web_developer_url: The SQL Web Developer URL for the Oracle Autonomous Database.
    :vartype sql_web_developer_url: str
    :ivar supported_regions_to_clone_to: The list of regions that support the creation of an
     Autonomous Database clone or an Autonomous Data Guard standby database.
    :vartype supported_regions_to_clone_to: list[str]
    :ivar time_data_guard_role_changed: The date and time the Autonomous Data Guard role was
     switched for the Autonomous Database.
    :vartype time_data_guard_role_changed: str
    :ivar time_deletion_of_free_autonomous_database: The date and time the Always Free database
     will be automatically deleted because of inactivity.
    :vartype time_deletion_of_free_autonomous_database: str
    :ivar time_local_data_guard_enabled: The date and time that Autonomous Data Guard was enabled
     for an Autonomous Database where the standby was provisioned in the same region as the primary
     database.
    :vartype time_local_data_guard_enabled: str
    :ivar time_of_last_failover: The timestamp of the last failover operation.
    :vartype time_of_last_failover: str
    :ivar time_of_last_refresh: The date and time when last refresh happened.
    :vartype time_of_last_refresh: str
    :ivar time_of_last_refresh_point: The refresh point timestamp (UTC).
    :vartype time_of_last_refresh_point: str
    :ivar time_of_last_switchover: The timestamp of the last switchover operation for the
     Autonomous Database.
    :vartype time_of_last_switchover: str
    :ivar time_reclamation_of_free_autonomous_database: The date and time the Always Free database
     will be stopped because of inactivity.
    :vartype time_reclamation_of_free_autonomous_database: str
    :ivar used_data_storage_size_in_gbs: The storage space consumed by Autonomous Database in GBs.
    :vartype used_data_storage_size_in_gbs: int
    :ivar used_data_storage_size_in_tbs: The amount of storage that has been used, in terabytes.
    :vartype used_data_storage_size_in_tbs: int
    :ivar ocid: Database ocid.
    :vartype ocid: str
    :ivar backup_retention_period_in_days: Retention period, in days, for long-term backups.
    :vartype backup_retention_period_in_days: int
    :ivar whitelisted_ips: The client IP access control list (ACL). This is an array of CIDR
     notations and/or IP addresses. Values should be separate strings, separated by commas. Example:
     ['1.1.1.1','1.1.1.0/24','1.1.2.25'].
    :vartype whitelisted_ips: list[str]
    """

    _validation = {
        "data_base_type": {"required": True},
        "character_set": {"max_length": 255, "min_length": 1},
        "compute_count": {"maximum": 512, "minimum": 0.1},
        "cpu_core_count": {"maximum": 128, "minimum": 1},
        "data_storage_size_in_tbs": {"maximum": 384, "minimum": 1},
        "data_storage_size_in_gbs": {"maximum": 393216, "minimum": 20},
        "db_version": {"max_length": 255, "min_length": 1},
        "display_name": {"max_length": 255, "min_length": 1},
        "peer_db_ids": {"readonly": True},
        "peer_db_id": {"max_length": 255, "min_length": 1},
        "is_remote_data_guard_enabled": {"readonly": True},
        "local_disaster_recovery_type": {"readonly": True},
        "local_standby_db": {"readonly": True},
        "failed_data_recovery_in_seconds": {"readonly": True},
        "ncharacter_set": {"max_length": 255, "min_length": 1},
        "lifecycle_details": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "lifecycle_state": {"readonly": True},
        "oci_url": {"readonly": True},
        "time_created": {"readonly": True},
        "time_maintenance_begin": {"readonly": True},
        "time_maintenance_end": {"readonly": True},
        "actual_used_data_storage_size_in_tbs": {"readonly": True},
        "allocated_storage_size_in_tbs": {"readonly": True},
        "apex_details": {"readonly": True},
        "available_upgrade_versions": {"readonly": True},
        "connection_strings": {"readonly": True},
        "connection_urls": {"readonly": True},
        "data_safe_status": {"readonly": True},
        "in_memory_area_in_gbs": {"readonly": True},
        "next_long_term_backup_time_stamp": {"readonly": True},
        "is_preview": {"readonly": True},
        "local_adg_auto_failover_max_data_loss_limit": {"maximum": 3600, "minimum": 0},
        "memory_per_oracle_compute_unit_in_gbs": {"readonly": True},
        "operations_insights_status": {"readonly": True},
        "private_endpoint": {"readonly": True},
        "provisionable_cpus": {"readonly": True},
        "service_console_url": {"readonly": True, "max_length": 255, "min_length": 10},
        "sql_web_developer_url": {"readonly": True, "max_length": 2048, "min_length": 10},
        "supported_regions_to_clone_to": {"readonly": True, "max_items": 50, "min_items": 0},
        "time_data_guard_role_changed": {"readonly": True},
        "time_deletion_of_free_autonomous_database": {"readonly": True},
        "time_local_data_guard_enabled": {"readonly": True},
        "time_of_last_failover": {"readonly": True},
        "time_of_last_refresh": {"readonly": True},
        "time_of_last_refresh_point": {"readonly": True},
        "time_of_last_switchover": {"readonly": True},
        "time_reclamation_of_free_autonomous_database": {"readonly": True},
        "used_data_storage_size_in_gbs": {"readonly": True},
        "used_data_storage_size_in_tbs": {"readonly": True},
        "ocid": {"readonly": True, "max_length": 255, "min_length": 1},
    }

    _attribute_map = {
        "admin_password": {"key": "adminPassword", "type": "str"},
        "data_base_type": {"key": "dataBaseType", "type": "str"},
        "autonomous_maintenance_schedule_type": {"key": "autonomousMaintenanceScheduleType", "type": "str"},
        "character_set": {"key": "characterSet", "type": "str"},
        "compute_count": {"key": "computeCount", "type": "float"},
        "compute_model": {"key": "computeModel", "type": "str"},
        "cpu_core_count": {"key": "cpuCoreCount", "type": "int"},
        "customer_contacts": {"key": "customerContacts", "type": "[CustomerContact]"},
        "data_storage_size_in_tbs": {"key": "dataStorageSizeInTbs", "type": "int"},
        "data_storage_size_in_gbs": {"key": "dataStorageSizeInGbs", "type": "int"},
        "db_version": {"key": "dbVersion", "type": "str"},
        "db_workload": {"key": "dbWorkload", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "is_auto_scaling_enabled": {"key": "isAutoScalingEnabled", "type": "bool"},
        "is_auto_scaling_for_storage_enabled": {"key": "isAutoScalingForStorageEnabled", "type": "bool"},
        "peer_db_ids": {"key": "peerDbIds", "type": "[str]"},
        "peer_db_id": {"key": "peerDbId", "type": "str"},
        "is_local_data_guard_enabled": {"key": "isLocalDataGuardEnabled", "type": "bool"},
        "is_remote_data_guard_enabled": {"key": "isRemoteDataGuardEnabled", "type": "bool"},
        "local_disaster_recovery_type": {"key": "localDisasterRecoveryType", "type": "str"},
        "local_standby_db": {"key": "localStandbyDb", "type": "AutonomousDatabaseStandbySummary"},
        "failed_data_recovery_in_seconds": {"key": "failedDataRecoveryInSeconds", "type": "int"},
        "is_mtls_connection_required": {"key": "isMtlsConnectionRequired", "type": "bool"},
        "is_preview_version_with_service_terms_accepted": {
            "key": "isPreviewVersionWithServiceTermsAccepted",
            "type": "bool",
        },
        "license_model": {"key": "licenseModel", "type": "str"},
        "ncharacter_set": {"key": "ncharacterSet", "type": "str"},
        "lifecycle_details": {"key": "lifecycleDetails", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "lifecycle_state": {"key": "lifecycleState", "type": "str"},
        "scheduled_operations": {"key": "scheduledOperations", "type": "ScheduledOperationsType"},
        "private_endpoint_ip": {"key": "privateEndpointIp", "type": "str"},
        "private_endpoint_label": {"key": "privateEndpointLabel", "type": "str"},
        "oci_url": {"key": "ociUrl", "type": "str"},
        "subnet_id": {"key": "subnetId", "type": "str"},
        "vnet_id": {"key": "vnetId", "type": "str"},
        "time_created": {"key": "timeCreated", "type": "iso-8601"},
        "time_maintenance_begin": {"key": "timeMaintenanceBegin", "type": "iso-8601"},
        "time_maintenance_end": {"key": "timeMaintenanceEnd", "type": "iso-8601"},
        "actual_used_data_storage_size_in_tbs": {"key": "actualUsedDataStorageSizeInTbs", "type": "float"},
        "allocated_storage_size_in_tbs": {"key": "allocatedStorageSizeInTbs", "type": "float"},
        "apex_details": {"key": "apexDetails", "type": "ApexDetailsType"},
        "available_upgrade_versions": {"key": "availableUpgradeVersions", "type": "[str]"},
        "connection_strings": {"key": "connectionStrings", "type": "ConnectionStringType"},
        "connection_urls": {"key": "connectionUrls", "type": "ConnectionUrlType"},
        "data_safe_status": {"key": "dataSafeStatus", "type": "str"},
        "database_edition": {"key": "databaseEdition", "type": "str"},
        "autonomous_database_id": {"key": "autonomousDatabaseId", "type": "str"},
        "in_memory_area_in_gbs": {"key": "inMemoryAreaInGbs", "type": "int"},
        "next_long_term_backup_time_stamp": {"key": "nextLongTermBackupTimeStamp", "type": "iso-8601"},
        "long_term_backup_schedule": {"key": "longTermBackupSchedule", "type": "LongTermBackUpScheduleDetails"},
        "is_preview": {"key": "isPreview", "type": "bool"},
        "local_adg_auto_failover_max_data_loss_limit": {"key": "localAdgAutoFailoverMaxDataLossLimit", "type": "int"},
        "memory_per_oracle_compute_unit_in_gbs": {"key": "memoryPerOracleComputeUnitInGbs", "type": "int"},
        "open_mode": {"key": "openMode", "type": "str"},
        "operations_insights_status": {"key": "operationsInsightsStatus", "type": "str"},
        "permission_level": {"key": "permissionLevel", "type": "str"},
        "private_endpoint": {"key": "privateEndpoint", "type": "str"},
        "provisionable_cpus": {"key": "provisionableCpus", "type": "[int]"},
        "role": {"key": "role", "type": "str"},
        "service_console_url": {"key": "serviceConsoleUrl", "type": "str"},
        "sql_web_developer_url": {"key": "sqlWebDeveloperUrl", "type": "str"},
        "supported_regions_to_clone_to": {"key": "supportedRegionsToCloneTo", "type": "[str]"},
        "time_data_guard_role_changed": {"key": "timeDataGuardRoleChanged", "type": "str"},
        "time_deletion_of_free_autonomous_database": {"key": "timeDeletionOfFreeAutonomousDatabase", "type": "str"},
        "time_local_data_guard_enabled": {"key": "timeLocalDataGuardEnabled", "type": "str"},
        "time_of_last_failover": {"key": "timeOfLastFailover", "type": "str"},
        "time_of_last_refresh": {"key": "timeOfLastRefresh", "type": "str"},
        "time_of_last_refresh_point": {"key": "timeOfLastRefreshPoint", "type": "str"},
        "time_of_last_switchover": {"key": "timeOfLastSwitchover", "type": "str"},
        "time_reclamation_of_free_autonomous_database": {
            "key": "timeReclamationOfFreeAutonomousDatabase",
            "type": "str",
        },
        "used_data_storage_size_in_gbs": {"key": "usedDataStorageSizeInGbs", "type": "int"},
        "used_data_storage_size_in_tbs": {"key": "usedDataStorageSizeInTbs", "type": "int"},
        "ocid": {"key": "ocid", "type": "str"},
        "backup_retention_period_in_days": {"key": "backupRetentionPeriodInDays", "type": "int"},
        "whitelisted_ips": {"key": "whitelistedIps", "type": "[str]"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        admin_password: Optional[str] = None,
        autonomous_maintenance_schedule_type: Optional[Union[str, "_models.AutonomousMaintenanceScheduleType"]] = None,
        character_set: Optional[str] = None,
        compute_count: Optional[float] = None,
        compute_model: Optional[Union[str, "_models.ComputeModel"]] = None,
        cpu_core_count: Optional[int] = None,
        customer_contacts: Optional[List["_models.CustomerContact"]] = None,
        data_storage_size_in_tbs: Optional[int] = None,
        data_storage_size_in_gbs: Optional[int] = None,
        db_version: Optional[str] = None,
        db_workload: Optional[Union[str, "_models.WorkloadType"]] = None,
        display_name: Optional[str] = None,
        is_auto_scaling_enabled: Optional[bool] = None,
        is_auto_scaling_for_storage_enabled: Optional[bool] = None,
        peer_db_id: Optional[str] = None,
        is_local_data_guard_enabled: Optional[bool] = None,
        is_mtls_connection_required: Optional[bool] = None,
        is_preview_version_with_service_terms_accepted: Optional[bool] = None,
        license_model: Optional[Union[str, "_models.LicenseModel"]] = None,
        ncharacter_set: Optional[str] = None,
        scheduled_operations: Optional["_models.ScheduledOperationsType"] = None,
        private_endpoint_ip: Optional[str] = None,
        private_endpoint_label: Optional[str] = None,
        subnet_id: Optional[str] = None,
        vnet_id: Optional[str] = None,
        database_edition: Optional[Union[str, "_models.DatabaseEditionType"]] = None,
        autonomous_database_id: Optional[str] = None,
        long_term_backup_schedule: Optional["_models.LongTermBackUpScheduleDetails"] = None,
        local_adg_auto_failover_max_data_loss_limit: Optional[int] = None,
        open_mode: Optional[Union[str, "_models.OpenModeType"]] = None,
        permission_level: Optional[Union[str, "_models.PermissionLevelType"]] = None,
        role: Optional[Union[str, "_models.RoleType"]] = None,
        backup_retention_period_in_days: Optional[int] = None,
        whitelisted_ips: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword admin_password: Admin password.
        :paramtype admin_password: str
        :keyword autonomous_maintenance_schedule_type: The maintenance schedule type of the Autonomous
         Database Serverless. Known values are: "Early" and "Regular".
        :paramtype autonomous_maintenance_schedule_type: str or
         ~azure.mgmt.oracledatabase.models.AutonomousMaintenanceScheduleType
        :keyword character_set: The character set for the autonomous database.
        :paramtype character_set: str
        :keyword compute_count: The compute amount (CPUs) available to the database.
        :paramtype compute_count: float
        :keyword compute_model: The compute model of the Autonomous Database. Known values are: "ECPU"
         and "OCPU".
        :paramtype compute_model: str or ~azure.mgmt.oracledatabase.models.ComputeModel
        :keyword cpu_core_count: The number of CPU cores to be made available to the database.
        :paramtype cpu_core_count: int
        :keyword customer_contacts: Customer Contacts.
        :paramtype customer_contacts: list[~azure.mgmt.oracledatabase.models.CustomerContact]
        :keyword data_storage_size_in_tbs: The quantity of data in the database, in terabytes.
        :paramtype data_storage_size_in_tbs: int
        :keyword data_storage_size_in_gbs: The size, in gigabytes, of the data volume that will be
         created and attached to the database.
        :paramtype data_storage_size_in_gbs: int
        :keyword db_version: A valid Oracle Database version for Autonomous Database.
        :paramtype db_version: str
        :keyword db_workload: The Autonomous Database workload type. Known values are: "OLTP", "DW",
         "AJD", and "APEX".
        :paramtype db_workload: str or ~azure.mgmt.oracledatabase.models.WorkloadType
        :keyword display_name: The user-friendly name for the Autonomous Database.
        :paramtype display_name: str
        :keyword is_auto_scaling_enabled: Indicates if auto scaling is enabled for the Autonomous
         Database CPU core count.
        :paramtype is_auto_scaling_enabled: bool
        :keyword is_auto_scaling_for_storage_enabled: Indicates if auto scaling is enabled for the
         Autonomous Database storage.
        :paramtype is_auto_scaling_for_storage_enabled: bool
        :keyword peer_db_id: The database OCID of the Disaster Recovery peer database, which is located
         in a different region from the current peer database.
        :paramtype peer_db_id: str
        :keyword is_local_data_guard_enabled: Indicates whether the Autonomous Database has local or
         called in-region Data Guard enabled.
        :paramtype is_local_data_guard_enabled: bool
        :keyword is_mtls_connection_required: Specifies if the Autonomous Database requires mTLS
         connections.
        :paramtype is_mtls_connection_required: bool
        :keyword is_preview_version_with_service_terms_accepted: Specifies if the Autonomous Database
         preview version is being provisioned.
        :paramtype is_preview_version_with_service_terms_accepted: bool
        :keyword license_model: The Oracle license model that applies to the Oracle Autonomous
         Database. The default is LICENSE_INCLUDED. Known values are: "LicenseIncluded" and
         "BringYourOwnLicense".
        :paramtype license_model: str or ~azure.mgmt.oracledatabase.models.LicenseModel
        :keyword ncharacter_set: The character set for the Autonomous Database.
        :paramtype ncharacter_set: str
        :keyword scheduled_operations: The list of scheduled operations.
        :paramtype scheduled_operations: ~azure.mgmt.oracledatabase.models.ScheduledOperationsType
        :keyword private_endpoint_ip: The private endpoint Ip address for the resource.
        :paramtype private_endpoint_ip: str
        :keyword private_endpoint_label: The resource's private endpoint label.
        :paramtype private_endpoint_label: str
        :keyword subnet_id: Client subnet.
        :paramtype subnet_id: str
        :keyword vnet_id: VNET for network connectivity.
        :paramtype vnet_id: str
        :keyword database_edition: The Oracle Database Edition that applies to the Autonomous
         databases. Known values are: "StandardEdition" and "EnterpriseEdition".
        :paramtype database_edition: str or ~azure.mgmt.oracledatabase.models.DatabaseEditionType
        :keyword autonomous_database_id: Autonomous Database ID.
        :paramtype autonomous_database_id: str
        :keyword long_term_backup_schedule: Details for the long-term backup schedule.
        :paramtype long_term_backup_schedule:
         ~azure.mgmt.oracledatabase.models.LongTermBackUpScheduleDetails
        :keyword local_adg_auto_failover_max_data_loss_limit: Parameter that allows users to select an
         acceptable maximum data loss limit in seconds, up to which Automatic Failover will be triggered
         when necessary for a Local Autonomous Data Guard.
        :paramtype local_adg_auto_failover_max_data_loss_limit: int
        :keyword open_mode: Indicates the Autonomous Database mode. Known values are: "ReadOnly" and
         "ReadWrite".
        :paramtype open_mode: str or ~azure.mgmt.oracledatabase.models.OpenModeType
        :keyword permission_level: The Autonomous Database permission level. Known values are:
         "Restricted" and "Unrestricted".
        :paramtype permission_level: str or ~azure.mgmt.oracledatabase.models.PermissionLevelType
        :keyword role: The Data Guard role of the Autonomous Container Database or Autonomous Database,
         if Autonomous Data Guard is enabled. Known values are: "Primary", "Standby", "DisabledStandby",
         "BackupCopy", and "SnapshotStandby".
        :paramtype role: str or ~azure.mgmt.oracledatabase.models.RoleType
        :keyword backup_retention_period_in_days: Retention period, in days, for long-term backups.
        :paramtype backup_retention_period_in_days: int
        :keyword whitelisted_ips: The client IP access control list (ACL). This is an array of CIDR
         notations and/or IP addresses. Values should be separate strings, separated by commas. Example:
         ['1.1.1.1','1.1.1.0/24','1.1.2.25'].
        :paramtype whitelisted_ips: list[str]
        """
        super().__init__(
            admin_password=admin_password,
            autonomous_maintenance_schedule_type=autonomous_maintenance_schedule_type,
            character_set=character_set,
            compute_count=compute_count,
            compute_model=compute_model,
            cpu_core_count=cpu_core_count,
            customer_contacts=customer_contacts,
            data_storage_size_in_tbs=data_storage_size_in_tbs,
            data_storage_size_in_gbs=data_storage_size_in_gbs,
            db_version=db_version,
            db_workload=db_workload,
            display_name=display_name,
            is_auto_scaling_enabled=is_auto_scaling_enabled,
            is_auto_scaling_for_storage_enabled=is_auto_scaling_for_storage_enabled,
            peer_db_id=peer_db_id,
            is_local_data_guard_enabled=is_local_data_guard_enabled,
            is_mtls_connection_required=is_mtls_connection_required,
            is_preview_version_with_service_terms_accepted=is_preview_version_with_service_terms_accepted,
            license_model=license_model,
            ncharacter_set=ncharacter_set,
            scheduled_operations=scheduled_operations,
            private_endpoint_ip=private_endpoint_ip,
            private_endpoint_label=private_endpoint_label,
            subnet_id=subnet_id,
            vnet_id=vnet_id,
            database_edition=database_edition,
            autonomous_database_id=autonomous_database_id,
            long_term_backup_schedule=long_term_backup_schedule,
            local_adg_auto_failover_max_data_loss_limit=local_adg_auto_failover_max_data_loss_limit,
            open_mode=open_mode,
            permission_level=permission_level,
            role=role,
            backup_retention_period_in_days=backup_retention_period_in_days,
            whitelisted_ips=whitelisted_ips,
            **kwargs
        )
        self.data_base_type: str = "Regular"


class AutonomousDatabaseStandbySummary(_serialization.Model):
    """Autonomous Disaster Recovery standby database details.

    :ivar lag_time_in_seconds: The amount of time, in seconds, that the data of the standby
     database lags the data of the primary database. Can be used to determine the potential data
     loss in the event of a failover.
    :vartype lag_time_in_seconds: int
    :ivar lifecycle_state: The current state of the Autonomous Database. Known values are:
     "Provisioning", "Available", "Stopping", "Stopped", "Starting", "Terminating", "Terminated",
     "Unavailable", "RestoreInProgress", "RestoreFailed", "BackupInProgress", "ScaleInProgress",
     "AvailableNeedsAttention", "Updating", "MaintenanceInProgress", "Restarting", "Recreating",
     "RoleChangeInProgress", "Upgrading", "Inaccessible", and "Standby".
    :vartype lifecycle_state: str or
     ~azure.mgmt.oracledatabase.models.AutonomousDatabaseLifecycleState
    :ivar lifecycle_details: Additional information about the current lifecycle state.
    :vartype lifecycle_details: str
    :ivar time_data_guard_role_changed: The date and time the Autonomous Data Guard role was
     switched for the standby Autonomous Database.
    :vartype time_data_guard_role_changed: str
    :ivar time_disaster_recovery_role_changed: The date and time the Disaster Recovery role was
     switched for the standby Autonomous Database.
    :vartype time_disaster_recovery_role_changed: str
    """

    _attribute_map = {
        "lag_time_in_seconds": {"key": "lagTimeInSeconds", "type": "int"},
        "lifecycle_state": {"key": "lifecycleState", "type": "str"},
        "lifecycle_details": {"key": "lifecycleDetails", "type": "str"},
        "time_data_guard_role_changed": {"key": "timeDataGuardRoleChanged", "type": "str"},
        "time_disaster_recovery_role_changed": {"key": "timeDisasterRecoveryRoleChanged", "type": "str"},
    }

    def __init__(
        self,
        *,
        lag_time_in_seconds: Optional[int] = None,
        lifecycle_state: Optional[Union[str, "_models.AutonomousDatabaseLifecycleState"]] = None,
        lifecycle_details: Optional[str] = None,
        time_data_guard_role_changed: Optional[str] = None,
        time_disaster_recovery_role_changed: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword lag_time_in_seconds: The amount of time, in seconds, that the data of the standby
         database lags the data of the primary database. Can be used to determine the potential data
         loss in the event of a failover.
        :paramtype lag_time_in_seconds: int
        :keyword lifecycle_state: The current state of the Autonomous Database. Known values are:
         "Provisioning", "Available", "Stopping", "Stopped", "Starting", "Terminating", "Terminated",
         "Unavailable", "RestoreInProgress", "RestoreFailed", "BackupInProgress", "ScaleInProgress",
         "AvailableNeedsAttention", "Updating", "MaintenanceInProgress", "Restarting", "Recreating",
         "RoleChangeInProgress", "Upgrading", "Inaccessible", and "Standby".
        :paramtype lifecycle_state: str or
         ~azure.mgmt.oracledatabase.models.AutonomousDatabaseLifecycleState
        :keyword lifecycle_details: Additional information about the current lifecycle state.
        :paramtype lifecycle_details: str
        :keyword time_data_guard_role_changed: The date and time the Autonomous Data Guard role was
         switched for the standby Autonomous Database.
        :paramtype time_data_guard_role_changed: str
        :keyword time_disaster_recovery_role_changed: The date and time the Disaster Recovery role was
         switched for the standby Autonomous Database.
        :paramtype time_disaster_recovery_role_changed: str
        """
        super().__init__(**kwargs)
        self.lag_time_in_seconds = lag_time_in_seconds
        self.lifecycle_state = lifecycle_state
        self.lifecycle_details = lifecycle_details
        self.time_data_guard_role_changed = time_data_guard_role_changed
        self.time_disaster_recovery_role_changed = time_disaster_recovery_role_changed


class AutonomousDatabaseUpdate(_serialization.Model):
    """The type used for update operations of the AutonomousDatabase.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The updatable properties of the AutonomousDatabase.
    :vartype properties: ~azure.mgmt.oracledatabase.models.AutonomousDatabaseUpdateProperties
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "AutonomousDatabaseUpdateProperties"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.AutonomousDatabaseUpdateProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: The updatable properties of the AutonomousDatabase.
        :paramtype properties: ~azure.mgmt.oracledatabase.models.AutonomousDatabaseUpdateProperties
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.properties = properties


class AutonomousDatabaseUpdateProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The updatable properties of the AutonomousDatabase.

    :ivar admin_password: Admin password.
    :vartype admin_password: str
    :ivar autonomous_maintenance_schedule_type: The maintenance schedule type of the Autonomous
     Database Serverless. Known values are: "Early" and "Regular".
    :vartype autonomous_maintenance_schedule_type: str or
     ~azure.mgmt.oracledatabase.models.AutonomousMaintenanceScheduleType
    :ivar compute_count: The compute amount (CPUs) available to the database.
    :vartype compute_count: float
    :ivar cpu_core_count: The number of CPU cores to be made available to the database.
    :vartype cpu_core_count: int
    :ivar customer_contacts: Customer Contacts.
    :vartype customer_contacts: list[~azure.mgmt.oracledatabase.models.CustomerContact]
    :ivar data_storage_size_in_tbs: The quantity of data in the database, in terabytes.
    :vartype data_storage_size_in_tbs: int
    :ivar data_storage_size_in_gbs: The size, in gigabytes, of the data volume that will be created
     and attached to the database.
    :vartype data_storage_size_in_gbs: int
    :ivar display_name: The user-friendly name for the Autonomous Database.
    :vartype display_name: str
    :ivar is_auto_scaling_enabled: Indicates if auto scaling is enabled for the Autonomous Database
     CPU core count.
    :vartype is_auto_scaling_enabled: bool
    :ivar is_auto_scaling_for_storage_enabled: Indicates if auto scaling is enabled for the
     Autonomous Database storage.
    :vartype is_auto_scaling_for_storage_enabled: bool
    :ivar peer_db_id: The database OCID of the Disaster Recovery peer database, which is located in
     a different region from the current peer database.
    :vartype peer_db_id: str
    :ivar is_local_data_guard_enabled: Indicates whether the Autonomous Database has local or
     called in-region Data Guard enabled.
    :vartype is_local_data_guard_enabled: bool
    :ivar is_mtls_connection_required: Specifies if the Autonomous Database requires mTLS
     connections.
    :vartype is_mtls_connection_required: bool
    :ivar license_model: The Oracle license model that applies to the Oracle Autonomous Database.
     The default is LICENSE_INCLUDED. Known values are: "LicenseIncluded" and "BringYourOwnLicense".
    :vartype license_model: str or ~azure.mgmt.oracledatabase.models.LicenseModel
    :ivar scheduled_operations: The list of scheduled operations.
    :vartype scheduled_operations: ~azure.mgmt.oracledatabase.models.ScheduledOperationsTypeUpdate
    :ivar database_edition: The Oracle Database Edition that applies to the Autonomous databases.
     Known values are: "StandardEdition" and "EnterpriseEdition".
    :vartype database_edition: str or ~azure.mgmt.oracledatabase.models.DatabaseEditionType
    :ivar long_term_backup_schedule: Details for the long-term backup schedule.
    :vartype long_term_backup_schedule:
     ~azure.mgmt.oracledatabase.models.LongTermBackUpScheduleDetails
    :ivar local_adg_auto_failover_max_data_loss_limit: Parameter that allows users to select an
     acceptable maximum data loss limit in seconds, up to which Automatic Failover will be triggered
     when necessary for a Local Autonomous Data Guard.
    :vartype local_adg_auto_failover_max_data_loss_limit: int
    :ivar open_mode: Indicates the Autonomous Database mode. Known values are: "ReadOnly" and
     "ReadWrite".
    :vartype open_mode: str or ~azure.mgmt.oracledatabase.models.OpenModeType
    :ivar permission_level: The Autonomous Database permission level. Known values are:
     "Restricted" and "Unrestricted".
    :vartype permission_level: str or ~azure.mgmt.oracledatabase.models.PermissionLevelType
    :ivar role: The Data Guard role of the Autonomous Container Database or Autonomous Database, if
     Autonomous Data Guard is enabled. Known values are: "Primary", "Standby", "DisabledStandby",
     "BackupCopy", and "SnapshotStandby".
    :vartype role: str or ~azure.mgmt.oracledatabase.models.RoleType
    :ivar backup_retention_period_in_days: Retention period, in days, for long-term backups.
    :vartype backup_retention_period_in_days: int
    :ivar whitelisted_ips: The client IP access control list (ACL). This is an array of CIDR
     notations and/or IP addresses. Values should be separate strings, separated by commas. Example:
     ['1.1.1.1','1.1.1.0/24','1.1.2.25'].
    :vartype whitelisted_ips: list[str]
    """

    _validation = {
        "compute_count": {"maximum": 512, "minimum": 0.1},
        "cpu_core_count": {"maximum": 128, "minimum": 1},
        "data_storage_size_in_tbs": {"maximum": 384, "minimum": 1},
        "data_storage_size_in_gbs": {"maximum": 393216, "minimum": 20},
        "display_name": {"max_length": 255, "min_length": 1},
        "peer_db_id": {"max_length": 255, "min_length": 1},
        "local_adg_auto_failover_max_data_loss_limit": {"maximum": 3600, "minimum": 0},
    }

    _attribute_map = {
        "admin_password": {"key": "adminPassword", "type": "str"},
        "autonomous_maintenance_schedule_type": {"key": "autonomousMaintenanceScheduleType", "type": "str"},
        "compute_count": {"key": "computeCount", "type": "float"},
        "cpu_core_count": {"key": "cpuCoreCount", "type": "int"},
        "customer_contacts": {"key": "customerContacts", "type": "[CustomerContact]"},
        "data_storage_size_in_tbs": {"key": "dataStorageSizeInTbs", "type": "int"},
        "data_storage_size_in_gbs": {"key": "dataStorageSizeInGbs", "type": "int"},
        "display_name": {"key": "displayName", "type": "str"},
        "is_auto_scaling_enabled": {"key": "isAutoScalingEnabled", "type": "bool"},
        "is_auto_scaling_for_storage_enabled": {"key": "isAutoScalingForStorageEnabled", "type": "bool"},
        "peer_db_id": {"key": "peerDbId", "type": "str"},
        "is_local_data_guard_enabled": {"key": "isLocalDataGuardEnabled", "type": "bool"},
        "is_mtls_connection_required": {"key": "isMtlsConnectionRequired", "type": "bool"},
        "license_model": {"key": "licenseModel", "type": "str"},
        "scheduled_operations": {"key": "scheduledOperations", "type": "ScheduledOperationsTypeUpdate"},
        "database_edition": {"key": "databaseEdition", "type": "str"},
        "long_term_backup_schedule": {"key": "longTermBackupSchedule", "type": "LongTermBackUpScheduleDetails"},
        "local_adg_auto_failover_max_data_loss_limit": {"key": "localAdgAutoFailoverMaxDataLossLimit", "type": "int"},
        "open_mode": {"key": "openMode", "type": "str"},
        "permission_level": {"key": "permissionLevel", "type": "str"},
        "role": {"key": "role", "type": "str"},
        "backup_retention_period_in_days": {"key": "backupRetentionPeriodInDays", "type": "int"},
        "whitelisted_ips": {"key": "whitelistedIps", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        admin_password: Optional[str] = None,
        autonomous_maintenance_schedule_type: Optional[Union[str, "_models.AutonomousMaintenanceScheduleType"]] = None,
        compute_count: Optional[float] = None,
        cpu_core_count: Optional[int] = None,
        customer_contacts: Optional[List["_models.CustomerContact"]] = None,
        data_storage_size_in_tbs: Optional[int] = None,
        data_storage_size_in_gbs: Optional[int] = None,
        display_name: Optional[str] = None,
        is_auto_scaling_enabled: Optional[bool] = None,
        is_auto_scaling_for_storage_enabled: Optional[bool] = None,
        peer_db_id: Optional[str] = None,
        is_local_data_guard_enabled: Optional[bool] = None,
        is_mtls_connection_required: Optional[bool] = None,
        license_model: Optional[Union[str, "_models.LicenseModel"]] = None,
        scheduled_operations: Optional["_models.ScheduledOperationsTypeUpdate"] = None,
        database_edition: Optional[Union[str, "_models.DatabaseEditionType"]] = None,
        long_term_backup_schedule: Optional["_models.LongTermBackUpScheduleDetails"] = None,
        local_adg_auto_failover_max_data_loss_limit: Optional[int] = None,
        open_mode: Optional[Union[str, "_models.OpenModeType"]] = None,
        permission_level: Optional[Union[str, "_models.PermissionLevelType"]] = None,
        role: Optional[Union[str, "_models.RoleType"]] = None,
        backup_retention_period_in_days: Optional[int] = None,
        whitelisted_ips: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword admin_password: Admin password.
        :paramtype admin_password: str
        :keyword autonomous_maintenance_schedule_type: The maintenance schedule type of the Autonomous
         Database Serverless. Known values are: "Early" and "Regular".
        :paramtype autonomous_maintenance_schedule_type: str or
         ~azure.mgmt.oracledatabase.models.AutonomousMaintenanceScheduleType
        :keyword compute_count: The compute amount (CPUs) available to the database.
        :paramtype compute_count: float
        :keyword cpu_core_count: The number of CPU cores to be made available to the database.
        :paramtype cpu_core_count: int
        :keyword customer_contacts: Customer Contacts.
        :paramtype customer_contacts: list[~azure.mgmt.oracledatabase.models.CustomerContact]
        :keyword data_storage_size_in_tbs: The quantity of data in the database, in terabytes.
        :paramtype data_storage_size_in_tbs: int
        :keyword data_storage_size_in_gbs: The size, in gigabytes, of the data volume that will be
         created and attached to the database.
        :paramtype data_storage_size_in_gbs: int
        :keyword display_name: The user-friendly name for the Autonomous Database.
        :paramtype display_name: str
        :keyword is_auto_scaling_enabled: Indicates if auto scaling is enabled for the Autonomous
         Database CPU core count.
        :paramtype is_auto_scaling_enabled: bool
        :keyword is_auto_scaling_for_storage_enabled: Indicates if auto scaling is enabled for the
         Autonomous Database storage.
        :paramtype is_auto_scaling_for_storage_enabled: bool
        :keyword peer_db_id: The database OCID of the Disaster Recovery peer database, which is located
         in a different region from the current peer database.
        :paramtype peer_db_id: str
        :keyword is_local_data_guard_enabled: Indicates whether the Autonomous Database has local or
         called in-region Data Guard enabled.
        :paramtype is_local_data_guard_enabled: bool
        :keyword is_mtls_connection_required: Specifies if the Autonomous Database requires mTLS
         connections.
        :paramtype is_mtls_connection_required: bool
        :keyword license_model: The Oracle license model that applies to the Oracle Autonomous
         Database. The default is LICENSE_INCLUDED. Known values are: "LicenseIncluded" and
         "BringYourOwnLicense".
        :paramtype license_model: str or ~azure.mgmt.oracledatabase.models.LicenseModel
        :keyword scheduled_operations: The list of scheduled operations.
        :paramtype scheduled_operations:
         ~azure.mgmt.oracledatabase.models.ScheduledOperationsTypeUpdate
        :keyword database_edition: The Oracle Database Edition that applies to the Autonomous
         databases. Known values are: "StandardEdition" and "EnterpriseEdition".
        :paramtype database_edition: str or ~azure.mgmt.oracledatabase.models.DatabaseEditionType
        :keyword long_term_backup_schedule: Details for the long-term backup schedule.
        :paramtype long_term_backup_schedule:
         ~azure.mgmt.oracledatabase.models.LongTermBackUpScheduleDetails
        :keyword local_adg_auto_failover_max_data_loss_limit: Parameter that allows users to select an
         acceptable maximum data loss limit in seconds, up to which Automatic Failover will be triggered
         when necessary for a Local Autonomous Data Guard.
        :paramtype local_adg_auto_failover_max_data_loss_limit: int
        :keyword open_mode: Indicates the Autonomous Database mode. Known values are: "ReadOnly" and
         "ReadWrite".
        :paramtype open_mode: str or ~azure.mgmt.oracledatabase.models.OpenModeType
        :keyword permission_level: The Autonomous Database permission level. Known values are:
         "Restricted" and "Unrestricted".
        :paramtype permission_level: str or ~azure.mgmt.oracledatabase.models.PermissionLevelType
        :keyword role: The Data Guard role of the Autonomous Container Database or Autonomous Database,
         if Autonomous Data Guard is enabled. Known values are: "Primary", "Standby", "DisabledStandby",
         "BackupCopy", and "SnapshotStandby".
        :paramtype role: str or ~azure.mgmt.oracledatabase.models.RoleType
        :keyword backup_retention_period_in_days: Retention period, in days, for long-term backups.
        :paramtype backup_retention_period_in_days: int
        :keyword whitelisted_ips: The client IP access control list (ACL). This is an array of CIDR
         notations and/or IP addresses. Values should be separate strings, separated by commas. Example:
         ['1.1.1.1','1.1.1.0/24','1.1.2.25'].
        :paramtype whitelisted_ips: list[str]
        """
        super().__init__(**kwargs)
        self.admin_password = admin_password
        self.autonomous_maintenance_schedule_type = autonomous_maintenance_schedule_type
        self.compute_count = compute_count
        self.cpu_core_count = cpu_core_count
        self.customer_contacts = customer_contacts
        self.data_storage_size_in_tbs = data_storage_size_in_tbs
        self.data_storage_size_in_gbs = data_storage_size_in_gbs
        self.display_name = display_name
        self.is_auto_scaling_enabled = is_auto_scaling_enabled
        self.is_auto_scaling_for_storage_enabled = is_auto_scaling_for_storage_enabled
        self.peer_db_id = peer_db_id
        self.is_local_data_guard_enabled = is_local_data_guard_enabled
        self.is_mtls_connection_required = is_mtls_connection_required
        self.license_model = license_model
        self.scheduled_operations = scheduled_operations
        self.database_edition = database_edition
        self.long_term_backup_schedule = long_term_backup_schedule
        self.local_adg_auto_failover_max_data_loss_limit = local_adg_auto_failover_max_data_loss_limit
        self.open_mode = open_mode
        self.permission_level = permission_level
        self.role = role
        self.backup_retention_period_in_days = backup_retention_period_in_days
        self.whitelisted_ips = whitelisted_ips


class AutonomousDatabaseWalletFile(_serialization.Model):
    """Autonomous Database Wallet File resource model.

    All required parameters must be populated in order to send to server.

    :ivar wallet_files: The base64 encoded wallet files. Required.
    :vartype wallet_files: str
    """

    _validation = {
        "wallet_files": {"required": True},
    }

    _attribute_map = {
        "wallet_files": {"key": "walletFiles", "type": "str"},
    }

    def __init__(self, *, wallet_files: str, **kwargs: Any) -> None:
        """
        :keyword wallet_files: The base64 encoded wallet files. Required.
        :paramtype wallet_files: str
        """
        super().__init__(**kwargs)
        self.wallet_files = wallet_files


class AutonomousDbVersion(ProxyResource):
    """AutonomousDbVersion resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.AutonomousDbVersionProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "AutonomousDbVersionProperties"},
    }

    def __init__(self, *, properties: Optional["_models.AutonomousDbVersionProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.oracledatabase.models.AutonomousDbVersionProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class AutonomousDbVersionListResult(_serialization.Model):
    """The response of a AutonomousDbVersion list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The AutonomousDbVersion items on this page. Required.
    :vartype value: list[~azure.mgmt.oracledatabase.models.AutonomousDbVersion]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AutonomousDbVersion]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.AutonomousDbVersion"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The AutonomousDbVersion items on this page. Required.
        :paramtype value: list[~azure.mgmt.oracledatabase.models.AutonomousDbVersion]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AutonomousDbVersionProperties(_serialization.Model):
    """AutonomousDbVersion resource model.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar version: Supported Autonomous Db versions. Required.
    :vartype version: str
    :ivar db_workload: The Autonomous Database workload type. Known values are: "OLTP", "DW",
     "AJD", and "APEX".
    :vartype db_workload: str or ~azure.mgmt.oracledatabase.models.WorkloadType
    :ivar is_default_for_free: True if this version of the Oracle Database software's default is
     free.
    :vartype is_default_for_free: bool
    :ivar is_default_for_paid: True if this version of the Oracle Database software's default is
     paid.
    :vartype is_default_for_paid: bool
    :ivar is_free_tier_enabled: True if this version of the Oracle Database software can be used
     for Always-Free Autonomous Databases.
    :vartype is_free_tier_enabled: bool
    :ivar is_paid_enabled: True if this version of the Oracle Database software has payments
     enabled.
    :vartype is_paid_enabled: bool
    """

    _validation = {
        "version": {"required": True, "readonly": True, "max_length": 255, "min_length": 1},
        "db_workload": {"readonly": True},
        "is_default_for_free": {"readonly": True},
        "is_default_for_paid": {"readonly": True},
        "is_free_tier_enabled": {"readonly": True},
        "is_paid_enabled": {"readonly": True},
    }

    _attribute_map = {
        "version": {"key": "version", "type": "str"},
        "db_workload": {"key": "dbWorkload", "type": "str"},
        "is_default_for_free": {"key": "isDefaultForFree", "type": "bool"},
        "is_default_for_paid": {"key": "isDefaultForPaid", "type": "bool"},
        "is_free_tier_enabled": {"key": "isFreeTierEnabled", "type": "bool"},
        "is_paid_enabled": {"key": "isPaidEnabled", "type": "bool"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.version = None
        self.db_workload = None
        self.is_default_for_free = None
        self.is_default_for_paid = None
        self.is_free_tier_enabled = None
        self.is_paid_enabled = None


class CloudAccountDetails(_serialization.Model):
    """Cloud Account Details model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar cloud_account_name: Cloud Account name.
    :vartype cloud_account_name: str
    :ivar cloud_account_home_region: Cloud Account Home region.
    :vartype cloud_account_home_region: str
    """

    _validation = {
        "cloud_account_name": {"readonly": True},
        "cloud_account_home_region": {"readonly": True},
    }

    _attribute_map = {
        "cloud_account_name": {"key": "cloudAccountName", "type": "str"},
        "cloud_account_home_region": {"key": "cloudAccountHomeRegion", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.cloud_account_name = None
        self.cloud_account_home_region = None


class CloudExadataInfrastructure(TrackedResource):
    """CloudExadataInfrastructure resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.CloudExadataInfrastructureProperties
    :ivar zones: CloudExadataInfrastructure zones. Required.
    :vartype zones: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "zones": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "CloudExadataInfrastructureProperties"},
        "zones": {"key": "zones", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        location: str,
        zones: List[str],
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.CloudExadataInfrastructureProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.oracledatabase.models.CloudExadataInfrastructureProperties
        :keyword zones: CloudExadataInfrastructure zones. Required.
        :paramtype zones: list[str]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties
        self.zones = zones


class CloudExadataInfrastructureListResult(_serialization.Model):
    """The response of a CloudExadataInfrastructure list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The CloudExadataInfrastructure items on this page. Required.
    :vartype value: list[~azure.mgmt.oracledatabase.models.CloudExadataInfrastructure]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CloudExadataInfrastructure]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.CloudExadataInfrastructure"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The CloudExadataInfrastructure items on this page. Required.
        :paramtype value: list[~azure.mgmt.oracledatabase.models.CloudExadataInfrastructure]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CloudExadataInfrastructureProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """CloudExadataInfrastructure resource model.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar ocid: Exadata infra ocid.
    :vartype ocid: str
    :ivar compute_count: The number of compute servers for the cloud Exadata infrastructure.
    :vartype compute_count: int
    :ivar storage_count: The number of storage servers for the cloud Exadata infrastructure.
    :vartype storage_count: int
    :ivar total_storage_size_in_gbs: The total storage allocated to the cloud Exadata
     infrastructure resource, in gigabytes (GB).
    :vartype total_storage_size_in_gbs: int
    :ivar available_storage_size_in_gbs: The available storage can be allocated to the cloud
     Exadata infrastructure resource, in gigabytes (GB).
    :vartype available_storage_size_in_gbs: int
    :ivar time_created: The date and time the cloud Exadata infrastructure resource was created.
    :vartype time_created: str
    :ivar lifecycle_details: Additional information about the current lifecycle state.
    :vartype lifecycle_details: str
    :ivar maintenance_window: maintenanceWindow property.
    :vartype maintenance_window: ~azure.mgmt.oracledatabase.models.MaintenanceWindow
    :ivar estimated_patching_time: The estimated total time required in minutes for all patching
     operations (database server, storage server, and network switch patching).
    :vartype estimated_patching_time: ~azure.mgmt.oracledatabase.models.EstimatedPatchingTime
    :ivar customer_contacts: The list of customer email addresses that receive information from
     Oracle about the specified OCI Database service resource. Oracle uses these email addresses to
     send notifications about planned and unplanned software maintenance updates, information about
     system hardware, and other information needed by administrators. Up to 10 email addresses can
     be added to the customer contacts for a cloud Exadata infrastructure instance.
    :vartype customer_contacts: list[~azure.mgmt.oracledatabase.models.CustomerContact]
    :ivar provisioning_state: CloudExadataInfrastructure provisioning state. Known values are:
     "Succeeded", "Failed", "Canceled", and "Provisioning".
    :vartype provisioning_state: str or
     ~azure.mgmt.oracledatabase.models.AzureResourceProvisioningState
    :ivar lifecycle_state: CloudExadataInfrastructure lifecycle state. Known values are:
     "Provisioning", "Available", "Updating", "Terminating", "Terminated", "MaintenanceInProgress",
     and "Failed".
    :vartype lifecycle_state: str or
     ~azure.mgmt.oracledatabase.models.CloudExadataInfrastructureLifecycleState
    :ivar shape: The model name of the cloud Exadata infrastructure resource. Required.
    :vartype shape: str
    :ivar oci_url: HTTPS link to OCI resources exposed to Azure Customer via Azure Interface.
    :vartype oci_url: str
    :ivar cpu_count: The total number of CPU cores allocated.
    :vartype cpu_count: int
    :ivar max_cpu_count: The total number of CPU cores available.
    :vartype max_cpu_count: int
    :ivar memory_size_in_gbs: The memory allocated in GBs.
    :vartype memory_size_in_gbs: int
    :ivar max_memory_in_gbs: The total memory available in GBs.
    :vartype max_memory_in_gbs: int
    :ivar db_node_storage_size_in_gbs: The local node storage to be allocated in GBs.
    :vartype db_node_storage_size_in_gbs: int
    :ivar max_db_node_storage_size_in_gbs: The total local node storage available in GBs.
    :vartype max_db_node_storage_size_in_gbs: int
    :ivar data_storage_size_in_tbs: The quantity of data in the database, in terabytes.
    :vartype data_storage_size_in_tbs: float
    :ivar max_data_storage_in_tbs: The total available DATA disk group size.
    :vartype max_data_storage_in_tbs: float
    :ivar db_server_version: The software version of the database servers (dom0) in the Exadata
     infrastructure.
    :vartype db_server_version: str
    :ivar storage_server_version: The software version of the storage servers (cells) in the
     Exadata infrastructure.
    :vartype storage_server_version: str
    :ivar activated_storage_count: The requested number of additional storage servers activated for
     the Exadata infrastructure.
    :vartype activated_storage_count: int
    :ivar additional_storage_count: The requested number of additional storage servers for the
     Exadata infrastructure.
    :vartype additional_storage_count: int
    :ivar display_name: The name for the Exadata infrastructure. Required.
    :vartype display_name: str
    :ivar last_maintenance_run_id: The OCID of the last maintenance run.
    :vartype last_maintenance_run_id: str
    :ivar next_maintenance_run_id: The OCID of the next maintenance run.
    :vartype next_maintenance_run_id: str
    :ivar monthly_db_server_version: Monthly Db Server version.
    :vartype monthly_db_server_version: str
    :ivar monthly_storage_server_version: Monthly Storage Server version.
    :vartype monthly_storage_server_version: str
    """

    _validation = {
        "ocid": {"readonly": True, "max_length": 255, "min_length": 1},
        "total_storage_size_in_gbs": {"readonly": True},
        "available_storage_size_in_gbs": {"readonly": True},
        "time_created": {"readonly": True},
        "lifecycle_details": {"readonly": True},
        "estimated_patching_time": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "lifecycle_state": {"readonly": True},
        "shape": {"required": True},
        "oci_url": {"readonly": True},
        "cpu_count": {"readonly": True},
        "max_cpu_count": {"readonly": True},
        "memory_size_in_gbs": {"readonly": True},
        "max_memory_in_gbs": {"readonly": True},
        "db_node_storage_size_in_gbs": {"readonly": True},
        "max_db_node_storage_size_in_gbs": {"readonly": True},
        "data_storage_size_in_tbs": {"readonly": True},
        "max_data_storage_in_tbs": {"readonly": True},
        "db_server_version": {"readonly": True},
        "storage_server_version": {"readonly": True},
        "activated_storage_count": {"readonly": True},
        "additional_storage_count": {"readonly": True},
        "display_name": {"required": True, "max_length": 255, "min_length": 1},
        "last_maintenance_run_id": {"readonly": True, "max_length": 255, "min_length": 1},
        "next_maintenance_run_id": {"readonly": True, "max_length": 255, "min_length": 1},
        "monthly_db_server_version": {"readonly": True},
        "monthly_storage_server_version": {"readonly": True},
    }

    _attribute_map = {
        "ocid": {"key": "ocid", "type": "str"},
        "compute_count": {"key": "computeCount", "type": "int"},
        "storage_count": {"key": "storageCount", "type": "int"},
        "total_storage_size_in_gbs": {"key": "totalStorageSizeInGbs", "type": "int"},
        "available_storage_size_in_gbs": {"key": "availableStorageSizeInGbs", "type": "int"},
        "time_created": {"key": "timeCreated", "type": "str"},
        "lifecycle_details": {"key": "lifecycleDetails", "type": "str"},
        "maintenance_window": {"key": "maintenanceWindow", "type": "MaintenanceWindow"},
        "estimated_patching_time": {"key": "estimatedPatchingTime", "type": "EstimatedPatchingTime"},
        "customer_contacts": {"key": "customerContacts", "type": "[CustomerContact]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "lifecycle_state": {"key": "lifecycleState", "type": "str"},
        "shape": {"key": "shape", "type": "str"},
        "oci_url": {"key": "ociUrl", "type": "str"},
        "cpu_count": {"key": "cpuCount", "type": "int"},
        "max_cpu_count": {"key": "maxCpuCount", "type": "int"},
        "memory_size_in_gbs": {"key": "memorySizeInGbs", "type": "int"},
        "max_memory_in_gbs": {"key": "maxMemoryInGbs", "type": "int"},
        "db_node_storage_size_in_gbs": {"key": "dbNodeStorageSizeInGbs", "type": "int"},
        "max_db_node_storage_size_in_gbs": {"key": "maxDbNodeStorageSizeInGbs", "type": "int"},
        "data_storage_size_in_tbs": {"key": "dataStorageSizeInTbs", "type": "float"},
        "max_data_storage_in_tbs": {"key": "maxDataStorageInTbs", "type": "float"},
        "db_server_version": {"key": "dbServerVersion", "type": "str"},
        "storage_server_version": {"key": "storageServerVersion", "type": "str"},
        "activated_storage_count": {"key": "activatedStorageCount", "type": "int"},
        "additional_storage_count": {"key": "additionalStorageCount", "type": "int"},
        "display_name": {"key": "displayName", "type": "str"},
        "last_maintenance_run_id": {"key": "lastMaintenanceRunId", "type": "str"},
        "next_maintenance_run_id": {"key": "nextMaintenanceRunId", "type": "str"},
        "monthly_db_server_version": {"key": "monthlyDbServerVersion", "type": "str"},
        "monthly_storage_server_version": {"key": "monthlyStorageServerVersion", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        shape: str,
        display_name: str,
        compute_count: Optional[int] = None,
        storage_count: Optional[int] = None,
        maintenance_window: Optional["_models.MaintenanceWindow"] = None,
        customer_contacts: Optional[List["_models.CustomerContact"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword compute_count: The number of compute servers for the cloud Exadata infrastructure.
        :paramtype compute_count: int
        :keyword storage_count: The number of storage servers for the cloud Exadata infrastructure.
        :paramtype storage_count: int
        :keyword maintenance_window: maintenanceWindow property.
        :paramtype maintenance_window: ~azure.mgmt.oracledatabase.models.MaintenanceWindow
        :keyword customer_contacts: The list of customer email addresses that receive information from
         Oracle about the specified OCI Database service resource. Oracle uses these email addresses to
         send notifications about planned and unplanned software maintenance updates, information about
         system hardware, and other information needed by administrators. Up to 10 email addresses can
         be added to the customer contacts for a cloud Exadata infrastructure instance.
        :paramtype customer_contacts: list[~azure.mgmt.oracledatabase.models.CustomerContact]
        :keyword shape: The model name of the cloud Exadata infrastructure resource. Required.
        :paramtype shape: str
        :keyword display_name: The name for the Exadata infrastructure. Required.
        :paramtype display_name: str
        """
        super().__init__(**kwargs)
        self.ocid = None
        self.compute_count = compute_count
        self.storage_count = storage_count
        self.total_storage_size_in_gbs = None
        self.available_storage_size_in_gbs = None
        self.time_created = None
        self.lifecycle_details = None
        self.maintenance_window = maintenance_window
        self.estimated_patching_time = None
        self.customer_contacts = customer_contacts
        self.provisioning_state = None
        self.lifecycle_state = None
        self.shape = shape
        self.oci_url = None
        self.cpu_count = None
        self.max_cpu_count = None
        self.memory_size_in_gbs = None
        self.max_memory_in_gbs = None
        self.db_node_storage_size_in_gbs = None
        self.max_db_node_storage_size_in_gbs = None
        self.data_storage_size_in_tbs = None
        self.max_data_storage_in_tbs = None
        self.db_server_version = None
        self.storage_server_version = None
        self.activated_storage_count = None
        self.additional_storage_count = None
        self.display_name = display_name
        self.last_maintenance_run_id = None
        self.next_maintenance_run_id = None
        self.monthly_db_server_version = None
        self.monthly_storage_server_version = None


class CloudExadataInfrastructureUpdate(_serialization.Model):
    """The type used for update operations of the CloudExadataInfrastructure.

    :ivar zones: CloudExadataInfrastructure zones.
    :vartype zones: list[str]
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The updatable properties of the CloudExadataInfrastructure.
    :vartype properties:
     ~azure.mgmt.oracledatabase.models.CloudExadataInfrastructureUpdateProperties
    """

    _attribute_map = {
        "zones": {"key": "zones", "type": "[str]"},
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "CloudExadataInfrastructureUpdateProperties"},
    }

    def __init__(
        self,
        *,
        zones: Optional[List[str]] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.CloudExadataInfrastructureUpdateProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword zones: CloudExadataInfrastructure zones.
        :paramtype zones: list[str]
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: The updatable properties of the CloudExadataInfrastructure.
        :paramtype properties:
         ~azure.mgmt.oracledatabase.models.CloudExadataInfrastructureUpdateProperties
        """
        super().__init__(**kwargs)
        self.zones = zones
        self.tags = tags
        self.properties = properties


class CloudExadataInfrastructureUpdateProperties(_serialization.Model):  # pylint: disable=name-too-long
    """The updatable properties of the CloudExadataInfrastructure.

    :ivar compute_count: The number of compute servers for the cloud Exadata infrastructure.
    :vartype compute_count: int
    :ivar storage_count: The number of storage servers for the cloud Exadata infrastructure.
    :vartype storage_count: int
    :ivar maintenance_window: maintenanceWindow property.
    :vartype maintenance_window: ~azure.mgmt.oracledatabase.models.MaintenanceWindow
    :ivar customer_contacts: The list of customer email addresses that receive information from
     Oracle about the specified OCI Database service resource. Oracle uses these email addresses to
     send notifications about planned and unplanned software maintenance updates, information about
     system hardware, and other information needed by administrators. Up to 10 email addresses can
     be added to the customer contacts for a cloud Exadata infrastructure instance.
    :vartype customer_contacts: list[~azure.mgmt.oracledatabase.models.CustomerContact]
    :ivar display_name: The name for the Exadata infrastructure.
    :vartype display_name: str
    """

    _validation = {
        "display_name": {"max_length": 255, "min_length": 1},
    }

    _attribute_map = {
        "compute_count": {"key": "computeCount", "type": "int"},
        "storage_count": {"key": "storageCount", "type": "int"},
        "maintenance_window": {"key": "maintenanceWindow", "type": "MaintenanceWindow"},
        "customer_contacts": {"key": "customerContacts", "type": "[CustomerContact]"},
        "display_name": {"key": "displayName", "type": "str"},
    }

    def __init__(
        self,
        *,
        compute_count: Optional[int] = None,
        storage_count: Optional[int] = None,
        maintenance_window: Optional["_models.MaintenanceWindow"] = None,
        customer_contacts: Optional[List["_models.CustomerContact"]] = None,
        display_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword compute_count: The number of compute servers for the cloud Exadata infrastructure.
        :paramtype compute_count: int
        :keyword storage_count: The number of storage servers for the cloud Exadata infrastructure.
        :paramtype storage_count: int
        :keyword maintenance_window: maintenanceWindow property.
        :paramtype maintenance_window: ~azure.mgmt.oracledatabase.models.MaintenanceWindow
        :keyword customer_contacts: The list of customer email addresses that receive information from
         Oracle about the specified OCI Database service resource. Oracle uses these email addresses to
         send notifications about planned and unplanned software maintenance updates, information about
         system hardware, and other information needed by administrators. Up to 10 email addresses can
         be added to the customer contacts for a cloud Exadata infrastructure instance.
        :paramtype customer_contacts: list[~azure.mgmt.oracledatabase.models.CustomerContact]
        :keyword display_name: The name for the Exadata infrastructure.
        :paramtype display_name: str
        """
        super().__init__(**kwargs)
        self.compute_count = compute_count
        self.storage_count = storage_count
        self.maintenance_window = maintenance_window
        self.customer_contacts = customer_contacts
        self.display_name = display_name


class CloudVmCluster(TrackedResource):
    """CloudVmCluster resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.CloudVmClusterProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "CloudVmClusterProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.CloudVmClusterProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.oracledatabase.models.CloudVmClusterProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties


class CloudVmClusterListResult(_serialization.Model):
    """The response of a CloudVmCluster list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The CloudVmCluster items on this page. Required.
    :vartype value: list[~azure.mgmt.oracledatabase.models.CloudVmCluster]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CloudVmCluster]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.CloudVmCluster"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The CloudVmCluster items on this page. Required.
        :paramtype value: list[~azure.mgmt.oracledatabase.models.CloudVmCluster]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CloudVmClusterProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """CloudVmCluster resource model.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar ocid: Cloud VM Cluster ocid.
    :vartype ocid: str
    :ivar listener_port: The port number configured for the listener on the cloud VM cluster.
    :vartype listener_port: int
    :ivar node_count: The number of nodes in the cloud VM cluster.
    :vartype node_count: int
    :ivar storage_size_in_gbs: The data disk group size to be allocated in GBs per VM.
    :vartype storage_size_in_gbs: int
    :ivar data_storage_size_in_tbs: The data disk group size to be allocated in TBs.
    :vartype data_storage_size_in_tbs: float
    :ivar db_node_storage_size_in_gbs: The local node storage to be allocated in GBs.
    :vartype db_node_storage_size_in_gbs: int
    :ivar memory_size_in_gbs: The memory to be allocated in GBs.
    :vartype memory_size_in_gbs: int
    :ivar time_created: The date and time that the cloud VM cluster was created.
    :vartype time_created: ~datetime.datetime
    :ivar lifecycle_details: Additional information about the current lifecycle state.
    :vartype lifecycle_details: str
    :ivar time_zone: The time zone of the cloud VM cluster. For details, see `Exadata
     Infrastructure Time Zones </Content/Database/References/timezones.htm>`_.
    :vartype time_zone: str
    :ivar zone_id: The OCID of the zone the cloud VM cluster is associated with.
    :vartype zone_id: str
    :ivar hostname: The hostname for the cloud VM cluster. Required.
    :vartype hostname: str
    :ivar domain: The domain name for the cloud VM cluster.
    :vartype domain: str
    :ivar cpu_core_count: The number of CPU cores enabled on the cloud VM cluster. Required.
    :vartype cpu_core_count: int
    :ivar ocpu_count: The number of OCPU cores to enable on the cloud VM cluster. Only 1 decimal
     place is allowed for the fractional part.
    :vartype ocpu_count: float
    :ivar cluster_name: The cluster name for cloud VM cluster. The cluster name must begin with an
     alphabetic character, and may contain hyphens (-). Underscores (_) are not permitted. The
     cluster name can be no longer than 11 characters and is not case sensitive.
    :vartype cluster_name: str
    :ivar data_storage_percentage: The percentage assigned to DATA storage (user data and database
     files). The remaining percentage is assigned to RECO storage (database redo logs, archive logs,
     and recovery manager backups). Accepted values are 35, 40, 60 and 80. The default is 80 percent
     assigned to DATA storage. See `Storage Configuration
     </Content/Database/Concepts/exaoverview.htm#Exadata>`_ in the Exadata documentation for details
     on the impact of the configuration settings on storage.
    :vartype data_storage_percentage: int
    :ivar is_local_backup_enabled: If true, database backup on local Exadata storage is configured
     for the cloud VM cluster. If false, database backup on local Exadata storage is not available
     in the cloud VM cluster.
    :vartype is_local_backup_enabled: bool
    :ivar cloud_exadata_infrastructure_id: Cloud Exadata Infrastructure ID. Required.
    :vartype cloud_exadata_infrastructure_id: str
    :ivar is_sparse_diskgroup_enabled: If true, sparse disk group is configured for the cloud VM
     cluster. If false, sparse disk group is not created.
    :vartype is_sparse_diskgroup_enabled: bool
    :ivar system_version: Operating system version of the image.
    :vartype system_version: str
    :ivar ssh_public_keys: The public key portion of one or more key pairs used for SSH access to
     the cloud VM cluster. Required.
    :vartype ssh_public_keys: list[str]
    :ivar license_model: The Oracle license model that applies to the cloud VM cluster. The default
     is LICENSE_INCLUDED. Known values are: "LicenseIncluded" and "BringYourOwnLicense".
    :vartype license_model: str or ~azure.mgmt.oracledatabase.models.LicenseModel
    :ivar disk_redundancy: The type of redundancy configured for the cloud Vm cluster. NORMAL is
     2-way redundancy. HIGH is 3-way redundancy. Known values are: "High" and "Normal".
    :vartype disk_redundancy: str or ~azure.mgmt.oracledatabase.models.DiskRedundancy
    :ivar scan_ip_ids: The Single Client Access Name (SCAN) IP addresses associated with the cloud
     VM cluster. SCAN IP addresses are typically used for load balancing and are not assigned to any
     interface. Oracle Clusterware directs the requests to the appropriate nodes in the cluster.
     **Note:** For a single-node DB system, this list is empty.
    :vartype scan_ip_ids: list[str]
    :ivar vip_ids: The virtual IP (VIP) addresses associated with the cloud VM cluster. The Cluster
     Ready Services (CRS) creates and maintains one VIP address for each node in the Exadata Cloud
     Service instance to enable failover. If one node fails, the VIP is reassigned to another active
     node in the cluster. **Note:** For a single-node DB system, this list is empty.
    :vartype vip_ids: list[str]
    :ivar scan_dns_name: The FQDN of the DNS record for the SCAN IP addresses that are associated
     with the cloud VM cluster.
    :vartype scan_dns_name: str
    :ivar scan_listener_port_tcp: The TCP Single Client Access Name (SCAN) port. The default port
     is 1521.
    :vartype scan_listener_port_tcp: int
    :ivar scan_listener_port_tcp_ssl: The TCPS Single Client Access Name (SCAN) port. The default
     port is 2484.
    :vartype scan_listener_port_tcp_ssl: int
    :ivar scan_dns_record_id: The OCID of the DNS record for the SCAN IP addresses that are
     associated with the cloud VM cluster.
    :vartype scan_dns_record_id: str
    :ivar shape: The model name of the Exadata hardware running the cloud VM cluster.
    :vartype shape: str
    :ivar provisioning_state: CloudVmCluster provisioning state. Known values are: "Succeeded",
     "Failed", "Canceled", and "Provisioning".
    :vartype provisioning_state: str or
     ~azure.mgmt.oracledatabase.models.AzureResourceProvisioningState
    :ivar lifecycle_state: CloudVmCluster lifecycle state. Known values are: "Provisioning",
     "Available", "Updating", "Terminating", "Terminated", "MaintenanceInProgress", and "Failed".
    :vartype lifecycle_state: str or ~azure.mgmt.oracledatabase.models.CloudVmClusterLifecycleState
    :ivar vnet_id: VNET for network connectivity. Required.
    :vartype vnet_id: str
    :ivar gi_version: Oracle Grid Infrastructure (GI) software version. Required.
    :vartype gi_version: str
    :ivar oci_url: HTTPS link to OCI resources exposed to Azure Customer via Azure Interface.
    :vartype oci_url: str
    :ivar nsg_url: HTTPS link to OCI Network Security Group exposed to Azure Customer via the Azure
     Interface.
    :vartype nsg_url: str
    :ivar subnet_id: Client subnet. Required.
    :vartype subnet_id: str
    :ivar backup_subnet_cidr: Client OCI backup subnet CIDR, default is 192.168.252.0/22.
    :vartype backup_subnet_cidr: str
    :ivar nsg_cidrs: CIDR blocks for additional NSG ingress rules. The VNET CIDRs used to provision
     the VM Cluster will be added by default.
    :vartype nsg_cidrs: list[~azure.mgmt.oracledatabase.models.NsgCidr]
    :ivar data_collection_options: Indicates user preferences for the various diagnostic collection
     options for the VM cluster/Cloud VM cluster/VMBM DBCS.
    :vartype data_collection_options: ~azure.mgmt.oracledatabase.models.DataCollectionOptions
    :ivar display_name: Display Name. Required.
    :vartype display_name: str
    :ivar compute_nodes: The list of compute servers to be added to the cloud VM cluster.
    :vartype compute_nodes: list[str]
    :ivar iorm_config_cache: iormConfigCache details for cloud VM cluster.
    :vartype iorm_config_cache: ~azure.mgmt.oracledatabase.models.ExadataIormConfig
    :ivar last_update_history_entry_id: The OCID of the last maintenance update history entry.
    :vartype last_update_history_entry_id: str
    :ivar db_servers: The list of DB servers.
    :vartype db_servers: list[str]
    :ivar compartment_id: Cluster compartmentId.
    :vartype compartment_id: str
    :ivar subnet_ocid: Cluster subnet ocid.
    :vartype subnet_ocid: str
    """

    _validation = {
        "ocid": {"readonly": True, "max_length": 255, "min_length": 1},
        "listener_port": {"readonly": True},
        "node_count": {"readonly": True},
        "time_created": {"readonly": True},
        "lifecycle_details": {"readonly": True},
        "time_zone": {"max_length": 255, "min_length": 1},
        "zone_id": {"max_length": 255, "min_length": 1},
        "hostname": {"required": True, "max_length": 23, "min_length": 1},
        "cpu_core_count": {"required": True},
        "cluster_name": {"max_length": 11, "min_length": 1},
        "cloud_exadata_infrastructure_id": {"required": True},
        "system_version": {"max_length": 255, "min_length": 1},
        "ssh_public_keys": {"required": True},
        "disk_redundancy": {"readonly": True},
        "scan_ip_ids": {"readonly": True},
        "vip_ids": {"readonly": True},
        "scan_dns_name": {"readonly": True, "max_length": 72, "min_length": 1},
        "scan_dns_record_id": {"readonly": True, "max_length": 255, "min_length": 1},
        "shape": {"readonly": True, "max_length": 255, "min_length": 1},
        "provisioning_state": {"readonly": True},
        "lifecycle_state": {"readonly": True},
        "vnet_id": {"required": True},
        "gi_version": {"required": True},
        "oci_url": {"readonly": True},
        "nsg_url": {"readonly": True},
        "subnet_id": {"required": True},
        "backup_subnet_cidr": {"max_length": 32, "min_length": 1},
        "display_name": {"required": True, "max_length": 255, "min_length": 1},
        "iorm_config_cache": {"readonly": True},
        "last_update_history_entry_id": {"readonly": True, "max_length": 255, "min_length": 1},
        "compartment_id": {"readonly": True, "max_length": 255, "min_length": 1},
        "subnet_ocid": {"readonly": True, "max_length": 255, "min_length": 1},
    }

    _attribute_map = {
        "ocid": {"key": "ocid", "type": "str"},
        "listener_port": {"key": "listenerPort", "type": "int"},
        "node_count": {"key": "nodeCount", "type": "int"},
        "storage_size_in_gbs": {"key": "storageSizeInGbs", "type": "int"},
        "data_storage_size_in_tbs": {"key": "dataStorageSizeInTbs", "type": "float"},
        "db_node_storage_size_in_gbs": {"key": "dbNodeStorageSizeInGbs", "type": "int"},
        "memory_size_in_gbs": {"key": "memorySizeInGbs", "type": "int"},
        "time_created": {"key": "timeCreated", "type": "iso-8601"},
        "lifecycle_details": {"key": "lifecycleDetails", "type": "str"},
        "time_zone": {"key": "timeZone", "type": "str"},
        "zone_id": {"key": "zoneId", "type": "str"},
        "hostname": {"key": "hostname", "type": "str"},
        "domain": {"key": "domain", "type": "str"},
        "cpu_core_count": {"key": "cpuCoreCount", "type": "int"},
        "ocpu_count": {"key": "ocpuCount", "type": "float"},
        "cluster_name": {"key": "clusterName", "type": "str"},
        "data_storage_percentage": {"key": "dataStoragePercentage", "type": "int"},
        "is_local_backup_enabled": {"key": "isLocalBackupEnabled", "type": "bool"},
        "cloud_exadata_infrastructure_id": {"key": "cloudExadataInfrastructureId", "type": "str"},
        "is_sparse_diskgroup_enabled": {"key": "isSparseDiskgroupEnabled", "type": "bool"},
        "system_version": {"key": "systemVersion", "type": "str"},
        "ssh_public_keys": {"key": "sshPublicKeys", "type": "[str]"},
        "license_model": {"key": "licenseModel", "type": "str"},
        "disk_redundancy": {"key": "diskRedundancy", "type": "str"},
        "scan_ip_ids": {"key": "scanIpIds", "type": "[str]"},
        "vip_ids": {"key": "vipIds", "type": "[str]"},
        "scan_dns_name": {"key": "scanDnsName", "type": "str"},
        "scan_listener_port_tcp": {"key": "scanListenerPortTcp", "type": "int"},
        "scan_listener_port_tcp_ssl": {"key": "scanListenerPortTcpSsl", "type": "int"},
        "scan_dns_record_id": {"key": "scanDnsRecordId", "type": "str"},
        "shape": {"key": "shape", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "lifecycle_state": {"key": "lifecycleState", "type": "str"},
        "vnet_id": {"key": "vnetId", "type": "str"},
        "gi_version": {"key": "giVersion", "type": "str"},
        "oci_url": {"key": "ociUrl", "type": "str"},
        "nsg_url": {"key": "nsgUrl", "type": "str"},
        "subnet_id": {"key": "subnetId", "type": "str"},
        "backup_subnet_cidr": {"key": "backupSubnetCidr", "type": "str"},
        "nsg_cidrs": {"key": "nsgCidrs", "type": "[NsgCidr]"},
        "data_collection_options": {"key": "dataCollectionOptions", "type": "DataCollectionOptions"},
        "display_name": {"key": "displayName", "type": "str"},
        "compute_nodes": {"key": "computeNodes", "type": "[str]"},
        "iorm_config_cache": {"key": "iormConfigCache", "type": "ExadataIormConfig"},
        "last_update_history_entry_id": {"key": "lastUpdateHistoryEntryId", "type": "str"},
        "db_servers": {"key": "dbServers", "type": "[str]"},
        "compartment_id": {"key": "compartmentId", "type": "str"},
        "subnet_ocid": {"key": "subnetOcid", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        hostname: str,
        cpu_core_count: int,
        cloud_exadata_infrastructure_id: str,
        ssh_public_keys: List[str],
        vnet_id: str,
        gi_version: str,
        subnet_id: str,
        display_name: str,
        storage_size_in_gbs: Optional[int] = None,
        data_storage_size_in_tbs: Optional[float] = None,
        db_node_storage_size_in_gbs: Optional[int] = None,
        memory_size_in_gbs: Optional[int] = None,
        time_zone: Optional[str] = None,
        zone_id: Optional[str] = None,
        domain: Optional[str] = None,
        ocpu_count: Optional[float] = None,
        cluster_name: Optional[str] = None,
        data_storage_percentage: Optional[int] = None,
        is_local_backup_enabled: bool = False,
        is_sparse_diskgroup_enabled: bool = False,
        system_version: Optional[str] = None,
        license_model: Optional[Union[str, "_models.LicenseModel"]] = None,
        scan_listener_port_tcp: Optional[int] = None,
        scan_listener_port_tcp_ssl: Optional[int] = None,
        backup_subnet_cidr: Optional[str] = None,
        nsg_cidrs: Optional[List["_models.NsgCidr"]] = None,
        data_collection_options: Optional["_models.DataCollectionOptions"] = None,
        compute_nodes: Optional[List[str]] = None,
        db_servers: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword storage_size_in_gbs: The data disk group size to be allocated in GBs per VM.
        :paramtype storage_size_in_gbs: int
        :keyword data_storage_size_in_tbs: The data disk group size to be allocated in TBs.
        :paramtype data_storage_size_in_tbs: float
        :keyword db_node_storage_size_in_gbs: The local node storage to be allocated in GBs.
        :paramtype db_node_storage_size_in_gbs: int
        :keyword memory_size_in_gbs: The memory to be allocated in GBs.
        :paramtype memory_size_in_gbs: int
        :keyword time_zone: The time zone of the cloud VM cluster. For details, see `Exadata
         Infrastructure Time Zones </Content/Database/References/timezones.htm>`_.
        :paramtype time_zone: str
        :keyword zone_id: The OCID of the zone the cloud VM cluster is associated with.
        :paramtype zone_id: str
        :keyword hostname: The hostname for the cloud VM cluster. Required.
        :paramtype hostname: str
        :keyword domain: The domain name for the cloud VM cluster.
        :paramtype domain: str
        :keyword cpu_core_count: The number of CPU cores enabled on the cloud VM cluster. Required.
        :paramtype cpu_core_count: int
        :keyword ocpu_count: The number of OCPU cores to enable on the cloud VM cluster. Only 1 decimal
         place is allowed for the fractional part.
        :paramtype ocpu_count: float
        :keyword cluster_name: The cluster name for cloud VM cluster. The cluster name must begin with
         an alphabetic character, and may contain hyphens (-). Underscores (_) are not permitted. The
         cluster name can be no longer than 11 characters and is not case sensitive.
        :paramtype cluster_name: str
        :keyword data_storage_percentage: The percentage assigned to DATA storage (user data and
         database files). The remaining percentage is assigned to RECO storage (database redo logs,
         archive logs, and recovery manager backups). Accepted values are 35, 40, 60 and 80. The default
         is 80 percent assigned to DATA storage. See `Storage Configuration
         </Content/Database/Concepts/exaoverview.htm#Exadata>`_ in the Exadata documentation for details
         on the impact of the configuration settings on storage.
        :paramtype data_storage_percentage: int
        :keyword is_local_backup_enabled: If true, database backup on local Exadata storage is
         configured for the cloud VM cluster. If false, database backup on local Exadata storage is not
         available in the cloud VM cluster.
        :paramtype is_local_backup_enabled: bool
        :keyword cloud_exadata_infrastructure_id: Cloud Exadata Infrastructure ID. Required.
        :paramtype cloud_exadata_infrastructure_id: str
        :keyword is_sparse_diskgroup_enabled: If true, sparse disk group is configured for the cloud VM
         cluster. If false, sparse disk group is not created.
        :paramtype is_sparse_diskgroup_enabled: bool
        :keyword system_version: Operating system version of the image.
        :paramtype system_version: str
        :keyword ssh_public_keys: The public key portion of one or more key pairs used for SSH access
         to the cloud VM cluster. Required.
        :paramtype ssh_public_keys: list[str]
        :keyword license_model: The Oracle license model that applies to the cloud VM cluster. The
         default is LICENSE_INCLUDED. Known values are: "LicenseIncluded" and "BringYourOwnLicense".
        :paramtype license_model: str or ~azure.mgmt.oracledatabase.models.LicenseModel
        :keyword scan_listener_port_tcp: The TCP Single Client Access Name (SCAN) port. The default
         port is 1521.
        :paramtype scan_listener_port_tcp: int
        :keyword scan_listener_port_tcp_ssl: The TCPS Single Client Access Name (SCAN) port. The
         default port is 2484.
        :paramtype scan_listener_port_tcp_ssl: int
        :keyword vnet_id: VNET for network connectivity. Required.
        :paramtype vnet_id: str
        :keyword gi_version: Oracle Grid Infrastructure (GI) software version. Required.
        :paramtype gi_version: str
        :keyword subnet_id: Client subnet. Required.
        :paramtype subnet_id: str
        :keyword backup_subnet_cidr: Client OCI backup subnet CIDR, default is 192.168.252.0/22.
        :paramtype backup_subnet_cidr: str
        :keyword nsg_cidrs: CIDR blocks for additional NSG ingress rules. The VNET CIDRs used to
         provision the VM Cluster will be added by default.
        :paramtype nsg_cidrs: list[~azure.mgmt.oracledatabase.models.NsgCidr]
        :keyword data_collection_options: Indicates user preferences for the various diagnostic
         collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        :paramtype data_collection_options: ~azure.mgmt.oracledatabase.models.DataCollectionOptions
        :keyword display_name: Display Name. Required.
        :paramtype display_name: str
        :keyword compute_nodes: The list of compute servers to be added to the cloud VM cluster.
        :paramtype compute_nodes: list[str]
        :keyword db_servers: The list of DB servers.
        :paramtype db_servers: list[str]
        """
        super().__init__(**kwargs)
        self.ocid = None
        self.listener_port = None
        self.node_count = None
        self.storage_size_in_gbs = storage_size_in_gbs
        self.data_storage_size_in_tbs = data_storage_size_in_tbs
        self.db_node_storage_size_in_gbs = db_node_storage_size_in_gbs
        self.memory_size_in_gbs = memory_size_in_gbs
        self.time_created = None
        self.lifecycle_details = None
        self.time_zone = time_zone
        self.zone_id = zone_id
        self.hostname = hostname
        self.domain = domain
        self.cpu_core_count = cpu_core_count
        self.ocpu_count = ocpu_count
        self.cluster_name = cluster_name
        self.data_storage_percentage = data_storage_percentage
        self.is_local_backup_enabled = is_local_backup_enabled
        self.cloud_exadata_infrastructure_id = cloud_exadata_infrastructure_id
        self.is_sparse_diskgroup_enabled = is_sparse_diskgroup_enabled
        self.system_version = system_version
        self.ssh_public_keys = ssh_public_keys
        self.license_model = license_model
        self.disk_redundancy = None
        self.scan_ip_ids = None
        self.vip_ids = None
        self.scan_dns_name = None
        self.scan_listener_port_tcp = scan_listener_port_tcp
        self.scan_listener_port_tcp_ssl = scan_listener_port_tcp_ssl
        self.scan_dns_record_id = None
        self.shape = None
        self.provisioning_state = None
        self.lifecycle_state = None
        self.vnet_id = vnet_id
        self.gi_version = gi_version
        self.oci_url = None
        self.nsg_url = None
        self.subnet_id = subnet_id
        self.backup_subnet_cidr = backup_subnet_cidr
        self.nsg_cidrs = nsg_cidrs
        self.data_collection_options = data_collection_options
        self.display_name = display_name
        self.compute_nodes = compute_nodes
        self.iorm_config_cache = None
        self.last_update_history_entry_id = None
        self.db_servers = db_servers
        self.compartment_id = None
        self.subnet_ocid = None


class CloudVmClusterUpdate(_serialization.Model):
    """The type used for update operations of the CloudVmCluster.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The updatable properties of the CloudVmCluster.
    :vartype properties: ~azure.mgmt.oracledatabase.models.CloudVmClusterUpdateProperties
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "CloudVmClusterUpdateProperties"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.CloudVmClusterUpdateProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: The updatable properties of the CloudVmCluster.
        :paramtype properties: ~azure.mgmt.oracledatabase.models.CloudVmClusterUpdateProperties
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.properties = properties


class CloudVmClusterUpdateProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The updatable properties of the CloudVmCluster.

    :ivar storage_size_in_gbs: The data disk group size to be allocated in GBs per VM.
    :vartype storage_size_in_gbs: int
    :ivar data_storage_size_in_tbs: The data disk group size to be allocated in TBs.
    :vartype data_storage_size_in_tbs: float
    :ivar db_node_storage_size_in_gbs: The local node storage to be allocated in GBs.
    :vartype db_node_storage_size_in_gbs: int
    :ivar memory_size_in_gbs: The memory to be allocated in GBs.
    :vartype memory_size_in_gbs: int
    :ivar cpu_core_count: The number of CPU cores enabled on the cloud VM cluster.
    :vartype cpu_core_count: int
    :ivar ocpu_count: The number of OCPU cores to enable on the cloud VM cluster. Only 1 decimal
     place is allowed for the fractional part.
    :vartype ocpu_count: float
    :ivar ssh_public_keys: The public key portion of one or more key pairs used for SSH access to
     the cloud VM cluster.
    :vartype ssh_public_keys: list[str]
    :ivar license_model: The Oracle license model that applies to the cloud VM cluster. The default
     is LICENSE_INCLUDED. Known values are: "LicenseIncluded" and "BringYourOwnLicense".
    :vartype license_model: str or ~azure.mgmt.oracledatabase.models.LicenseModel
    :ivar data_collection_options: Indicates user preferences for the various diagnostic collection
     options for the VM cluster/Cloud VM cluster/VMBM DBCS.
    :vartype data_collection_options: ~azure.mgmt.oracledatabase.models.DataCollectionOptions
    :ivar display_name: Display Name.
    :vartype display_name: str
    :ivar compute_nodes: The list of compute servers to be added to the cloud VM cluster.
    :vartype compute_nodes: list[str]
    """

    _validation = {
        "display_name": {"max_length": 255, "min_length": 1},
    }

    _attribute_map = {
        "storage_size_in_gbs": {"key": "storageSizeInGbs", "type": "int"},
        "data_storage_size_in_tbs": {"key": "dataStorageSizeInTbs", "type": "float"},
        "db_node_storage_size_in_gbs": {"key": "dbNodeStorageSizeInGbs", "type": "int"},
        "memory_size_in_gbs": {"key": "memorySizeInGbs", "type": "int"},
        "cpu_core_count": {"key": "cpuCoreCount", "type": "int"},
        "ocpu_count": {"key": "ocpuCount", "type": "float"},
        "ssh_public_keys": {"key": "sshPublicKeys", "type": "[str]"},
        "license_model": {"key": "licenseModel", "type": "str"},
        "data_collection_options": {"key": "dataCollectionOptions", "type": "DataCollectionOptions"},
        "display_name": {"key": "displayName", "type": "str"},
        "compute_nodes": {"key": "computeNodes", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        storage_size_in_gbs: Optional[int] = None,
        data_storage_size_in_tbs: Optional[float] = None,
        db_node_storage_size_in_gbs: Optional[int] = None,
        memory_size_in_gbs: Optional[int] = None,
        cpu_core_count: Optional[int] = None,
        ocpu_count: Optional[float] = None,
        ssh_public_keys: Optional[List[str]] = None,
        license_model: Optional[Union[str, "_models.LicenseModel"]] = None,
        data_collection_options: Optional["_models.DataCollectionOptions"] = None,
        display_name: Optional[str] = None,
        compute_nodes: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword storage_size_in_gbs: The data disk group size to be allocated in GBs per VM.
        :paramtype storage_size_in_gbs: int
        :keyword data_storage_size_in_tbs: The data disk group size to be allocated in TBs.
        :paramtype data_storage_size_in_tbs: float
        :keyword db_node_storage_size_in_gbs: The local node storage to be allocated in GBs.
        :paramtype db_node_storage_size_in_gbs: int
        :keyword memory_size_in_gbs: The memory to be allocated in GBs.
        :paramtype memory_size_in_gbs: int
        :keyword cpu_core_count: The number of CPU cores enabled on the cloud VM cluster.
        :paramtype cpu_core_count: int
        :keyword ocpu_count: The number of OCPU cores to enable on the cloud VM cluster. Only 1 decimal
         place is allowed for the fractional part.
        :paramtype ocpu_count: float
        :keyword ssh_public_keys: The public key portion of one or more key pairs used for SSH access
         to the cloud VM cluster.
        :paramtype ssh_public_keys: list[str]
        :keyword license_model: The Oracle license model that applies to the cloud VM cluster. The
         default is LICENSE_INCLUDED. Known values are: "LicenseIncluded" and "BringYourOwnLicense".
        :paramtype license_model: str or ~azure.mgmt.oracledatabase.models.LicenseModel
        :keyword data_collection_options: Indicates user preferences for the various diagnostic
         collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        :paramtype data_collection_options: ~azure.mgmt.oracledatabase.models.DataCollectionOptions
        :keyword display_name: Display Name.
        :paramtype display_name: str
        :keyword compute_nodes: The list of compute servers to be added to the cloud VM cluster.
        :paramtype compute_nodes: list[str]
        """
        super().__init__(**kwargs)
        self.storage_size_in_gbs = storage_size_in_gbs
        self.data_storage_size_in_tbs = data_storage_size_in_tbs
        self.db_node_storage_size_in_gbs = db_node_storage_size_in_gbs
        self.memory_size_in_gbs = memory_size_in_gbs
        self.cpu_core_count = cpu_core_count
        self.ocpu_count = ocpu_count
        self.ssh_public_keys = ssh_public_keys
        self.license_model = license_model
        self.data_collection_options = data_collection_options
        self.display_name = display_name
        self.compute_nodes = compute_nodes


class ConnectionStringType(_serialization.Model):
    """Connection strings to connect to an Oracle Autonomous Database.

    :ivar all_connection_strings: Returns all connection strings that can be used to connect to the
     Autonomous Database.
    :vartype all_connection_strings: ~azure.mgmt.oracledatabase.models.AllConnectionStringType
    :ivar dedicated: The database service provides the least level of resources to each SQL
     statement, but supports the most number of concurrent SQL statements.
    :vartype dedicated: str
    :ivar high: The High database service provides the highest level of resources to each SQL
     statement resulting in the highest performance, but supports the fewest number of concurrent
     SQL statements.
    :vartype high: str
    :ivar low: The Low database service provides the least level of resources to each SQL
     statement, but supports the most number of concurrent SQL statements.
    :vartype low: str
    :ivar medium: The Medium database service provides a lower level of resources to each SQL
     statement potentially resulting a lower level of performance, but supports more concurrent SQL
     statements.
    :vartype medium: str
    :ivar profiles: A list of connection string profiles to allow clients to group, filter and
     select connection string values based on structured metadata.
    :vartype profiles: list[~azure.mgmt.oracledatabase.models.ProfileType]
    """

    _validation = {
        "dedicated": {"max_length": 255, "min_length": 10},
        "high": {"max_length": 255, "min_length": 10},
        "low": {"max_length": 255, "min_length": 10},
        "medium": {"max_length": 255, "min_length": 10},
    }

    _attribute_map = {
        "all_connection_strings": {"key": "allConnectionStrings", "type": "AllConnectionStringType"},
        "dedicated": {"key": "dedicated", "type": "str"},
        "high": {"key": "high", "type": "str"},
        "low": {"key": "low", "type": "str"},
        "medium": {"key": "medium", "type": "str"},
        "profiles": {"key": "profiles", "type": "[ProfileType]"},
    }

    def __init__(
        self,
        *,
        all_connection_strings: Optional["_models.AllConnectionStringType"] = None,
        dedicated: Optional[str] = None,
        high: Optional[str] = None,
        low: Optional[str] = None,
        medium: Optional[str] = None,
        profiles: Optional[List["_models.ProfileType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword all_connection_strings: Returns all connection strings that can be used to connect to
         the Autonomous Database.
        :paramtype all_connection_strings: ~azure.mgmt.oracledatabase.models.AllConnectionStringType
        :keyword dedicated: The database service provides the least level of resources to each SQL
         statement, but supports the most number of concurrent SQL statements.
        :paramtype dedicated: str
        :keyword high: The High database service provides the highest level of resources to each SQL
         statement resulting in the highest performance, but supports the fewest number of concurrent
         SQL statements.
        :paramtype high: str
        :keyword low: The Low database service provides the least level of resources to each SQL
         statement, but supports the most number of concurrent SQL statements.
        :paramtype low: str
        :keyword medium: The Medium database service provides a lower level of resources to each SQL
         statement potentially resulting a lower level of performance, but supports more concurrent SQL
         statements.
        :paramtype medium: str
        :keyword profiles: A list of connection string profiles to allow clients to group, filter and
         select connection string values based on structured metadata.
        :paramtype profiles: list[~azure.mgmt.oracledatabase.models.ProfileType]
        """
        super().__init__(**kwargs)
        self.all_connection_strings = all_connection_strings
        self.dedicated = dedicated
        self.high = high
        self.low = low
        self.medium = medium
        self.profiles = profiles


class ConnectionUrlType(_serialization.Model):
    """The URLs for accessing Oracle Application Express (APEX) and SQL Developer Web with a browser
    from a Compute instance within your VCN or that has a direct connection to your VCN.

    :ivar apex_url: Oracle Application Express (APEX) URL.
    :vartype apex_url: str
    :ivar database_transforms_url: The URL of the Database Transforms for the Autonomous Database.
    :vartype database_transforms_url: str
    :ivar graph_studio_url: The URL of the Graph Studio for the Autonomous Database.
    :vartype graph_studio_url: str
    :ivar machine_learning_notebook_url: The URL of the Oracle Machine Learning (OML) Notebook for
     the Autonomous Database.
    :vartype machine_learning_notebook_url: str
    :ivar mongo_db_url: The URL of the MongoDB API for the Autonomous Database.
    :vartype mongo_db_url: str
    :ivar ords_url: The Oracle REST Data Services (ORDS) URL of the Web Access for the Autonomous
     Database.
    :vartype ords_url: str
    :ivar sql_dev_web_url: Oracle SQL Developer Web URL.
    :vartype sql_dev_web_url: str
    """

    _validation = {
        "apex_url": {"max_length": 512, "min_length": 10},
        "database_transforms_url": {"max_length": 512, "min_length": 10},
        "graph_studio_url": {"max_length": 512, "min_length": 10},
        "machine_learning_notebook_url": {"max_length": 512, "min_length": 10},
        "mongo_db_url": {"max_length": 512, "min_length": 10},
        "ords_url": {"max_length": 512, "min_length": 10},
        "sql_dev_web_url": {"max_length": 512, "min_length": 10},
    }

    _attribute_map = {
        "apex_url": {"key": "apexUrl", "type": "str"},
        "database_transforms_url": {"key": "databaseTransformsUrl", "type": "str"},
        "graph_studio_url": {"key": "graphStudioUrl", "type": "str"},
        "machine_learning_notebook_url": {"key": "machineLearningNotebookUrl", "type": "str"},
        "mongo_db_url": {"key": "mongoDbUrl", "type": "str"},
        "ords_url": {"key": "ordsUrl", "type": "str"},
        "sql_dev_web_url": {"key": "sqlDevWebUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        apex_url: Optional[str] = None,
        database_transforms_url: Optional[str] = None,
        graph_studio_url: Optional[str] = None,
        machine_learning_notebook_url: Optional[str] = None,
        mongo_db_url: Optional[str] = None,
        ords_url: Optional[str] = None,
        sql_dev_web_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword apex_url: Oracle Application Express (APEX) URL.
        :paramtype apex_url: str
        :keyword database_transforms_url: The URL of the Database Transforms for the Autonomous
         Database.
        :paramtype database_transforms_url: str
        :keyword graph_studio_url: The URL of the Graph Studio for the Autonomous Database.
        :paramtype graph_studio_url: str
        :keyword machine_learning_notebook_url: The URL of the Oracle Machine Learning (OML) Notebook
         for the Autonomous Database.
        :paramtype machine_learning_notebook_url: str
        :keyword mongo_db_url: The URL of the MongoDB API for the Autonomous Database.
        :paramtype mongo_db_url: str
        :keyword ords_url: The Oracle REST Data Services (ORDS) URL of the Web Access for the
         Autonomous Database.
        :paramtype ords_url: str
        :keyword sql_dev_web_url: Oracle SQL Developer Web URL.
        :paramtype sql_dev_web_url: str
        """
        super().__init__(**kwargs)
        self.apex_url = apex_url
        self.database_transforms_url = database_transforms_url
        self.graph_studio_url = graph_studio_url
        self.machine_learning_notebook_url = machine_learning_notebook_url
        self.mongo_db_url = mongo_db_url
        self.ords_url = ords_url
        self.sql_dev_web_url = sql_dev_web_url


class CustomerContact(_serialization.Model):
    """CustomerContact resource properties.

    All required parameters must be populated in order to send to server.

    :ivar email: The email address used by Oracle to send notifications regarding databases and
     infrastructure. Required.
    :vartype email: str
    """

    _validation = {
        "email": {"required": True, "max_length": 320, "min_length": 1},
    }

    _attribute_map = {
        "email": {"key": "email", "type": "str"},
    }

    def __init__(self, *, email: str, **kwargs: Any) -> None:
        """
        :keyword email: The email address used by Oracle to send notifications regarding databases and
         infrastructure. Required.
        :paramtype email: str
        """
        super().__init__(**kwargs)
        self.email = email


class DataCollectionOptions(_serialization.Model):
    """DataCollectionOptions resource properties.

    :ivar is_diagnostics_events_enabled: Indicates whether diagnostic collection is enabled for the
     VM cluster/Cloud VM cluster/VMBM DBCS.
    :vartype is_diagnostics_events_enabled: bool
    :ivar is_health_monitoring_enabled: Indicates whether health monitoring is enabled for the VM
     cluster / Cloud VM cluster / VMBM DBCS.
    :vartype is_health_monitoring_enabled: bool
    :ivar is_incident_logs_enabled: Indicates whether incident logs and trace collection are
     enabled for the VM cluster / Cloud VM cluster / VMBM DBCS.
    :vartype is_incident_logs_enabled: bool
    """

    _attribute_map = {
        "is_diagnostics_events_enabled": {"key": "isDiagnosticsEventsEnabled", "type": "bool"},
        "is_health_monitoring_enabled": {"key": "isHealthMonitoringEnabled", "type": "bool"},
        "is_incident_logs_enabled": {"key": "isIncidentLogsEnabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        is_diagnostics_events_enabled: bool = False,
        is_health_monitoring_enabled: bool = False,
        is_incident_logs_enabled: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_diagnostics_events_enabled: Indicates whether diagnostic collection is enabled for
         the VM cluster/Cloud VM cluster/VMBM DBCS.
        :paramtype is_diagnostics_events_enabled: bool
        :keyword is_health_monitoring_enabled: Indicates whether health monitoring is enabled for the
         VM cluster / Cloud VM cluster / VMBM DBCS.
        :paramtype is_health_monitoring_enabled: bool
        :keyword is_incident_logs_enabled: Indicates whether incident logs and trace collection are
         enabled for the VM cluster / Cloud VM cluster / VMBM DBCS.
        :paramtype is_incident_logs_enabled: bool
        """
        super().__init__(**kwargs)
        self.is_diagnostics_events_enabled = is_diagnostics_events_enabled
        self.is_health_monitoring_enabled = is_health_monitoring_enabled
        self.is_incident_logs_enabled = is_incident_logs_enabled


class DayOfWeek(_serialization.Model):
    """DayOfWeek resource properties.

    All required parameters must be populated in order to send to server.

    :ivar name: Name of the day of the week. Required. Known values are: "Monday", "Tuesday",
     "Wednesday", "Thursday", "Friday", "Saturday", and "Sunday".
    :vartype name: str or ~azure.mgmt.oracledatabase.models.DayOfWeekName
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Union[str, "_models.DayOfWeekName"], **kwargs: Any) -> None:
        """
        :keyword name: Name of the day of the week. Required. Known values are: "Monday", "Tuesday",
         "Wednesday", "Thursday", "Friday", "Saturday", and "Sunday".
        :paramtype name: str or ~azure.mgmt.oracledatabase.models.DayOfWeekName
        """
        super().__init__(**kwargs)
        self.name = name


class DayOfWeekUpdate(_serialization.Model):
    """DayOfWeek resource properties.

    :ivar name: Name of the day of the week. Known values are: "Monday", "Tuesday", "Wednesday",
     "Thursday", "Friday", "Saturday", and "Sunday".
    :vartype name: str or ~azure.mgmt.oracledatabase.models.DayOfWeekName
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Optional[Union[str, "_models.DayOfWeekName"]] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name of the day of the week. Known values are: "Monday", "Tuesday", "Wednesday",
         "Thursday", "Friday", "Saturday", and "Sunday".
        :paramtype name: str or ~azure.mgmt.oracledatabase.models.DayOfWeekName
        """
        super().__init__(**kwargs)
        self.name = name


class DbIormConfig(_serialization.Model):
    """DbIormConfig for cloud vm cluster.

    :ivar db_name: The database name. For the default DbPlan, the dbName is default.
    :vartype db_name: str
    :ivar flash_cache_limit: The flash cache limit for this database. This value is internally
     configured based on the share value assigned to the database.
    :vartype flash_cache_limit: str
    :ivar share: The relative priority of this database.
    :vartype share: int
    """

    _validation = {
        "share": {"maximum": 32, "minimum": 1},
    }

    _attribute_map = {
        "db_name": {"key": "dbName", "type": "str"},
        "flash_cache_limit": {"key": "flashCacheLimit", "type": "str"},
        "share": {"key": "share", "type": "int"},
    }

    def __init__(
        self,
        *,
        db_name: Optional[str] = None,
        flash_cache_limit: Optional[str] = None,
        share: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword db_name: The database name. For the default DbPlan, the dbName is default.
        :paramtype db_name: str
        :keyword flash_cache_limit: The flash cache limit for this database. This value is internally
         configured based on the share value assigned to the database.
        :paramtype flash_cache_limit: str
        :keyword share: The relative priority of this database.
        :paramtype share: int
        """
        super().__init__(**kwargs)
        self.db_name = db_name
        self.flash_cache_limit = flash_cache_limit
        self.share = share


class DbNode(ProxyResource):
    """The DbNode resource belonging to vmCluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.DbNodeProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "DbNodeProperties"},
    }

    def __init__(self, *, properties: Optional["_models.DbNodeProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.oracledatabase.models.DbNodeProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class DbNodeAction(_serialization.Model):
    """DbNode action object.

    All required parameters must be populated in order to send to server.

    :ivar action: Db action. Required. Known values are: "Start", "Stop", "SoftReset", and "Reset".
    :vartype action: str or ~azure.mgmt.oracledatabase.models.DbNodeActionEnum
    """

    _validation = {
        "action": {"required": True},
    }

    _attribute_map = {
        "action": {"key": "action", "type": "str"},
    }

    def __init__(self, *, action: Union[str, "_models.DbNodeActionEnum"], **kwargs: Any) -> None:
        """
        :keyword action: Db action. Required. Known values are: "Start", "Stop", "SoftReset", and
         "Reset".
        :paramtype action: str or ~azure.mgmt.oracledatabase.models.DbNodeActionEnum
        """
        super().__init__(**kwargs)
        self.action = action


class DbNodeListResult(_serialization.Model):
    """The response of a DbNode list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The DbNode items on this page. Required.
    :vartype value: list[~azure.mgmt.oracledatabase.models.DbNode]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DbNode]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.DbNode"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The DbNode items on this page. Required.
        :paramtype value: list[~azure.mgmt.oracledatabase.models.DbNode]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DbNodeProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The properties of DbNodeResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar ocid: DbNode OCID. Required.
    :vartype ocid: str
    :ivar additional_details: Additional information about the planned maintenance.
    :vartype additional_details: str
    :ivar backup_ip_id: The OCID of the backup IP address associated with the database node.
    :vartype backup_ip_id: str
    :ivar backup_vnic2_id: The OCID of the second backup VNIC.
    :vartype backup_vnic2_id: str
    :ivar backup_vnic_id: The OCID of the backup VNIC.
    :vartype backup_vnic_id: str
    :ivar cpu_core_count: The number of CPU cores enabled on the Db node.
    :vartype cpu_core_count: int
    :ivar db_node_storage_size_in_gbs: The allocated local node storage in GBs on the Db node.
    :vartype db_node_storage_size_in_gbs: int
    :ivar db_server_id: The OCID of the Exacc Db server associated with the database node.
    :vartype db_server_id: str
    :ivar db_system_id: The OCID of the DB system. Required.
    :vartype db_system_id: str
    :ivar fault_domain: The name of the Fault Domain the instance is contained in.
    :vartype fault_domain: str
    :ivar host_ip_id: The OCID of the host IP address associated with the database node.
    :vartype host_ip_id: str
    :ivar hostname: The host name for the database node.
    :vartype hostname: str
    :ivar lifecycle_state: The current state of the database node. Known values are:
     "Provisioning", "Available", "Updating", "Stopping", "Stopped", "Starting", "Terminating",
     "Terminated", and "Failed".
    :vartype lifecycle_state: str or ~azure.mgmt.oracledatabase.models.DbNodeProvisioningState
    :ivar lifecycle_details: Lifecycle details of Db Node.
    :vartype lifecycle_details: str
    :ivar maintenance_type: The type of database node maintenance. "VmdbRebootMigration"
    :vartype maintenance_type: str or ~azure.mgmt.oracledatabase.models.DbNodeMaintenanceType
    :ivar memory_size_in_gbs: The allocated memory in GBs on the Db node.
    :vartype memory_size_in_gbs: int
    :ivar software_storage_size_in_gb: The size (in GB) of the block storage volume allocation for
     the DB system. This attribute applies only for virtual machine DB systems.
    :vartype software_storage_size_in_gb: int
    :ivar time_created: The date and time that the database node was created.
    :vartype time_created: ~datetime.datetime
    :ivar time_maintenance_window_end: End date and time of maintenance window.
    :vartype time_maintenance_window_end: ~datetime.datetime
    :ivar time_maintenance_window_start: Start date and time of maintenance window.
    :vartype time_maintenance_window_start: ~datetime.datetime
    :ivar vnic2_id: The OCID of the second VNIC.
    :vartype vnic2_id: str
    :ivar vnic_id: The OCID of the VNIC.
    :vartype vnic_id: str
    :ivar provisioning_state: Azure resource provisioning state. Known values are: "Succeeded",
     "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.oracledatabase.models.ResourceProvisioningState
    """

    _validation = {
        "ocid": {"required": True, "readonly": True, "max_length": 255, "min_length": 1},
        "additional_details": {"readonly": True},
        "backup_ip_id": {"readonly": True, "max_length": 255, "min_length": 1},
        "backup_vnic2_id": {"readonly": True, "max_length": 255, "min_length": 1},
        "backup_vnic_id": {"readonly": True, "max_length": 255, "min_length": 1},
        "cpu_core_count": {"readonly": True},
        "db_node_storage_size_in_gbs": {"readonly": True},
        "db_server_id": {"readonly": True, "max_length": 255, "min_length": 1},
        "db_system_id": {"required": True, "readonly": True, "max_length": 255, "min_length": 1},
        "fault_domain": {"readonly": True, "max_length": 255, "min_length": 1},
        "host_ip_id": {"readonly": True, "max_length": 255, "min_length": 1},
        "hostname": {"readonly": True},
        "lifecycle_state": {"readonly": True},
        "lifecycle_details": {"readonly": True},
        "maintenance_type": {"readonly": True},
        "memory_size_in_gbs": {"readonly": True},
        "software_storage_size_in_gb": {"readonly": True},
        "time_created": {"readonly": True},
        "time_maintenance_window_end": {"readonly": True},
        "time_maintenance_window_start": {"readonly": True},
        "vnic2_id": {"readonly": True, "max_length": 255, "min_length": 1},
        "vnic_id": {"readonly": True, "max_length": 255, "min_length": 1},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "ocid": {"key": "ocid", "type": "str"},
        "additional_details": {"key": "additionalDetails", "type": "str"},
        "backup_ip_id": {"key": "backupIpId", "type": "str"},
        "backup_vnic2_id": {"key": "backupVnic2Id", "type": "str"},
        "backup_vnic_id": {"key": "backupVnicId", "type": "str"},
        "cpu_core_count": {"key": "cpuCoreCount", "type": "int"},
        "db_node_storage_size_in_gbs": {"key": "dbNodeStorageSizeInGbs", "type": "int"},
        "db_server_id": {"key": "dbServerId", "type": "str"},
        "db_system_id": {"key": "dbSystemId", "type": "str"},
        "fault_domain": {"key": "faultDomain", "type": "str"},
        "host_ip_id": {"key": "hostIpId", "type": "str"},
        "hostname": {"key": "hostname", "type": "str"},
        "lifecycle_state": {"key": "lifecycleState", "type": "str"},
        "lifecycle_details": {"key": "lifecycleDetails", "type": "str"},
        "maintenance_type": {"key": "maintenanceType", "type": "str"},
        "memory_size_in_gbs": {"key": "memorySizeInGbs", "type": "int"},
        "software_storage_size_in_gb": {"key": "softwareStorageSizeInGb", "type": "int"},
        "time_created": {"key": "timeCreated", "type": "iso-8601"},
        "time_maintenance_window_end": {"key": "timeMaintenanceWindowEnd", "type": "iso-8601"},
        "time_maintenance_window_start": {"key": "timeMaintenanceWindowStart", "type": "iso-8601"},
        "vnic2_id": {"key": "vnic2Id", "type": "str"},
        "vnic_id": {"key": "vnicId", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.ocid = None
        self.additional_details = None
        self.backup_ip_id = None
        self.backup_vnic2_id = None
        self.backup_vnic_id = None
        self.cpu_core_count = None
        self.db_node_storage_size_in_gbs = None
        self.db_server_id = None
        self.db_system_id = None
        self.fault_domain = None
        self.host_ip_id = None
        self.hostname = None
        self.lifecycle_state = None
        self.lifecycle_details = None
        self.maintenance_type = None
        self.memory_size_in_gbs = None
        self.software_storage_size_in_gb = None
        self.time_created = None
        self.time_maintenance_window_end = None
        self.time_maintenance_window_start = None
        self.vnic2_id = None
        self.vnic_id = None
        self.provisioning_state = None


class DbServer(ProxyResource):
    """DbServer resource model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.DbServerProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "DbServerProperties"},
    }

    def __init__(self, *, properties: Optional["_models.DbServerProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.oracledatabase.models.DbServerProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class DbServerListResult(_serialization.Model):
    """The response of a DbServer list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The DbServer items on this page. Required.
    :vartype value: list[~azure.mgmt.oracledatabase.models.DbServer]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DbServer]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.DbServer"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The DbServer items on this page. Required.
        :paramtype value: list[~azure.mgmt.oracledatabase.models.DbServer]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DbServerPatchingDetails(_serialization.Model):
    """DbServer Patching Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar estimated_patch_duration: Estimated Patch Duration.
    :vartype estimated_patch_duration: int
    :ivar patching_status: Patching Status. Known values are: "Scheduled", "MaintenanceInProgress",
     "Failed", and "Complete".
    :vartype patching_status: str or ~azure.mgmt.oracledatabase.models.DbServerPatchingStatus
    :ivar time_patching_ended: Time Patching Ended.
    :vartype time_patching_ended: ~datetime.datetime
    :ivar time_patching_started: Time Patching Started.
    :vartype time_patching_started: ~datetime.datetime
    """

    _validation = {
        "estimated_patch_duration": {"readonly": True, "maximum": 3000, "minimum": 1},
        "patching_status": {"readonly": True},
        "time_patching_ended": {"readonly": True},
        "time_patching_started": {"readonly": True},
    }

    _attribute_map = {
        "estimated_patch_duration": {"key": "estimatedPatchDuration", "type": "int"},
        "patching_status": {"key": "patchingStatus", "type": "str"},
        "time_patching_ended": {"key": "timePatchingEnded", "type": "iso-8601"},
        "time_patching_started": {"key": "timePatchingStarted", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.estimated_patch_duration = None
        self.patching_status = None
        self.time_patching_ended = None
        self.time_patching_started = None


class DbServerProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """DbServer resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar ocid: Db server name.
    :vartype ocid: str
    :ivar display_name: The name for the Db Server.
    :vartype display_name: str
    :ivar compartment_id: The OCID of the compartment.
    :vartype compartment_id: str
    :ivar exadata_infrastructure_id: The OCID of the Exadata infrastructure.
    :vartype exadata_infrastructure_id: str
    :ivar cpu_core_count: The number of CPU cores enabled on the Db server.
    :vartype cpu_core_count: int
    :ivar db_server_patching_details: dbServerPatching details of the Db server.
    :vartype db_server_patching_details: ~azure.mgmt.oracledatabase.models.DbServerPatchingDetails
    :ivar max_memory_in_gbs: The total memory available in GBs.
    :vartype max_memory_in_gbs: int
    :ivar db_node_storage_size_in_gbs: The allocated local node storage in GBs on the Db server.
    :vartype db_node_storage_size_in_gbs: int
    :ivar vm_cluster_ids: The OCID of the VM Clusters associated with the Db server.
    :vartype vm_cluster_ids: list[str]
    :ivar db_node_ids: The OCID of the Db nodes associated with the Db server.
    :vartype db_node_ids: list[str]
    :ivar lifecycle_details: Lifecycle details of dbServer.
    :vartype lifecycle_details: str
    :ivar lifecycle_state: DbServer provisioning state. Known values are: "Creating", "Available",
     "Unavailable", "Deleting", "Deleted", and "MaintenanceInProgress".
    :vartype lifecycle_state: str or ~azure.mgmt.oracledatabase.models.DbServerProvisioningState
    :ivar max_cpu_count: The total number of CPU cores available.
    :vartype max_cpu_count: int
    :ivar autonomous_vm_cluster_ids: The list of OCIDs of the Autonomous VM Clusters associated
     with the Db server.
    :vartype autonomous_vm_cluster_ids: list[str]
    :ivar autonomous_virtual_machine_ids: The list of OCIDs of the Autonomous Virtual Machines
     associated with the Db server.
    :vartype autonomous_virtual_machine_ids: list[str]
    :ivar max_db_node_storage_in_gbs: The total max dbNode storage in GBs.
    :vartype max_db_node_storage_in_gbs: int
    :ivar memory_size_in_gbs: The total memory size in GBs.
    :vartype memory_size_in_gbs: int
    :ivar shape: The shape of the Db server. The shape determines the amount of CPU, storage, and
     memory resources available.
    :vartype shape: str
    :ivar time_created: The date and time that the Db Server was created.
    :vartype time_created: ~datetime.datetime
    :ivar provisioning_state: Azure resource provisioning state. Known values are: "Succeeded",
     "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.oracledatabase.models.ResourceProvisioningState
    """

    _validation = {
        "ocid": {"readonly": True, "max_length": 255, "min_length": 1},
        "display_name": {"readonly": True, "max_length": 255, "min_length": 1},
        "compartment_id": {"readonly": True, "max_length": 255, "min_length": 1},
        "exadata_infrastructure_id": {"readonly": True, "max_length": 255, "min_length": 1},
        "cpu_core_count": {"readonly": True},
        "db_server_patching_details": {"readonly": True},
        "max_memory_in_gbs": {"readonly": True},
        "db_node_storage_size_in_gbs": {"readonly": True},
        "vm_cluster_ids": {"readonly": True},
        "db_node_ids": {"readonly": True},
        "lifecycle_details": {"readonly": True},
        "lifecycle_state": {"readonly": True},
        "max_cpu_count": {"readonly": True},
        "autonomous_vm_cluster_ids": {"readonly": True},
        "autonomous_virtual_machine_ids": {"readonly": True},
        "max_db_node_storage_in_gbs": {"readonly": True},
        "memory_size_in_gbs": {"readonly": True},
        "shape": {"readonly": True, "max_length": 255, "min_length": 1},
        "time_created": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "ocid": {"key": "ocid", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "compartment_id": {"key": "compartmentId", "type": "str"},
        "exadata_infrastructure_id": {"key": "exadataInfrastructureId", "type": "str"},
        "cpu_core_count": {"key": "cpuCoreCount", "type": "int"},
        "db_server_patching_details": {"key": "dbServerPatchingDetails", "type": "DbServerPatchingDetails"},
        "max_memory_in_gbs": {"key": "maxMemoryInGbs", "type": "int"},
        "db_node_storage_size_in_gbs": {"key": "dbNodeStorageSizeInGbs", "type": "int"},
        "vm_cluster_ids": {"key": "vmClusterIds", "type": "[str]"},
        "db_node_ids": {"key": "dbNodeIds", "type": "[str]"},
        "lifecycle_details": {"key": "lifecycleDetails", "type": "str"},
        "lifecycle_state": {"key": "lifecycleState", "type": "str"},
        "max_cpu_count": {"key": "maxCpuCount", "type": "int"},
        "autonomous_vm_cluster_ids": {"key": "autonomousVmClusterIds", "type": "[str]"},
        "autonomous_virtual_machine_ids": {"key": "autonomousVirtualMachineIds", "type": "[str]"},
        "max_db_node_storage_in_gbs": {"key": "maxDbNodeStorageInGbs", "type": "int"},
        "memory_size_in_gbs": {"key": "memorySizeInGbs", "type": "int"},
        "shape": {"key": "shape", "type": "str"},
        "time_created": {"key": "timeCreated", "type": "iso-8601"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.ocid = None
        self.display_name = None
        self.compartment_id = None
        self.exadata_infrastructure_id = None
        self.cpu_core_count = None
        self.db_server_patching_details = None
        self.max_memory_in_gbs = None
        self.db_node_storage_size_in_gbs = None
        self.vm_cluster_ids = None
        self.db_node_ids = None
        self.lifecycle_details = None
        self.lifecycle_state = None
        self.max_cpu_count = None
        self.autonomous_vm_cluster_ids = None
        self.autonomous_virtual_machine_ids = None
        self.max_db_node_storage_in_gbs = None
        self.memory_size_in_gbs = None
        self.shape = None
        self.time_created = None
        self.provisioning_state = None


class DbSystemShape(ProxyResource):
    """DbSystemShape resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.DbSystemShapeProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "DbSystemShapeProperties"},
    }

    def __init__(self, *, properties: Optional["_models.DbSystemShapeProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.oracledatabase.models.DbSystemShapeProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class DbSystemShapeListResult(_serialization.Model):
    """The response of a DbSystemShape list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The DbSystemShape items on this page. Required.
    :vartype value: list[~azure.mgmt.oracledatabase.models.DbSystemShape]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DbSystemShape]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.DbSystemShape"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The DbSystemShape items on this page. Required.
        :paramtype value: list[~azure.mgmt.oracledatabase.models.DbSystemShape]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DbSystemShapeProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """DbSystemShape resource model.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar shape_family: The family of the shape used for the DB system.
    :vartype shape_family: str
    :ivar available_core_count: The maximum number of CPU cores that can be enabled on the DB
     system for this shape. Required.
    :vartype available_core_count: int
    :ivar minimum_core_count: The minimum number of CPU cores that can be enabled on the DB system
     for this shape.
    :vartype minimum_core_count: int
    :ivar runtime_minimum_core_count: The runtime minimum number of CPU cores that can be enabled
     on the DB system for this shape.
    :vartype runtime_minimum_core_count: int
    :ivar core_count_increment: The discrete number by which the CPU core count for this shape can
     be increased or decreased.
    :vartype core_count_increment: int
    :ivar min_storage_count: The minimum number of Exadata storage servers available for the
     Exadata infrastructure.
    :vartype min_storage_count: int
    :ivar max_storage_count: The maximum number of Exadata storage servers available for the
     Exadata infrastructure.
    :vartype max_storage_count: int
    :ivar available_data_storage_per_server_in_tbs: The maximum data storage available per storage
     server for this shape. Only applicable to ExaCC Elastic shapes.
    :vartype available_data_storage_per_server_in_tbs: float
    :ivar available_memory_per_node_in_gbs: The maximum memory available per database node for this
     shape. Only applicable to ExaCC Elastic shapes.
    :vartype available_memory_per_node_in_gbs: int
    :ivar available_db_node_per_node_in_gbs: The maximum Db Node storage available per database
     node for this shape. Only applicable to ExaCC Elastic shapes.
    :vartype available_db_node_per_node_in_gbs: int
    :ivar min_core_count_per_node: The minimum number of CPU cores that can be enabled per node for
     this shape.
    :vartype min_core_count_per_node: int
    :ivar available_memory_in_gbs: The maximum memory that can be enabled for this shape.
    :vartype available_memory_in_gbs: int
    :ivar min_memory_per_node_in_gbs: The minimum memory that need be allocated per node for this
     shape.
    :vartype min_memory_per_node_in_gbs: int
    :ivar available_db_node_storage_in_gbs: The maximum Db Node storage that can be enabled for
     this shape.
    :vartype available_db_node_storage_in_gbs: int
    :ivar min_db_node_storage_per_node_in_gbs: The minimum Db Node storage that need be allocated
     per node for this shape.
    :vartype min_db_node_storage_per_node_in_gbs: int
    :ivar available_data_storage_in_tbs: The maximum DATA storage that can be enabled for this
     shape.
    :vartype available_data_storage_in_tbs: int
    :ivar min_data_storage_in_tbs: The minimum data storage that need be allocated for this shape.
    :vartype min_data_storage_in_tbs: int
    :ivar minimum_node_count: The minimum number of database nodes available for this shape.
    :vartype minimum_node_count: int
    :ivar maximum_node_count: The maximum number of database nodes available for this shape.
    :vartype maximum_node_count: int
    :ivar available_core_count_per_node: The maximum number of CPU cores per database node that can
     be enabled for this shape. Only applicable to the flex Exadata shape and ExaCC Elastic shapes.
    :vartype available_core_count_per_node: int
    """

    _validation = {
        "shape_family": {"readonly": True, "max_length": 255, "min_length": 1},
        "available_core_count": {"required": True, "readonly": True},
        "minimum_core_count": {"readonly": True},
        "runtime_minimum_core_count": {"readonly": True},
        "core_count_increment": {"readonly": True},
        "min_storage_count": {"readonly": True},
        "max_storage_count": {"readonly": True},
        "available_data_storage_per_server_in_tbs": {"readonly": True},
        "available_memory_per_node_in_gbs": {"readonly": True},
        "available_db_node_per_node_in_gbs": {"readonly": True},
        "min_core_count_per_node": {"readonly": True},
        "available_memory_in_gbs": {"readonly": True},
        "min_memory_per_node_in_gbs": {"readonly": True},
        "available_db_node_storage_in_gbs": {"readonly": True},
        "min_db_node_storage_per_node_in_gbs": {"readonly": True},
        "available_data_storage_in_tbs": {"readonly": True},
        "min_data_storage_in_tbs": {"readonly": True},
        "minimum_node_count": {"readonly": True},
        "maximum_node_count": {"readonly": True},
        "available_core_count_per_node": {"readonly": True},
    }

    _attribute_map = {
        "shape_family": {"key": "shapeFamily", "type": "str"},
        "available_core_count": {"key": "availableCoreCount", "type": "int"},
        "minimum_core_count": {"key": "minimumCoreCount", "type": "int"},
        "runtime_minimum_core_count": {"key": "runtimeMinimumCoreCount", "type": "int"},
        "core_count_increment": {"key": "coreCountIncrement", "type": "int"},
        "min_storage_count": {"key": "minStorageCount", "type": "int"},
        "max_storage_count": {"key": "maxStorageCount", "type": "int"},
        "available_data_storage_per_server_in_tbs": {"key": "availableDataStoragePerServerInTbs", "type": "float"},
        "available_memory_per_node_in_gbs": {"key": "availableMemoryPerNodeInGbs", "type": "int"},
        "available_db_node_per_node_in_gbs": {"key": "availableDbNodePerNodeInGbs", "type": "int"},
        "min_core_count_per_node": {"key": "minCoreCountPerNode", "type": "int"},
        "available_memory_in_gbs": {"key": "availableMemoryInGbs", "type": "int"},
        "min_memory_per_node_in_gbs": {"key": "minMemoryPerNodeInGbs", "type": "int"},
        "available_db_node_storage_in_gbs": {"key": "availableDbNodeStorageInGbs", "type": "int"},
        "min_db_node_storage_per_node_in_gbs": {"key": "minDbNodeStoragePerNodeInGbs", "type": "int"},
        "available_data_storage_in_tbs": {"key": "availableDataStorageInTbs", "type": "int"},
        "min_data_storage_in_tbs": {"key": "minDataStorageInTbs", "type": "int"},
        "minimum_node_count": {"key": "minimumNodeCount", "type": "int"},
        "maximum_node_count": {"key": "maximumNodeCount", "type": "int"},
        "available_core_count_per_node": {"key": "availableCoreCountPerNode", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.shape_family = None
        self.available_core_count = None
        self.minimum_core_count = None
        self.runtime_minimum_core_count = None
        self.core_count_increment = None
        self.min_storage_count = None
        self.max_storage_count = None
        self.available_data_storage_per_server_in_tbs = None
        self.available_memory_per_node_in_gbs = None
        self.available_db_node_per_node_in_gbs = None
        self.min_core_count_per_node = None
        self.available_memory_in_gbs = None
        self.min_memory_per_node_in_gbs = None
        self.available_db_node_storage_in_gbs = None
        self.min_db_node_storage_per_node_in_gbs = None
        self.available_data_storage_in_tbs = None
        self.min_data_storage_in_tbs = None
        self.minimum_node_count = None
        self.maximum_node_count = None
        self.available_core_count_per_node = None


class DnsPrivateView(ProxyResource):
    """DnsPrivateView resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.DnsPrivateViewProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "DnsPrivateViewProperties"},
    }

    def __init__(self, *, properties: Optional["_models.DnsPrivateViewProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.oracledatabase.models.DnsPrivateViewProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class DnsPrivateViewListResult(_serialization.Model):
    """The response of a DnsPrivateView list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The DnsPrivateView items on this page. Required.
    :vartype value: list[~azure.mgmt.oracledatabase.models.DnsPrivateView]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DnsPrivateView]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.DnsPrivateView"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The DnsPrivateView items on this page. Required.
        :paramtype value: list[~azure.mgmt.oracledatabase.models.DnsPrivateView]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DnsPrivateViewProperties(_serialization.Model):
    """Views resource model.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar ocid: The OCID of the view. Required.
    :vartype ocid: str
    :ivar display_name: The display name of the view resource.
    :vartype display_name: str
    :ivar is_protected: A Boolean flag indicating whether or not parts of the resource are unable
     to be explicitly managed. Required.
    :vartype is_protected: bool
    :ivar lifecycle_state: Views lifecycleState. Known values are: "Active", "Deleted", "Deleting",
     and "Updating".
    :vartype lifecycle_state: str or
     ~azure.mgmt.oracledatabase.models.DnsPrivateViewsLifecycleState
    :ivar self_property: The canonical absolute URL of the resource. Required.
    :vartype self_property: str
    :ivar time_created: views timeCreated. Required.
    :vartype time_created: ~datetime.datetime
    :ivar time_updated: views timeCreated. Required.
    :vartype time_updated: ~datetime.datetime
    :ivar provisioning_state: Azure resource provisioning state. Known values are: "Succeeded",
     "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.oracledatabase.models.ResourceProvisioningState
    """

    _validation = {
        "ocid": {"required": True, "readonly": True, "max_length": 255, "min_length": 1},
        "display_name": {"readonly": True},
        "is_protected": {"required": True, "readonly": True},
        "lifecycle_state": {"readonly": True},
        "self_property": {"required": True, "readonly": True},
        "time_created": {"required": True, "readonly": True},
        "time_updated": {"required": True, "readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "ocid": {"key": "ocid", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "is_protected": {"key": "isProtected", "type": "bool"},
        "lifecycle_state": {"key": "lifecycleState", "type": "str"},
        "self_property": {"key": "self", "type": "str"},
        "time_created": {"key": "timeCreated", "type": "iso-8601"},
        "time_updated": {"key": "timeUpdated", "type": "iso-8601"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.ocid = None
        self.display_name = None
        self.is_protected = None
        self.lifecycle_state = None
        self.self_property = None
        self.time_created = None
        self.time_updated = None
        self.provisioning_state = None


class DnsPrivateZone(ProxyResource):
    """DnsPrivateZone resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.DnsPrivateZoneProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "DnsPrivateZoneProperties"},
    }

    def __init__(self, *, properties: Optional["_models.DnsPrivateZoneProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.oracledatabase.models.DnsPrivateZoneProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class DnsPrivateZoneListResult(_serialization.Model):
    """The response of a DnsPrivateZone list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The DnsPrivateZone items on this page. Required.
    :vartype value: list[~azure.mgmt.oracledatabase.models.DnsPrivateZone]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DnsPrivateZone]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.DnsPrivateZone"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The DnsPrivateZone items on this page. Required.
        :paramtype value: list[~azure.mgmt.oracledatabase.models.DnsPrivateZone]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DnsPrivateZoneProperties(_serialization.Model):
    """Zones resource model.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar ocid: The OCID of the Zone. Required.
    :vartype ocid: str
    :ivar is_protected: A Boolean flag indicating whether or not parts of the resource are unable
     to be explicitly managed. Required.
    :vartype is_protected: bool
    :ivar lifecycle_state: Zones lifecycleState. Known values are: "Active", "Creating", "Deleted",
     "Deleting", and "Updating".
    :vartype lifecycle_state: str or
     ~azure.mgmt.oracledatabase.models.DnsPrivateZonesLifecycleState
    :ivar self_property: The canonical absolute URL of the resource. Required.
    :vartype self_property: str
    :ivar serial: The current serial of the zone. As seen in the zone's SOA record. Required.
    :vartype serial: int
    :ivar version: Version is the never-repeating, totally-orderable, version of the zone, from
     which the serial field of the zone's SOA record is derived. Required.
    :vartype version: str
    :ivar view_id: The OCID of the private view containing the zone. This value will be null for
     zones in the global DNS, which are publicly resolvable and not part of a private view.
    :vartype view_id: str
    :ivar zone_type: The type of the zone. Must be either PRIMARY or SECONDARY. SECONDARY is only
     supported for GLOBAL zones. Required. Known values are: "Primary" and "Secondary".
    :vartype zone_type: str or ~azure.mgmt.oracledatabase.models.ZoneType
    :ivar time_created: Zones timeCreated. Required.
    :vartype time_created: ~datetime.datetime
    :ivar provisioning_state: Azure resource provisioning state. Known values are: "Succeeded",
     "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.oracledatabase.models.ResourceProvisioningState
    """

    _validation = {
        "ocid": {"required": True, "readonly": True, "max_length": 255, "min_length": 1},
        "is_protected": {"required": True, "readonly": True},
        "lifecycle_state": {"readonly": True},
        "self_property": {"required": True, "readonly": True},
        "serial": {"required": True, "readonly": True},
        "version": {"required": True, "readonly": True},
        "view_id": {"readonly": True, "max_length": 255, "min_length": 1},
        "zone_type": {"required": True, "readonly": True},
        "time_created": {"required": True, "readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "ocid": {"key": "ocid", "type": "str"},
        "is_protected": {"key": "isProtected", "type": "bool"},
        "lifecycle_state": {"key": "lifecycleState", "type": "str"},
        "self_property": {"key": "self", "type": "str"},
        "serial": {"key": "serial", "type": "int"},
        "version": {"key": "version", "type": "str"},
        "view_id": {"key": "viewId", "type": "str"},
        "zone_type": {"key": "zoneType", "type": "str"},
        "time_created": {"key": "timeCreated", "type": "iso-8601"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.ocid = None
        self.is_protected = None
        self.lifecycle_state = None
        self.self_property = None
        self.serial = None
        self.version = None
        self.view_id = None
        self.zone_type = None
        self.time_created = None
        self.provisioning_state = None


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.oracledatabase.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.oracledatabase.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.oracledatabase.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.oracledatabase.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class EstimatedPatchingTime(_serialization.Model):
    """The estimated total time required in minutes for all patching operations (database server,
    storage server, and network switch patching).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar estimated_db_server_patching_time: The estimated time required in minutes for database
     server patching.
    :vartype estimated_db_server_patching_time: int
    :ivar estimated_network_switches_patching_time: The estimated time required in minutes for
     network switch patching.
    :vartype estimated_network_switches_patching_time: int
    :ivar estimated_storage_server_patching_time: The estimated time required in minutes for
     storage server patching.
    :vartype estimated_storage_server_patching_time: int
    :ivar total_estimated_patching_time: The estimated total time required in minutes for all
     patching operations.
    :vartype total_estimated_patching_time: int
    """

    _validation = {
        "estimated_db_server_patching_time": {"readonly": True, "maximum": 3000, "minimum": 1},
        "estimated_network_switches_patching_time": {"readonly": True, "maximum": 3000, "minimum": 1},
        "estimated_storage_server_patching_time": {"readonly": True, "maximum": 3000, "minimum": 1},
        "total_estimated_patching_time": {"readonly": True, "maximum": 3000, "minimum": 1},
    }

    _attribute_map = {
        "estimated_db_server_patching_time": {"key": "estimatedDbServerPatchingTime", "type": "int"},
        "estimated_network_switches_patching_time": {"key": "estimatedNetworkSwitchesPatchingTime", "type": "int"},
        "estimated_storage_server_patching_time": {"key": "estimatedStorageServerPatchingTime", "type": "int"},
        "total_estimated_patching_time": {"key": "totalEstimatedPatchingTime", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.estimated_db_server_patching_time = None
        self.estimated_network_switches_patching_time = None
        self.estimated_storage_server_patching_time = None
        self.total_estimated_patching_time = None


class ExadataIormConfig(_serialization.Model):
    """ExadataIormConfig for cloud vm cluster.

    :ivar db_plans: An array of IORM settings for all the database in the Exadata DB system.
    :vartype db_plans: list[~azure.mgmt.oracledatabase.models.DbIormConfig]
    :ivar lifecycle_details: Additional information about the current lifecycleState.
    :vartype lifecycle_details: str
    :ivar lifecycle_state: The current state of IORM configuration for the Exadata DB system. Known
     values are: "BootStrapping", "Enabled", "Disabled", "Updating", and "Failed".
    :vartype lifecycle_state: str or ~azure.mgmt.oracledatabase.models.IormLifecycleState
    :ivar objective: The current value for the IORM objective. The default is AUTO. Known values
     are: "LowLatency", "HighThroughput", "Balanced", "Auto", and "Basic".
    :vartype objective: str or ~azure.mgmt.oracledatabase.models.Objective
    """

    _attribute_map = {
        "db_plans": {"key": "dbPlans", "type": "[DbIormConfig]"},
        "lifecycle_details": {"key": "lifecycleDetails", "type": "str"},
        "lifecycle_state": {"key": "lifecycleState", "type": "str"},
        "objective": {"key": "objective", "type": "str"},
    }

    def __init__(
        self,
        *,
        db_plans: Optional[List["_models.DbIormConfig"]] = None,
        lifecycle_details: Optional[str] = None,
        lifecycle_state: Optional[Union[str, "_models.IormLifecycleState"]] = None,
        objective: Optional[Union[str, "_models.Objective"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword db_plans: An array of IORM settings for all the database in the Exadata DB system.
        :paramtype db_plans: list[~azure.mgmt.oracledatabase.models.DbIormConfig]
        :keyword lifecycle_details: Additional information about the current lifecycleState.
        :paramtype lifecycle_details: str
        :keyword lifecycle_state: The current state of IORM configuration for the Exadata DB system.
         Known values are: "BootStrapping", "Enabled", "Disabled", "Updating", and "Failed".
        :paramtype lifecycle_state: str or ~azure.mgmt.oracledatabase.models.IormLifecycleState
        :keyword objective: The current value for the IORM objective. The default is AUTO. Known values
         are: "LowLatency", "HighThroughput", "Balanced", "Auto", and "Basic".
        :paramtype objective: str or ~azure.mgmt.oracledatabase.models.Objective
        """
        super().__init__(**kwargs)
        self.db_plans = db_plans
        self.lifecycle_details = lifecycle_details
        self.lifecycle_state = lifecycle_state
        self.objective = objective


class GenerateAutonomousDatabaseWalletDetails(_serialization.Model):
    """Autonomous Database Generate Wallet resource model.

    All required parameters must be populated in order to send to server.

    :ivar generate_type: The type of wallet to generate. Known values are: "Single" and "All".
    :vartype generate_type: str or ~azure.mgmt.oracledatabase.models.GenerateType
    :ivar is_regional: True when requesting regional connection strings in PDB connect info,
     applicable to cross-region DG only.
    :vartype is_regional: bool
    :ivar password: The password to encrypt the keys inside the wallet. Required.
    :vartype password: str
    """

    _validation = {
        "password": {"required": True},
    }

    _attribute_map = {
        "generate_type": {"key": "generateType", "type": "str"},
        "is_regional": {"key": "isRegional", "type": "bool"},
        "password": {"key": "password", "type": "str"},
    }

    def __init__(
        self,
        *,
        password: str,
        generate_type: Optional[Union[str, "_models.GenerateType"]] = None,
        is_regional: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword generate_type: The type of wallet to generate. Known values are: "Single" and "All".
        :paramtype generate_type: str or ~azure.mgmt.oracledatabase.models.GenerateType
        :keyword is_regional: True when requesting regional connection strings in PDB connect info,
         applicable to cross-region DG only.
        :paramtype is_regional: bool
        :keyword password: The password to encrypt the keys inside the wallet. Required.
        :paramtype password: str
        """
        super().__init__(**kwargs)
        self.generate_type = generate_type
        self.is_regional = is_regional
        self.password = password


class GiVersion(ProxyResource):
    """GiVersion resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.GiVersionProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "GiVersionProperties"},
    }

    def __init__(self, *, properties: Optional["_models.GiVersionProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.oracledatabase.models.GiVersionProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class GiVersionListResult(_serialization.Model):
    """The response of a GiVersion list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The GiVersion items on this page. Required.
    :vartype value: list[~azure.mgmt.oracledatabase.models.GiVersion]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[GiVersion]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.GiVersion"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The GiVersion items on this page. Required.
        :paramtype value: list[~azure.mgmt.oracledatabase.models.GiVersion]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GiVersionProperties(_serialization.Model):
    """GiVersion resource model.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar version: A valid Oracle Grid Infrastructure (GI) software version. Required.
    :vartype version: str
    """

    _validation = {
        "version": {"required": True, "readonly": True, "max_length": 255, "min_length": 1},
    }

    _attribute_map = {
        "version": {"key": "version", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.version = None


class LongTermBackUpScheduleDetails(_serialization.Model):
    """Details for the long-term backup schedule.

    :ivar repeat_cadence: The frequency of the long-term backup schedule. Known values are:
     "OneTime", "Weekly", "Monthly", and "Yearly".
    :vartype repeat_cadence: str or ~azure.mgmt.oracledatabase.models.RepeatCadenceType
    :ivar time_of_backup: The timestamp for the long-term backup schedule. For a MONTHLY cadence,
     months having fewer days than the provided date will have the backup taken on the last day of
     that month.
    :vartype time_of_backup: ~datetime.datetime
    :ivar retention_period_in_days: Retention period, in days, for backups.
    :vartype retention_period_in_days: int
    :ivar is_disabled: Indicates if the long-term backup schedule should be deleted. The default
     value is ``FALSE``.
    :vartype is_disabled: bool
    """

    _validation = {
        "retention_period_in_days": {"maximum": 2558, "minimum": 90},
    }

    _attribute_map = {
        "repeat_cadence": {"key": "repeatCadence", "type": "str"},
        "time_of_backup": {"key": "timeOfBackup", "type": "iso-8601"},
        "retention_period_in_days": {"key": "retentionPeriodInDays", "type": "int"},
        "is_disabled": {"key": "isDisabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        repeat_cadence: Optional[Union[str, "_models.RepeatCadenceType"]] = None,
        time_of_backup: Optional[datetime.datetime] = None,
        retention_period_in_days: Optional[int] = None,
        is_disabled: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword repeat_cadence: The frequency of the long-term backup schedule. Known values are:
         "OneTime", "Weekly", "Monthly", and "Yearly".
        :paramtype repeat_cadence: str or ~azure.mgmt.oracledatabase.models.RepeatCadenceType
        :keyword time_of_backup: The timestamp for the long-term backup schedule. For a MONTHLY
         cadence, months having fewer days than the provided date will have the backup taken on the last
         day of that month.
        :paramtype time_of_backup: ~datetime.datetime
        :keyword retention_period_in_days: Retention period, in days, for backups.
        :paramtype retention_period_in_days: int
        :keyword is_disabled: Indicates if the long-term backup schedule should be deleted. The default
         value is ``FALSE``.
        :paramtype is_disabled: bool
        """
        super().__init__(**kwargs)
        self.repeat_cadence = repeat_cadence
        self.time_of_backup = time_of_backup
        self.retention_period_in_days = retention_period_in_days
        self.is_disabled = is_disabled


class MaintenanceWindow(_serialization.Model):
    """MaintenanceWindow resource properties.

    :ivar preference: The maintenance window scheduling preference. Known values are:
     "NoPreference" and "CustomPreference".
    :vartype preference: str or ~azure.mgmt.oracledatabase.models.Preference
    :ivar months: Months during the year when maintenance should be performed.
    :vartype months: list[~azure.mgmt.oracledatabase.models.Month]
    :ivar weeks_of_month: Weeks during the month when maintenance should be performed. Weeks start
     on the 1st, 8th, 15th, and 22nd days of the month, and have a duration of 7 days. Weeks start
     and end based on calendar dates, not days of the week. For example, to allow maintenance during
     the 2nd week of the month (from the 8th day to the 14th day of the month), use the value 2.
     Maintenance cannot be scheduled for the fifth week of months that contain more than 28 days.
     Note that this parameter works in conjunction with the  daysOfWeek and hoursOfDay parameters to
     allow you to specify specific days of the week and hours that maintenance will be performed.
    :vartype weeks_of_month: list[int]
    :ivar days_of_week: Days during the week when maintenance should be performed.
    :vartype days_of_week: list[~azure.mgmt.oracledatabase.models.DayOfWeek]
    :ivar hours_of_day: The window of hours during the day when maintenance should be performed.
     The window is a 4 hour slot. Valid values are - 0 - represents time slot 0:00 - 3:59 UTC - 4 -
     represents time slot 4:00 - 7:59 UTC - 8 - represents time slot 8:00 - 11:59 UTC - 12 -
     represents time slot 12:00 - 15:59 UTC - 16 - represents time slot 16:00 - 19:59 UTC - 20 -
     represents time slot 20:00 - 23:59 UTC.
    :vartype hours_of_day: list[int]
    :ivar lead_time_in_weeks: Lead time window allows user to set a lead time to prepare for a down
     time. The lead time is in weeks and valid value is between 1 to 4.
    :vartype lead_time_in_weeks: int
    :ivar patching_mode: Cloud Exadata infrastructure node patching method. Known values are:
     "Rolling" and "NonRolling".
    :vartype patching_mode: str or ~azure.mgmt.oracledatabase.models.PatchingMode
    :ivar custom_action_timeout_in_mins: Determines the amount of time the system will wait before
     the start of each database server patching operation. Custom action timeout is in minutes and
     valid value is between 15 to 120 (inclusive).
    :vartype custom_action_timeout_in_mins: int
    :ivar is_custom_action_timeout_enabled: If true, enables the configuration of a custom action
     timeout (waiting period) between database server patching operations.
    :vartype is_custom_action_timeout_enabled: bool
    :ivar is_monthly_patching_enabled: is Monthly Patching Enabled.
    :vartype is_monthly_patching_enabled: bool
    """

    _validation = {
        "custom_action_timeout_in_mins": {"maximum": 120, "minimum": 0},
    }

    _attribute_map = {
        "preference": {"key": "preference", "type": "str"},
        "months": {"key": "months", "type": "[Month]"},
        "weeks_of_month": {"key": "weeksOfMonth", "type": "[int]"},
        "days_of_week": {"key": "daysOfWeek", "type": "[DayOfWeek]"},
        "hours_of_day": {"key": "hoursOfDay", "type": "[int]"},
        "lead_time_in_weeks": {"key": "leadTimeInWeeks", "type": "int"},
        "patching_mode": {"key": "patchingMode", "type": "str"},
        "custom_action_timeout_in_mins": {"key": "customActionTimeoutInMins", "type": "int"},
        "is_custom_action_timeout_enabled": {"key": "isCustomActionTimeoutEnabled", "type": "bool"},
        "is_monthly_patching_enabled": {"key": "isMonthlyPatchingEnabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        preference: Optional[Union[str, "_models.Preference"]] = None,
        months: Optional[List["_models.Month"]] = None,
        weeks_of_month: Optional[List[int]] = None,
        days_of_week: Optional[List["_models.DayOfWeek"]] = None,
        hours_of_day: Optional[List[int]] = None,
        lead_time_in_weeks: Optional[int] = None,
        patching_mode: Optional[Union[str, "_models.PatchingMode"]] = None,
        custom_action_timeout_in_mins: Optional[int] = None,
        is_custom_action_timeout_enabled: Optional[bool] = None,
        is_monthly_patching_enabled: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword preference: The maintenance window scheduling preference. Known values are:
         "NoPreference" and "CustomPreference".
        :paramtype preference: str or ~azure.mgmt.oracledatabase.models.Preference
        :keyword months: Months during the year when maintenance should be performed.
        :paramtype months: list[~azure.mgmt.oracledatabase.models.Month]
        :keyword weeks_of_month: Weeks during the month when maintenance should be performed. Weeks
         start on the 1st, 8th, 15th, and 22nd days of the month, and have a duration of 7 days. Weeks
         start and end based on calendar dates, not days of the week. For example, to allow maintenance
         during the 2nd week of the month (from the 8th day to the 14th day of the month), use the value
         2. Maintenance cannot be scheduled for the fifth week of months that contain more than 28 days.
         Note that this parameter works in conjunction with the  daysOfWeek and hoursOfDay parameters to
         allow you to specify specific days of the week and hours that maintenance will be performed.
        :paramtype weeks_of_month: list[int]
        :keyword days_of_week: Days during the week when maintenance should be performed.
        :paramtype days_of_week: list[~azure.mgmt.oracledatabase.models.DayOfWeek]
        :keyword hours_of_day: The window of hours during the day when maintenance should be performed.
         The window is a 4 hour slot. Valid values are - 0 - represents time slot 0:00 - 3:59 UTC - 4 -
         represents time slot 4:00 - 7:59 UTC - 8 - represents time slot 8:00 - 11:59 UTC - 12 -
         represents time slot 12:00 - 15:59 UTC - 16 - represents time slot 16:00 - 19:59 UTC - 20 -
         represents time slot 20:00 - 23:59 UTC.
        :paramtype hours_of_day: list[int]
        :keyword lead_time_in_weeks: Lead time window allows user to set a lead time to prepare for a
         down time. The lead time is in weeks and valid value is between 1 to 4.
        :paramtype lead_time_in_weeks: int
        :keyword patching_mode: Cloud Exadata infrastructure node patching method. Known values are:
         "Rolling" and "NonRolling".
        :paramtype patching_mode: str or ~azure.mgmt.oracledatabase.models.PatchingMode
        :keyword custom_action_timeout_in_mins: Determines the amount of time the system will wait
         before the start of each database server patching operation. Custom action timeout is in
         minutes and valid value is between 15 to 120 (inclusive).
        :paramtype custom_action_timeout_in_mins: int
        :keyword is_custom_action_timeout_enabled: If true, enables the configuration of a custom
         action timeout (waiting period) between database server patching operations.
        :paramtype is_custom_action_timeout_enabled: bool
        :keyword is_monthly_patching_enabled: is Monthly Patching Enabled.
        :paramtype is_monthly_patching_enabled: bool
        """
        super().__init__(**kwargs)
        self.preference = preference
        self.months = months
        self.weeks_of_month = weeks_of_month
        self.days_of_week = days_of_week
        self.hours_of_day = hours_of_day
        self.lead_time_in_weeks = lead_time_in_weeks
        self.patching_mode = patching_mode
        self.custom_action_timeout_in_mins = custom_action_timeout_in_mins
        self.is_custom_action_timeout_enabled = is_custom_action_timeout_enabled
        self.is_monthly_patching_enabled = is_monthly_patching_enabled


class Month(_serialization.Model):
    """Month resource properties.

    All required parameters must be populated in order to send to server.

    :ivar name: Name of the month of the year. Required. Known values are: "January", "February",
     "March", "April", "May", "June", "July", "August", "September", "October", "November", and
     "December".
    :vartype name: str or ~azure.mgmt.oracledatabase.models.MonthName
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Union[str, "_models.MonthName"], **kwargs: Any) -> None:
        """
        :keyword name: Name of the month of the year. Required. Known values are: "January",
         "February", "March", "April", "May", "June", "July", "August", "September", "October",
         "November", and "December".
        :paramtype name: str or ~azure.mgmt.oracledatabase.models.MonthName
        """
        super().__init__(**kwargs)
        self.name = name


class NsgCidr(_serialization.Model):
    """A rule for allowing inbound (INGRESS) IP packets.

    All required parameters must be populated in order to send to server.

    :ivar source: Conceptually, this is the range of IP addresses that a packet coming into the
     instance can come from. Required.
    :vartype source: str
    :ivar destination_port_range: Destination port range to specify particular destination ports
     for TCP rules.
    :vartype destination_port_range: ~azure.mgmt.oracledatabase.models.PortRange
    """

    _validation = {
        "source": {"required": True, "max_length": 128, "min_length": 1},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "str"},
        "destination_port_range": {"key": "destinationPortRange", "type": "PortRange"},
    }

    def __init__(
        self, *, source: str, destination_port_range: Optional["_models.PortRange"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword source: Conceptually, this is the range of IP addresses that a packet coming into the
         instance can come from. Required.
        :paramtype source: str
        :keyword destination_port_range: Destination port range to specify particular destination ports
         for TCP rules.
        :paramtype destination_port_range: ~azure.mgmt.oracledatabase.models.PortRange
        """
        super().__init__(**kwargs)
        self.source = source
        self.destination_port_range = destination_port_range


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.oracledatabase.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.oracledatabase.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.oracledatabase.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.oracledatabase.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.oracledatabase.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class OracleSubscription(ProxyResource):
    """OracleSubscription resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.OracleSubscriptionProperties
    :ivar plan: Details of the resource plan.
    :vartype plan: ~azure.mgmt.oracledatabase.models.Plan
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "OracleSubscriptionProperties"},
        "plan": {"key": "plan", "type": "Plan"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.OracleSubscriptionProperties"] = None,
        plan: Optional["_models.Plan"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.oracledatabase.models.OracleSubscriptionProperties
        :keyword plan: Details of the resource plan.
        :paramtype plan: ~azure.mgmt.oracledatabase.models.Plan
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.plan = plan


class OracleSubscriptionListResult(_serialization.Model):
    """The response of a OracleSubscription list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The OracleSubscription items on this page. Required.
    :vartype value: list[~azure.mgmt.oracledatabase.models.OracleSubscription]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[OracleSubscription]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.OracleSubscription"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The OracleSubscription items on this page. Required.
        :paramtype value: list[~azure.mgmt.oracledatabase.models.OracleSubscription]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OracleSubscriptionProperties(_serialization.Model):
    """Oracle Subscription resource model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: OracleSubscriptionProvisioningState provisioning state. Known values
     are: "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.oracledatabase.models.OracleSubscriptionProvisioningState
    :ivar saas_subscription_id: SAAS subscription ID generated by Marketplace.
    :vartype saas_subscription_id: str
    :ivar cloud_account_id: Cloud Account Id.
    :vartype cloud_account_id: str
    :ivar cloud_account_state: Cloud Account provisioning state. Known values are: "Pending",
     "Provisioning", and "Available".
    :vartype cloud_account_state: str or
     ~azure.mgmt.oracledatabase.models.CloudAccountProvisioningState
    :ivar term_unit: Term Unit. P1Y, P3Y, etc, see Durations
     https://en.wikipedia.org/wiki/ISO_8601.
    :vartype term_unit: str
    :ivar product_code: Product code for the term unit.
    :vartype product_code: str
    :ivar intent: Intent for the update operation. Known values are: "Retain" and "Reset".
    :vartype intent: str or ~azure.mgmt.oracledatabase.models.Intent
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "saas_subscription_id": {"readonly": True},
        "cloud_account_id": {"readonly": True, "max_length": 255, "min_length": 1},
        "cloud_account_state": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "saas_subscription_id": {"key": "saasSubscriptionId", "type": "str"},
        "cloud_account_id": {"key": "cloudAccountId", "type": "str"},
        "cloud_account_state": {"key": "cloudAccountState", "type": "str"},
        "term_unit": {"key": "termUnit", "type": "str"},
        "product_code": {"key": "productCode", "type": "str"},
        "intent": {"key": "intent", "type": "str"},
    }

    def __init__(
        self,
        *,
        term_unit: Optional[str] = None,
        product_code: Optional[str] = None,
        intent: Optional[Union[str, "_models.Intent"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword term_unit: Term Unit. P1Y, P3Y, etc, see Durations
         https://en.wikipedia.org/wiki/ISO_8601.
        :paramtype term_unit: str
        :keyword product_code: Product code for the term unit.
        :paramtype product_code: str
        :keyword intent: Intent for the update operation. Known values are: "Retain" and "Reset".
        :paramtype intent: str or ~azure.mgmt.oracledatabase.models.Intent
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.saas_subscription_id = None
        self.cloud_account_id = None
        self.cloud_account_state = None
        self.term_unit = term_unit
        self.product_code = product_code
        self.intent = intent


class OracleSubscriptionUpdate(_serialization.Model):
    """The type used for update operations of the OracleSubscription.

    :ivar plan: Details of the resource plan.
    :vartype plan: ~azure.mgmt.oracledatabase.models.PlanUpdate
    :ivar properties: The updatable properties of the OracleSubscription.
    :vartype properties: ~azure.mgmt.oracledatabase.models.OracleSubscriptionUpdateProperties
    """

    _attribute_map = {
        "plan": {"key": "plan", "type": "PlanUpdate"},
        "properties": {"key": "properties", "type": "OracleSubscriptionUpdateProperties"},
    }

    def __init__(
        self,
        *,
        plan: Optional["_models.PlanUpdate"] = None,
        properties: Optional["_models.OracleSubscriptionUpdateProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword plan: Details of the resource plan.
        :paramtype plan: ~azure.mgmt.oracledatabase.models.PlanUpdate
        :keyword properties: The updatable properties of the OracleSubscription.
        :paramtype properties: ~azure.mgmt.oracledatabase.models.OracleSubscriptionUpdateProperties
        """
        super().__init__(**kwargs)
        self.plan = plan
        self.properties = properties


class OracleSubscriptionUpdateProperties(_serialization.Model):
    """The updatable properties of the OracleSubscription.

    :ivar product_code: Product code for the term unit.
    :vartype product_code: str
    :ivar intent: Intent for the update operation. Known values are: "Retain" and "Reset".
    :vartype intent: str or ~azure.mgmt.oracledatabase.models.Intent
    """

    _attribute_map = {
        "product_code": {"key": "productCode", "type": "str"},
        "intent": {"key": "intent", "type": "str"},
    }

    def __init__(
        self,
        *,
        product_code: Optional[str] = None,
        intent: Optional[Union[str, "_models.Intent"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword product_code: Product code for the term unit.
        :paramtype product_code: str
        :keyword intent: Intent for the update operation. Known values are: "Retain" and "Reset".
        :paramtype intent: str or ~azure.mgmt.oracledatabase.models.Intent
        """
        super().__init__(**kwargs)
        self.product_code = product_code
        self.intent = intent


class PeerDbDetails(_serialization.Model):
    """PeerDb Details.

    :ivar peer_db_id: The database OCID of the Disaster Recovery peer database, which is located in
     a different region from the current peer database.
    :vartype peer_db_id: str
    """

    _validation = {
        "peer_db_id": {"max_length": 255, "min_length": 1},
    }

    _attribute_map = {
        "peer_db_id": {"key": "peerDbId", "type": "str"},
    }

    def __init__(self, *, peer_db_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword peer_db_id: The database OCID of the Disaster Recovery peer database, which is located
         in a different region from the current peer database.
        :paramtype peer_db_id: str
        """
        super().__init__(**kwargs)
        self.peer_db_id = peer_db_id


class Plan(_serialization.Model):
    """Plan for the resource.

    All required parameters must be populated in order to send to server.

    :ivar name: A user defined name of the 3rd Party Artifact that is being procured. Required.
    :vartype name: str
    :ivar publisher: The publisher of the 3rd Party Artifact that is being bought. E.g. NewRelic.
     Required.
    :vartype publisher: str
    :ivar product: The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to
     the OfferID specified for the artifact at the time of Data Market onboarding. Required.
    :vartype product: str
    :ivar promotion_code: A publisher provided promotion code as provisioned in Data Market for the
     said product/artifact.
    :vartype promotion_code: str
    :ivar version: The version of the desired product/artifact.
    :vartype version: str
    """

    _validation = {
        "name": {"required": True},
        "publisher": {"required": True},
        "product": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "publisher": {"key": "publisher", "type": "str"},
        "product": {"key": "product", "type": "str"},
        "promotion_code": {"key": "promotionCode", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        publisher: str,
        product: str,
        promotion_code: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: A user defined name of the 3rd Party Artifact that is being procured. Required.
        :paramtype name: str
        :keyword publisher: The publisher of the 3rd Party Artifact that is being bought. E.g.
         NewRelic. Required.
        :paramtype publisher: str
        :keyword product: The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to
         the OfferID specified for the artifact at the time of Data Market onboarding. Required.
        :paramtype product: str
        :keyword promotion_code: A publisher provided promotion code as provisioned in Data Market for
         the said product/artifact.
        :paramtype promotion_code: str
        :keyword version: The version of the desired product/artifact.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.publisher = publisher
        self.product = product
        self.promotion_code = promotion_code
        self.version = version


class PlanUpdate(_serialization.Model):
    """ResourcePlanTypeUpdate model definition.

    :ivar name: A user defined name of the 3rd Party Artifact that is being procured.
    :vartype name: str
    :ivar publisher: The publisher of the 3rd Party Artifact that is being bought. E.g. NewRelic.
    :vartype publisher: str
    :ivar product: The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to
     the OfferID specified for the artifact at the time of Data Market onboarding.
    :vartype product: str
    :ivar promotion_code: A publisher provided promotion code as provisioned in Data Market for the
     said product/artifact.
    :vartype promotion_code: str
    :ivar version: The version of the desired product/artifact.
    :vartype version: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "publisher": {"key": "publisher", "type": "str"},
        "product": {"key": "product", "type": "str"},
        "promotion_code": {"key": "promotionCode", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        publisher: Optional[str] = None,
        product: Optional[str] = None,
        promotion_code: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: A user defined name of the 3rd Party Artifact that is being procured.
        :paramtype name: str
        :keyword publisher: The publisher of the 3rd Party Artifact that is being bought. E.g.
         NewRelic.
        :paramtype publisher: str
        :keyword product: The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to
         the OfferID specified for the artifact at the time of Data Market onboarding.
        :paramtype product: str
        :keyword promotion_code: A publisher provided promotion code as provisioned in Data Market for
         the said product/artifact.
        :paramtype promotion_code: str
        :keyword version: The version of the desired product/artifact.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.publisher = publisher
        self.product = product
        self.promotion_code = promotion_code
        self.version = version


class PortRange(_serialization.Model):
    """Port Range to specify particular destination ports for TCP rules.

    All required parameters must be populated in order to send to server.

    :ivar min: The minimum port number, which must not be greater than the maximum port number.
     Required.
    :vartype min: int
    :ivar max: The maximum port number, which must not be less than the minimum port number. To
     specify a single port number, set both the min and max to the same value. Required.
    :vartype max: int
    """

    _validation = {
        "min": {"required": True, "maximum": 65535, "minimum": 1},
        "max": {"required": True, "maximum": 65535, "minimum": 1},
    }

    _attribute_map = {
        "min": {"key": "min", "type": "int"},
        "max": {"key": "max", "type": "int"},
    }

    def __init__(
        self,
        *,
        min: int,  # pylint: disable=redefined-builtin
        max: int,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword min: The minimum port number, which must not be greater than the maximum port number.
         Required.
        :paramtype min: int
        :keyword max: The maximum port number, which must not be less than the minimum port number. To
         specify a single port number, set both the min and max to the same value. Required.
        :paramtype max: int
        """
        super().__init__(**kwargs)
        self.min = min
        self.max = max


class PrivateIpAddressesFilter(_serialization.Model):
    """Private Ip Addresses filter.

    All required parameters must be populated in order to send to server.

    :ivar subnet_id: Subnet OCID. Required.
    :vartype subnet_id: str
    :ivar vnic_id: VCN OCID. Required.
    :vartype vnic_id: str
    """

    _validation = {
        "subnet_id": {"required": True, "max_length": 255, "min_length": 1},
        "vnic_id": {"required": True, "max_length": 255, "min_length": 1},
    }

    _attribute_map = {
        "subnet_id": {"key": "subnetId", "type": "str"},
        "vnic_id": {"key": "vnicId", "type": "str"},
    }

    def __init__(self, *, subnet_id: str, vnic_id: str, **kwargs: Any) -> None:
        """
        :keyword subnet_id: Subnet OCID. Required.
        :paramtype subnet_id: str
        :keyword vnic_id: VCN OCID. Required.
        :paramtype vnic_id: str
        """
        super().__init__(**kwargs)
        self.subnet_id = subnet_id
        self.vnic_id = vnic_id


class PrivateIpAddressProperties(_serialization.Model):
    """PrivateIpAddress resource properties.

    All required parameters must be populated in order to send to server.

    :ivar display_name: PrivateIpAddresses displayName. Required.
    :vartype display_name: str
    :ivar hostname_label: PrivateIpAddresses hostnameLabel. Required.
    :vartype hostname_label: str
    :ivar ocid: PrivateIpAddresses Id. Required.
    :vartype ocid: str
    :ivar ip_address: PrivateIpAddresses ipAddress. Required.
    :vartype ip_address: str
    :ivar subnet_id: PrivateIpAddresses subnetId. Required.
    :vartype subnet_id: str
    """

    _validation = {
        "display_name": {"required": True},
        "hostname_label": {"required": True},
        "ocid": {"required": True, "max_length": 255, "min_length": 1},
        "ip_address": {"required": True},
        "subnet_id": {"required": True, "max_length": 255, "min_length": 1},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "hostname_label": {"key": "hostnameLabel", "type": "str"},
        "ocid": {"key": "ocid", "type": "str"},
        "ip_address": {"key": "ipAddress", "type": "str"},
        "subnet_id": {"key": "subnetId", "type": "str"},
    }

    def __init__(
        self, *, display_name: str, hostname_label: str, ocid: str, ip_address: str, subnet_id: str, **kwargs: Any
    ) -> None:
        """
        :keyword display_name: PrivateIpAddresses displayName. Required.
        :paramtype display_name: str
        :keyword hostname_label: PrivateIpAddresses hostnameLabel. Required.
        :paramtype hostname_label: str
        :keyword ocid: PrivateIpAddresses Id. Required.
        :paramtype ocid: str
        :keyword ip_address: PrivateIpAddresses ipAddress. Required.
        :paramtype ip_address: str
        :keyword subnet_id: PrivateIpAddresses subnetId. Required.
        :paramtype subnet_id: str
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.hostname_label = hostname_label
        self.ocid = ocid
        self.ip_address = ip_address
        self.subnet_id = subnet_id


class ProfileType(_serialization.Model):
    """The connection string profile to allow clients to group, filter and select connection string
    values based on structured metadata.

    All required parameters must be populated in order to send to server.

    :ivar consumer_group: Consumer group used by the connection. Known values are: "High",
     "Medium", "Low", "Tp", and "Tpurgent".
    :vartype consumer_group: str or ~azure.mgmt.oracledatabase.models.ConsumerGroup
    :ivar display_name: A user-friendly name for the connection. Required.
    :vartype display_name: str
    :ivar host_format: Host format used in connection string. Required. Known values are: "Fqdn"
     and "Ip".
    :vartype host_format: str or ~azure.mgmt.oracledatabase.models.HostFormatType
    :ivar is_regional: True for a regional connection string, applicable to cross-region DG only.
    :vartype is_regional: bool
    :ivar protocol: Protocol used by the connection. Required. Known values are: "TCP" and "TCPS".
    :vartype protocol: str or ~azure.mgmt.oracledatabase.models.ProtocolType
    :ivar session_mode: Specifies whether the listener performs a direct hand-off of the session,
     or redirects the session. Required. Known values are: "Direct" and "Redirect".
    :vartype session_mode: str or ~azure.mgmt.oracledatabase.models.SessionModeType
    :ivar syntax_format: Specifies whether the connection string is using the long (LONG), Easy
     Connect (EZCONNECT), or Easy Connect Plus (EZCONNECTPLUS) format. Required. Known values are:
     "Long", "Ezconnect", and "Ezconnectplus".
    :vartype syntax_format: str or ~azure.mgmt.oracledatabase.models.SyntaxFormatType
    :ivar tls_authentication: Specifies whether the TLS handshake is using one-way (SERVER) or
     mutual (MUTUAL) authentication. Known values are: "Server" and "Mutual".
    :vartype tls_authentication: str or ~azure.mgmt.oracledatabase.models.TlsAuthenticationType
    :ivar value: Connection string value. Required.
    :vartype value: str
    """

    _validation = {
        "display_name": {"required": True, "max_length": 255, "min_length": 1},
        "host_format": {"required": True},
        "protocol": {"required": True},
        "session_mode": {"required": True},
        "syntax_format": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "consumer_group": {"key": "consumerGroup", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "host_format": {"key": "hostFormat", "type": "str"},
        "is_regional": {"key": "isRegional", "type": "bool"},
        "protocol": {"key": "protocol", "type": "str"},
        "session_mode": {"key": "sessionMode", "type": "str"},
        "syntax_format": {"key": "syntaxFormat", "type": "str"},
        "tls_authentication": {"key": "tlsAuthentication", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(
        self,
        *,
        display_name: str,
        host_format: Union[str, "_models.HostFormatType"],
        protocol: Union[str, "_models.ProtocolType"],
        session_mode: Union[str, "_models.SessionModeType"],
        syntax_format: Union[str, "_models.SyntaxFormatType"],
        value: str,
        consumer_group: Optional[Union[str, "_models.ConsumerGroup"]] = None,
        is_regional: Optional[bool] = None,
        tls_authentication: Optional[Union[str, "_models.TlsAuthenticationType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword consumer_group: Consumer group used by the connection. Known values are: "High",
         "Medium", "Low", "Tp", and "Tpurgent".
        :paramtype consumer_group: str or ~azure.mgmt.oracledatabase.models.ConsumerGroup
        :keyword display_name: A user-friendly name for the connection. Required.
        :paramtype display_name: str
        :keyword host_format: Host format used in connection string. Required. Known values are: "Fqdn"
         and "Ip".
        :paramtype host_format: str or ~azure.mgmt.oracledatabase.models.HostFormatType
        :keyword is_regional: True for a regional connection string, applicable to cross-region DG
         only.
        :paramtype is_regional: bool
        :keyword protocol: Protocol used by the connection. Required. Known values are: "TCP" and
         "TCPS".
        :paramtype protocol: str or ~azure.mgmt.oracledatabase.models.ProtocolType
        :keyword session_mode: Specifies whether the listener performs a direct hand-off of the
         session, or redirects the session. Required. Known values are: "Direct" and "Redirect".
        :paramtype session_mode: str or ~azure.mgmt.oracledatabase.models.SessionModeType
        :keyword syntax_format: Specifies whether the connection string is using the long (LONG), Easy
         Connect (EZCONNECT), or Easy Connect Plus (EZCONNECTPLUS) format. Required. Known values are:
         "Long", "Ezconnect", and "Ezconnectplus".
        :paramtype syntax_format: str or ~azure.mgmt.oracledatabase.models.SyntaxFormatType
        :keyword tls_authentication: Specifies whether the TLS handshake is using one-way (SERVER) or
         mutual (MUTUAL) authentication. Known values are: "Server" and "Mutual".
        :paramtype tls_authentication: str or ~azure.mgmt.oracledatabase.models.TlsAuthenticationType
        :keyword value: Connection string value. Required.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.consumer_group = consumer_group
        self.display_name = display_name
        self.host_format = host_format
        self.is_regional = is_regional
        self.protocol = protocol
        self.session_mode = session_mode
        self.syntax_format = syntax_format
        self.tls_authentication = tls_authentication
        self.value = value


class RestoreAutonomousDatabaseDetails(_serialization.Model):
    """Details to restore an Oracle Autonomous Database.

    All required parameters must be populated in order to send to server.

    :ivar timestamp: The time to restore the database to. Required.
    :vartype timestamp: ~datetime.datetime
    """

    _validation = {
        "timestamp": {"required": True},
    }

    _attribute_map = {
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
    }

    def __init__(self, *, timestamp: datetime.datetime, **kwargs: Any) -> None:
        """
        :keyword timestamp: The time to restore the database to. Required.
        :paramtype timestamp: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.timestamp = timestamp


class SaasSubscriptionDetails(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """SaaS Subscription Details model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Purchased SaaS subscription ID.
    :vartype id: str
    :ivar subscription_name: SaaS subscription name.
    :vartype subscription_name: str
    :ivar time_created: Creation Date and Time.
    :vartype time_created: ~datetime.datetime
    :ivar offer_id: Purchased offer ID.
    :vartype offer_id: str
    :ivar plan_id: Purchased offer's plan ID.
    :vartype plan_id: str
    :ivar saas_subscription_status: Indicates the status of the Subscription.
    :vartype saas_subscription_status: str
    :ivar publisher_id: Publisher ID.
    :vartype publisher_id: str
    :ivar purchaser_email_id: Purchaser Email ID.
    :vartype purchaser_email_id: str
    :ivar purchaser_tenant_id: Purchaser Tenant ID.
    :vartype purchaser_tenant_id: str
    :ivar term_unit: Purchase Term Unit.
    :vartype term_unit: str
    :ivar is_auto_renew: AutoRenew flag.
    :vartype is_auto_renew: bool
    :ivar is_free_trial: FreeTrial flag.
    :vartype is_free_trial: bool
    """

    _validation = {
        "id": {"readonly": True},
        "subscription_name": {"readonly": True},
        "time_created": {"readonly": True},
        "offer_id": {"readonly": True},
        "plan_id": {"readonly": True},
        "saas_subscription_status": {"readonly": True},
        "publisher_id": {"readonly": True},
        "purchaser_email_id": {"readonly": True},
        "purchaser_tenant_id": {"readonly": True},
        "term_unit": {"readonly": True},
        "is_auto_renew": {"readonly": True},
        "is_free_trial": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "subscription_name": {"key": "subscriptionName", "type": "str"},
        "time_created": {"key": "timeCreated", "type": "iso-8601"},
        "offer_id": {"key": "offerId", "type": "str"},
        "plan_id": {"key": "planId", "type": "str"},
        "saas_subscription_status": {"key": "saasSubscriptionStatus", "type": "str"},
        "publisher_id": {"key": "publisherId", "type": "str"},
        "purchaser_email_id": {"key": "purchaserEmailId", "type": "str"},
        "purchaser_tenant_id": {"key": "purchaserTenantId", "type": "str"},
        "term_unit": {"key": "termUnit", "type": "str"},
        "is_auto_renew": {"key": "isAutoRenew", "type": "bool"},
        "is_free_trial": {"key": "isFreeTrial", "type": "bool"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.subscription_name = None
        self.time_created = None
        self.offer_id = None
        self.plan_id = None
        self.saas_subscription_status = None
        self.publisher_id = None
        self.purchaser_email_id = None
        self.purchaser_tenant_id = None
        self.term_unit = None
        self.is_auto_renew = None
        self.is_free_trial = None


class ScheduledOperationsType(_serialization.Model):
    """The list of scheduled operations.

    All required parameters must be populated in order to send to server.

    :ivar day_of_week: Day of week. Required.
    :vartype day_of_week: ~azure.mgmt.oracledatabase.models.DayOfWeek
    :ivar scheduled_start_time: auto start time. value must be of ISO-8601 format HH:mm.
    :vartype scheduled_start_time: str
    :ivar scheduled_stop_time: auto stop time. value must be of ISO-8601 format HH:mm.
    :vartype scheduled_stop_time: str
    """

    _validation = {
        "day_of_week": {"required": True},
        "scheduled_start_time": {"max_length": 50, "min_length": 1},
        "scheduled_stop_time": {"max_length": 50, "min_length": 1},
    }

    _attribute_map = {
        "day_of_week": {"key": "dayOfWeek", "type": "DayOfWeek"},
        "scheduled_start_time": {"key": "scheduledStartTime", "type": "str"},
        "scheduled_stop_time": {"key": "scheduledStopTime", "type": "str"},
    }

    def __init__(
        self,
        *,
        day_of_week: "_models.DayOfWeek",
        scheduled_start_time: Optional[str] = None,
        scheduled_stop_time: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword day_of_week: Day of week. Required.
        :paramtype day_of_week: ~azure.mgmt.oracledatabase.models.DayOfWeek
        :keyword scheduled_start_time: auto start time. value must be of ISO-8601 format HH:mm.
        :paramtype scheduled_start_time: str
        :keyword scheduled_stop_time: auto stop time. value must be of ISO-8601 format HH:mm.
        :paramtype scheduled_stop_time: str
        """
        super().__init__(**kwargs)
        self.day_of_week = day_of_week
        self.scheduled_start_time = scheduled_start_time
        self.scheduled_stop_time = scheduled_stop_time


class ScheduledOperationsTypeUpdate(_serialization.Model):
    """The list of scheduled operations.

    :ivar day_of_week: Day of week.
    :vartype day_of_week: ~azure.mgmt.oracledatabase.models.DayOfWeekUpdate
    :ivar scheduled_start_time: auto start time. value must be of ISO-8601 format HH:mm.
    :vartype scheduled_start_time: str
    :ivar scheduled_stop_time: auto stop time. value must be of ISO-8601 format HH:mm.
    :vartype scheduled_stop_time: str
    """

    _validation = {
        "scheduled_start_time": {"max_length": 50, "min_length": 1},
        "scheduled_stop_time": {"max_length": 50, "min_length": 1},
    }

    _attribute_map = {
        "day_of_week": {"key": "dayOfWeek", "type": "DayOfWeekUpdate"},
        "scheduled_start_time": {"key": "scheduledStartTime", "type": "str"},
        "scheduled_stop_time": {"key": "scheduledStopTime", "type": "str"},
    }

    def __init__(
        self,
        *,
        day_of_week: Optional["_models.DayOfWeekUpdate"] = None,
        scheduled_start_time: Optional[str] = None,
        scheduled_stop_time: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword day_of_week: Day of week.
        :paramtype day_of_week: ~azure.mgmt.oracledatabase.models.DayOfWeekUpdate
        :keyword scheduled_start_time: auto start time. value must be of ISO-8601 format HH:mm.
        :paramtype scheduled_start_time: str
        :keyword scheduled_stop_time: auto stop time. value must be of ISO-8601 format HH:mm.
        :paramtype scheduled_stop_time: str
        """
        super().__init__(**kwargs)
        self.day_of_week = day_of_week
        self.scheduled_start_time = scheduled_start_time
        self.scheduled_stop_time = scheduled_stop_time


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.oracledatabase.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.oracledatabase.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.oracledatabase.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.oracledatabase.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class SystemVersion(ProxyResource):
    """SystemVersion resource Definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.SystemVersionProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "SystemVersionProperties"},
    }

    def __init__(self, *, properties: Optional["_models.SystemVersionProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.oracledatabase.models.SystemVersionProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class SystemVersionListResult(_serialization.Model):
    """The response of a SystemVersion list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The SystemVersion items on this page. Required.
    :vartype value: list[~azure.mgmt.oracledatabase.models.SystemVersion]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SystemVersion]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.SystemVersion"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The SystemVersion items on this page. Required.
        :paramtype value: list[~azure.mgmt.oracledatabase.models.SystemVersion]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SystemVersionProperties(_serialization.Model):
    """System Version Resource model.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar system_version: A valid Oracle System Version. Required.
    :vartype system_version: str
    """

    _validation = {
        "system_version": {"required": True, "readonly": True},
    }

    _attribute_map = {
        "system_version": {"key": "systemVersion", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.system_version = None


class SystemVersionsFilter(_serialization.Model):
    """SystemVersions filter.

    All required parameters must be populated in order to send to server.

    :ivar gi_version: Grid Infrastructure version. Required.
    :vartype gi_version: str
    :ivar shape: Exadata shape. Required.
    :vartype shape: str
    :ivar is_latest_version: Check If we have to list only latest versions.
    :vartype is_latest_version: bool
    """

    _validation = {
        "gi_version": {"required": True},
        "shape": {"required": True},
    }

    _attribute_map = {
        "gi_version": {"key": "giVersion", "type": "str"},
        "shape": {"key": "shape", "type": "str"},
        "is_latest_version": {"key": "isLatestVersion", "type": "bool"},
    }

    def __init__(self, *, gi_version: str, shape: str, is_latest_version: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword gi_version: Grid Infrastructure version. Required.
        :paramtype gi_version: str
        :keyword shape: Exadata shape. Required.
        :paramtype shape: str
        :keyword is_latest_version: Check If we have to list only latest versions.
        :paramtype is_latest_version: bool
        """
        super().__init__(**kwargs)
        self.gi_version = gi_version
        self.shape = shape
        self.is_latest_version = is_latest_version


class ValidationError(_serialization.Model):
    """validation error.

    All required parameters must be populated in order to send to server.

    :ivar code: error code. Required.
    :vartype code: str
    :ivar message: error message. Required.
    :vartype message: str
    """

    _validation = {
        "code": {"required": True},
        "message": {"required": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: str, message: str, **kwargs: Any) -> None:
        """
        :keyword code: error code. Required.
        :paramtype code: str
        :keyword message: error message. Required.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class ValidationResult(_serialization.Model):
    """validation result.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar status: validation status. Required. Known values are: "Succeeded" and "Failed".
    :vartype status: str or ~azure.mgmt.oracledatabase.models.ValidationStatus
    :ivar error: validation error. Required.
    :vartype error: ~azure.mgmt.oracledatabase.models.ValidationError
    """

    _validation = {
        "status": {"required": True, "readonly": True},
        "error": {"required": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "error": {"key": "error", "type": "ValidationError"},
    }

    def __init__(self, *, error: "_models.ValidationError", **kwargs: Any) -> None:
        """
        :keyword error: validation error. Required.
        :paramtype error: ~azure.mgmt.oracledatabase.models.ValidationError
        """
        super().__init__(**kwargs)
        self.status = None
        self.error = error


class VirtualNetworkAddress(ProxyResource):
    """Virtual IP resource belonging to a vm cluster resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.VirtualNetworkAddressProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "VirtualNetworkAddressProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.VirtualNetworkAddressProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.oracledatabase.models.VirtualNetworkAddressProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class VirtualNetworkAddressListResult(_serialization.Model):
    """The response of a VirtualNetworkAddress list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The VirtualNetworkAddress items on this page. Required.
    :vartype value: list[~azure.mgmt.oracledatabase.models.VirtualNetworkAddress]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualNetworkAddress]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.VirtualNetworkAddress"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The VirtualNetworkAddress items on this page. Required.
        :paramtype value: list[~azure.mgmt.oracledatabase.models.VirtualNetworkAddress]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualNetworkAddressProperties(_serialization.Model):
    """virtualNetworkAddress resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar ip_address: Virtual network Address address.
    :vartype ip_address: str
    :ivar vm_ocid: Virtual Machine OCID.
    :vartype vm_ocid: str
    :ivar ocid: Application VIP OCID.
    :vartype ocid: str
    :ivar domain: Virtual network address fully qualified domain name.
    :vartype domain: str
    :ivar lifecycle_details: Additional information about the current lifecycle state of the
     application virtual IP (VIP) address.
    :vartype lifecycle_details: str
    :ivar provisioning_state: Azure resource provisioning state. Known values are: "Succeeded",
     "Failed", "Canceled", and "Provisioning".
    :vartype provisioning_state: str or
     ~azure.mgmt.oracledatabase.models.AzureResourceProvisioningState
    :ivar lifecycle_state: virtual network address lifecycle state. Known values are:
     "Provisioning", "Available", "Terminating", "Terminated", and "Failed".
    :vartype lifecycle_state: str or
     ~azure.mgmt.oracledatabase.models.VirtualNetworkAddressLifecycleState
    :ivar time_assigned: The date and time when the create operation for the application virtual IP
     (VIP) address completed.
    :vartype time_assigned: ~datetime.datetime
    """

    _validation = {
        "vm_ocid": {"max_length": 255, "min_length": 1},
        "ocid": {"readonly": True, "max_length": 255, "min_length": 1},
        "domain": {"readonly": True},
        "lifecycle_details": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "lifecycle_state": {"readonly": True},
        "time_assigned": {"readonly": True},
    }

    _attribute_map = {
        "ip_address": {"key": "ipAddress", "type": "str"},
        "vm_ocid": {"key": "vmOcid", "type": "str"},
        "ocid": {"key": "ocid", "type": "str"},
        "domain": {"key": "domain", "type": "str"},
        "lifecycle_details": {"key": "lifecycleDetails", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "lifecycle_state": {"key": "lifecycleState", "type": "str"},
        "time_assigned": {"key": "timeAssigned", "type": "iso-8601"},
    }

    def __init__(self, *, ip_address: Optional[str] = None, vm_ocid: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword ip_address: Virtual network Address address.
        :paramtype ip_address: str
        :keyword vm_ocid: Virtual Machine OCID.
        :paramtype vm_ocid: str
        """
        super().__init__(**kwargs)
        self.ip_address = ip_address
        self.vm_ocid = vm_ocid
        self.ocid = None
        self.domain = None
        self.lifecycle_details = None
        self.provisioning_state = None
        self.lifecycle_state = None
        self.time_assigned = None
