'''OpenGL extension IMG.framebuffer_downsample

This module customises the behaviour of the 
OpenGL.raw.GLES2.IMG.framebuffer_downsample to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension introduces the ability to attach color buffers to a
	framebuffer that are at a lower resolution than the framebuffer itself, with
	the GPU automatically downsampling the color attachment to fit.
	
	This can be useful for various post-process rendering techniques where it is
	desirable to generate downsampled images in an efficient manner, or for a
	lower resolution post-process technique.
	
	This extension exposes at least a 2 x 2 downscale. Other downsampling modes
	may be exposed on the system and this can be queried.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/IMG/framebuffer_downsample.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.IMG.framebuffer_downsample import *
from OpenGL.raw.GLES2.IMG.framebuffer_downsample import _EXTENSION_NAME

def glInitFramebufferDownsampleIMG():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION