/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * GTK+ widget for embedding a Pigment viewport
 *
 * Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Loïc Molinari <loic@fluendo.com>
 */

#ifndef __PGM_GTK_H__
#define __PGM_GTK_H__

#include <gtk/gtksocket.h>
#include <pgm/pgm.h>

G_BEGIN_DECLS

#define PGM_TYPE_GTK (pgm_gtk_get_type ())
#define PGM_GTK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PGM_TYPE_GTK, PgmGtk))
#define PGM_IS_GTK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PGM_TYPE_GTK))
#define PGM_GTK_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), PGM_TYPE_GTK, PgmGtkClass))
#define PGM_IS_GTK_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), PGM_TYPE_GTK))

typedef struct _PgmGtk      PgmGtk;
typedef struct _PgmGtkClass PgmGtkClass;

/**
 * PgmGtk:
 *
 * The opaque #PgmGtk data structure.
 */
struct _PgmGtk {
  /*< private >*/
  GtkSocket parent;

  PgmViewport *viewport;
  gulong       embedding_id;
};

struct _PgmGtkClass {
  GtkSocketClass parent_class;
};

GType      pgm_gtk_get_type     (void) G_GNUC_CONST;

GtkWidget *pgm_gtk_new          (void);

gboolean   pgm_gtk_set_viewport (PgmGtk *gtk,
                                 PgmViewport *viewport);

PgmError   pgm_gtk_get_viewport (PgmGtk *gtk,
                                 PgmViewport **viewport);

G_END_DECLS

#endif /* __PGM_GTK_H__ */
