%define name      libprinterconf
%define version   0.5
%define rel       1
%define prefix    /usr

Name: %{name}
Version: %{version}
Release: %{rel}
Summary: Printer configuration library
License: GPL
Group: System Environment/Libraries
BuildRoot: /tmp/%{name}-root

Source0: %{name}-%{version}.tar.gz

%package devel
Summary: Headers and additional files to develop programs using libprinterconf.
Group: Development/Libraries
Requires: %{name}

%package -n pconfdetect
Summary: Utility for autodetecting printers.
Group: Applications/System

%description
libprinterconf is a C library for autodetecting printers.

%description devel
This packae contains the header files and additional files needed to
develop programs using libprinterconf.

%description -n pconfdetect
pconf_detect is a command-line utility for autodetecting printers from
Linux.  It is a simple wrapper around libprinterconf's
pconf_detect_printer() function.  It currently supports two methods of
autodetection: parallel port detection and network detection.


%prep
%setup

%build
./configure --prefix=%{_prefix} \
            --exec-prefix=%{_exec_prefix} \
            --bindir=%{_bindir} \
            --sbindir=%{_sbindir} \
            --sysconfdir=%{_sysconfdir} \
            --datadir=%{_datadir} \
            --includedir=%{_includedir} \
            --libdir=%{_libdir} \
            --libexecdir=%{_libexecdir} \
            --localstatedir=%{_localstatedir} \
            --sharedstatedir=%{_sharedstatedir} \
            --mandir=%{_mandir} \
            --infodir=%{_infodir}
make

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT%{_prefix}
make DESTDIR="$RPM_BUILD_ROOT" install

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-, root, root)
%{_libdir}/*.so.*
%{_mandir}/man6/pconf_detect.6*
%{_sbindir}/pconf_detect

%files devel
%defattr(-, root, root)
%{_libdir}/lib*.so
%{_libdir}/*.a
%{_libdir}/*.la
%{_includedir}/printerconf.h
%{_includedir}/snmpinter.h
%{_mandir}/man3/pconf_detect_printer.3*
%{_mandir}/man3/pconf_get_detection_methods.3*
%{_mandir}/man3/pconf_autodetect_pport.3*
%{_mandir}/man3/libprinterconf.3*

%changelog
* Wed Nov 15 2000 Tom Dyas <tdyas@valinux.com>
- initial version
