#
# Copyright (C) 2020-2022 Intel Corporation
#
# SPDX-License-Identifier: MIT
#

SET_FLAGS_FOR("GEN8" "BDW")
SET_FLAGS_FOR("GEN9" "SKL" "KBL" "BXT" "GLK" "CFL")
SET_FLAGS_FOR("GEN11" "ICLLP" "LKF" "EHL")
SET_FLAGS_FOR("GEN12LP" "TGLLP" "RKL" "ADLS" "ADLP" "DG1")
SET_FLAGS_FOR("XE_HP_CORE" "XE_HP_SDV")
SET_FLAGS_FOR("XE_HPG_CORE" "DG2")
SET_FLAGS_FOR("XE_HPC_CORE" "PVC")

foreach(CORE_TYPE ${XEHP_AND_LATER_CORE_TYPES})
  if(TESTS_${CORE_TYPE})
    set(TESTS_XEHP_AND_LATER 1)
  endif()
  if(SUPPORT_${CORE_TYPE})
    set(SUPPORT_XEHP_AND_LATER 1)
  endif()
endforeach()

foreach(CORE_TYPE ${DG2_AND_LATER_CORE_TYPES})
  if(TESTS_${CORE_TYPE})
    set(TESTS_DG2_AND_LATER 1)
  endif()
  if(SUPPORT_${CORE_TYPE})
    set(SUPPORT_DG2_AND_LATER 1)
  endif()
endforeach()

foreach(CORE_TYPE ${PVC_AND_LATER_CORE_TYPES})
  if(TESTS_${CORE_TYPE})
    set(TESTS_PVC_AND_LATER 1)
  endif()
  if(SUPPORT_${CORE_TYPE})
    set(SUPPORT_PVC_AND_LATER 1)
  endif()
endforeach()

# Add supported and tested platforms
if(SUPPORT_GEN8)
  set(CORE_GEN8_REVISIONS 0)
  if(TESTS_GEN8)
    ADD_ITEM_FOR_CORE_TYPE("FAMILY_NAME" "TESTED" "GEN8" "BDWFamily")
  endif()
  if(SUPPORT_BDW)
    ADD_PRODUCT("SUPPORTED" "BDW" "IGFX_BROADWELL")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED" "GEN8" "BDW" "CORE")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_2_0" "GEN8" "BDW" "CORE")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_IMAGES" "GEN8" "BDW" "CORE")
    if(TESTS_BDW)
      ADD_ITEM_FOR_CORE_TYPE("PLATFORMS" "TESTED" "GEN8" "BDW")
      ADD_PRODUCT("TESTED" "BDW" "IGFX_BROADWELL")
    endif()
  endif()
endif()

if(SUPPORT_GEN9)
  set(CORE_GEN9_REVISIONS 9)
  set(LP_GEN9_REVISIONS 0)
  if(TESTS_GEN9)
    ADD_ITEM_FOR_CORE_TYPE("FAMILY_NAME" "TESTED" "GEN9" "SKLFamily")
  endif()
  if(SUPPORT_SKL)
    ADD_PRODUCT("SUPPORTED" "SKL" "IGFX_SKYLAKE")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED" "GEN9" "SKL" "CORE")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_2_0" "GEN9" "SKL" "CORE")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_VME" "GEN9" "SKL" "CORE")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_IMAGES" "GEN9" "SKL" "CORE")
    set(PREFERRED_PLATFORM "SKL")
    if(TESTS_SKL)
      set(PREFERRED_FAMILY_NAME "SKLFamily")
      ADD_ITEM_FOR_CORE_TYPE("PLATFORMS" "TESTED" "GEN9" "SKL")
      ADD_PRODUCT("TESTED" "SKL" "IGFX_SKYLAKE")
    endif()
  endif()

  if(SUPPORT_KBL)
    ADD_PRODUCT("SUPPORTED" "KBL" "IGFX_KABYLAKE")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED" "GEN9" "KBL" "CORE")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_2_0" "GEN9" "KBL" "CORE")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_VME" "GEN9" "KBL" "CORE")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_IMAGES" "GEN9" "KBL" "CORE")
    if(TESTS_KBL)
      ADD_ITEM_FOR_CORE_TYPE("PLATFORMS" "TESTED" "GEN9" "KBL")
      ADD_PRODUCT("TESTED" "KBL" "IGFX_KABYLAKE")
    endif()
  endif()

  if(SUPPORT_GLK)
    ADD_PRODUCT("SUPPORTED" "GLK" "IGFX_GEMINILAKE")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED" "GEN9" "GLK" "LP")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_VME" "GEN9" "GLK" "LP")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_IMAGES" "GEN9" "GLK" "LP")
    if(TESTS_GLK)
      ADD_ITEM_FOR_CORE_TYPE("PLATFORMS" "TESTED" "GEN9" "GLK")
      ADD_PRODUCT("TESTED" "GLK" "IGFX_GEMINILAKE")
    endif()
  endif()

  if(SUPPORT_CFL)
    ADD_PRODUCT("SUPPORTED" "CFL" "IGFX_COFFEELAKE")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED" "GEN9" "CFL" "CORE")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_2_0" "GEN9" "CFL" "CORE")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_VME" "GEN9" "CFL" "CORE")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_IMAGES" "GEN9" "CFL" "CORE")
    if(TESTS_CFL)
      ADD_ITEM_FOR_CORE_TYPE("PLATFORMS" "TESTED" "GEN9" "CFL")
      ADD_PRODUCT("TESTED" "CFL" "IGFX_COFFEELAKE")
    endif()
  endif()

  if(SUPPORT_BXT)
    ADD_PRODUCT("SUPPORTED" "BXT" "IGFX_BROXTON")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED" "GEN9" "BXT" "LP")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_VME" "GEN9" "BXT" "LP")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_IMAGES" "GEN9" "BXT" "LP")
    if(TESTS_BXT)
      ADD_ITEM_FOR_CORE_TYPE("PLATFORMS" "TESTED" "GEN9" "BXT")
      ADD_PRODUCT("TESTED" "BXT" "IGFX_BROXTON")
    endif()
  endif()
endif()

if(SUPPORT_GEN11)
  set(CORE_GEN11_REVISIONS 0)
  set(LP_GEN11_REVISIONS 0)
  if(TESTS_GEN11)
    ADD_ITEM_FOR_CORE_TYPE("FAMILY_NAME" "TESTED" "GEN11" "ICLFamily")
  endif()

  if(SUPPORT_ICLLP)
    ADD_PRODUCT("SUPPORTED" "ICLLP" "IGFX_ICELAKE_LP")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED" "GEN11" "ICLLP" "LP")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_2_0" "GEN11" "ICLLP" "LP")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_VME" "GEN11" "ICLLP" "LP")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_IMAGES" "GEN11" "ICLLP" "LP")
    if(TESTS_ICLLP)
      ADD_ITEM_FOR_CORE_TYPE("PLATFORMS" "TESTED" "GEN11" "ICLLP")
      ADD_PRODUCT("TESTED" "ICLLP" "IGFX_ICELAKE_LP")
    endif()
  endif()

  if(SUPPORT_LKF)
    ADD_PRODUCT("SUPPORTED" "LKF" "IGFX_LAKEFIELD")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED" "GEN11" "LKF" "LP")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_IMAGES" "GEN11" "LKF" "LP")
    if(TESTS_LKF)
      ADD_ITEM_FOR_CORE_TYPE("PLATFORMS" "TESTED" "GEN11" "LKF")
      ADD_PRODUCT("TESTED" "LKF" "IGFX_LAKEFIELD")
    endif()
  endif()

  if(SUPPORT_EHL)
    ADD_PRODUCT("SUPPORTED" "EHL" "IGFX_ELKHARTLAKE")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED" "GEN11" "EHL" "LP")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_IMAGES" "GEN11" "EHL" "LP")
    if(TESTS_EHL)
      ADD_ITEM_FOR_CORE_TYPE("PLATFORMS" "TESTED" "GEN11" "EHL")
      ADD_PRODUCT("TESTED" "EHL" "IGFX_ELKHARTLAKE")
    endif()
  endif()
endif()

if(SUPPORT_GEN12LP)
  set(LP_GEN12LP_REVISIONS 0)
  if(TESTS_GEN12LP)
    ADD_ITEM_FOR_CORE_TYPE("FAMILY_NAME" "TESTED" "GEN12LP" "TGLLPFamily")
  endif()
  if(SUPPORT_TGLLP)
    ADD_PRODUCT("SUPPORTED" "TGLLP" "IGFX_TIGERLAKE_LP")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED" "GEN12LP" "TGLLP" "LP")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_IMAGES" "GEN12LP" "TGLLP" "LP")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_AUX_TRANSLATION" "GEN12LP" "TGLLP" "LP")
    if(TESTS_TGLLP)
      ADD_ITEM_FOR_CORE_TYPE("PLATFORMS" "TESTED" "GEN12LP" "TGLLP")
      ADD_PRODUCT("TESTED" "TGLLP" "IGFX_TIGERLAKE_LP")
    endif()
  endif()

  if(SUPPORT_DG1)
    ADD_PRODUCT("SUPPORTED" "DG1" "IGFX_DG1")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED" "GEN12LP" "DG1" "LP")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_IMAGES" "GEN12LP" "DG1" "LP")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_AUX_TRANSLATION" "GEN12LP" "DG1" "LP")
    if(TESTS_DG1)
      ADD_ITEM_FOR_CORE_TYPE("PLATFORMS" "TESTED" "GEN12LP" "DG1")
      ADD_PRODUCT("TESTED" "DG1" "IGFX_DG1")
    endif()
  endif()

  if(SUPPORT_RKL)
    ADD_PRODUCT("SUPPORTED" "RKL" "IGFX_ROCKETLAKE")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED" "GEN12LP" "RKL" "LP")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_IMAGES" "GEN12LP" "RKL" "LP")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_AUX_TRANSLATION" "GEN12LP" "RKL" "LP")
    if(TESTS_RKL)
      ADD_ITEM_FOR_CORE_TYPE("PLATFORMS" "TESTED" "GEN12LP" "RKL")
      ADD_PRODUCT("TESTED" "RKL" "IGFX_ROCKETLAKE")
    endif()
  endif()

  if(SUPPORT_ADLS)
    ADD_PRODUCT("SUPPORTED" "ADLS" "IGFX_ALDERLAKE_S")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED" "GEN12LP" "ADLS" "LP")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_IMAGES" "GEN12LP" "ADLS" "LP")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_AUX_TRANSLATION" "GEN12LP" "ADLS" "LP")
    if(TESTS_ADLS)
      ADD_ITEM_FOR_CORE_TYPE("PLATFORMS" "TESTED" "GEN12LP" "ADLS")
      ADD_PRODUCT("TESTED" "ADLS" "IGFX_ALDERLAKE_S")
    endif()
  endif()

  if(SUPPORT_ADLP)
    ADD_PRODUCT("SUPPORTED" "ADLP" "IGFX_ALDERLAKE_P")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED" "GEN12LP" "ADLP" "LP")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_IMAGES" "GEN12LP" "ADLP" "LP")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_AUX_TRANSLATION" "GEN12LP" "ADLP" "LP")
    if(TESTS_ADLP)
      ADD_ITEM_FOR_CORE_TYPE("PLATFORMS" "TESTED" "GEN12LP" "ADLP")
      ADD_PRODUCT("TESTED" "ADLP" "IGFX_ALDERLAKE_P")
    endif()
  endif()
endif()

if(SUPPORT_XE_HP_CORE)
  SET_FLAGS_FOR("XE_HP_CORE")
  set(CORE_XE_HP_CORE_REVISIONS 4)
  if(TESTS_XE_HP_CORE)
    if(TESTS_XE_HP_SDV)
      ADD_ITEM_FOR_CORE_TYPE("FAMILY_NAME" "TESTED" "XE_HP_CORE" "XeHpFamily")
    else()
      set(TESTS_XE_HP_CORE FALSE)
    endif()
  endif()
  if(SUPPORT_XE_HP_SDV)
    ADD_PRODUCT("SUPPORTED" "XE_HP_SDV" "IGFX_XE_HP_SDV")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED" "XE_HP_CORE" "XE_HP_SDV" "CORE")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_IMAGES" "XE_HP_CORE" "XE_HP_SDV" "CORE")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_AUX_TRANSLATION" "XE_HP_CORE" "XE_HP_SDV" "CORE")
    set(PREFERRED_PLATFORM "XE_HP_SDV")
    if(TESTS_XE_HP_SDV)
      set(PREFERRED_FAMILY_NAME "XeHpFamily")
      ADD_ITEM_FOR_CORE_TYPE("PLATFORMS" "TESTED" "XE_HP_CORE" "XE_HP_SDV")
      ADD_PRODUCT("TESTED" "XE_HP_SDV" "IGFX_XE_HP_SDV")
    endif()
  endif()
endif()

if(SUPPORT_XE_HPG_CORE)
  set(CORE_XE_HPG_CORE_REVISIONS 0)
  if(TESTS_XE_HPG_CORE)
    ADD_ITEM_FOR_CORE_TYPE("FAMILY_NAME" "TESTED" "XE_HPG_CORE" "XE_HPG_COREFamily")
  endif()
  if(SUPPORT_DG2)
    set(DG2_XE_HPG_CORE_REVISIONS 0)
    ADD_PRODUCT("SUPPORTED" "DG2" "IGFX_DG2")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED" "XE_HPG_CORE" "DG2" "DG2")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_AUX_TRANSLATION" "XE_HPG_CORE" "DG2" "DG2")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_IMAGES" "XE_HPG_CORE" "DG2" "DG2")
    if(TESTS_DG2)
      ADD_ITEM_FOR_CORE_TYPE("PLATFORMS" "TESTED" "XE_HPG_CORE" "DG2")
      ADD_PRODUCT("TESTED" "DG2" "IGFX_DG2")
    endif()
  endif()
endif()

if(SUPPORT_XE_HPC_CORE)
  set(XE_HPC_CORE_TEST_KERNELS_BLOCKLIST "CopyBuffer_simd8.cl")
  set(CORE_XE_HPC_CORE_REVISIONS 0 3 30 157)
  if(TESTS_XE_HPC_CORE)
    ADD_ITEM_FOR_CORE_TYPE("FAMILY_NAME" "TESTED" "XE_HPC_CORE" "XE_HPC_COREFamily")
  endif()

  if(SUPPORT_PVC)
    ADD_PRODUCT("SUPPORTED" "PVC" "IGFX_PVC")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED" "XE_HPC_CORE" "PVC" "CORE")
    ADD_PLATFORM_FOR_CORE_TYPE("SUPPORTED_AUX_TRANSLATION" "XE_HPC_CORE" "PVC" "CORE")
    if(TESTS_PVC)
      ADD_ITEM_FOR_CORE_TYPE("PLATFORMS" "TESTED" "XE_HPC_CORE" "PVC")
      ADD_PRODUCT("TESTED" "PVC" "IGFX_PVC")
    endif()
  endif()
endif()
