goawk(1)

# NAME

goawk - POSIX-compliant AWK interpreter with CSV support

# SYNOPSIS

*goawk* [*-F* _fs_] [*-v* _var_=_value_] [*-f* _progfile_ | _'prog'_] [_file_ ...]

# DESCRIPTION

*goawk* is a POSIX-compliant AWK interpreter written in Go. Additionally, it has
some features not provided by POSIX AWK:

- Code coverage.
- Proper CSV and TSV support.
- Negative field indexes to access fields from the right.
- Single-quoted strings.

# OPTIONS

Standard AWK arguments:

*--csv*
	Enable CSV input mode. Equivalent to *-i* _csv_.

*-F* _fs_
	Use _fs_ for the input field separator.

*-F* _progfile_
	Read the AWK program source from _progfile_. Multiple *-f* options may be
	used.

*-v* _var_=_val_
	Assign the value _val_ to the variable _var_ before the execution of the
	program begins.

Additional GoAWK features:

*-E* _progfile_
	Load program from _progfile_, disable _var_=_val_ arguments, stop processing
	arguments, parse header row and enable @"field" in CSV input mode.

*-H*
	Parse header row and enable @"field" in CSV input mode.

*-h*,*--help*
	Show the help message and exit.

*-i* _mode_
	Parse input into fields using CSV format, ignoring _FS_ and _RS_.

*-o* _mode_
	Use CSV output, ignoring _OFS_ and _ORS_.

*-version*
	Show GoAWK version and exit.

GoAWK debugging arguments:

*-coverappend*
	Append to coverage file instead of overwriting.

*-covermode* _mode_
	Set coverage mode, where _mode_ is _set_ or _count_ (default: _set_).

*-coverprofile* _file_
	Write coverage profile to _file_.

*-cpuprofile* _file_
	Write cpu profile to _file_.

*-d*
	Print parsed syntax tree to stdout and exit.

*-da*
	Print VM assembly instructions to stdout and exit.

*-dt*
	Print variable type information to stdout and exit.

*-memprofile* _file_
	Write memory profile to _file_.

# SEE ALSO

*gawk*(1), *mawk*(1)
