//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Numeric/SafeSpinBox.cpp
//! @brief     Implements class SafeSpinBox.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "SafeSpinBox.h"
#include <QWheelEvent>

SafeSpinBox::SafeSpinBox(bool easyScrollable, QWidget* parent)
    : QSpinBox{parent}
    , m_easy_scrollable(easyScrollable)
{
    setFocusPolicy(Qt::StrongFocus);
}

void SafeSpinBox::wheelEvent(QWheelEvent* event)
{
    if (hasFocus() || m_easy_scrollable)
        QSpinBox::wheelEvent(event);
    else
        event->ignore();
}
