#
# Copyright (c) 2017, Alliance for Open Media. All rights reserved.
#
# This source code is subject to the terms of the BSD 2 Clause License and the
# Alliance for Open Media Patent License 1.0. If the BSD 2 Clause License was
# not distributed with this source code in the LICENSE file, you can obtain it
# at www.aomedia.org/license/software. If the Alliance for Open Media Patent
# License 1.0 was not distributed with this source code in the PATENTS file, you
# can obtain it at www.aomedia.org/license/patent.
#

list(APPEND AOM_TEST_DATA_FILE_NAMES
            "desktopqvga2.320_240.yuv"
            "desktop1.320_180.yuv"
            "hantro_collage_w176h144.yuv"
            "hantro_collage_w352h288.yuv"
            "hantro_collage_w352h288_nv12.yuv"
            "hantro_odd.yuv"
            "paris_352_288_30.y4m"
            "park_joy_90p_10_420.y4m"
            "park_joy_90p_10_422.y4m"
            "park_joy_90p_10_444.y4m"
            "park_joy_90p_12_420.y4m"
            "park_joy_90p_12_422.y4m"
            "park_joy_90p_12_444.y4m"
            "park_joy_90p_8_420_a10-1.y4m"
            "park_joy_90p_8_420.y4m"
            "park_joy_90p_8_420_monochrome.y4m"
            "park_joy_90p_8_420_vertical_csp.y4m"
            "park_joy_90p_8_422.y4m"
            "park_joy_90p_8_444.y4m"
            "pixel_capture_w320h240.yuv"
            "desktop_credits.y4m"
            "rand_noise_w1280h720.yuv"
            "niklas_1280_720_30.y4m"
            "rush_hour_444.y4m"
            "screendata.y4m"
            "screendata.1920_1080.y4m"
            "niklas_640_480_30.yuv"
            "vase10x10.yuv"
            "vase10x10_tiles.txt"
            "bus_352x288_420_f20_b8.yuv"
            "test_input_w1h1.yuv"
            "crowd_run_360p_10_150f.y4m"
            "wikipedia_420_360p_60f.y4m")

if(ENABLE_DECODE_PERF_TESTS AND CONFIG_AV1_ENCODER)
  list(APPEND AOM_TEST_DATA_FILE_NAMES "niklas_1280_720_30.yuv")
endif()

if(CONFIG_AV1_DECODER)
  list(APPEND AOM_TEST_DATA_FILE_NAMES
              "av1-1-b8-00-quantizer-00.ivf"
              "av1-1-b8-00-quantizer-00.ivf.md5"
              "av1-1-b8-00-quantizer-01.ivf"
              "av1-1-b8-00-quantizer-01.ivf.md5"
              "av1-1-b8-00-quantizer-02.ivf"
              "av1-1-b8-00-quantizer-02.ivf.md5"
              "av1-1-b8-00-quantizer-03.ivf"
              "av1-1-b8-00-quantizer-03.ivf.md5"
              "av1-1-b8-00-quantizer-04.ivf"
              "av1-1-b8-00-quantizer-04.ivf.md5"
              "av1-1-b8-00-quantizer-05.ivf"
              "av1-1-b8-00-quantizer-05.ivf.md5"
              "av1-1-b8-00-quantizer-06.ivf"
              "av1-1-b8-00-quantizer-06.ivf.md5"
              "av1-1-b8-00-quantizer-07.ivf"
              "av1-1-b8-00-quantizer-07.ivf.md5"
              "av1-1-b8-00-quantizer-08.ivf"
              "av1-1-b8-00-quantizer-08.ivf.md5"
              "av1-1-b8-00-quantizer-09.ivf"
              "av1-1-b8-00-quantizer-09.ivf.md5"
              "av1-1-b8-00-quantizer-10.ivf"
              "av1-1-b8-00-quantizer-10.ivf.md5"
              "av1-1-b8-00-quantizer-11.ivf"
              "av1-1-b8-00-quantizer-11.ivf.md5"
              "av1-1-b8-00-quantizer-12.ivf"
              "av1-1-b8-00-quantizer-12.ivf.md5"
              "av1-1-b8-00-quantizer-13.ivf"
              "av1-1-b8-00-quantizer-13.ivf.md5"
              "av1-1-b8-00-quantizer-14.ivf"
              "av1-1-b8-00-quantizer-14.ivf.md5"
              "av1-1-b8-00-quantizer-15.ivf"
              "av1-1-b8-00-quantizer-15.ivf.md5"
              "av1-1-b8-00-quantizer-16.ivf"
              "av1-1-b8-00-quantizer-16.ivf.md5"
              "av1-1-b8-00-quantizer-17.ivf"
              "av1-1-b8-00-quantizer-17.ivf.md5"
              "av1-1-b8-00-quantizer-18.ivf"
              "av1-1-b8-00-quantizer-18.ivf.md5"
              "av1-1-b8-00-quantizer-19.ivf"
              "av1-1-b8-00-quantizer-19.ivf.md5"
              "av1-1-b8-00-quantizer-20.ivf"
              "av1-1-b8-00-quantizer-20.ivf.md5"
              "av1-1-b8-00-quantizer-21.ivf"
              "av1-1-b8-00-quantizer-21.ivf.md5"
              "av1-1-b8-00-quantizer-22.ivf"
              "av1-1-b8-00-quantizer-22.ivf.md5"
              "av1-1-b8-00-quantizer-23.ivf"
              "av1-1-b8-00-quantizer-23.ivf.md5"
              "av1-1-b8-00-quantizer-24.ivf"
              "av1-1-b8-00-quantizer-24.ivf.md5"
              "av1-1-b8-00-quantizer-25.ivf"
              "av1-1-b8-00-quantizer-25.ivf.md5"
              "av1-1-b8-00-quantizer-26.ivf"
              "av1-1-b8-00-quantizer-26.ivf.md5"
              "av1-1-b8-00-quantizer-27.ivf"
              "av1-1-b8-00-quantizer-27.ivf.md5"
              "av1-1-b8-00-quantizer-28.ivf"
              "av1-1-b8-00-quantizer-28.ivf.md5"
              "av1-1-b8-00-quantizer-29.ivf"
              "av1-1-b8-00-quantizer-29.ivf.md5"
              "av1-1-b8-00-quantizer-30.ivf"
              "av1-1-b8-00-quantizer-30.ivf.md5"
              "av1-1-b8-00-quantizer-31.ivf"
              "av1-1-b8-00-quantizer-31.ivf.md5"
              "av1-1-b8-00-quantizer-32.ivf"
              "av1-1-b8-00-quantizer-32.ivf.md5"
              "av1-1-b8-00-quantizer-33.ivf"
              "av1-1-b8-00-quantizer-33.ivf.md5"
              "av1-1-b8-00-quantizer-34.ivf"
              "av1-1-b8-00-quantizer-34.ivf.md5"
              "av1-1-b8-00-quantizer-35.ivf"
              "av1-1-b8-00-quantizer-35.ivf.md5"
              "av1-1-b8-00-quantizer-36.ivf"
              "av1-1-b8-00-quantizer-36.ivf.md5"
              "av1-1-b8-00-quantizer-37.ivf"
              "av1-1-b8-00-quantizer-37.ivf.md5"
              "av1-1-b8-00-quantizer-38.ivf"
              "av1-1-b8-00-quantizer-38.ivf.md5"
              "av1-1-b8-00-quantizer-39.ivf"
              "av1-1-b8-00-quantizer-39.ivf.md5"
              "av1-1-b8-00-quantizer-40.ivf"
              "av1-1-b8-00-quantizer-40.ivf.md5"
              "av1-1-b8-00-quantizer-41.ivf"
              "av1-1-b8-00-quantizer-41.ivf.md5"
              "av1-1-b8-00-quantizer-42.ivf"
              "av1-1-b8-00-quantizer-42.ivf.md5"
              "av1-1-b8-00-quantizer-43.ivf"
              "av1-1-b8-00-quantizer-43.ivf.md5"
              "av1-1-b8-00-quantizer-44.ivf"
              "av1-1-b8-00-quantizer-44.ivf.md5"
              "av1-1-b8-00-quantizer-45.ivf"
              "av1-1-b8-00-quantizer-45.ivf.md5"
              "av1-1-b8-00-quantizer-46.ivf"
              "av1-1-b8-00-quantizer-46.ivf.md5"
              "av1-1-b8-00-quantizer-47.ivf"
              "av1-1-b8-00-quantizer-47.ivf.md5"
              "av1-1-b8-00-quantizer-48.ivf"
              "av1-1-b8-00-quantizer-48.ivf.md5"
              "av1-1-b8-00-quantizer-49.ivf"
              "av1-1-b8-00-quantizer-49.ivf.md5"
              "av1-1-b8-00-quantizer-50.ivf"
              "av1-1-b8-00-quantizer-50.ivf.md5"
              "av1-1-b8-00-quantizer-51.ivf"
              "av1-1-b8-00-quantizer-51.ivf.md5"
              "av1-1-b8-00-quantizer-52.ivf"
              "av1-1-b8-00-quantizer-52.ivf.md5"
              "av1-1-b8-00-quantizer-53.ivf"
              "av1-1-b8-00-quantizer-53.ivf.md5"
              "av1-1-b8-00-quantizer-54.ivf"
              "av1-1-b8-00-quantizer-54.ivf.md5"
              "av1-1-b8-00-quantizer-55.ivf"
              "av1-1-b8-00-quantizer-55.ivf.md5"
              "av1-1-b8-00-quantizer-56.ivf"
              "av1-1-b8-00-quantizer-56.ivf.md5"
              "av1-1-b8-00-quantizer-57.ivf"
              "av1-1-b8-00-quantizer-57.ivf.md5"
              "av1-1-b8-00-quantizer-58.ivf"
              "av1-1-b8-00-quantizer-58.ivf.md5"
              "av1-1-b8-00-quantizer-59.ivf"
              "av1-1-b8-00-quantizer-59.ivf.md5"
              "av1-1-b8-00-quantizer-60.ivf"
              "av1-1-b8-00-quantizer-60.ivf.md5"
              "av1-1-b8-00-quantizer-61.ivf"
              "av1-1-b8-00-quantizer-61.ivf.md5"
              "av1-1-b8-00-quantizer-62.ivf"
              "av1-1-b8-00-quantizer-62.ivf.md5"
              "av1-1-b8-00-quantizer-63.ivf"
              "av1-1-b8-00-quantizer-63.ivf.md5"
              "av1-1-b10-00-quantizer-00.ivf"
              "av1-1-b10-00-quantizer-00.ivf.md5"
              "av1-1-b10-00-quantizer-01.ivf"
              "av1-1-b10-00-quantizer-01.ivf.md5"
              "av1-1-b10-00-quantizer-02.ivf"
              "av1-1-b10-00-quantizer-02.ivf.md5"
              "av1-1-b10-00-quantizer-03.ivf"
              "av1-1-b10-00-quantizer-03.ivf.md5"
              "av1-1-b10-00-quantizer-04.ivf"
              "av1-1-b10-00-quantizer-04.ivf.md5"
              "av1-1-b10-00-quantizer-05.ivf"
              "av1-1-b10-00-quantizer-05.ivf.md5"
              "av1-1-b10-00-quantizer-06.ivf"
              "av1-1-b10-00-quantizer-06.ivf.md5"
              "av1-1-b10-00-quantizer-07.ivf"
              "av1-1-b10-00-quantizer-07.ivf.md5"
              "av1-1-b10-00-quantizer-08.ivf"
              "av1-1-b10-00-quantizer-08.ivf.md5"
              "av1-1-b10-00-quantizer-09.ivf"
              "av1-1-b10-00-quantizer-09.ivf.md5"
              "av1-1-b10-00-quantizer-10.ivf"
              "av1-1-b10-00-quantizer-10.ivf.md5"
              "av1-1-b10-00-quantizer-11.ivf"
              "av1-1-b10-00-quantizer-11.ivf.md5"
              "av1-1-b10-00-quantizer-12.ivf"
              "av1-1-b10-00-quantizer-12.ivf.md5"
              "av1-1-b10-00-quantizer-13.ivf"
              "av1-1-b10-00-quantizer-13.ivf.md5"
              "av1-1-b10-00-quantizer-14.ivf"
              "av1-1-b10-00-quantizer-14.ivf.md5"
              "av1-1-b10-00-quantizer-15.ivf"
              "av1-1-b10-00-quantizer-15.ivf.md5"
              "av1-1-b10-00-quantizer-16.ivf"
              "av1-1-b10-00-quantizer-16.ivf.md5"
              "av1-1-b10-00-quantizer-17.ivf"
              "av1-1-b10-00-quantizer-17.ivf.md5"
              "av1-1-b10-00-quantizer-18.ivf"
              "av1-1-b10-00-quantizer-18.ivf.md5"
              "av1-1-b10-00-quantizer-19.ivf"
              "av1-1-b10-00-quantizer-19.ivf.md5"
              "av1-1-b10-00-quantizer-20.ivf"
              "av1-1-b10-00-quantizer-20.ivf.md5"
              "av1-1-b10-00-quantizer-21.ivf"
              "av1-1-b10-00-quantizer-21.ivf.md5"
              "av1-1-b10-00-quantizer-22.ivf"
              "av1-1-b10-00-quantizer-22.ivf.md5"
              "av1-1-b10-00-quantizer-23.ivf"
              "av1-1-b10-00-quantizer-23.ivf.md5"
              "av1-1-b10-00-quantizer-24.ivf"
              "av1-1-b10-00-quantizer-24.ivf.md5"
              "av1-1-b10-00-quantizer-25.ivf"
              "av1-1-b10-00-quantizer-25.ivf.md5"
              "av1-1-b10-00-quantizer-26.ivf"
              "av1-1-b10-00-quantizer-26.ivf.md5"
              "av1-1-b10-00-quantizer-27.ivf"
              "av1-1-b10-00-quantizer-27.ivf.md5"
              "av1-1-b10-00-quantizer-28.ivf"
              "av1-1-b10-00-quantizer-28.ivf.md5"
              "av1-1-b10-00-quantizer-29.ivf"
              "av1-1-b10-00-quantizer-29.ivf.md5"
              "av1-1-b10-00-quantizer-30.ivf"
              "av1-1-b10-00-quantizer-30.ivf.md5"
              "av1-1-b10-00-quantizer-31.ivf"
              "av1-1-b10-00-quantizer-31.ivf.md5"
              "av1-1-b10-00-quantizer-32.ivf"
              "av1-1-b10-00-quantizer-32.ivf.md5"
              "av1-1-b10-00-quantizer-33.ivf"
              "av1-1-b10-00-quantizer-33.ivf.md5"
              "av1-1-b10-00-quantizer-34.ivf"
              "av1-1-b10-00-quantizer-34.ivf.md5"
              "av1-1-b10-00-quantizer-35.ivf"
              "av1-1-b10-00-quantizer-35.ivf.md5"
              "av1-1-b10-00-quantizer-36.ivf"
              "av1-1-b10-00-quantizer-36.ivf.md5"
              "av1-1-b10-00-quantizer-37.ivf"
              "av1-1-b10-00-quantizer-37.ivf.md5"
              "av1-1-b10-00-quantizer-38.ivf"
              "av1-1-b10-00-quantizer-38.ivf.md5"
              "av1-1-b10-00-quantizer-39.ivf"
              "av1-1-b10-00-quantizer-39.ivf.md5"
              "av1-1-b10-00-quantizer-40.ivf"
              "av1-1-b10-00-quantizer-40.ivf.md5"
              "av1-1-b10-00-quantizer-41.ivf"
              "av1-1-b10-00-quantizer-41.ivf.md5"
              "av1-1-b10-00-quantizer-42.ivf"
              "av1-1-b10-00-quantizer-42.ivf.md5"
              "av1-1-b10-00-quantizer-43.ivf"
              "av1-1-b10-00-quantizer-43.ivf.md5"
              "av1-1-b10-00-quantizer-44.ivf"
              "av1-1-b10-00-quantizer-44.ivf.md5"
              "av1-1-b10-00-quantizer-45.ivf"
              "av1-1-b10-00-quantizer-45.ivf.md5"
              "av1-1-b10-00-quantizer-46.ivf"
              "av1-1-b10-00-quantizer-46.ivf.md5"
              "av1-1-b10-00-quantizer-47.ivf"
              "av1-1-b10-00-quantizer-47.ivf.md5"
              "av1-1-b10-00-quantizer-48.ivf"
              "av1-1-b10-00-quantizer-48.ivf.md5"
              "av1-1-b10-00-quantizer-49.ivf"
              "av1-1-b10-00-quantizer-49.ivf.md5"
              "av1-1-b10-00-quantizer-50.ivf"
              "av1-1-b10-00-quantizer-50.ivf.md5"
              "av1-1-b10-00-quantizer-51.ivf"
              "av1-1-b10-00-quantizer-51.ivf.md5"
              "av1-1-b10-00-quantizer-52.ivf"
              "av1-1-b10-00-quantizer-52.ivf.md5"
              "av1-1-b10-00-quantizer-53.ivf"
              "av1-1-b10-00-quantizer-53.ivf.md5"
              "av1-1-b10-00-quantizer-54.ivf"
              "av1-1-b10-00-quantizer-54.ivf.md5"
              "av1-1-b10-00-quantizer-55.ivf"
              "av1-1-b10-00-quantizer-55.ivf.md5"
              "av1-1-b10-00-quantizer-56.ivf"
              "av1-1-b10-00-quantizer-56.ivf.md5"
              "av1-1-b10-00-quantizer-57.ivf"
              "av1-1-b10-00-quantizer-57.ivf.md5"
              "av1-1-b10-00-quantizer-58.ivf"
              "av1-1-b10-00-quantizer-58.ivf.md5"
              "av1-1-b10-00-quantizer-59.ivf"
              "av1-1-b10-00-quantizer-59.ivf.md5"
              "av1-1-b10-00-quantizer-60.ivf"
              "av1-1-b10-00-quantizer-60.ivf.md5"
              "av1-1-b10-00-quantizer-61.ivf"
              "av1-1-b10-00-quantizer-61.ivf.md5"
              "av1-1-b10-00-quantizer-62.ivf"
              "av1-1-b10-00-quantizer-62.ivf.md5"
              "av1-1-b10-00-quantizer-63.ivf"
              "av1-1-b10-00-quantizer-63.ivf.md5"
              "av1-1-b10-23-film_grain-50.ivf"
              "av1-1-b10-23-film_grain-50.ivf.md5"
              "av1-1-b10-24-monochrome.ivf"
              "av1-1-b10-24-monochrome.ivf.md5"
              "av1-1-b8-01-size-16x16.ivf"
              "av1-1-b8-01-size-16x16.ivf.md5"
              "av1-1-b8-01-size-16x18.ivf"
              "av1-1-b8-01-size-16x18.ivf.md5"
              "av1-1-b8-01-size-16x32.ivf"
              "av1-1-b8-01-size-16x32.ivf.md5"
              "av1-1-b8-01-size-16x34.ivf"
              "av1-1-b8-01-size-16x34.ivf.md5"
              "av1-1-b8-01-size-16x64.ivf"
              "av1-1-b8-01-size-16x64.ivf.md5"
              "av1-1-b8-01-size-16x66.ivf"
              "av1-1-b8-01-size-16x66.ivf.md5"
              "av1-1-b8-01-size-18x16.ivf"
              "av1-1-b8-01-size-18x16.ivf.md5"
              "av1-1-b8-01-size-18x18.ivf"
              "av1-1-b8-01-size-18x18.ivf.md5"
              "av1-1-b8-01-size-18x32.ivf"
              "av1-1-b8-01-size-18x32.ivf.md5"
              "av1-1-b8-01-size-18x34.ivf"
              "av1-1-b8-01-size-18x34.ivf.md5"
              "av1-1-b8-01-size-18x64.ivf"
              "av1-1-b8-01-size-18x64.ivf.md5"
              "av1-1-b8-01-size-18x66.ivf"
              "av1-1-b8-01-size-18x66.ivf.md5"
              "av1-1-b8-01-size-196x196.ivf"
              "av1-1-b8-01-size-196x196.ivf.md5"
              "av1-1-b8-01-size-196x198.ivf"
              "av1-1-b8-01-size-196x198.ivf.md5"
              "av1-1-b8-01-size-196x200.ivf"
              "av1-1-b8-01-size-196x200.ivf.md5"
              "av1-1-b8-01-size-196x202.ivf"
              "av1-1-b8-01-size-196x202.ivf.md5"
              "av1-1-b8-01-size-196x208.ivf"
              "av1-1-b8-01-size-196x208.ivf.md5"
              "av1-1-b8-01-size-196x210.ivf"
              "av1-1-b8-01-size-196x210.ivf.md5"
              "av1-1-b8-01-size-196x224.ivf"
              "av1-1-b8-01-size-196x224.ivf.md5"
              "av1-1-b8-01-size-196x226.ivf"
              "av1-1-b8-01-size-196x226.ivf.md5"
              "av1-1-b8-01-size-198x196.ivf"
              "av1-1-b8-01-size-198x196.ivf.md5"
              "av1-1-b8-01-size-198x198.ivf"
              "av1-1-b8-01-size-198x198.ivf.md5"
              "av1-1-b8-01-size-198x200.ivf"
              "av1-1-b8-01-size-198x200.ivf.md5"
              "av1-1-b8-01-size-198x202.ivf"
              "av1-1-b8-01-size-198x202.ivf.md5"
              "av1-1-b8-01-size-198x208.ivf"
              "av1-1-b8-01-size-198x208.ivf.md5"
              "av1-1-b8-01-size-198x210.ivf"
              "av1-1-b8-01-size-198x210.ivf.md5"
              "av1-1-b8-01-size-198x224.ivf"
              "av1-1-b8-01-size-198x224.ivf.md5"
              "av1-1-b8-01-size-198x226.ivf"
              "av1-1-b8-01-size-198x226.ivf.md5"
              "av1-1-b8-01-size-200x196.ivf"
              "av1-1-b8-01-size-200x196.ivf.md5"
              "av1-1-b8-01-size-200x198.ivf"
              "av1-1-b8-01-size-200x198.ivf.md5"
              "av1-1-b8-01-size-200x200.ivf"
              "av1-1-b8-01-size-200x200.ivf.md5"
              "av1-1-b8-01-size-200x202.ivf"
              "av1-1-b8-01-size-200x202.ivf.md5"
              "av1-1-b8-01-size-200x208.ivf"
              "av1-1-b8-01-size-200x208.ivf.md5"
              "av1-1-b8-01-size-200x210.ivf"
              "av1-1-b8-01-size-200x210.ivf.md5"
              "av1-1-b8-01-size-200x224.ivf"
              "av1-1-b8-01-size-200x224.ivf.md5"
              "av1-1-b8-01-size-200x226.ivf"
              "av1-1-b8-01-size-200x226.ivf.md5"
              "av1-1-b8-01-size-202x196.ivf"
              "av1-1-b8-01-size-202x196.ivf.md5"
              "av1-1-b8-01-size-202x198.ivf"
              "av1-1-b8-01-size-202x198.ivf.md5"
              "av1-1-b8-01-size-202x200.ivf"
              "av1-1-b8-01-size-202x200.ivf.md5"
              "av1-1-b8-01-size-202x202.ivf"
              "av1-1-b8-01-size-202x202.ivf.md5"
              "av1-1-b8-01-size-202x208.ivf"
              "av1-1-b8-01-size-202x208.ivf.md5"
              "av1-1-b8-01-size-202x210.ivf"
              "av1-1-b8-01-size-202x210.ivf.md5"
              "av1-1-b8-01-size-202x224.ivf"
              "av1-1-b8-01-size-202x224.ivf.md5"
              "av1-1-b8-01-size-202x226.ivf"
              "av1-1-b8-01-size-202x226.ivf.md5"
              "av1-1-b8-01-size-208x196.ivf"
              "av1-1-b8-01-size-208x196.ivf.md5"
              "av1-1-b8-01-size-208x198.ivf"
              "av1-1-b8-01-size-208x198.ivf.md5"
              "av1-1-b8-01-size-208x200.ivf"
              "av1-1-b8-01-size-208x200.ivf.md5"
              "av1-1-b8-01-size-208x202.ivf"
              "av1-1-b8-01-size-208x202.ivf.md5"
              "av1-1-b8-01-size-208x208.ivf"
              "av1-1-b8-01-size-208x208.ivf.md5"
              "av1-1-b8-01-size-208x210.ivf"
              "av1-1-b8-01-size-208x210.ivf.md5"
              "av1-1-b8-01-size-208x224.ivf"
              "av1-1-b8-01-size-208x224.ivf.md5"
              "av1-1-b8-01-size-208x226.ivf"
              "av1-1-b8-01-size-208x226.ivf.md5"
              "av1-1-b8-01-size-210x196.ivf"
              "av1-1-b8-01-size-210x196.ivf.md5"
              "av1-1-b8-01-size-210x198.ivf"
              "av1-1-b8-01-size-210x198.ivf.md5"
              "av1-1-b8-01-size-210x200.ivf"
              "av1-1-b8-01-size-210x200.ivf.md5"
              "av1-1-b8-01-size-210x202.ivf"
              "av1-1-b8-01-size-210x202.ivf.md5"
              "av1-1-b8-01-size-210x208.ivf"
              "av1-1-b8-01-size-210x208.ivf.md5"
              "av1-1-b8-01-size-210x210.ivf"
              "av1-1-b8-01-size-210x210.ivf.md5"
              "av1-1-b8-01-size-210x224.ivf"
              "av1-1-b8-01-size-210x224.ivf.md5"
              "av1-1-b8-01-size-210x226.ivf"
              "av1-1-b8-01-size-210x226.ivf.md5"
              "av1-1-b8-01-size-224x196.ivf"
              "av1-1-b8-01-size-224x196.ivf.md5"
              "av1-1-b8-01-size-224x198.ivf"
              "av1-1-b8-01-size-224x198.ivf.md5"
              "av1-1-b8-01-size-224x200.ivf"
              "av1-1-b8-01-size-224x200.ivf.md5"
              "av1-1-b8-01-size-224x202.ivf"
              "av1-1-b8-01-size-224x202.ivf.md5"
              "av1-1-b8-01-size-224x208.ivf"
              "av1-1-b8-01-size-224x208.ivf.md5"
              "av1-1-b8-01-size-224x210.ivf"
              "av1-1-b8-01-size-224x210.ivf.md5"
              "av1-1-b8-01-size-224x224.ivf"
              "av1-1-b8-01-size-224x224.ivf.md5"
              "av1-1-b8-01-size-224x226.ivf"
              "av1-1-b8-01-size-224x226.ivf.md5"
              "av1-1-b8-01-size-226x196.ivf"
              "av1-1-b8-01-size-226x196.ivf.md5"
              "av1-1-b8-01-size-226x198.ivf"
              "av1-1-b8-01-size-226x198.ivf.md5"
              "av1-1-b8-01-size-226x200.ivf"
              "av1-1-b8-01-size-226x200.ivf.md5"
              "av1-1-b8-01-size-226x202.ivf"
              "av1-1-b8-01-size-226x202.ivf.md5"
              "av1-1-b8-01-size-226x208.ivf"
              "av1-1-b8-01-size-226x208.ivf.md5"
              "av1-1-b8-01-size-226x210.ivf"
              "av1-1-b8-01-size-226x210.ivf.md5"
              "av1-1-b8-01-size-226x224.ivf"
              "av1-1-b8-01-size-226x224.ivf.md5"
              "av1-1-b8-01-size-226x226.ivf"
              "av1-1-b8-01-size-226x226.ivf.md5"
              "av1-1-b8-01-size-32x16.ivf"
              "av1-1-b8-01-size-32x16.ivf.md5"
              "av1-1-b8-01-size-32x18.ivf"
              "av1-1-b8-01-size-32x18.ivf.md5"
              "av1-1-b8-01-size-32x32.ivf"
              "av1-1-b8-01-size-32x32.ivf.md5"
              "av1-1-b8-01-size-32x34.ivf"
              "av1-1-b8-01-size-32x34.ivf.md5"
              "av1-1-b8-01-size-32x64.ivf"
              "av1-1-b8-01-size-32x64.ivf.md5"
              "av1-1-b8-01-size-32x66.ivf"
              "av1-1-b8-01-size-32x66.ivf.md5"
              "av1-1-b8-01-size-34x16.ivf"
              "av1-1-b8-01-size-34x16.ivf.md5"
              "av1-1-b8-01-size-34x18.ivf"
              "av1-1-b8-01-size-34x18.ivf.md5"
              "av1-1-b8-01-size-34x32.ivf"
              "av1-1-b8-01-size-34x32.ivf.md5"
              "av1-1-b8-01-size-34x34.ivf"
              "av1-1-b8-01-size-34x34.ivf.md5"
              "av1-1-b8-01-size-34x64.ivf"
              "av1-1-b8-01-size-34x64.ivf.md5"
              "av1-1-b8-01-size-34x66.ivf"
              "av1-1-b8-01-size-34x66.ivf.md5"
              "av1-1-b8-01-size-64x16.ivf"
              "av1-1-b8-01-size-64x16.ivf.md5"
              "av1-1-b8-01-size-64x18.ivf"
              "av1-1-b8-01-size-64x18.ivf.md5"
              "av1-1-b8-01-size-64x32.ivf"
              "av1-1-b8-01-size-64x32.ivf.md5"
              "av1-1-b8-01-size-64x34.ivf"
              "av1-1-b8-01-size-64x34.ivf.md5"
              "av1-1-b8-01-size-64x64.ivf"
              "av1-1-b8-01-size-64x64.ivf.md5"
              "av1-1-b8-01-size-64x66.ivf"
              "av1-1-b8-01-size-64x66.ivf.md5"
              "av1-1-b8-01-size-66x16.ivf"
              "av1-1-b8-01-size-66x16.ivf.md5"
              "av1-1-b8-01-size-66x18.ivf"
              "av1-1-b8-01-size-66x18.ivf.md5"
              "av1-1-b8-01-size-66x32.ivf"
              "av1-1-b8-01-size-66x32.ivf.md5"
              "av1-1-b8-01-size-66x34.ivf"
              "av1-1-b8-01-size-66x34.ivf.md5"
              "av1-1-b8-01-size-66x64.ivf"
              "av1-1-b8-01-size-66x64.ivf.md5"
              "av1-1-b8-01-size-66x66.ivf"
              "av1-1-b8-01-size-66x66.ivf.md5"
              "av1-1-b8-02-allintra.ivf"
              "av1-1-b8-02-allintra.ivf.md5"
              "av1-1-b8-03-sizeup.mkv"
              "av1-1-b8-03-sizeup.mkv.md5"
              "av1-1-b8-03-sizedown.mkv"
              "av1-1-b8-03-sizedown.mkv.md5"
              "av1-1-b8-04-cdfupdate.ivf"
              "av1-1-b8-04-cdfupdate.ivf.md5"
              "av1-1-b8-05-mv.ivf"
              "av1-1-b8-05-mv.ivf.md5"
              "av1-1-b8-06-mfmv.ivf"
              "av1-1-b8-06-mfmv.ivf.md5"
              "av1-1-b8-16-intra_only-intrabc-extreme-dv.ivf"
              "av1-1-b8-16-intra_only-intrabc-extreme-dv.ivf.md5"
              "av1-1-b8-22-svc-L2T1.ivf"
              "av1-1-b8-22-svc-L2T1.ivf.md5"
              "av1-1-b8-22-svc-L1T2.ivf"
              "av1-1-b8-22-svc-L1T2.ivf.md5"
              "av1-1-b8-22-svc-L2T2.ivf"
              "av1-1-b8-22-svc-L2T2.ivf.md5"
              "av1-1-b8-23-film_grain-50.ivf"
              "av1-1-b8-23-film_grain-50.ivf.md5"
              "av1-1-b8-24-monochrome.ivf"
              "av1-1-b8-24-monochrome.ivf.md5"
              "invalid-bug-1814.ivf"
              "invalid-bug-1814.ivf.res"
              "invalid-chromium-906381.ivf"
              "invalid-chromium-906381.ivf.res"
              "invalid-google-142530197-1.ivf"
              "invalid-google-142530197-1.ivf.res"
              "invalid-google-142530197.ivf"
              "invalid-google-142530197.ivf.res"
              "invalid-oss-fuzz-10061.ivf"
              "invalid-oss-fuzz-10061.ivf.res"
              "invalid-oss-fuzz-10117-mc-buf-use-highbd.ivf"
              "invalid-oss-fuzz-10117-mc-buf-use-highbd.ivf.res"
              "invalid-oss-fuzz-10227.ivf"
              "invalid-oss-fuzz-10227.ivf.res"
              "invalid-oss-fuzz-10389.ivf"
              "invalid-oss-fuzz-10389.ivf.res.4"
              "invalid-oss-fuzz-10555.ivf"
              "invalid-oss-fuzz-10555.ivf.res"
              "invalid-oss-fuzz-10705.ivf"
              "invalid-oss-fuzz-10705.ivf.res"
              "invalid-oss-fuzz-10723.ivf"
              "invalid-oss-fuzz-10723.ivf.res.2"
              "invalid-oss-fuzz-10723.ivf.res.3"
              "invalid-oss-fuzz-10779.ivf"
              "invalid-oss-fuzz-10779.ivf.res"
              "invalid-oss-fuzz-11477.ivf"
              "invalid-oss-fuzz-11477.ivf.res"
              "invalid-oss-fuzz-11479.ivf"
              "invalid-oss-fuzz-11479.ivf.res.2"
              "invalid-oss-fuzz-11523.ivf"
              "invalid-oss-fuzz-11523.ivf.res.2"
              "invalid-oss-fuzz-15363.ivf"
              "invalid-oss-fuzz-15363.ivf.res"
              "invalid-oss-fuzz-16437.ivf"
              "invalid-oss-fuzz-16437.ivf.res.2"
              "invalid-oss-fuzz-24706.ivf"
              "invalid-oss-fuzz-24706.ivf.res"
              "invalid-oss-fuzz-33030.ivf"
              "invalid-oss-fuzz-33030.ivf.res"
              "invalid-oss-fuzz-9288.ivf"
              "invalid-oss-fuzz-9288.ivf.res"
              "invalid-oss-fuzz-9463.ivf"
              "invalid-oss-fuzz-9463.ivf.res.2"
              "invalid-oss-fuzz-9482.ivf"
              "invalid-oss-fuzz-9482.ivf.res"
              "invalid-oss-fuzz-9720.ivf"
              "invalid-oss-fuzz-9720.ivf.res")
endif()

if(ENABLE_ENCODE_PERF_TESTS AND CONFIG_AV1_ENCODER)
  list(APPEND AOM_TEST_DATA_FILE_NAMES "desktop_640_360_30.yuv"
              "kirland_640_480_30.yuv" "macmarcomoving_640_480_30.yuv"
              "macmarcostationary_640_480_30.yuv" "niklas_1280_720_30.yuv"
              "tacomanarrows_640_480_30.yuv"
              "tacomasmallcameramovement_640_480_30.yuv"
              "thaloundeskmtg_640_480_30.yuv")
endif()

# Parses test/test-data.sha1 and writes captured file names and checksums to
# $out_files and $out_checksums as lists.
function(make_test_data_lists test_data_file out_files out_checksums)
  if(NOT test_data_file OR NOT EXISTS "${test_data_file}")
    message(FATAL_ERROR "Test info file missing or empty (${test_data_file})")
  endif()

  # Read $test_data_file into $files_and_checksums. $files_and_checksums becomes
  # a list with an entry for each line from $test_data_file.
  file(STRINGS "${test_data_file}" files_and_checksums)

  # Iterate over the list of lines and split it into $checksums and $filenames.
  foreach(line ${files_and_checksums})
    string(FIND "${line}" " *" delim_pos)

    math(EXPR filename_pos "${delim_pos} + 2")
    string(SUBSTRING "${line}" 0 ${delim_pos} checksum)
    string(SUBSTRING "${line}" ${filename_pos} -1 filename)

    list(FIND AOM_TEST_DATA_FILE_NAMES ${filename} list_index)
    if(NOT ${list_index} EQUAL -1)

      # Include the name and checksum in output only when the file is needed.
      set(checksums ${checksums} ${checksum})
      set(filenames ${filenames} ${filename})
    endif()
  endforeach()

  list(LENGTH filenames num_files)
  list(LENGTH checksums num_checksums)
  if(NOT checksums OR NOT filenames OR NOT num_files EQUAL num_checksums)
    message(FATAL_ERROR "Parsing of ${test_data_file} failed.")
  endif()

  set(${out_checksums} ${checksums} PARENT_SCOPE)
  set(${out_files} ${filenames} PARENT_SCOPE)
endfunction()

# Appends each file name in $test_files to $test_dir and adds the result path to
# $out_path_list.
function(expand_test_file_paths test_files test_dir out_path_list)
  foreach(filename ${${test_files}})
    set(path_list ${path_list} "${test_dir}/${filename}")
  endforeach()
  set(${out_path_list} ${path_list} PARENT_SCOPE)
endfunction()

function(check_file local_path expected_checksum out_needs_update)
  if(EXISTS "${local_path}")
    file(SHA1 "${local_path}" file_checksum)
  else()
    set(${out_needs_update} 1 PARENT_SCOPE)
    return()
  endif()

  if("${file_checksum}" STREQUAL "${expected_checksum}")
    unset(${out_needs_update} PARENT_SCOPE)
  else()
    set(${out_needs_update} 1 PARENT_SCOPE)
    return()
  endif()
  message("${local_path} up to date.")
endfunction()

# Downloads data from $file_url, confirms that $file_checksum matches, and
# writes it to $local_path.
function(download_test_file file_url file_checksum local_path)
  message("Downloading ${file_url} ...")
  file(DOWNLOAD "${file_url}" "${local_path}" SHOW_PROGRESS EXPECTED_HASH
                                              SHA1=${file_checksum})
  message("Download of ${file_url} complete.")
endfunction()
