"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getElementNames = getElementNames;
const language_core_1 = require("@vue/language-core");
const utils_1 = require("./utils");
function getElementNames(fileName) {
    const { typescript: ts, language, languageService } = this;
    const sourceScript = language.scripts.get(fileName);
    const root = sourceScript?.generated?.root;
    if (!sourceScript?.generated || !(root instanceof language_core_1.VueVirtualCode)) {
        return [];
    }
    return (0, utils_1.getVariableType)(ts, languageService, root, '__VLS_elements')
        ?.type
        ?.getProperties()
        .map(c => c.name)
        ?? [];
}
//# sourceMappingURL=getElementNames.js.map