/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.glsl.fixedfunc;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.util.IntIntHashMap;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLArrayData;
import com.jogamp.opengl.GLES2;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLRunnable2;
import com.jogamp.opengl.GLUniformData;
import com.jogamp.opengl.fixedfunc.GLPointerFuncUtil;
import com.jogamp.opengl.util.PMVMatrix;
import com.jogamp.opengl.util.SyncMatrices4f;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import com.jogamp.opengl.util.glsl.ShaderState;
import com.jogamp.opengl.util.glsl.fixedfunc.ShaderSelectionMode;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import jogamp.opengl.Debug;

public class FixedFuncPipeline {
    protected static final boolean DEBUG;
    public static final int MAX_TEXTURE_UNITS = 8;
    public static final int MAX_LIGHTS = 8;
    private static final GLRunnable2<Object, Object> glDrawArraysAction;
    private static final String constMaxTextures0 = "#define MAX_TEXTURE_UNITS 0\n";
    private static final String constMaxTextures2 = "#define MAX_TEXTURE_UNITS 2\n";
    private static final String constMaxTextures4 = "#define MAX_TEXTURE_UNITS 4\n";
    private static final String constMaxTextures8 = "#define MAX_TEXTURE_UNITS 8\n";
    protected boolean verbose = DEBUG;
    private final FloatBuffer colorStatic = Buffers.copyFloatBuffer((FloatBuffer)one4f);
    private int activeTextureUnit = 0;
    private int clientActiveTextureUnit = 0;
    private final IntIntHashMap texID2Format = new IntIntHashMap();
    private final int[] boundTextureObject = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private int textureEnabledBits = 0;
    private final IntBuffer textureEnabled = Buffers.newDirectIntBuffer((int[])new int[]{0, 0, 0, 0, 0, 0, 0, 0});
    private boolean textureEnabledDirty = false;
    private final IntBuffer textureCoordEnabled = Buffers.newDirectIntBuffer((int[])new int[]{0, 0, 0, 0, 0, 0, 0, 0});
    private boolean textureCoordEnabledDirty = false;
    private final IntBuffer textureEnvMode = Buffers.newDirectIntBuffer((int[])new int[]{2, 2, 2, 2, 2, 2, 2, 2});
    private boolean textureEnvModeDirty = false;
    private final IntBuffer textureFormat = Buffers.newDirectIntBuffer((int[])new int[]{0, 0, 0, 0, 0, 0, 0, 0});
    private boolean textureFormatDirty = false;
    private boolean colorVAEnabledDirty = false;
    private boolean lightingEnabled = false;
    private final IntBuffer lightsEnabled = Buffers.newDirectIntBuffer((int[])new int[]{0, 0, 0, 0, 0, 0, 0, 0});
    private boolean lightsEnabledDirty = false;
    private boolean alphaTestDirty = false;
    private int alphaTestFunc = -8;
    private float alphaTestRef = 0.0f;
    private boolean pointParamsDirty = false;
    private final FloatBuffer pointParams = Buffers.newDirectFloatBuffer((float[])new float[]{1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f});
    private PMVMatrix pmvMatrix;
    private ShaderState shaderState;
    private ShaderProgram shaderProgramColor;
    private ShaderProgram shaderProgramColorTexture2;
    private ShaderProgram shaderProgramColorTexture4;
    private ShaderProgram shaderProgramColorTexture8;
    private ShaderProgram shaderProgramColorLight;
    private ShaderProgram shaderProgramColorTexture8Light;
    private ShaderProgram shaderProgramPoints;
    private ShaderSelectionMode requestedShaderSelectionMode;
    private ShaderSelectionMode currentShaderSelectionMode = this.requestedShaderSelectionMode = ShaderSelectionMode.AUTO;
    private static final String mgl_PMVMatrix = "mgl_PMVMatrix";
    private static final String mgl_ColorEnabled = "mgl_ColorEnabled";
    private static final String mgl_ColorStatic = "mgl_ColorStatic";
    private static final String mgl_LightModel = "mgl_LightModel";
    private static final String mgl_LightSource = "mgl_LightSource";
    private static final String mgl_FrontMaterial = "mgl_FrontMaterial";
    private static final String mgl_LightsEnabled = "mgl_LightsEnabled";
    private static final String mgl_AlphaTestFunc = "mgl_AlphaTestFunc";
    private static final String mgl_AlphaTestRef = "mgl_AlphaTestRef";
    private static final String mgl_ShadeModel = "mgl_ShadeModel";
    private static final String mgl_PointParams = "mgl_PointParams";
    private static final String mgl_TextureEnabled = "mgl_TextureEnabled";
    private static final String mgl_Texture = "mgl_Texture";
    private static final String mgl_TexCoordEnabled = "mgl_TexCoordEnabled";
    private static final String mgl_TexEnvMode = "mgl_TexEnvMode";
    private static final String mgl_TexFormat = "mgl_TexFormat";
    private static final FloatBuffer neut4f;
    private static final FloatBuffer one4f;
    public static final FloatBuffer defAmbient;
    public static final FloatBuffer defDiffuseN;
    public static final FloatBuffer defSpecularN;
    public static final FloatBuffer defPosition;
    public static final FloatBuffer defSpotDir;
    public static final float defSpotExponent = 0.0f;
    public static final float defSpotCutoff = 180.0f;
    public static final float defConstantAtten = 1.0f;
    public static final float defLinearAtten = 0.0f;
    public static final float defQuadraticAtten = 0.0f;
    public static final FloatBuffer defLightModelAmbient;
    public static final FloatBuffer defMatAmbient;
    public static final FloatBuffer defMatDiffuse;
    public static final FloatBuffer defMatSpecular;
    public static final FloatBuffer defMatEmission;
    public static final float defMatShininess = 0.0f;
    private static final String vertexColorFileDef = "FixedFuncColor";
    private static final String vertexColorLightFileDef = "FixedFuncColorLight";
    private static final String fragmentColorFileDef = "FixedFuncColor";
    private static final String fragmentColorTextureFileDef = "FixedFuncColorTexture";
    private static final String shaderPointFileDef = "FixedFuncPoints";
    private static final String shaderSrcRootDef = "shaders";
    private static final String shaderBinRootDef = "shaders/bin";
    private final Class<?> shaderRootClass;
    private final String shaderSrcRoot;
    private final String shaderBinRoot;
    private final String vertexColorFile;
    private final String vertexColorLightFile;
    private final String fragmentColorFile;
    private final String fragmentColorTextureFile;

    public FixedFuncPipeline(GL2ES2 gL2ES2, ShaderSelectionMode shaderSelectionMode, PMVMatrix pMVMatrix) {
        this.shaderRootClass = FixedFuncPipeline.class;
        this.shaderSrcRoot = shaderSrcRootDef;
        this.shaderBinRoot = shaderBinRootDef;
        this.vertexColorFile = "FixedFuncColor";
        this.vertexColorLightFile = vertexColorLightFileDef;
        this.fragmentColorFile = "FixedFuncColor";
        this.fragmentColorTextureFile = fragmentColorTextureFileDef;
        this.init(gL2ES2, shaderSelectionMode, pMVMatrix);
    }

    public FixedFuncPipeline(GL2ES2 gL2ES2, ShaderSelectionMode shaderSelectionMode, PMVMatrix pMVMatrix, Class<?> clazz, String string, String string2, String string3, String string4, String string5, String string6) {
        this.shaderRootClass = clazz;
        this.shaderSrcRoot = string;
        this.shaderBinRoot = string2;
        this.vertexColorFile = string3;
        this.vertexColorLightFile = string4;
        this.fragmentColorFile = string5;
        this.fragmentColorTextureFile = string6;
        this.init(gL2ES2, shaderSelectionMode, pMVMatrix);
    }

    public ShaderSelectionMode getShaderSelectionMode() {
        return this.requestedShaderSelectionMode;
    }

    public void setShaderSelectionMode(ShaderSelectionMode shaderSelectionMode) {
        this.requestedShaderSelectionMode = shaderSelectionMode;
    }

    public ShaderSelectionMode getCurrentShaderSelectionMode() {
        return this.currentShaderSelectionMode;
    }

    public boolean verbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = DEBUG || bl;
    }

    public boolean isValid() {
        return this.shaderState.linked();
    }

    public ShaderState getShaderState() {
        return this.shaderState;
    }

    public int getActiveTextureUnit() {
        return this.activeTextureUnit;
    }

    public void destroy(GL2ES2 gL2ES2) {
        if (null != this.shaderProgramColor) {
            this.shaderProgramColor.release(gL2ES2, true);
        }
        if (null != this.shaderProgramColorLight) {
            this.shaderProgramColorLight.release(gL2ES2, true);
        }
        if (null != this.shaderProgramColorTexture2) {
            this.shaderProgramColorTexture2.release(gL2ES2, true);
        }
        if (null != this.shaderProgramColorTexture4) {
            this.shaderProgramColorTexture4.release(gL2ES2, true);
        }
        if (null != this.shaderProgramColorTexture4) {
            this.shaderProgramColorTexture4.release(gL2ES2, true);
        }
        if (null != this.shaderProgramColorTexture8Light) {
            this.shaderProgramColorTexture8Light.release(gL2ES2, true);
        }
        this.shaderState.destroy(gL2ES2);
    }

    public void glColor4f(GL2ES2 gL2ES2, float f, float f2, float f3, float f4) {
        this.colorStatic.put(0, f);
        this.colorStatic.put(1, f2);
        this.colorStatic.put(2, f3);
        this.colorStatic.put(3, f4);
        this.shaderState.useProgram(gL2ES2, true);
        GLUniformData gLUniformData = this.shaderState.getUniform(mgl_ColorStatic);
        if (null == gLUniformData) {
            throw new GLException("Failed to update: mgl_ColorStatic");
        }
        this.shaderState.uniform(gL2ES2, gLUniformData);
    }

    public void glEnableClientState(GL2ES2 gL2ES2, int n) {
        this.glToggleClientState(gL2ES2, n, true);
    }

    public void glDisableClientState(GL2ES2 gL2ES2, int n) {
        this.glToggleClientState(gL2ES2, n, false);
    }

    private void glToggleClientState(GL2ES2 gL2ES2, int n, boolean bl) {
        String string = GLPointerFuncUtil.getPredefinedArrayIndexName(n, this.clientActiveTextureUnit);
        if (null == string) {
            throw new GLException("arrayIndex " + this.toHexString(n) + " unknown");
        }
        this.shaderState.useProgram(gL2ES2, true);
        if (bl) {
            this.shaderState.enableVertexAttribArray(gL2ES2, string);
        } else {
            this.shaderState.disableVertexAttribArray(gL2ES2, string);
        }
        switch (n) {
            case 32888: {
                int n2;
                int n3 = n2 = bl ? 1 : 0;
                if (this.textureCoordEnabled.get(this.clientActiveTextureUnit) == n2) break;
                this.textureCoordEnabled.put(this.clientActiveTextureUnit, n2);
                this.textureCoordEnabledDirty = true;
                break;
            }
            case 32886: {
                this.colorVAEnabledDirty = true;
            }
        }
    }

    public void glVertexPointer(GL2ES2 gL2ES2, GLArrayData gLArrayData) {
        this.shaderState.useProgram(gL2ES2, true);
        this.shaderState.vertexAttribPointer(gL2ES2, gLArrayData);
    }

    public void glColorPointer(GL2ES2 gL2ES2, GLArrayData gLArrayData) {
        this.shaderState.useProgram(gL2ES2, true);
        this.shaderState.vertexAttribPointer(gL2ES2, gLArrayData);
    }

    public void glNormalPointer(GL2ES2 gL2ES2, GLArrayData gLArrayData) {
        this.shaderState.useProgram(gL2ES2, true);
        this.shaderState.vertexAttribPointer(gL2ES2, gLArrayData);
    }

    private boolean glEnableTexture(boolean bl, int n) {
        boolean bl2;
        boolean bl3 = bl2 = 0 != (this.textureEnabledBits & 1 << this.activeTextureUnit);
        if (bl2 != bl) {
            if (bl) {
                this.textureEnabledBits |= 1 << n;
                this.textureEnabled.put(n, 1);
            } else {
                this.textureEnabledBits &= ~(1 << n);
                this.textureEnabled.put(n, 0);
            }
            this.textureEnabledDirty = true;
        }
        return bl2;
    }

    public void glClientActiveTexture(int n) {
        if (0 > (n -= 33984) || n >= 8) {
            throw new GLException("glClientActiveTexture textureUnit not within GL_TEXTURE0 + [0..8]: " + n);
        }
        this.clientActiveTextureUnit = n;
    }

    public void glActiveTexture(int n) {
        if (0 > (n -= 33984) || n >= 8) {
            throw new GLException("glActivateTexture textureUnit not within GL_TEXTURE0 + [0..8]: " + n);
        }
        this.activeTextureUnit = n;
    }

    public void glTexCoordPointer(GL2ES2 gL2ES2, GLArrayData gLArrayData) {
        if (32888 != gLArrayData.getIndex()) {
            throw new GLException("Invalid GLArrayData Index " + this.toHexString(gLArrayData.getIndex()) + ", " + gLArrayData);
        }
        this.shaderState.useProgram(gL2ES2, true);
        gLArrayData.setName(GLPointerFuncUtil.getPredefinedArrayIndexName(gLArrayData.getIndex(), this.clientActiveTextureUnit));
        this.shaderState.vertexAttribPointer(gL2ES2, gLArrayData);
    }

    public void glBindTexture(int n, int n2) {
        if (3553 == n) {
            if (n2 != this.boundTextureObject[this.activeTextureUnit]) {
                this.boundTextureObject[this.activeTextureUnit] = n2;
                this.textureFormatDirty = true;
            }
        } else {
            System.err.println("FixedFuncPipeline: Unimplemented glBindTexture for target " + this.toHexString(n) + ". Texture name " + this.toHexString(n2));
        }
    }

    public void glTexImage2D(int n, int n2, int n3) {
        if (3553 == n) {
            int n4;
            switch (n2) {
                case 3: 
                case 6407: 
                case 32849: 
                case 32850: 
                case 36194: {
                    n4 = 3;
                    break;
                }
                case 4: 
                case 6408: 
                case 32854: 
                case 32855: 
                case 32856: 
                case 32857: {
                    n4 = 4;
                    break;
                }
                default: {
                    System.err.println("FixedFuncPipeline: glTexImage2D TEXTURE_2D: Unimplemented internalformat " + this.toHexString(n2));
                    n4 = 4;
                }
            }
            if (n4 != this.texID2Format.put(this.boundTextureObject[this.activeTextureUnit], n4)) {
                this.textureFormatDirty = true;
            }
        } else {
            System.err.println("FixedFuncPipeline: Unimplemented glTexImage2D: target " + this.toHexString(n) + ", internalformat " + this.toHexString(n2));
        }
    }

    public void glTexEnvi(int n, int n2, int n3) {
        if (8960 == n && 8704 == n2) {
            int n4;
            switch (n3) {
                case 260: {
                    n4 = 1;
                    break;
                }
                case 8448: {
                    n4 = 2;
                    break;
                }
                case 8449: {
                    n4 = 3;
                    break;
                }
                case 3042: {
                    n4 = 4;
                    break;
                }
                case 7681: {
                    n4 = 5;
                    break;
                }
                case 34160: {
                    n4 = 2;
                    System.err.println("FixedFuncPipeline: glTexEnv GL_TEXTURE_ENV_MODE: unimplemented mode: " + this.toHexString(n3));
                    break;
                }
                default: {
                    throw new GLException("glTexEnv GL_TEXTURE_ENV_MODE: invalid mode: " + this.toHexString(n3));
                }
            }
            this.setTextureEnvMode(n4);
        } else if (this.verbose) {
            System.err.println("FixedFuncPipeline: Unimplemented TexEnv: target " + this.toHexString(n) + ", pname " + this.toHexString(n2) + ", mode: " + this.toHexString(n3));
        }
    }

    private void setTextureEnvMode(int n) {
        if (n != this.textureEnvMode.get(this.activeTextureUnit)) {
            this.textureEnvMode.put(this.activeTextureUnit, n);
            this.textureEnvModeDirty = true;
        }
    }

    public void glGetTexEnviv(int n, int n2, IntBuffer intBuffer) {
        System.err.println("FixedFuncPipeline: Unimplemented glGetTexEnviv: target " + this.toHexString(n) + ", pname " + this.toHexString(n2));
    }

    public void glGetTexEnviv(int n, int n2, int[] nArray, int n3) {
        System.err.println("FixedFuncPipeline: Unimplemented glGetTexEnviv: target " + this.toHexString(n) + ", pname " + this.toHexString(n2));
    }

    public void glPointSize(float f) {
        this.pointParams.put(0, f);
        this.pointParamsDirty = true;
    }

    public void glPointParameterf(int n, float f) {
        switch (n) {
            case 33062: {
                this.pointParams.put(2, f);
                break;
            }
            case 33063: {
                this.pointParams.put(3, f);
                break;
            }
            case 33064: {
                this.pointParams.put(7, f);
            }
        }
        this.pointParamsDirty = true;
    }

    public void glPointParameterfv(int n, float[] fArray, int n2) {
        switch (n) {
            case 33065: {
                this.pointParams.put(4, fArray[n2 + 0]);
                this.pointParams.put(5, fArray[n2 + 1]);
                this.pointParams.put(6, fArray[n2 + 2]);
            }
        }
        this.pointParamsDirty = true;
    }

    public void glPointParameterfv(int n, FloatBuffer floatBuffer) {
        int n2 = floatBuffer.position();
        switch (n) {
            case 33065: {
                this.pointParams.put(4, floatBuffer.get(n2 + 0));
                this.pointParams.put(5, floatBuffer.get(n2 + 1));
                this.pointParams.put(6, floatBuffer.get(n2 + 2));
            }
        }
        this.pointParamsDirty = true;
    }

    private void glDrawPoints(GL2ES2 gL2ES2, GLRunnable2<Object, Object> gLRunnable2, Object object) {
        if (gL2ES2.isGL2GL3()) {
            gL2ES2.glEnable(34370);
        }
        if (gL2ES2.isGL2ES1()) {
            gL2ES2.glEnable(34913);
        }
        this.loadShaderPoints(gL2ES2);
        this.shaderState.attachShaderProgram(gL2ES2, this.shaderProgramPoints, true);
        this.validate(gL2ES2, false);
        gLRunnable2.run(gL2ES2, object);
        if (gL2ES2.isGL2ES1()) {
            gL2ES2.glDisable(34913);
        }
        if (gL2ES2.isGL2GL3()) {
            gL2ES2.glDisable(34370);
        }
        this.shaderState.attachShaderProgram(gL2ES2, this.selectShaderProgram(gL2ES2, this.currentShaderSelectionMode), true);
    }

    private final void glDrawPointArrays(GL2ES2 gL2ES2, int n, int n2) {
        this.glDrawPoints(gL2ES2, glDrawArraysAction, new int[]{n, n2});
    }

    public void glLightfv(GL2ES2 gL2ES2, int n, int n2, FloatBuffer floatBuffer) {
        this.shaderState.useProgram(gL2ES2, true);
        if (0 <= (n -= 16384) && n < 8) {
            GLUniformData gLUniformData = null;
            switch (n2) {
                case 4608: {
                    gLUniformData = this.shaderState.getUniform("mgl_LightSource[" + n + "].ambient");
                    break;
                }
                case 4609: {
                    gLUniformData = this.shaderState.getUniform("mgl_LightSource[" + n + "].diffuse");
                    break;
                }
                case 4610: {
                    gLUniformData = this.shaderState.getUniform("mgl_LightSource[" + n + "].specular");
                    break;
                }
                case 4611: {
                    gLUniformData = this.shaderState.getUniform("mgl_LightSource[" + n + "].position");
                    break;
                }
                case 4612: {
                    gLUniformData = this.shaderState.getUniform("mgl_LightSource[" + n + "].spotDirection");
                    break;
                }
                case 4613: {
                    gLUniformData = this.shaderState.getUniform("mgl_LightSource[" + n + "].spotExponent");
                    break;
                }
                case 4614: {
                    gLUniformData = this.shaderState.getUniform("mgl_LightSource[" + n + "].spotCutoff");
                    break;
                }
                case 4615: {
                    gLUniformData = this.shaderState.getUniform("mgl_LightSource[" + n + "].constantAttenuation");
                    break;
                }
                case 4616: {
                    gLUniformData = this.shaderState.getUniform("mgl_LightSource[" + n + "].linearAttenuation");
                    break;
                }
                case 4617: {
                    gLUniformData = this.shaderState.getUniform("mgl_LightSource[" + n + "].quadraticAttenuation");
                    break;
                }
                default: {
                    throw new GLException("glLightfv invalid pname: " + this.toHexString(n2));
                }
            }
            if (null != gLUniformData) {
                gLUniformData.setData(floatBuffer);
                this.shaderState.uniform(gL2ES2, gLUniformData);
            }
        } else {
            throw new GLException("glLightfv light not within [0..8]: " + n);
        }
    }

    public void glMaterialfv(GL2ES2 gL2ES2, int n, int n2, FloatBuffer floatBuffer) {
        this.shaderState.useProgram(gL2ES2, true);
        switch (n) {
            case 1028: 
            case 1032: {
                break;
            }
            case 1029: {
                System.err.println("FixedFuncPipeline: Unimplemented glMaterialfv GL_BACK face");
                return;
            }
        }
        GLUniformData gLUniformData = null;
        switch (n2) {
            case 4608: {
                gLUniformData = this.shaderState.getUniform("mgl_FrontMaterial.ambient");
                break;
            }
            case 5634: {
                gLUniformData = this.shaderState.getUniform("mgl_FrontMaterial.ambient");
                if (null != gLUniformData) {
                    gLUniformData.setData(floatBuffer);
                    this.shaderState.uniform(gL2ES2, gLUniformData);
                }
            }
            case 4609: {
                gLUniformData = this.shaderState.getUniform("mgl_FrontMaterial.diffuse");
                break;
            }
            case 4610: {
                gLUniformData = this.shaderState.getUniform("mgl_FrontMaterial.specular");
                break;
            }
            case 5632: {
                gLUniformData = this.shaderState.getUniform("mgl_FrontMaterial.emission");
                break;
            }
            case 5633: {
                gLUniformData = this.shaderState.getUniform("mgl_FrontMaterial.shininess");
                break;
            }
            default: {
                throw new GLException("glMaterialfv invalid pname: " + this.toHexString(n2));
            }
        }
        if (null != gLUniformData) {
            gLUniformData.setData(floatBuffer);
            this.shaderState.uniform(gL2ES2, gLUniformData);
        } else if (this.verbose) {
            // empty if block
        }
    }

    public void glShadeModel(GL2ES2 gL2ES2, int n) {
        this.shaderState.useProgram(gL2ES2, true);
        GLUniformData gLUniformData = this.shaderState.getUniform(mgl_ShadeModel);
        if (null != gLUniformData) {
            gLUniformData.setData(n);
            this.shaderState.uniform(gL2ES2, gLUniformData);
        }
    }

    public void glAlphaFunc(int n, float f) {
        int n2;
        switch (n) {
            case 512: {
                n2 = 1;
                break;
            }
            case 513: {
                n2 = 2;
                break;
            }
            case 514: {
                n2 = 3;
                break;
            }
            case 515: {
                n2 = 4;
                break;
            }
            case 516: {
                n2 = 5;
                break;
            }
            case 517: {
                n2 = 6;
                break;
            }
            case 518: {
                n2 = 7;
                break;
            }
            case 519: {
                n2 = 8;
                break;
            }
            default: {
                throw new GLException("glAlphaFunc invalid func: " + this.toHexString(n));
            }
        }
        if (0 < n2) {
            if (0 > this.alphaTestFunc) {
                n2 *= -1;
            }
            if (this.alphaTestFunc != n2 || this.alphaTestRef != f) {
                this.alphaTestFunc = n2;
                this.alphaTestRef = f;
                this.alphaTestDirty = true;
            }
        }
    }

    public boolean glEnable(int n, boolean bl) {
        switch (n) {
            case 2929: 
            case 2960: 
            case 3024: 
            case 3042: 
            case 3089: 
            case 32823: 
            case 32926: 
            case 32928: {
                return true;
            }
            case 2884: {
                return true;
            }
            case 3553: {
                this.glEnableTexture(bl, this.activeTextureUnit);
                return false;
            }
            case 2896: {
                this.lightingEnabled = bl;
                return false;
            }
            case 3008: {
                int n2 = 0 > this.alphaTestFunc && bl || 0 < this.alphaTestFunc && !bl ? this.alphaTestFunc * -1 : this.alphaTestFunc;
                if (n2 != this.alphaTestFunc) {
                    this.alphaTestDirty = true;
                    this.alphaTestFunc = n2;
                }
                return false;
            }
            case 2832: {
                this.pointParams.put(1, bl ? 1.0f : 0.0f);
                this.pointParamsDirty = true;
                return false;
            }
            case 34913: {
                return false;
            }
        }
        int n3 = n - 16384;
        if (0 <= n3 && n3 < 8 && this.lightsEnabled.get(n3) == 1 != bl) {
            this.lightsEnabled.put(n3, bl ? 1 : 0);
            this.lightsEnabledDirty = true;
            return false;
        }
        System.err.println("FixedFunctionPipeline: " + (bl ? "glEnable" : "glDisable") + " " + this.toHexString(n) + " not handled in emulation and not supported in ES2");
        return false;
    }

    public void glDrawArrays(GL2ES2 gL2ES2, int n, int n2, int n3) {
        switch (n) {
            case 8: {
                n = 5;
                break;
            }
            case 9: {
                n = 6;
                break;
            }
            case 0: {
                this.glDrawPointArrays(gL2ES2, n2, n3);
                return;
            }
        }
        this.validate(gL2ES2, true);
        if (7 == n && !gL2ES2.isGL2()) {
            for (int i = n2; i < n3 - 3; i += 4) {
                gL2ES2.glDrawArrays(6, i, 4);
            }
        } else {
            gL2ES2.glDrawArrays(n, n2, n3);
        }
    }

    public void glDrawElements(GL2ES2 gL2ES2, int n, int n2, int n3, Buffer buffer) {
        this.validate(gL2ES2, true);
        if (7 == n && !gL2ES2.isGL2()) {
            int n4 = buffer.position();
            if (5121 == n3) {
                ByteBuffer byteBuffer = (ByteBuffer)buffer;
                for (int i = 0; i < n2; ++i) {
                    gL2ES2.glDrawArrays(6, 0xFF & byteBuffer.get(n4 + i), 4);
                }
            } else if (5123 == n3) {
                ShortBuffer shortBuffer = (ShortBuffer)buffer;
                for (int i = 0; i < n2; ++i) {
                    gL2ES2.glDrawArrays(6, 0xFFFF & shortBuffer.get(n4 + i), 4);
                }
            } else {
                IntBuffer intBuffer = (IntBuffer)buffer;
                for (int i = 0; i < n2; ++i) {
                    gL2ES2.glDrawArrays(6, 0xFFFFFFFF & intBuffer.get(n4 + i), 4);
                }
            }
        } else {
            if (!gL2ES2.getContext().isCPUDataSourcingAvail()) {
                throw new GLException("CPU data sourcing n/a w/ " + gL2ES2.getContext());
            }
            ((GLES2)gL2ES2).glDrawElements(n, n2, n3, buffer);
        }
    }

    public void glDrawElements(GL2ES2 gL2ES2, int n, int n2, int n3, long l) {
        this.validate(gL2ES2, true);
        if (7 == n && !gL2ES2.isGL2()) {
            throw new GLException("Cannot handle indexed QUADS on !GL2 w/ VBO due to lack of CPU index access");
        }
        gL2ES2.glDrawElements(n, n2, n3, l);
    }

    private final int textureEnabledCount() {
        int n = 0;
        for (int i = 7; i >= 0; --i) {
            if (0 == this.textureEnabled.get(i)) continue;
            ++n;
        }
        return n;
    }

    public void validate(GL2ES2 gL2ES2, boolean bl) {
        Object object;
        int n;
        if (bl) {
            if (ShaderSelectionMode.AUTO == this.requestedShaderSelectionMode) {
                object = 0 != this.textureEnabledBits ? (this.lightingEnabled ? ShaderSelectionMode.COLOR_TEXTURE8_LIGHT_PER_VERTEX : (4 < (n = this.textureEnabledCount()) ? ShaderSelectionMode.COLOR_TEXTURE8 : (2 < n ? ShaderSelectionMode.COLOR_TEXTURE4 : ShaderSelectionMode.COLOR_TEXTURE2))) : (this.lightingEnabled ? ShaderSelectionMode.COLOR_LIGHT_PER_VERTEX : ShaderSelectionMode.COLOR);
                this.shaderState.attachShaderProgram(gL2ES2, this.selectShaderProgram(gL2ES2, (ShaderSelectionMode)((Object)object)), true);
            } else {
                this.shaderState.useProgram(gL2ES2, true);
            }
        }
        if (this.pmvMatrix.isReqDirty()) {
            object = this.shaderState.getUniform(mgl_PMVMatrix);
            if (null != object) {
                SyncMatrices4f syncMatrices4f = ShaderSelectionMode.COLOR_TEXTURE8_LIGHT_PER_VERTEX == this.currentShaderSelectionMode || ShaderSelectionMode.COLOR_LIGHT_PER_VERTEX == this.currentShaderSelectionMode ? this.pmvMatrix.getSyncPMvMviMvitMat() : this.pmvMatrix.getSyncPMvMat();
                if (syncMatrices4f != object.getBuffer()) {
                    object.setData(syncMatrices4f);
                }
                this.shaderState.uniform(gL2ES2, (GLUniformData)object);
            } else {
                throw new GLException("Failed to update: mgl_PMVMatrix");
            }
        }
        if (this.colorVAEnabledDirty) {
            object = this.shaderState.getUniform(mgl_ColorEnabled);
            if (null != object) {
                int n2 = n = true == this.shaderState.isVertexAttribArrayEnabled("mgl_Color") ? 1 : 0;
                if (n != object.intValue()) {
                    object.setData(n);
                    this.shaderState.uniform(gL2ES2, (GLUniformData)object);
                }
            } else {
                throw new GLException("Failed to update: mgl_ColorEnabled");
            }
            this.colorVAEnabledDirty = false;
        }
        if (this.alphaTestDirty) {
            object = this.shaderState.getUniform(mgl_AlphaTestFunc);
            if (null != object) {
                object.setData(this.alphaTestFunc);
                this.shaderState.uniform(gL2ES2, (GLUniformData)object);
            }
            if (null != (object = this.shaderState.getUniform(mgl_AlphaTestRef))) {
                object.setData(this.alphaTestRef);
                this.shaderState.uniform(gL2ES2, (GLUniformData)object);
            }
            this.alphaTestDirty = false;
        }
        if (this.pointParamsDirty) {
            object = this.shaderState.getUniform(mgl_PointParams);
            if (null != object) {
                this.shaderState.uniform(gL2ES2, (GLUniformData)object);
            }
            this.pointParamsDirty = false;
        }
        if (this.lightsEnabledDirty) {
            object = this.shaderState.getUniform(mgl_LightsEnabled);
            if (null != object) {
                this.shaderState.uniform(gL2ES2, (GLUniformData)object);
            }
            this.lightsEnabledDirty = false;
        }
        if (this.textureCoordEnabledDirty) {
            object = this.shaderState.getUniform(mgl_TexCoordEnabled);
            if (null != object) {
                this.shaderState.uniform(gL2ES2, (GLUniformData)object);
            }
            this.textureCoordEnabledDirty = false;
        }
        if (this.textureEnvModeDirty) {
            object = this.shaderState.getUniform(mgl_TexEnvMode);
            if (null != object) {
                this.shaderState.uniform(gL2ES2, (GLUniformData)object);
            }
            this.textureEnvModeDirty = false;
        }
        if (this.textureFormatDirty) {
            for (n = 0; n < 8; ++n) {
                this.textureFormat.put(n, this.texID2Format.get(this.boundTextureObject[n]));
            }
            object = this.shaderState.getUniform(mgl_TexFormat);
            if (null != object) {
                this.shaderState.uniform(gL2ES2, (GLUniformData)object);
            }
            this.textureFormatDirty = false;
        }
        if (this.textureEnabledDirty) {
            object = this.shaderState.getUniform(mgl_TextureEnabled);
            if (null != object) {
                this.shaderState.uniform(gL2ES2, (GLUniformData)object);
            }
            this.textureEnabledDirty = false;
        }
        if (this.verbose) {
            System.err.println("validate: " + this.toString(null, DEBUG).toString());
        }
    }

    public StringBuilder toString(StringBuilder stringBuilder, boolean bl) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("FixedFuncPipeline[");
        stringBuilder.append(", textureEnabled: " + this.toHexString(this.textureEnabledBits) + ", ");
        Buffers.toString((StringBuilder)stringBuilder, null, (Buffer)this.textureEnabled);
        stringBuilder.append("\n\t, textureCoordEnabled: ");
        Buffers.toString((StringBuilder)stringBuilder, null, (Buffer)this.textureCoordEnabled);
        stringBuilder.append("\n\t lightingEnabled: " + this.lightingEnabled);
        stringBuilder.append(", lightsEnabled: ");
        Buffers.toString((StringBuilder)stringBuilder, null, (Buffer)this.lightsEnabled);
        stringBuilder.append("\n\t, shaderProgramColor: " + this.shaderProgramColor);
        stringBuilder.append("\n\t, shaderProgramColorTexture2: " + this.shaderProgramColorTexture2);
        stringBuilder.append("\n\t, shaderProgramColorTexture4: " + this.shaderProgramColorTexture4);
        stringBuilder.append("\n\t, shaderProgramColorTexture8: " + this.shaderProgramColorTexture8);
        stringBuilder.append("\n\t, shaderProgramColorLight: " + this.shaderProgramColorLight);
        stringBuilder.append("\n\t, shaderProgramColorTexture8Light: " + this.shaderProgramColorTexture8Light);
        stringBuilder.append("\n\t, ShaderState: ");
        this.shaderState.toString(stringBuilder, bl);
        stringBuilder.append("]");
        return stringBuilder;
    }

    public String toString() {
        return this.toString(null, DEBUG).toString();
    }

    private final void customizeShader(GL2ES2 gL2ES2, ShaderCode shaderCode, ShaderCode shaderCode2, String string) {
        int n = shaderCode.defaultShaderCustomization(gL2ES2, true, true);
        int n2 = shaderCode2.defaultShaderCustomization(gL2ES2, true, true);
        shaderCode.insertShaderSource(0, n, string);
        shaderCode2.insertShaderSource(0, n2, string);
    }

    private final void loadShaderPoints(GL2ES2 gL2ES2) {
        if (null != this.shaderProgramPoints) {
            return;
        }
        ShaderCode shaderCode = ShaderCode.create(gL2ES2, 35633, this.shaderRootClass, this.shaderSrcRoot, this.shaderBinRoot, shaderPointFileDef, true);
        ShaderCode shaderCode2 = ShaderCode.create(gL2ES2, 35632, this.shaderRootClass, this.shaderSrcRoot, this.shaderBinRoot, shaderPointFileDef, true);
        this.customizeShader(gL2ES2, shaderCode, shaderCode2, constMaxTextures2);
        this.shaderProgramPoints = new ShaderProgram();
        this.shaderProgramPoints.add(shaderCode);
        this.shaderProgramPoints.add(shaderCode2);
        if (!this.shaderProgramPoints.link(gL2ES2, System.err)) {
            throw new GLException("Couldn't link VertexColor program: " + this.shaderProgramPoints);
        }
    }

    private final void loadShader(GL2ES2 gL2ES2, ShaderSelectionMode shaderSelectionMode) {
        boolean bl;
        boolean bl2 = ShaderSelectionMode.COLOR == shaderSelectionMode;
        boolean bl3 = ShaderSelectionMode.COLOR_TEXTURE2 == shaderSelectionMode;
        boolean bl4 = ShaderSelectionMode.COLOR_TEXTURE4 == shaderSelectionMode;
        boolean bl5 = ShaderSelectionMode.COLOR_TEXTURE8 == shaderSelectionMode;
        boolean bl6 = bl3 || bl4 || bl5;
        boolean bl7 = ShaderSelectionMode.COLOR_LIGHT_PER_VERTEX == shaderSelectionMode;
        boolean bl8 = bl = ShaderSelectionMode.COLOR_TEXTURE8_LIGHT_PER_VERTEX == shaderSelectionMode;
        if (null != this.shaderProgramColor && bl2 || null != this.shaderProgramColorTexture2 && bl3 || null != this.shaderProgramColorTexture4 && bl4 || null != this.shaderProgramColorTexture8 && bl5 || null != this.shaderProgramColorLight && bl7 || null != this.shaderProgramColorTexture8Light && bl) {
            return;
        }
        if (bl2) {
            ShaderCode shaderCode = ShaderCode.create(gL2ES2, 35633, this.shaderRootClass, this.shaderSrcRoot, this.shaderBinRoot, this.vertexColorFile, true);
            ShaderCode shaderCode2 = ShaderCode.create(gL2ES2, 35632, this.shaderRootClass, this.shaderSrcRoot, this.shaderBinRoot, this.fragmentColorFile, true);
            this.customizeShader(gL2ES2, shaderCode, shaderCode2, constMaxTextures0);
            this.shaderProgramColor = new ShaderProgram();
            this.shaderProgramColor.add(shaderCode);
            this.shaderProgramColor.add(shaderCode2);
            if (!this.shaderProgramColor.link(gL2ES2, System.err)) {
                throw new GLException("Couldn't link VertexColor program: " + this.shaderProgramColor);
            }
        } else if (bl6) {
            ShaderCode shaderCode = ShaderCode.create(gL2ES2, 35633, this.shaderRootClass, this.shaderSrcRoot, this.shaderBinRoot, this.vertexColorFile, true);
            ShaderCode shaderCode3 = ShaderCode.create(gL2ES2, 35632, this.shaderRootClass, this.shaderSrcRoot, this.shaderBinRoot, this.fragmentColorTextureFile, true);
            if (bl3) {
                this.customizeShader(gL2ES2, shaderCode, shaderCode3, constMaxTextures2);
                this.shaderProgramColorTexture2 = new ShaderProgram();
                this.shaderProgramColorTexture2.add(shaderCode);
                this.shaderProgramColorTexture2.add(shaderCode3);
                if (!this.shaderProgramColorTexture2.link(gL2ES2, System.err)) {
                    throw new GLException("Couldn't link VertexColorTexture2 program: " + this.shaderProgramColorTexture2);
                }
            } else if (bl4) {
                this.customizeShader(gL2ES2, shaderCode, shaderCode3, constMaxTextures4);
                this.shaderProgramColorTexture4 = new ShaderProgram();
                this.shaderProgramColorTexture4.add(shaderCode);
                this.shaderProgramColorTexture4.add(shaderCode3);
                if (!this.shaderProgramColorTexture4.link(gL2ES2, System.err)) {
                    throw new GLException("Couldn't link VertexColorTexture4 program: " + this.shaderProgramColorTexture4);
                }
            } else if (bl5) {
                this.customizeShader(gL2ES2, shaderCode, shaderCode3, constMaxTextures8);
                this.shaderProgramColorTexture8 = new ShaderProgram();
                this.shaderProgramColorTexture8.add(shaderCode);
                this.shaderProgramColorTexture8.add(shaderCode3);
                if (!this.shaderProgramColorTexture8.link(gL2ES2, System.err)) {
                    throw new GLException("Couldn't link VertexColorTexture8 program: " + this.shaderProgramColorTexture8);
                }
            }
        } else if (bl7) {
            ShaderCode shaderCode = ShaderCode.create(gL2ES2, 35633, this.shaderRootClass, this.shaderSrcRoot, this.shaderBinRoot, this.vertexColorLightFile, true);
            ShaderCode shaderCode4 = ShaderCode.create(gL2ES2, 35632, this.shaderRootClass, this.shaderSrcRoot, this.shaderBinRoot, this.fragmentColorFile, true);
            this.customizeShader(gL2ES2, shaderCode, shaderCode4, constMaxTextures0);
            this.shaderProgramColorLight = new ShaderProgram();
            this.shaderProgramColorLight.add(shaderCode);
            this.shaderProgramColorLight.add(shaderCode4);
            if (!this.shaderProgramColorLight.link(gL2ES2, System.err)) {
                throw new GLException("Couldn't link VertexColorLight program: " + this.shaderProgramColorLight);
            }
        } else if (bl) {
            ShaderCode shaderCode = ShaderCode.create(gL2ES2, 35633, this.shaderRootClass, this.shaderSrcRoot, this.shaderBinRoot, this.vertexColorLightFile, true);
            ShaderCode shaderCode5 = ShaderCode.create(gL2ES2, 35632, this.shaderRootClass, this.shaderSrcRoot, this.shaderBinRoot, this.fragmentColorTextureFile, true);
            this.customizeShader(gL2ES2, shaderCode, shaderCode5, constMaxTextures8);
            this.shaderProgramColorTexture8Light = new ShaderProgram();
            this.shaderProgramColorTexture8Light.add(shaderCode);
            this.shaderProgramColorTexture8Light.add(shaderCode5);
            if (!this.shaderProgramColorTexture8Light.link(gL2ES2, System.err)) {
                throw new GLException("Couldn't link VertexColorLight program: " + this.shaderProgramColorTexture8Light);
            }
        }
    }

    private ShaderProgram selectShaderProgram(GL2ES2 gL2ES2, ShaderSelectionMode shaderSelectionMode) {
        ShaderProgram shaderProgram;
        if (ShaderSelectionMode.AUTO == shaderSelectionMode) {
            shaderSelectionMode = ShaderSelectionMode.COLOR;
        }
        this.loadShader(gL2ES2, shaderSelectionMode);
        switch (shaderSelectionMode) {
            case COLOR_LIGHT_PER_VERTEX: {
                shaderProgram = this.shaderProgramColorLight;
                break;
            }
            case COLOR_TEXTURE2: {
                shaderProgram = this.shaderProgramColorTexture2;
                break;
            }
            case COLOR_TEXTURE4: {
                shaderProgram = this.shaderProgramColorTexture4;
                break;
            }
            case COLOR_TEXTURE8: {
                shaderProgram = this.shaderProgramColorTexture8;
                break;
            }
            case COLOR_TEXTURE8_LIGHT_PER_VERTEX: {
                shaderProgram = this.shaderProgramColorTexture8Light;
                break;
            }
            default: {
                shaderProgram = this.shaderProgramColor;
            }
        }
        this.currentShaderSelectionMode = shaderSelectionMode;
        return shaderProgram;
    }

    private void init(GL2ES2 gL2ES2, ShaderSelectionMode shaderSelectionMode, PMVMatrix pMVMatrix) {
        int n;
        if (null == pMVMatrix) {
            throw new GLException("PMVMatrix is null");
        }
        this.pmvMatrix = pMVMatrix;
        this.requestedShaderSelectionMode = shaderSelectionMode;
        this.shaderState = new ShaderState();
        this.shaderState.setVerbose(this.verbose);
        this.shaderState.attachShaderProgram(gL2ES2, this.selectShaderProgram(gL2ES2, this.requestedShaderSelectionMode), true);
        if (!this.shaderState.uniform(gL2ES2, new GLUniformData(mgl_PMVMatrix, 4, 4, pMVMatrix.getSyncPMvMviMvitMat()))) {
            throw new GLException("Error setting PMVMatrix in shader: " + this);
        }
        this.shaderState.uniform(gL2ES2, new GLUniformData(mgl_ColorEnabled, 0));
        this.shaderState.uniform(gL2ES2, new GLUniformData(mgl_ColorStatic, 4, this.colorStatic));
        this.texID2Format.setKeyNotFoundValue(0);
        this.shaderState.uniform(gL2ES2, new GLUniformData(mgl_TexCoordEnabled, 1, this.textureCoordEnabled));
        this.shaderState.uniform(gL2ES2, new GLUniformData(mgl_TexEnvMode, 1, this.textureEnvMode));
        this.shaderState.uniform(gL2ES2, new GLUniformData(mgl_TexFormat, 1, this.textureFormat));
        this.shaderState.uniform(gL2ES2, new GLUniformData(mgl_TextureEnabled, 1, this.textureEnabled));
        for (n = 0; n < 8; ++n) {
            this.shaderState.uniform(gL2ES2, new GLUniformData(mgl_Texture + n, n));
        }
        this.shaderState.uniform(gL2ES2, new GLUniformData(mgl_ShadeModel, 0));
        this.shaderState.uniform(gL2ES2, new GLUniformData(mgl_AlphaTestFunc, this.alphaTestFunc));
        this.shaderState.uniform(gL2ES2, new GLUniformData(mgl_AlphaTestRef, this.alphaTestRef));
        this.shaderState.uniform(gL2ES2, new GLUniformData(mgl_PointParams, 4, this.pointParams));
        for (n = 0; n < 8; ++n) {
            this.shaderState.uniform(gL2ES2, new GLUniformData("mgl_LightSource[" + n + "].ambient", 4, defAmbient));
            this.shaderState.uniform(gL2ES2, new GLUniformData("mgl_LightSource[" + n + "].diffuse", 4, 0 == n ? one4f : defDiffuseN));
            this.shaderState.uniform(gL2ES2, new GLUniformData("mgl_LightSource[" + n + "].specular", 4, 0 == n ? one4f : defSpecularN));
            this.shaderState.uniform(gL2ES2, new GLUniformData("mgl_LightSource[" + n + "].position", 4, defPosition));
            this.shaderState.uniform(gL2ES2, new GLUniformData("mgl_LightSource[" + n + "].spotDirection", 3, defSpotDir));
            this.shaderState.uniform(gL2ES2, new GLUniformData("mgl_LightSource[" + n + "].spotExponent", 0.0f));
            this.shaderState.uniform(gL2ES2, new GLUniformData("mgl_LightSource[" + n + "].spotCutoff", 180.0f));
            this.shaderState.uniform(gL2ES2, new GLUniformData("mgl_LightSource[" + n + "].constantAttenuation", 1.0f));
            this.shaderState.uniform(gL2ES2, new GLUniformData("mgl_LightSource[" + n + "].linearAttenuation", 0.0f));
            this.shaderState.uniform(gL2ES2, new GLUniformData("mgl_LightSource[" + n + "].quadraticAttenuation", 0.0f));
        }
        this.shaderState.uniform(gL2ES2, new GLUniformData("mgl_LightModel.ambient", 4, defLightModelAmbient));
        this.shaderState.uniform(gL2ES2, new GLUniformData(mgl_LightsEnabled, 1, this.lightsEnabled));
        this.shaderState.uniform(gL2ES2, new GLUniformData("mgl_FrontMaterial.ambient", 4, defMatAmbient));
        this.shaderState.uniform(gL2ES2, new GLUniformData("mgl_FrontMaterial.diffuse", 4, defMatDiffuse));
        this.shaderState.uniform(gL2ES2, new GLUniformData("mgl_FrontMaterial.specular", 4, defMatSpecular));
        this.shaderState.uniform(gL2ES2, new GLUniformData("mgl_FrontMaterial.emission", 4, defMatEmission));
        this.shaderState.uniform(gL2ES2, new GLUniformData("mgl_FrontMaterial.shininess", 0.0f));
        this.shaderState.useProgram(gL2ES2, false);
        if (this.verbose) {
            System.err.println("init: " + this.toString(null, DEBUG).toString());
        }
    }

    private String toHexString(int n) {
        return "0x" + Integer.toHexString(n);
    }

    static {
        Debug.initSingleton();
        DEBUG = PropertyAccess.isPropertyDefined((String)"jogl.debug.FixedFuncPipeline", (boolean)true);
        glDrawArraysAction = new GLRunnable2<Object, Object>(){

            @Override
            public Object run(GL gL, Object object) {
                int[] nArray = (int[])object;
                gL.glDrawArrays(0, nArray[0], nArray[1]);
                return null;
            }
        };
        neut4f = Buffers.newDirectFloatBuffer((float[])new float[]{0.0f, 0.0f, 0.0f, 1.0f});
        one4f = Buffers.newDirectFloatBuffer((float[])new float[]{1.0f, 1.0f, 1.0f, 1.0f});
        defAmbient = neut4f;
        defDiffuseN = neut4f;
        defSpecularN = neut4f;
        defPosition = Buffers.newDirectFloatBuffer((float[])new float[]{0.0f, 0.0f, 1.0f, 0.0f});
        defSpotDir = Buffers.newDirectFloatBuffer((float[])new float[]{0.0f, 0.0f, -1.0f});
        defLightModelAmbient = Buffers.newDirectFloatBuffer((float[])new float[]{0.2f, 0.2f, 0.2f, 1.0f});
        defMatAmbient = Buffers.newDirectFloatBuffer((float[])new float[]{0.2f, 0.2f, 0.2f, 1.0f});
        defMatDiffuse = Buffers.newDirectFloatBuffer((float[])new float[]{0.8f, 0.8f, 0.8f, 1.0f});
        defMatSpecular = neut4f;
        defMatEmission = neut4f;
    }
}

