# frozen_string_literal: true

# The code was auto-generated by {this script}[https://github.com/cucumber/messages/blob/main/codegen/codegen.rb]
module Cucumber
  module Messages
    ##
    # Represents the TestStepResult message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    ##
    ##
    class TestStepResult < Message
      attr_reader :duration

      ##
      # An arbitrary bit of information that explains this result. This can be a stack trace of anything else.
      ##
      attr_reader :message

      attr_reader :status

      ##
      # Exception thrown while executing this step, if any.
      ##
      attr_reader :exception

      def initialize(
        duration: Duration.new,
        message: nil,
        status: TestStepResultStatus::UNKNOWN,
        exception: nil
      )
        @duration = duration
        @message = message
        @status = status
        @exception = exception
        super()
      end

      ##
      # Returns a new TestStepResult from the given hash.
      # If the hash keys are camelCased, they are properly assigned to the
      # corresponding snake_cased attributes.
      #
      #   Cucumber::Messages::TestStepResult.from_h(some_hash) # => #<Cucumber::Messages::TestStepResult:0x... ...>
      ##
      def self.from_h(hash)
        return nil if hash.nil?

        new(
          duration: Duration.from_h(hash[:duration]),
          message: hash[:message],
          status: hash[:status],
          exception: Exception.from_h(hash[:exception])
        )
      end
    end
  end
end
