/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.drawing.svg;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.klimt.ClipContainer;
import net.sourceforge.plantuml.klimt.UClip;
import net.sourceforge.plantuml.klimt.UParam;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorGradient;
import net.sourceforge.plantuml.klimt.drawing.UDriver;
import net.sourceforge.plantuml.klimt.drawing.svg.SvgGraphics;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.FontStyle;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.font.UFontContext;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.UText;

public class DriverTextSvg
implements UDriver<UText, SvgGraphics> {
    private final StringBounder stringBounder;
    private final ClipContainer clipContainer;

    public DriverTextSvg(StringBounder stringBounder, ClipContainer clipContainer) {
        if (stringBounder == null) {
            System.err.println("stringBounder=" + stringBounder);
        }
        this.stringBounder = stringBounder;
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UText shape, double x, double y, ColorMapper mapper, UParam param, SvgGraphics svg) {
        String text;
        UClip clip = this.clipContainer.getClip();
        if (clip != null && !clip.isInside(x, y)) {
            return;
        }
        FontConfiguration fontConfiguration = shape.getFontConfiguration();
        if (fontConfiguration.getColor().isTransparent()) {
            return;
        }
        UFont font = fontConfiguration.getFont();
        String fontWeight = null;
        if (fontConfiguration.containsStyle(FontStyle.BOLD) || font.isBold()) {
            fontWeight = "bold";
        }
        String fontStyle = null;
        if (fontConfiguration.containsStyle(FontStyle.ITALIC) || font.isItalic()) {
            fontStyle = "italic";
        }
        if ((text = shape.getText()).matches("^\\s*$")) {
            text = text.replace(' ', '\u00a0');
        }
        if (text.startsWith(" ")) {
            double space = this.stringBounder.calculateDimension(font, " ").getWidth();
            while (text.startsWith(" ")) {
                x += space;
                text = text.substring(1);
            }
        }
        text = StringUtils.trin(text);
        XDimension2D dim = this.stringBounder.calculateDimension(font, text);
        double width = dim.getWidth();
        double height = dim.getHeight();
        HColor extraLine = null;
        double deltaLineY = 0.0;
        String textDecoration = null;
        if (fontConfiguration.containsStyle(FontStyle.UNDERLINE) && fontConfiguration.getUnderlineStroke().getThickness() > 0.0) {
            if (fontConfiguration.getExtendedColor() == null) {
                textDecoration = "underline";
            } else {
                extraLine = fontConfiguration.getExtendedColor();
                deltaLineY = font.getSize2D() / 14.0;
            }
        } else if (fontConfiguration.containsStyle(FontStyle.STRIKE)) {
            if (fontConfiguration.getExtendedColor() == null) {
                textDecoration = "line-through";
            } else {
                extraLine = fontConfiguration.getExtendedColor();
                deltaLineY = -font.getSize2D() / 4.0;
            }
        } else if (fontConfiguration.containsStyle(FontStyle.WAVE)) {
            textDecoration = "wavy underline";
        }
        String backColor = null;
        if (fontConfiguration.containsStyle(FontStyle.BACKCOLOR)) {
            HColor back = fontConfiguration.getExtendedColor();
            if (back instanceof HColorGradient) {
                HColorGradient gr = (HColorGradient)back;
                String id = svg.createSvgGradient(gr.getColor1().toRGB(mapper), gr.getColor2().toRGB(mapper), gr.getPolicy());
                svg.setFillColor("url(#" + id + ")");
                svg.setStrokeColor(null);
                double deltaPatch = 2.0;
                svg.svgRectangle(x, y - height + 2.0, width, height, 0.0, 0.0, 0.0);
            } else {
                backColor = back.toRGB(mapper);
            }
        }
        HColor textColor = fontConfiguration.getColor();
        svg.setFillColor(textColor.toSvg(mapper));
        svg.text(text, x, y, font.getFamily(UFontContext.SVG), font.getSize(), fontWeight, fontStyle, textDecoration, width, fontConfiguration.getAttributes(), backColor);
        if (extraLine != null) {
            svg.setStrokeColor(extraLine.toSvg(mapper));
            svg.setStrokeWidth(font.getSize2D() / 28.0, null);
            svg.svgLine(x, y + deltaLineY, x + width, y + deltaLineY, 0.0);
        }
    }
}

