-- Copyright © 2008-2025 Pioneer Developers. See AUTHORS.txt for details
-- Licensed under the terms of the GPL v3. See licenses/GPL-3.txt

-- Albanian names

-- References
-- https://en.wikipedia.org/wiki/Albanian_name
-- https://en.wikipedia.org/wiki/Category:Albanian-language_surnames
-- https://en.wikipedia.org/wiki/Category:Albanian_masculine_given_names
-- https://en.wikipedia.org/wiki/Category:Albanian_feminine_given_names
-- https://github.com/Ninble/name-census-top-100 (GPL-3.0)

local CultureName = require './common'

local male = {
    "Adi",
    "Adrian",
    "Agim",
    "Agron",
    "Albert",
    "Aldo",
    "Aleksander",
    "Alija",
    "Alban",
    "Albi",
    "Alfred",
    "Altin",
    "Alvin",
    "Amarildo",
    "Andi",
    "Andon",
    "Anton",
    "Arben",
    "Arber",
    "Ardi",
    "Ardian",
    "Ardit",
    "Argjend",
    "Arjan",
    "Arlind",
    "Armand",
    "Armando",
    "Armend",
    "Artion",
    "Artur",
    "Artan",
    "Astrit",
    "Avni",
    "Azem",
    "Bardhyl",
    "Bashkim",
    "Bedri",
    "Bekim",
    "Berat",
    "Besim",
    "Besmir",
    "Besnik",
    "Bledar",
    "Bledi",
    "Blendi",
    "Blerim",
    "Bruno",
    "Bujar",
    "Burim",
    "Daniel",
    "Dardan",
    "Dashamir",
    "Denis",
    "Dhimitër",
    "Donald",
    "Dorian",
    "Dren",
    "Drilon",
    "Dritan",
    "Džemal",
    "Edi",
    "Edison",
    "Edmond",
    "Eduard",
    "Eduart",
    "Egli",
    "Elion",
    "Elton",
    "Elvin",
    "Elvir",
    "Elvis",
    "Endri",
    "Endrit",
    "Erald",
    "Eraldo",
    "Ergys",
    "Erind",
    "Ermal",
    "Ermin",
    "Ermir",
    "Erion",
    "Erjon",
    "Ervin",
    "Ervis",
    "Fabian",
    "Fatjon",
    "Fatos",
    "Fatmir",
    "Faton",
    "Fisnik",
    "Flamur",
    "Florian",
    "Flori",
    "Florent",
    "Florenc",
    "Gazmend",
    "Gentian",
    "Genti",
    "Getoar",
    "Gezim",
    "Gëzim",
    "Gjergj",
    "Gjergji",
    "Gjin",
    "Gjon",
    "Haki",
    "Halit",
    "Haxhi",
    "Helidon",
    "Hysen",
    "Hysni",
    "Igli",
    "Ilir",
    "Ilirjan",
    "Indrit",
    "Irvin",
    "Ismail",
    "Jahja",
    "Jon",
    "Jona",
    "Jonuz",
    "Julian",
    "Jurgen",
    "Kadri",
    "Karlo",
    "Kastriot",
    "Kevin",
    "Klajdi",
    "Klaudio",
    "Klodian",
    "Kolë",
    "Korab",
    "Kostandin",
    "Klevis",
    "Kristaq",
    "Kristo",
    "Kreshnik",
    "Ledio",
    "Lefter",
    "Leka",
    "Leonard",
    "Leonidha",
    "Lesh",
    "Liridon",
    "Lirim",
    "Llazar",
    "Lorenc",
    "Lorik",
    "Luan",
    "Lulzim",
    "Mario",
    "Mariglen",
    "Marsel",
    "Mateos",
    "Mërgim",
    "Mehmet",
    "Migen",
    "Mihal",
    "Muhamet",
    "Namik",
    "Ndoc",
    "Ndriçim",
    "Ndue",
    "Nexhmedin",
    "Niko",
    "Nikolla",
    "Nikollë",
    "Oltion",
    "Omar",
    "Olsi",
    "Orgest",
    "Pandi",
    "Petrit",
    "Përparim",
    "Pjetër",
    "Pirro",
    "Qemal",
    "Rajmond",
    "Rasih",
    "Redi",
    "Rei",
    "Renato",
    "Rexhep",
    "Robert",
    "Roland",
    "Saimir",
    "Serxhio",
    "Shkelzen",
    "Shkëlzen",
    "Shkodran",
    "Shpend",
    "Shpëtim",
    "Shqiprim",
    "Shtjefën",
    "Shyqyri",
    "Skender",
    "Skënder",
    "Sokol",
    "Stavri",
    "Tanush",
    "Taulant",
    "Teodor",
    "Thanas",
    "Toni",
    "Tonibler",
    "Valmir",
    "Valon",
    "Vasillaq",
    "Vedat",
    "Visar",
    "Xhafer",
    "Xhelal",
    "Xhevahir",
    "Xhevdet",
    "Ylli",
    "Ymer",
    "Zef",
}

local female = {
    "Ada",
    "Adela",
    "Aida",
    "Alda",
    "Alba",
    "Albana",
    "Albania",
    "Albulena",
    "Alma",
    "Ana",
    "Ani",
    "Angela",
    "Anila",
    "Anna",
    "Anisa",
    "Anxhela",
    "Arlinda",
    "Armela",
    "Arta",
    "Aurora",
    "Besi",
    "Blerina",
    "Blerta",
    "Brunilda",
    "Daniela",
    "Dea",
    "Denada",
    "Denisa",
    "Diana",
    "Dorina",
    "Dori",
    "Drita",
    "Eda",
    "Edlira",
    "Egi",
    "Ela",
    "Elda",
    "Elena",
    "Elisa",
    "Elsa",
    "Enea",
    "Eneida",
    "Eni",
    "Entela",
    "Enxhi",
    "Eri",
    "Erinda",
    "Erisa",
    "Ermira",
    "Erjona",
    "Esi",
    "Esma",
    "Esmeralda",
    "Eva",
    "Evis",
    "Fatima",
    "Ferial",
    "Feride",
    "Fjolla",
    "Gerta",
    "Gerti",
    "Geri",
    "Gonxha",
    "Greta",
    "Hana",
    "Ilda",
    "Iva",
    "Ina",
    "Irena",
    "Iris",
    "Irina",
    "Joana",
    "Juli",
    "Kejsi",
    "Klaudia",
    "Klea",
    "Klevi",
    "Kristi",
    "Kristina",
    "Linda",
    "Lindita",
    "Liza",
    "Lorena",
    "Luiza",
    "Luljeta",
    "Majlinda",
    "Manjola",
    "Margarita",
    "Maria",
    "Matilda",
    "Megi",
    "Migena",
    "Mirela",
    "Miri",
    "Monika",
    "Nadia",
    "Olga",
    "Olta",
    "Ornela",
    "Rita",
    "Romina",
    "Ronela",
    "Rovena",
    "Rudina",
    "Sabina",
    "Sara",
    "Sarah",
    "Sidorela",
    "Silva",
    "Silvi",
    "Silvana",
    "Sindi",
    "Sonila",
    "Stela",
    "Suela",
    "Tea",
    "Teuta",
    "Valbona",
    "Venera",
    "Veronica",
    "Violeta",
    "Yllka",
}

local surname = {
    "Abazi",
    "Arapi",
    "Balla",
    "Balliu",
    "Bardhi",
    "Basha",
    "Begu",
    "Bektashi",
    "Beqiri",
    "Berisha",
    "Braho",
    "Brahimi",
    "Bushi",
    "Cani",
    "Caushi",
    "Çami",
    "çela",
    "Curri",
    "Daci",
    "Deda",
    "Dema",
    "Delvina",
    "Demiri",
    "Dervishi",
    "Dibra",
    "Doci",
    "Domi",
    "Duka",
    "Duro",
    "Elezi",
    "Frashëri",
    "Gashi",
    "Gega",
    "Gegaj",
    "Gjergji",
    "Gjika",
    "Gjini",
    "Gjoka",
    "Gjoni",
    "Gjonaj",
    "Hajdari",
    "Halili",
    "Hasa",
    "Hasani",
    "Hasanaj",
    "Hoti",
    "Hoxha",
    "Hoxhaj",
    "Hysa",
    "Hysi",
    "Hyseni",
    "Ibrahimi",
    "Ismaili",
    "Isufi",
    "Karaj",
    "Kastrati",
    "Kelmendi",
    "Koci",
    "Kodra",
    "Koka",
    "Kola",
    "Kolla",
    "Koroveshi",
    "Kraja",
    "Krasniqi",
    "Kristi",
    "Kristo",
    "Kuqi",
    "Kuka",
    "Kurti",
    "Laçi",
    "Laci",
    "Lala",
    "Leka",
    "Lekaj",
    "Lika",
    "Lila",
    "Lleshi",
    "Luka",
    "Malaj",
    "Marku",
    "Mema",
    "Mehmeti",
    "Meta",
    "Metaj",
    "Morina",
    "Muca",
    "Mucaj",
    "Muka",
    "Murati",
    "Mustafa",
    "Ndreu",
    "Nikolli",
    "Nikolla",
    "Osmani",
    "Përmeti",
    "Pjetri",
    "Plaku",
    "Prendi",
    "Prishtina",
    "Prifti",
    "Qose",
    "Rama",
    "Rexhepi",
    "Ruci",
    "Shabani",
    "Shala",
    "Shehu",
    "Shkodra",
    "Shkreli",
    "Shyti",
    "Sina",
    "Sinani",
    "Spahiu",
    "Stafa",
    "Sula",
    "Sulaj",
    "Tabaku",
    "Tafa",
    "Tahiri",
    "Thanasi",
    "Topalli",
    "Toska",
    "Toskaj",
    "Zeneli",
}

local Albanian = CultureName.New({
    male = male,
    female = female,
    surname = surname,
    name = "Albanian",
    code = "sq", -- ISO 639-1 code for Albanian
    replace = { -- Albanian uses some special characters like ç, ë
        ['ç'] = 'c', ['Ç'] = 'C',
        ['ë'] = 'e', ['Ë'] = 'E',
    }
})

return Albanian
