import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { ListDistributionsByWebACLIdResultFilterSensitiveLog, } from "../models/models_1";
import { de_ListDistributionsByWebACLIdCommand, se_ListDistributionsByWebACLIdCommand } from "../protocols/Aws_restXml";
export { $Command };
export class ListDistributionsByWebACLIdCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("Cloudfront2020_05_31", "ListDistributionsByWebACLId", {})
    .n("CloudFrontClient", "ListDistributionsByWebACLIdCommand")
    .f(void 0, ListDistributionsByWebACLIdResultFilterSensitiveLog)
    .ser(se_ListDistributionsByWebACLIdCommand)
    .de(de_ListDistributionsByWebACLIdCommand)
    .build() {
}
