import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { GetFunctionResultFilterSensitiveLog } from "../models/models_1";
import { de_GetFunctionCommand, se_GetFunctionCommand } from "../protocols/Aws_restXml";
export { $Command };
export class GetFunctionCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("Cloudfront2020_05_31", "GetFunction", {})
    .n("CloudFrontClient", "GetFunctionCommand")
    .f(void 0, GetFunctionResultFilterSensitiveLog)
    .ser(se_GetFunctionCommand)
    .de(de_GetFunctionCommand)
    .build() {
}
