/**
 * penguins-eggs
 *
 * Kernel management utilities
 * Handle vmlinuz and initramfs detection across different distributions
 */
/**
 * Kernel utilities for managing vmlinuz and initramfs paths
 */
export default class Kernel {
    /**
     * Ricava path per vmlinuz
     *
     * @returns Path al file vmlinuz
     */
    static vmlinuz(kernel?: string): string;
    /**
     * Ricava path per initramfs/initrd
     *
     * @param kernel - Versione del kernel
     * @returns Path al file initramfs
     */
    static initramfs(kernel?: string): string;
    /**
     * ALL PRIVATE
     */
    /**
     * vmlinuxFromCmdline
     * BOOT_IMAGE=/boot/vmlinuz-5.16.0-3-amd64 root=UUID=13768873-d6ba-4ae5-9e14-b5011f5aa31c ro quiet splash resume=UUID=beafb9b4-c429-4e1f-a268-4270b63a14e6
     * se non è presente - come nel caso di Franco Conidi - lo ricostruisce da initrd
     */
    private static vmlinuxFromCmdline;
    /**
         *
         * @param kernel
         * @returns
         */
    private static vmLinuxFromFiles;
    /**
     * Rileva automaticamente il kernel dai moduli disponibili
     */
    private static detectKernelFromModules;
    /**
     * Ottiene il path per un kernel specifico
     */
    private static getSpecificKernelPath;
    /**
     * Trova la directory dei moduli del kernel
     */
    private static getKernelModulesPath;
    /**
     * Ottiene la lista dei kernel disponibili, ordinati
     */
    private static getAvailableKernels;
    /**
     * Gestisce il rilevamento del kernel per Arch Linux
     */
    private static getArchLinuxKernelPath;
    /**
     * Gestisce il path del kernel per Manjaro
     */
    private static getManjaroKernelPath;
    /**
     * Gestisce il path del kernel standard per Arch Linux
     */
    private static getStandardArchKernelPath;
    /**
     * Gestisce il kernel specifico per Arch Linux
     */
    private static getArchLinuxSpecificKernel;
    /**
     * Gestisce initramfs per Arch Linux
     */
    private static getArchInitramfs;
    /**
     * Lista i kernel disponibili in /boot per debugging
     */
    private static listAvailableKernels;
    /**
     * Lista gli initramfs disponibili in /boot per debugging
     */
    private static listAvailableInitramfs;
    /**
     * Ottiene informazioni sul kernel corrente
     */
    private static getCurrentKernelInfo;
}
