/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.AggregateBase;
import org.opensearch.client.opensearch._types.aggregations.AggregateVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class CumulativeCardinalityAggregate
extends AggregateBase
implements AggregateVariant,
ToCopyableBuilder<Builder, CumulativeCardinalityAggregate> {
    private final long value;
    @Nullable
    private final String valueAsString;
    public static final JsonpDeserializer<CumulativeCardinalityAggregate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CumulativeCardinalityAggregate::setupCumulativeCardinalityAggregateDeserializer);

    private CumulativeCardinalityAggregate(Builder builder) {
        super(builder);
        this.value = ApiTypeHelper.requireNonNull(builder.value, this, "value");
        this.valueAsString = builder.valueAsString;
    }

    public static CumulativeCardinalityAggregate of(Function<Builder, ObjectBuilder<CumulativeCardinalityAggregate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregate.Kind _aggregateKind() {
        return Aggregate.Kind.SimpleLongValue;
    }

    public final long value() {
        return this.value;
    }

    @Nullable
    public final String valueAsString() {
        return this.valueAsString;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("value");
        generator.write(this.value);
        if (this.valueAsString != null) {
            generator.writeKey("value_as_string");
            generator.write(this.valueAsString);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupCumulativeCardinalityAggregateDeserializer(ObjectDeserializer<Builder> op) {
        CumulativeCardinalityAggregate.setupAggregateBaseDeserializer(op);
        op.add(Builder::value, JsonpDeserializer.longDeserializer(), "value");
        op.add(Builder::valueAsString, JsonpDeserializer.stringDeserializer(), "value_as_string");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Long.hashCode(this.value);
        result = 31 * result + Objects.hashCode(this.valueAsString);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CumulativeCardinalityAggregate other = (CumulativeCardinalityAggregate)o;
        return this.value == other.value && Objects.equals(this.valueAsString, other.valueAsString);
    }

    public static class Builder
    extends AggregateBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, CumulativeCardinalityAggregate> {
        private Long value;
        @Nullable
        private String valueAsString;

        public Builder() {
        }

        private Builder(CumulativeCardinalityAggregate o) {
            super(o);
            this.value = o.value;
            this.valueAsString = o.valueAsString;
        }

        private Builder(Builder o) {
            super(o);
            this.value = o.value;
            this.valueAsString = o.valueAsString;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder value(long value) {
            this.value = value;
            return this;
        }

        @Nonnull
        public final Builder valueAsString(@Nullable String value) {
            this.valueAsString = value;
            return this;
        }

        @Override
        @Nonnull
        public CumulativeCardinalityAggregate build() {
            this._checkSingleUse();
            return new CumulativeCardinalityAggregate(this);
        }
    }
}

