/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.send;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.commons.authuser.User;
import org.opensearch.commons.destination.message.LegacyBaseMessage;
import org.opensearch.commons.destination.message.LegacyCustomWebhookMessage;
import org.opensearch.commons.destination.message.LegacyDestinationType;
import org.opensearch.commons.destination.message.LegacyEmailMessage;
import org.opensearch.commons.destination.response.LegacyDestinationResponse;
import org.opensearch.commons.notifications.action.LegacyPublishNotificationRequest;
import org.opensearch.commons.notifications.action.LegacyPublishNotificationResponse;
import org.opensearch.commons.notifications.action.SendNotificationRequest;
import org.opensearch.commons.notifications.action.SendNotificationResponse;
import org.opensearch.commons.notifications.model.Attachment;
import org.opensearch.commons.notifications.model.BaseConfigData;
import org.opensearch.commons.notifications.model.ChannelMessage;
import org.opensearch.commons.notifications.model.Chime;
import org.opensearch.commons.notifications.model.ConfigType;
import org.opensearch.commons.notifications.model.DeliveryStatus;
import org.opensearch.commons.notifications.model.Email;
import org.opensearch.commons.notifications.model.EmailGroup;
import org.opensearch.commons.notifications.model.EmailRecipient;
import org.opensearch.commons.notifications.model.EmailRecipientStatus;
import org.opensearch.commons.notifications.model.EventSource;
import org.opensearch.commons.notifications.model.EventStatus;
import org.opensearch.commons.notifications.model.MicrosoftTeams;
import org.opensearch.commons.notifications.model.NotificationConfig;
import org.opensearch.commons.notifications.model.NotificationEvent;
import org.opensearch.commons.notifications.model.SesAccount;
import org.opensearch.commons.notifications.model.Slack;
import org.opensearch.commons.notifications.model.SmtpAccount;
import org.opensearch.commons.notifications.model.Sns;
import org.opensearch.commons.notifications.model.Webhook;
import org.opensearch.commons.utils.HelpersKt;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.notifications.CoreProvider;
import org.opensearch.notifications.index.ConfigOperations;
import org.opensearch.notifications.metrics.Metrics;
import org.opensearch.notifications.model.NotificationConfigDocInfo;
import org.opensearch.notifications.security.UserAccess;
import org.opensearch.notifications.send.SendMessageActionHelper;
import org.opensearch.notifications.spi.model.DestinationMessageResponse;
import org.opensearch.notifications.spi.model.MessageContent;
import org.opensearch.notifications.spi.model.destination.BaseDestination;
import org.opensearch.notifications.spi.model.destination.ChimeDestination;
import org.opensearch.notifications.spi.model.destination.CustomWebhookDestination;
import org.opensearch.notifications.spi.model.destination.MicrosoftTeamsDestination;
import org.opensearch.notifications.spi.model.destination.SesDestination;
import org.opensearch.notifications.spi.model.destination.SlackDestination;
import org.opensearch.notifications.spi.model.destination.SmtpDestination;
import org.opensearch.notifications.spi.model.destination.SnsDestination;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00f2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0019H\u0086@\u00a2\u0006\u0002\u0010\u001aJ*\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0 H\u0082@\u00a2\u0006\u0002\u0010!J\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0 2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001e0$H\u0002J*\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0 H\u0082@\u00a2\u0006\u0002\u0010!J\u0010\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020(H\u0002J$\u0010)\u001a\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001c2\u0006\u0010*\u001a\u00020\u001dH\u0082@\u00a2\u0006\u0002\u0010+J\u0012\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020\u001eH\u0002J\u0016\u0010/\u001a\u0002002\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ(\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u0002022\u0006\u00107\u001a\u00020\u001dH\u0002J0\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u001d2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u001d2\u0006\u00105\u001a\u00020\u000e2\u0006\u00107\u001a\u00020\u001dH\u0002J0\u0010>\u001a\u0002092\u0006\u0010:\u001a\u00020\u001d2\u0006\u0010?\u001a\u00020@2\u0006\u0010=\u001a\u00020\u001d2\u0006\u00105\u001a\u00020\u000e2\u0006\u00107\u001a\u00020\u001dH\u0002JH\u0010A\u001a\u0002022\b\u0010B\u001a\u0004\u0018\u00010C2\u0006\u0010D\u001a\u00020E2\u0014\u0010F\u001a\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001c2\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u0002022\u0006\u00107\u001a\u00020\u001dH\u0002J \u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020J2\u0006\u00105\u001a\u00020\u000e2\u0006\u00107\u001a\u00020\u001dH\u0002JN\u0010K\u001a\u0002022\b\u0010B\u001a\u0004\u0018\u00010C2\u0006\u0010\u000f\u001a\u00020\u00102\u0014\u0010L\u001a\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u001e0M2\u0014\u0010F\u001a\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001c2\u0006\u00105\u001a\u00020\u000eH\u0002J\u0010\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020QH\u0002JT\u0010R\u001a\b\u0012\u0004\u0012\u0002020$2\b\u0010B\u001a\u0004\u0018\u00010C2\u0006\u0010\u000f\u001a\u00020\u00102\u0014\u0010S\u001a\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001c2\u0014\u0010F\u001a\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001c2\u0006\u00105\u001a\u00020\u000eH\u0002J(\u0010T\u001a\u0002022\u0006\u0010U\u001a\u00020V2\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u0002022\u0006\u00107\u001a\u00020\u001dH\u0002J(\u0010W\u001a\u0002022\u0006\u0010X\u001a\u00020Y2\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u0002022\u0006\u00107\u001a\u00020\u001dH\u0002J(\u0010Z\u001a\u0002022\u0006\u0010[\u001a\u00020\\2\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u0002022\u0006\u00107\u001a\u00020\u001dH\u0002J(\u0010]\u001a\u0002022\u0006\u0010^\u001a\u00020_2\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u0002022\u0006\u00107\u001a\u00020\u001dH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006`"}, d2={"Lorg/opensearch/notifications/send/SendMessageActionHelper;", "", "()V", "configOperations", "Lorg/opensearch/notifications/index/ConfigOperations;", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "userAccess", "Lorg/opensearch/notifications/security/UserAccess;", "createMessageContent", "Lorg/opensearch/notifications/spi/model/MessageContent;", "eventSource", "Lorg/opensearch/commons/notifications/model/EventSource;", "channelMessage", "Lorg/opensearch/commons/notifications/model/ChannelMessage;", "executeLegacyRequest", "Lorg/opensearch/commons/notifications/action/LegacyPublishNotificationResponse;", "request", "Lorg/opensearch/commons/notifications/action/LegacyPublishNotificationRequest;", "executeRequest", "Lorg/opensearch/commons/notifications/action/SendNotificationResponse;", "Lorg/opensearch/commons/notifications/action/SendNotificationRequest;", "(Lorg/opensearch/commons/notifications/action/SendNotificationRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAllConfigs", "", "", "Lorg/opensearch/notifications/model/NotificationConfigDocInfo;", "configIds", "", "(Ljava/util/Set;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getChildConfigIds", "channels", "", "getConfigs", "getJsonString", "xContent", "Lorg/opensearch/core/xcontent/ToXContent;", "getSingleConfig", "configId", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getStatusIfChannelIsNotEligibleToSendMessage", "Lorg/opensearch/commons/notifications/model/DeliveryStatus;", "channel", "initialize", "", "sendChimeMessage", "Lorg/opensearch/commons/notifications/model/EventStatus;", "chime", "Lorg/opensearch/commons/notifications/model/Chime;", "message", "eventStatus", "referenceId", "sendEmailFromSesAccount", "Lorg/opensearch/commons/notifications/model/EmailRecipientStatus;", "accountName", "sesAccount", "Lorg/opensearch/commons/notifications/model/SesAccount;", "recipient", "sendEmailFromSmtpAccount", "smtpAccount", "Lorg/opensearch/commons/notifications/model/SmtpAccount;", "sendEmailMessage", "user", "Lorg/opensearch/commons/authuser/User;", "email", "Lorg/opensearch/commons/notifications/model/Email;", "childConfigMap", "sendMessageThroughSpi", "Lorg/opensearch/notifications/spi/model/DestinationMessageResponse;", "destination", "Lorg/opensearch/notifications/spi/model/destination/BaseDestination;", "sendMessageToChannel", "channelEntry", "", "sendMessageToLegacyDestination", "Lorg/opensearch/commons/destination/response/LegacyDestinationResponse;", "baseMessage", "Lorg/opensearch/commons/destination/message/LegacyBaseMessage;", "sendMessagesInParallel", "channelMap", "sendMicrosoftTeamsMessage", "microsoftTeams", "Lorg/opensearch/commons/notifications/model/MicrosoftTeams;", "sendSNSMessage", "sns", "Lorg/opensearch/commons/notifications/model/Sns;", "sendSlackMessage", "slack", "Lorg/opensearch/commons/notifications/model/Slack;", "sendWebhookMessage", "webhook", "Lorg/opensearch/commons/notifications/model/Webhook;", "opensearch-notifications"})
@SourceDebugExtension(value={"SMAP\nSendMessageActionHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SendMessageActionHelper.kt\norg/opensearch/notifications/send/SendMessageActionHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,681:1\n1855#2,2:682\n766#2:698\n857#2,2:699\n1549#2:701\n1620#2,3:702\n1855#2,2:705\n766#2:707\n857#2,2:708\n1855#2,2:710\n1855#2,2:712\n1855#2,2:714\n494#3,7:684\n494#3,7:691\n494#3,7:716\n*S KotlinDebug\n*F\n+ 1 SendMessageActionHelper.kt\norg/opensearch/notifications/send/SendMessageActionHelper\n*L\n93#1:682,2\n463#1:698\n463#1:699,2\n464#1:701\n464#1:702,3\n508#1:705,2\n613#1:707\n613#1:708,2\n616#1:710,2\n649#1:712,2\n650#1:714,2\n458#1:684,7\n461#1:691,7\n652#1:716,7\n*E\n"})
public final class SendMessageActionHelper {
    @NotNull
    public static final SendMessageActionHelper INSTANCE = new SendMessageActionHelper();
    @NotNull
    private static final Lazy log$delegate = HelpersKt.logger(SendMessageActionHelper.class);
    private static ConfigOperations configOperations;
    private static UserAccess userAccess;

    private SendMessageActionHelper() {
    }

    private final Logger getLog() {
        Lazy lazy = log$delegate;
        return (Logger)lazy.getValue();
    }

    public final void initialize(@NotNull ConfigOperations configOperations, @NotNull UserAccess userAccess) {
        Intrinsics.checkNotNullParameter((Object)configOperations, (String)"configOperations");
        Intrinsics.checkNotNullParameter((Object)userAccess, (String)"userAccess");
        SendMessageActionHelper.configOperations = configOperations;
        SendMessageActionHelper.userAccess = userAccess;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object executeRequest(@NotNull SendNotificationRequest var1_1, @NotNull Continuation<? super SendNotificationResponse> var2_2) {
        if (!(var2_2 instanceof executeRequest.1)) ** GOTO lbl-1000
        var20_3 = var2_2;
        if ((var20_3.label & -2147483648) != 0) {
            var20_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ SendMessageActionHelper this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.executeRequest(null, (Continuation<? super SendNotificationResponse>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var21_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                eventSource = request.getEventSource();
                channelMessage = request.getChannelMessage();
                channelIds = CollectionsKt.toSet((Iterable)request.getChannelIds());
                user = User.parse((String)request.getThreadContext());
                v0 = SendMessageActionHelper.userAccess;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
                    v0 = null;
                }
                v0.validateUser(user);
                $continuation.L$0 = this;
                $continuation.L$1 = eventSource;
                $continuation.L$2 = channelMessage;
                $continuation.L$3 = user;
                $continuation.label = 1;
                v1 = this.getConfigs(channelIds, (Continuation<? super Map<String, NotificationConfigDocInfo>>)$continuation);
                if (v1 == var21_5) {
                    return var21_5;
                }
                ** GOTO lbl37
            }
            case 1: {
                user = (User)$continuation.L$3;
                channelMessage = (ChannelMessage)$continuation.L$2;
                eventSource = (EventSource)$continuation.L$1;
                this = (SendMessageActionHelper)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl37:
                // 2 sources

                channelMap = (Map)v1;
                $continuation.L$0 = this;
                $continuation.L$1 = eventSource;
                $continuation.L$2 = channelMessage;
                $continuation.L$3 = user;
                $continuation.L$4 = channelMap;
                $continuation.label = 2;
                v2 = this.getConfigs(this.getChildConfigIds(CollectionsKt.toList((Iterable)CollectionsKt.filterNotNull((Iterable)channelMap.values()))), (Continuation<? super Map<String, NotificationConfigDocInfo>>)$continuation);
                if (v2 == var21_5) {
                    return var21_5;
                }
                ** GOTO lbl56
            }
            case 2: {
                channelMap = (Map)$continuation.L$4;
                user = (User)$continuation.L$3;
                channelMessage = (ChannelMessage)$continuation.L$2;
                eventSource = (EventSource)$continuation.L$1;
                this = (SendMessageActionHelper)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl56:
                // 2 sources

                childConfigMap = (Map)v2;
                message = this.createMessageContent(eventSource, channelMessage);
                eventStatusList = this.sendMessagesInParallel(user, eventSource, channelMap, childConfigMap, message);
                event = new NotificationEvent(eventSource, eventStatusList);
                overallStatusCode = null;
                v3 = ((EventStatus)CollectionsKt.first(eventStatusList)).getDeliveryStatus();
                overallStatusCode = v3 != null ? v3.getStatusCode() : null;
                $this$forEach$iv = eventStatusList;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    eventStatus = (EventStatus)element$iv;
                    $i$a$-forEach-SendMessageActionHelper$executeRequest$2 = false;
                    v4 = eventStatus.getDeliveryStatus();
                    if (Intrinsics.areEqual((Object)(v4 != null ? v4.getStatusCode() : null), (Object)overallStatusCode)) continue;
                    overallStatusCode = String.valueOf(RestStatus.MULTI_STATUS.getStatus());
                }
                eventStatusListString = CollectionsKt.joinToString$default((Iterable)eventStatusList, (CharSequence)",", (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)executeRequest.eventStatusListString.1.INSTANCE, (int)24, null);
                if (!Intrinsics.areEqual((Object)overallStatusCode, (Object)String.valueOf(RestStatus.OK.getStatus()))) {
                    errorMessage = "{\"event_status_list\": " + eventStatusListString + "}";
                    v5 = overallStatusCode;
                    Intrinsics.checkNotNull((Object)v5);
                    throw new OpenSearchStatusException(errorMessage, RestStatus.fromCode((int)Integer.parseInt(v5)), new Object[0]);
                }
                return new SendNotificationResponse(event);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public final LegacyPublishNotificationResponse executeLegacyRequest(@NotNull LegacyPublishNotificationRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        LegacyBaseMessage baseMessage = request.getBaseMessage();
        Ref.ObjectRef response2 = new Ref.ObjectRef();
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Ref.ObjectRef<LegacyDestinationResponse>)response2, baseMessage, null){
            int label;
            final /* synthetic */ Ref.ObjectRef<LegacyDestinationResponse> $response;
            final /* synthetic */ LegacyBaseMessage $baseMessage;
            {
                this.$response = $response;
                this.$baseMessage = $baseMessage;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.$response.element = SendMessageActionHelper.access$sendMessageToLegacyDestination(SendMessageActionHelper.INSTANCE, this.$baseMessage);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        return new LegacyPublishNotificationResponse((LegacyDestinationResponse)response2.element);
    }

    private final MessageContent createMessageContent(EventSource eventSource, ChannelMessage channelMessage) {
        Attachment attachment = channelMessage.getAttachment();
        Attachment attachment2 = channelMessage.getAttachment();
        Attachment attachment3 = channelMessage.getAttachment();
        Attachment attachment4 = channelMessage.getAttachment();
        return new MessageContent(eventSource.getTitle(), channelMessage.getTextDescription(), channelMessage.getHtmlDescription(), attachment != null ? attachment.getFileName() : null, attachment2 != null ? attachment2.getFileEncoding() : null, attachment3 != null ? attachment3.getFileData() : null, attachment4 != null ? attachment4.getFileContentType() : null);
    }

    private final List<EventStatus> sendMessagesInParallel(User user, EventSource eventSource, Map<String, NotificationConfigDocInfo> channelMap, Map<String, NotificationConfigDocInfo> childConfigMap, MessageContent message) {
        Ref.ObjectRef statusList = new Ref.ObjectRef();
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(channelMap, (Ref.ObjectRef<List<EventStatus>>)statusList, user, eventSource, childConfigMap, message, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Map<String, NotificationConfigDocInfo> $channelMap;
            final /* synthetic */ Ref.ObjectRef<List<EventStatus>> $statusList;
            final /* synthetic */ User $user;
            final /* synthetic */ EventSource $eventSource;
            final /* synthetic */ Map<String, NotificationConfigDocInfo> $childConfigMap;
            final /* synthetic */ MessageContent $message;
            {
                this.$channelMap = $channelMap;
                this.$statusList = $statusList;
                this.$user = $user;
                this.$eventSource = $eventSource;
                this.$childConfigMap = $childConfigMap;
                this.$message = $message;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var18_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$runBlocking = (CoroutineScope)this.L$0;
                        var4_4 = this.$channelMap;
                        var5_5 = this.$user;
                        var6_6 = this.$eventSource;
                        var7_7 = this.$childConfigMap;
                        var8_8 = this.$message;
                        $i$f$map = false;
                        var10_10 = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                        $i$f$mapTo = false;
                        var13_13 = $this$mapTo$iv$iv.entrySet().iterator();
                        while (var13_13.hasNext()) {
                            var15_15 = item$iv$iv = var13_13.next();
                            var17_17 = destination$iv$iv;
                            $i$a$-map-SendMessageActionHelper$sendMessagesInParallel$1$statusDeferredList$1 = false;
                            var17_17.add((Deferred)BuildersKt.async$default((CoroutineScope)$this$runBlocking, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super EventStatus>, Object>(var5_5, var6_6, (Map.Entry<String, NotificationConfigDocInfo>)it, var7_7, var8_8, null){
                                int label;
                                final /* synthetic */ User $user;
                                final /* synthetic */ EventSource $eventSource;
                                final /* synthetic */ Map.Entry<String, NotificationConfigDocInfo> $it;
                                final /* synthetic */ Map<String, NotificationConfigDocInfo> $childConfigMap;
                                final /* synthetic */ MessageContent $message;
                                {
                                    this.$user = $user;
                                    this.$eventSource = $eventSource;
                                    this.$it = $it;
                                    this.$childConfigMap = $childConfigMap;
                                    this.$message = $message;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            return SendMessageActionHelper.access$sendMessageToChannel(SendMessageActionHelper.INSTANCE, this.$user, this.$eventSource, this.$it, this.$childConfigMap, this.$message);
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super EventStatus> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)2, null));
                        }
                        statusDeferredList = (List)destination$iv$iv;
                        this.L$0 = var17_17 = this.$statusList;
                        this.label = 1;
                        v0 = AwaitKt.awaitAll((Collection)statusDeferredList, (Continuation)((Continuation)this));
                        if (v0 == var18_2) {
                            return var18_2;
                        }
                        ** GOTO lbl34
                    }
                    case 1: {
                        var17_17 = (Ref.ObjectRef<List<EventStatus>>)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl34:
                        // 2 sources

                        var17_17.element = v0;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        return (List)statusList.element;
    }

    private final EventStatus sendMessageToChannel(User user, EventSource eventSource, Map.Entry<String, NotificationConfigDocInfo> channelEntry, Map<String, NotificationConfigDocInfo> childConfigMap, MessageContent message) {
        EventStatus eventStatus;
        Metrics.NOTIFICATIONS_SEND_MESSAGE_TOTAL.getCounter().increment();
        Metrics.NOTIFICATIONS_SEND_MESSAGE_INTERVAL_COUNT.getCounter().increment();
        if (channelEntry.getValue() == null) {
            Metrics.NOTIFICATIONS_SEND_MESSAGE_USER_ERROR_NOT_FOUND.getCounter().increment();
            return new EventStatus(channelEntry.getKey(), "invalid-config", ConfigType.NONE, CollectionsKt.emptyList(), new DeliveryStatus(String.valueOf(RestStatus.NOT_FOUND.getStatus()), "Channel " + channelEntry.getKey() + " not found"));
        }
        UserAccess userAccess = SendMessageActionHelper.userAccess;
        if (userAccess == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
            userAccess = null;
        }
        NotificationConfigDocInfo notificationConfigDocInfo = channelEntry.getValue();
        Intrinsics.checkNotNull((Object)notificationConfigDocInfo);
        if (!userAccess.doesUserHaveAccess(user, notificationConfigDocInfo.getConfigDoc().getMetadata().getAccess())) {
            Metrics.NOTIFICATIONS_PERMISSION_USER_ERROR.getCounter().increment();
            return new EventStatus(channelEntry.getKey(), "invalid-access", ConfigType.NONE, CollectionsKt.emptyList(), new DeliveryStatus(String.valueOf(RestStatus.FORBIDDEN.getStatus()), "Access denied for channel " + channelEntry.getKey()));
        }
        NotificationConfigDocInfo notificationConfigDocInfo2 = channelEntry.getValue();
        Intrinsics.checkNotNull((Object)notificationConfigDocInfo2);
        NotificationConfigDocInfo channel = notificationConfigDocInfo2;
        ConfigType configType = channel.getConfigDoc().getConfig().getConfigType();
        BaseConfigData configData = channel.getConfigDoc().getConfig().getConfigData();
        List emailRecipientStatus2 = CollectionsKt.emptyList();
        if (configType == ConfigType.EMAIL) {
            emailRecipientStatus2 = CollectionsKt.listOf((Object)new EmailRecipientStatus("placeholder@example.com", new DeliveryStatus("Scheduled", "Pending execution")));
        }
        String string = channel.getDocInfo().getId();
        Intrinsics.checkNotNull((Object)string);
        EventStatus eventStatus2 = new EventStatus(string, channel.getConfigDoc().getConfig().getName(), channel.getConfigDoc().getConfig().getConfigType(), emailRecipientStatus2, new DeliveryStatus("Scheduled", "Pending execution"));
        DeliveryStatus invalidStatus = this.getStatusIfChannelIsNotEligibleToSendMessage(channel);
        if (invalidStatus != null) {
            return EventStatus.copy$default((EventStatus)eventStatus2, null, null, null, null, (DeliveryStatus)invalidStatus, (int)15, null);
        }
        EventStatus response2 = switch (WhenMappings.$EnumSwitchMapping$0[configType.ordinal()]) {
            case 1 -> null;
            case 2 -> {
                Intrinsics.checkNotNull((Object)configData, (String)"null cannot be cast to non-null type org.opensearch.commons.notifications.model.Slack");
                yield this.sendSlackMessage((Slack)configData, message, eventStatus2, eventSource.getReferenceId());
            }
            case 3 -> {
                Intrinsics.checkNotNull((Object)configData, (String)"null cannot be cast to non-null type org.opensearch.commons.notifications.model.Chime");
                yield this.sendChimeMessage((Chime)configData, message, eventStatus2, eventSource.getReferenceId());
            }
            case 4 -> {
                Intrinsics.checkNotNull((Object)configData, (String)"null cannot be cast to non-null type org.opensearch.commons.notifications.model.MicrosoftTeams");
                yield this.sendMicrosoftTeamsMessage((MicrosoftTeams)configData, message, eventStatus2, eventSource.getReferenceId());
            }
            case 5 -> {
                Intrinsics.checkNotNull((Object)configData, (String)"null cannot be cast to non-null type org.opensearch.commons.notifications.model.Webhook");
                yield this.sendWebhookMessage((Webhook)configData, message, eventStatus2, eventSource.getReferenceId());
            }
            case 6 -> {
                Intrinsics.checkNotNull((Object)configData, (String)"null cannot be cast to non-null type org.opensearch.commons.notifications.model.Email");
                yield this.sendEmailMessage(user, (Email)configData, childConfigMap, message, eventStatus2, eventSource.getReferenceId());
            }
            case 7 -> null;
            case 8 -> null;
            case 9 -> null;
            case 10 -> {
                Intrinsics.checkNotNull((Object)configData, (String)"null cannot be cast to non-null type org.opensearch.commons.notifications.model.Sns");
                yield this.sendSNSMessage((Sns)configData, message, eventStatus2, eventSource.getReferenceId());
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        if (response2 == null) {
            this.getLog().warn("Cannot send message to destination for config id :" + channel.getDocInfo().getId());
            Metrics.NOTIFICATIONS_SEND_MESSAGE_USER_ERROR_NOT_FOUND.getCounter().increment();
            eventStatus = EventStatus.copy$default((EventStatus)eventStatus2, null, null, null, null, (DeliveryStatus)new DeliveryStatus("NOT_FOUND", "Channel not found"), (int)15, null);
        } else {
            eventStatus = response2;
        }
        return eventStatus;
    }

    private final LegacyDestinationResponse sendMessageToLegacyDestination(LegacyBaseMessage baseMessage) {
        Ref.ObjectRef message = new Ref.ObjectRef();
        String string = baseMessage.getMessageContent();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessageContent(...)");
        message.element = new MessageContent("Legacy Notification", string, null, null, null, null, null, 124, null);
        LegacyDestinationType legacyDestinationType = baseMessage.getChannelType();
        return switch (legacyDestinationType == null ? -1 : WhenMappings.$EnumSwitchMapping$1[legacyDestinationType.ordinal()]) {
            case 1 -> {
                String v2 = baseMessage.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getUrl(...)");
                SlackDestination destination = new SlackDestination(v2);
                DestinationMessageResponse status = this.sendMessageThroughSpi((BaseDestination)destination, (MessageContent)message.element, "legacy");
                LegacyDestinationResponse var3_10 = new LegacyDestinationResponse.Builder().withStatusCode(Integer.valueOf(status.getStatusCode())).withResponseContent(status.getStatusText()).build();
                Intrinsics.checkNotNull((Object)var3_10);
                yield var3_10;
            }
            case 2 -> {
                String v4 = baseMessage.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getUrl(...)");
                ChimeDestination destination = new ChimeDestination(v4);
                DestinationMessageResponse status = this.sendMessageThroughSpi((BaseDestination)destination, (MessageContent)message.element, "legacy");
                LegacyDestinationResponse var3_11 = new LegacyDestinationResponse.Builder().withStatusCode(Integer.valueOf(status.getStatusCode())).withResponseContent(status.getStatusText()).build();
                Intrinsics.checkNotNull((Object)var3_11);
                yield var3_11;
            }
            case 3 -> {
                Intrinsics.checkNotNull((Object)baseMessage, (String)"null cannot be cast to non-null type org.opensearch.commons.destination.message.LegacyCustomWebhookMessage");
                String v5 = ((LegacyCustomWebhookMessage)baseMessage).getUri().toString();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"toString(...)");
                Map v6 = ((LegacyCustomWebhookMessage)baseMessage).getHeaderParams();
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getHeaderParams(...)");
                String v7 = ((LegacyCustomWebhookMessage)baseMessage).getMethod();
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"getMethod(...)");
                CustomWebhookDestination destination = new CustomWebhookDestination(v5, v6, v7);
                DestinationMessageResponse status = this.sendMessageThroughSpi((BaseDestination)destination, (MessageContent)message.element, "legacy");
                LegacyDestinationResponse var3_12 = new LegacyDestinationResponse.Builder().withStatusCode(Integer.valueOf(status.getStatusCode())).withResponseContent(status.getStatusText()).build();
                Intrinsics.checkNotNull((Object)var3_12);
                yield var3_12;
            }
            case 4 -> {
                Intrinsics.checkNotNull((Object)baseMessage, (String)"null cannot be cast to non-null type org.opensearch.commons.destination.message.LegacyEmailMessage");
                List recipients = ((LegacyEmailMessage)baseMessage).getRecipients();
                String v8 = ((LegacyEmailMessage)baseMessage).getSubject();
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"getSubject(...)");
                String v9 = ((LegacyEmailMessage)baseMessage).getMessageContent();
                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"getMessageContent(...)");
                message.element = new MessageContent(v8, v9, null, null, null, null, null, 124, null);
                Object var3_13 = BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super LegacyDestinationResponse>, Object>((List<String>)recipients, baseMessage, (Ref.ObjectRef<MessageContent>)message, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ List<String> $recipients;
                    final /* synthetic */ LegacyBaseMessage $baseMessage;
                    final /* synthetic */ Ref.ObjectRef<MessageContent> $message;
                    {
                        this.$recipients = $recipients;
                        this.$baseMessage = $baseMessage;
                        this.$message = $message;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var16_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                $this$runBlocking = (CoroutineScope)this.L$0;
                                v0 = this.$recipients;
                                Intrinsics.checkNotNullExpressionValue(v0, (String)"$recipients");
                                var4_4 = v0;
                                var5_5 = this.$baseMessage;
                                var6_6 = this.$message;
                                $i$f$map = false;
                                var8_9 = $this$map$iv;
                                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    var13_17 = (String)item$iv$iv;
                                    var15_19 = destination$iv$iv;
                                    $i$a$-map-SendMessageActionHelper$sendMessageToLegacyDestination$1$emailRecipientStatus$1 = false;
                                    var15_19.add(BuildersKt.async$default((CoroutineScope)$this$runBlocking, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super EmailRecipientStatus>, Object>(var5_5, (String)it, var6_6, null){
                                        int label;
                                        final /* synthetic */ LegacyBaseMessage $baseMessage;
                                        final /* synthetic */ String $it;
                                        final /* synthetic */ Ref.ObjectRef<MessageContent> $message;
                                        {
                                            this.$baseMessage = $baseMessage;
                                            this.$it = $it;
                                            this.$message = $message;
                                            super(2, $completion);
                                        }

                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object object) {
                                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)object);
                                                    String string = ((LegacyEmailMessage)this.$baseMessage).getAccountName();
                                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAccountName(...)");
                                                    String string2 = ((LegacyEmailMessage)this.$baseMessage).getHost();
                                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getHost(...)");
                                                    int n = ((LegacyEmailMessage)this.$baseMessage).getPort();
                                                    String string3 = ((LegacyEmailMessage)this.$baseMessage).getMethod();
                                                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getMethod(...)");
                                                    String string4 = ((LegacyEmailMessage)this.$baseMessage).getFrom();
                                                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getFrom(...)");
                                                    String string5 = this.$it;
                                                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"$it");
                                                    SmtpDestination destination = new SmtpDestination(string, string2, n, string3, string4, string5);
                                                    DestinationMessageResponse status = SendMessageActionHelper.access$sendMessageThroughSpi(SendMessageActionHelper.INSTANCE, (BaseDestination)destination, (MessageContent)this.$message.element, "legacy");
                                                    String string6 = this.$it;
                                                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"$it");
                                                    return new EmailRecipientStatus(string6, new DeliveryStatus(String.valueOf(status.getStatusCode()), status.getStatusText()));
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        @NotNull
                                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        @Nullable
                                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super EmailRecipientStatus> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (int)2, null));
                                }
                                this.label = 1;
                                v1 = AwaitKt.awaitAll((Collection)((List)destination$iv$iv), (Continuation)((Continuation)this));
                                if (v1 == var16_2) {
                                    return var16_2;
                                }
                                ** GOTO lbl30
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl30:
                                // 2 sources

                                emailRecipientStatus = (List)v1;
                                firstStatus = (EmailRecipientStatus)CollectionsKt.first((List)emailRecipientStatus);
                                overallStatus = null;
                                overallStatus = firstStatus.getDeliveryStatus().getStatusCode();
                                overallStatusText = null;
                                overallStatusText = firstStatus.getDeliveryStatus().getStatusText();
                                $this$forEach$iv = emailRecipientStatus;
                                $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    it = (EmailRecipientStatus)element$iv;
                                    $i$a$-forEach-SendMessageActionHelper$sendMessageToLegacyDestination$1$1 = false;
                                    status = it.getDeliveryStatus();
                                    SendMessageActionHelper.access$getLog(SendMessageActionHelper.INSTANCE).info("notifications:Legacy email:statusCode=" + status.getStatusCode() + ", statusText=" + status.getStatusText());
                                    if (Intrinsics.areEqual((Object)overallStatus, (Object)status.getStatusCode())) continue;
                                    overallStatus = String.valueOf(RestStatus.MULTI_STATUS.getStatus());
                                    overallStatusText = "Errors";
                                }
                                return new LegacyDestinationResponse.Builder().withStatusCode(Boxing.boxInt((int)Integer.parseInt(overallStatus))).withResponseContent(overallStatusText).build();
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super LegacyDestinationResponse> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)1, null);
                Intrinsics.checkNotNull((Object)var3_13);
                yield (LegacyDestinationResponse)var3_13;
            }
            case 5 -> {
                this.getLog().warn("Channel type given (sns) for publishing to legacy destination currently not supported");
                LegacyDestinationResponse var3_14 = new LegacyDestinationResponse.Builder().withStatusCode(Integer.valueOf(400)).withResponseContent("Channel type given (sns) for publishing to legacy destination not supported").build();
                Intrinsics.checkNotNull((Object)var3_14);
                yield var3_14;
            }
            case -1 -> {
                this.getLog().warn("No channel type given (null) for publishing to legacy destination");
                LegacyDestinationResponse var3_15 = new LegacyDestinationResponse.Builder().withStatusCode(Integer.valueOf(400)).withResponseContent("No channel type given (null) for publishing to legacy destination").build();
                Intrinsics.checkNotNull((Object)var3_15);
                yield var3_15;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final DeliveryStatus getStatusIfChannelIsNotEligibleToSendMessage(NotificationConfigDocInfo channel) {
        return !channel.getConfigDoc().getConfig().isEnabled() ? new DeliveryStatus("LOCKED", "The channel is muted") : null;
    }

    private final EventStatus sendSlackMessage(Slack slack, MessageContent message, EventStatus eventStatus, String referenceId) {
        Metrics.NOTIFICATIONS_MESSAGE_DESTINATION_SLACK.getCounter().increment();
        SlackDestination destination = new SlackDestination(slack.getUrl());
        DestinationMessageResponse status = this.sendMessageThroughSpi((BaseDestination)destination, message, referenceId);
        return EventStatus.copy$default((EventStatus)eventStatus, null, null, null, null, (DeliveryStatus)new DeliveryStatus(String.valueOf(status.getStatusCode()), status.getStatusText()), (int)15, null);
    }

    private final EventStatus sendChimeMessage(Chime chime, MessageContent message, EventStatus eventStatus, String referenceId) {
        Metrics.NOTIFICATIONS_MESSAGE_DESTINATION_CHIME.getCounter().increment();
        ChimeDestination destination = new ChimeDestination(chime.getUrl());
        DestinationMessageResponse status = this.sendMessageThroughSpi((BaseDestination)destination, message, referenceId);
        return EventStatus.copy$default((EventStatus)eventStatus, null, null, null, null, (DeliveryStatus)new DeliveryStatus(String.valueOf(status.getStatusCode()), status.getStatusText()), (int)15, null);
    }

    private final EventStatus sendMicrosoftTeamsMessage(MicrosoftTeams microsoftTeams, MessageContent message, EventStatus eventStatus, String referenceId) {
        Metrics.NOTIFICATIONS_MESSAGE_DESTINATION_MICROSOFT_TEAMS.getCounter().increment();
        MicrosoftTeamsDestination destination = new MicrosoftTeamsDestination(microsoftTeams.getUrl());
        DestinationMessageResponse status = this.sendMessageThroughSpi((BaseDestination)destination, message, referenceId);
        return EventStatus.copy$default((EventStatus)eventStatus, null, null, null, null, (DeliveryStatus)new DeliveryStatus(String.valueOf(status.getStatusCode()), status.getStatusText()), (int)15, null);
    }

    private final EventStatus sendWebhookMessage(Webhook webhook, MessageContent message, EventStatus eventStatus, String referenceId) {
        Metrics.NOTIFICATIONS_MESSAGE_DESTINATION_WEBHOOK.getCounter().increment();
        CustomWebhookDestination destination = new CustomWebhookDestination(webhook.getUrl(), webhook.getHeaderParams(), webhook.getMethod().getTag());
        DestinationMessageResponse status = this.sendMessageThroughSpi((BaseDestination)destination, message, referenceId);
        return EventStatus.copy$default((EventStatus)eventStatus, null, null, null, null, (DeliveryStatus)new DeliveryStatus(String.valueOf(status.getStatusCode()), status.getStatusText()), (int)15, null);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final EventStatus sendEmailMessage(User user, Email email, Map<String, NotificationConfigDocInfo> childConfigMap, MessageContent message, EventStatus eventStatus, String referenceId) {
        Metrics.NOTIFICATIONS_MESSAGE_DESTINATION_EMAIL.getCounter().increment();
        accountDocInfo = childConfigMap.get(email.getEmailAccountID());
        if (accountDocInfo == null) {
            Metrics.NOTIFICATIONS_SEND_MESSAGE_USER_ERROR_NOT_FOUND.getCounter().increment();
            return EventStatus.copy$default((EventStatus)eventStatus, null, null, null, (List)CollectionsKt.emptyList(), (DeliveryStatus)new DeliveryStatus(String.valueOf(RestStatus.NOT_FOUND.getStatus()), "Sender " + email.getEmailAccountID() + " not found"), (int)7, null);
        }
        v0 = SendMessageActionHelper.userAccess;
        if (v0 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
            v0 = null;
        }
        if (!v0.doesUserHaveAccess(user, accountDocInfo.getConfigDoc().getMetadata().getAccess())) {
            Metrics.NOTIFICATIONS_PERMISSION_USER_ERROR.getCounter().increment();
            return EventStatus.copy$default((EventStatus)eventStatus, null, null, null, (List)CollectionsKt.emptyList(), (DeliveryStatus)new DeliveryStatus(String.valueOf(RestStatus.FORBIDDEN.getStatus()), "Access denied for sender " + accountDocInfo.getDocInfo().getId()), (int)7, null);
        }
        $this$filterValues$iv = childConfigMap;
        $i$f$filterValues = false;
        result$iv = new LinkedHashMap<String, V>();
        for (Object entry$iv : $this$filterValues$iv.entrySet()) {
            it = entry$iv.getValue();
            $i$a$-filterValues-SendMessageActionHelper$sendEmailMessage$accessDeniedGroupIds$1 = false;
            if (it == null) ** GOTO lbl-1000
            v1 = SendMessageActionHelper.userAccess;
            if (v1 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"userAccess");
                v1 = null;
            }
            if (!v1.doesUserHaveAccess(user, it.getConfigDoc().getMetadata().getAccess())) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        accessDeniedGroupIds = ((Map)result$iv).keySet();
        $this$filterValues$iv = childConfigMap;
        $i$f$filterValues = false;
        result$iv = new LinkedHashMap<K, V>();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            it = (NotificationConfigDocInfo)entry$iv.getValue();
            $i$a$-filterValues-SendMessageActionHelper$sendEmailMessage$invalidGroupIds$1 = false;
            if (!(it == null)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        invalidGroupIds = ((Map)result$iv).keySet();
        $i$f$filterValues = CollectionsKt.filterNotNull((Iterable)childConfigMap.values());
        $i$f$filter = false;
        entry$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (NotificationConfigDocInfo)element$iv$iv;
            $i$a$-filter-SendMessageActionHelper$sendEmailMessage$groups$1 = false;
            if (!(CollectionsKt.contains((Iterable)email.getEmailGroupIds(), (Object)it.getDocInfo().getId()) != false && CollectionsKt.contains((Iterable)accessDeniedGroupIds, (Object)it.getDocInfo().getId()) == false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        groups = (List)destination$iv$iv;
        $this$map$iv = groups;
        $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (E item$iv$iv : $this$mapTo$iv$iv) {
            $i$a$-filter-SendMessageActionHelper$sendEmailMessage$groups$1 = (NotificationConfigDocInfo)item$iv$iv;
            var25_37 = destination$iv$iv;
            $i$a$-map-SendMessageActionHelper$sendEmailMessage$groupRecipients$1 = false;
            v3 = it.getConfigDoc().getConfig().getConfigData();
            Intrinsics.checkNotNull((Object)v3, (String)"null cannot be cast to non-null type org.opensearch.commons.notifications.model.EmailGroup");
            var25_37.add(((EmailGroup)v3).getRecipients());
        }
        groupRecipients = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        recipients = CollectionsKt.union((Iterable)email.getRecipients(), (Iterable)groupRecipients);
        emailRecipientStatus = new Ref.ObjectRef();
        accountConfig = accountDocInfo.getConfigDoc().getConfig();
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Set<EmailRecipient>)recipients, (Ref.ObjectRef<List<EmailRecipientStatus>>)emailRecipientStatus, invalidGroupIds, accessDeniedGroupIds, accountConfig, message, referenceId, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Set<EmailRecipient> $recipients;
            final /* synthetic */ Ref.ObjectRef<List<EmailRecipientStatus>> $emailRecipientStatus;
            final /* synthetic */ Set<String> $invalidGroupIds;
            final /* synthetic */ Set<String> $accessDeniedGroupIds;
            final /* synthetic */ NotificationConfig $accountConfig;
            final /* synthetic */ MessageContent $message;
            final /* synthetic */ String $referenceId;
            {
                this.$recipients = $recipients;
                this.$emailRecipientStatus = $emailRecipientStatus;
                this.$invalidGroupIds = $invalidGroupIds;
                this.$accessDeniedGroupIds = $accessDeniedGroupIds;
                this.$accountConfig = $accountConfig;
                this.$message = $message;
                this.$referenceId = $referenceId;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var19_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$runBlocking = (CoroutineScope)this.L$0;
                        var4_4 = this.$recipients;
                        var5_5 = this.$accountConfig;
                        var6_7 /* !! */  = this.$message;
                        var7_8 = this.$referenceId;
                        $i$f$map = false;
                        var9_10 = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            var14_19 = (EmailRecipient)item$iv$iv;
                            var16_21 = destination$iv$iv;
                            $i$a$-map-SendMessageActionHelper$sendEmailMessage$1$statusDeferredList$1 = false;
                            var16_21.add((Deferred)BuildersKt.async$default((CoroutineScope)$this$runBlocking, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super EmailRecipientStatus>, Object>(var5_5, (EmailRecipient)it, var6_7 /* !! */ , var7_8, null){
                                int label;
                                final /* synthetic */ NotificationConfig $accountConfig;
                                final /* synthetic */ EmailRecipient $it;
                                final /* synthetic */ MessageContent $message;
                                final /* synthetic */ String $referenceId;
                                {
                                    this.$accountConfig = $accountConfig;
                                    this.$it = $it;
                                    this.$message = $message;
                                    this.$referenceId = $referenceId;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            return switch (sendEmailMessage.statusDeferredList.1.WhenMappings.$EnumSwitchMapping$0[this.$accountConfig.getConfigType().ordinal()]) {
                                                case 1 -> {
                                                    String v0 = this.$accountConfig.getName();
                                                    BaseConfigData v1 = this.$accountConfig.getConfigData();
                                                    Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type org.opensearch.commons.notifications.model.SmtpAccount");
                                                    yield SendMessageActionHelper.access$sendEmailFromSmtpAccount(SendMessageActionHelper.INSTANCE, v0, (SmtpAccount)v1, this.$it.getRecipient(), this.$message, this.$referenceId);
                                                }
                                                case 2 -> {
                                                    String v3 = this.$accountConfig.getName();
                                                    BaseConfigData v4 = this.$accountConfig.getConfigData();
                                                    Intrinsics.checkNotNull((Object)v4, (String)"null cannot be cast to non-null type org.opensearch.commons.notifications.model.SesAccount");
                                                    yield SendMessageActionHelper.access$sendEmailFromSesAccount(SendMessageActionHelper.INSTANCE, v3, (SesAccount)v4, this.$it.getRecipient(), this.$message, this.$referenceId);
                                                }
                                                default -> new EmailRecipientStatus(this.$it.getRecipient(), new DeliveryStatus("NOT_ACCEPTABLE", "email account type not enabled"));
                                            };
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super EmailRecipientStatus> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)2, null));
                        }
                        statusDeferredList = (List)destination$iv$iv;
                        this.L$0 = var16_21 = this.$emailRecipientStatus;
                        this.label = 1;
                        v0 = AwaitKt.awaitAll((Collection)statusDeferredList, (Continuation)((Continuation)this));
                        if (v0 == var19_2) {
                            return var19_2;
                        }
                        ** GOTO lbl32
                    }
                    case 1: {
                        var16_21 = (Ref.ObjectRef<List<EmailRecipientStatus>>)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl32:
                        // 2 sources

                        $this$map$iv = this.$invalidGroupIds;
                        var17_23 = (Collection)v0;
                        $i$f$map = false;
                        var6_7 /* !! */  = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (E item$iv$iv : $this$mapTo$iv$iv) {
                            $i$f$mapTo = (String)item$iv$iv /* !! */ ;
                            var18_24 = destination$iv$iv;
                            $i$a$-map-SendMessageActionHelper$sendEmailMessage$1$1 = false;
                            var18_24.add(new EmailRecipientStatus("unknown-recipient@example.com", new DeliveryStatus(String.valueOf(RestStatus.NOT_FOUND.getStatus()), "Recipient " + (String)it + " not found")));
                        }
                        var18_24 = (List)destination$iv$iv;
                        $this$map$iv = this.$accessDeniedGroupIds;
                        var17_23 = CollectionsKt.plus((Collection)var17_23, (Iterable)var18_24);
                        $i$f$map = false;
                        $this$mapTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (E item$iv$iv : $this$mapTo$iv$iv) {
                            it = (String)item$iv$iv /* !! */ ;
                            var18_24 = destination$iv$iv;
                            $i$a$-map-SendMessageActionHelper$sendEmailMessage$1$2 = false;
                            var18_24.add(new EmailRecipientStatus("invalid-access@example.com", new DeliveryStatus(String.valueOf(RestStatus.FORBIDDEN.getStatus()), "Access denied for recipient " + it)));
                        }
                        var18_24 = (List)destination$iv$iv;
                        var16_21.element = CollectionsKt.plus((Collection)var17_23, (Iterable)var18_24);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        firstStatus = (EmailRecipientStatus)CollectionsKt.first((List)((List)emailRecipientStatus.element));
        overallStatus = null;
        overallStatus = firstStatus.getDeliveryStatus().getStatusCode();
        overallStatusText = null;
        overallStatusText = firstStatus.getDeliveryStatus().getStatusText();
        $this$forEach$iv = (Iterable)emailRecipientStatus.element;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            it = (EmailRecipientStatus)element$iv;
            $i$a$-forEach-SendMessageActionHelper$sendEmailMessage$2 = false;
            status = it.getDeliveryStatus();
            SendMessageActionHelper.INSTANCE.getLog().info("notifications:" + email.getEmailAccountID() + ":statusCode=" + status.getStatusCode() + ", statusText=" + status.getStatusText());
            if (Intrinsics.areEqual((Object)overallStatus, (Object)status.getStatusCode())) continue;
            overallStatus = String.valueOf(RestStatus.MULTI_STATUS.getStatus());
            overallStatusText = "Errors";
        }
        return EventStatus.copy$default((EventStatus)eventStatus, null, null, null, (List)((List)emailRecipientStatus.element), (DeliveryStatus)new DeliveryStatus(overallStatus, overallStatusText), (int)7, null);
    }

    private final EmailRecipientStatus sendEmailFromSmtpAccount(String accountName, SmtpAccount smtpAccount, String recipient, MessageContent message, String referenceId) {
        Metrics.NOTIFICATIONS_MESSAGE_DESTINATION_SMTP_ACCOUNT.getCounter().increment();
        SmtpDestination destination = new SmtpDestination(accountName, smtpAccount.getHost(), smtpAccount.getPort(), smtpAccount.getMethod().getTag(), smtpAccount.getFromAddress(), recipient);
        DestinationMessageResponse status = this.sendMessageThroughSpi((BaseDestination)destination, message, referenceId);
        return new EmailRecipientStatus(recipient, new DeliveryStatus(String.valueOf(status.getStatusCode()), status.getStatusText()));
    }

    private final EmailRecipientStatus sendEmailFromSesAccount(String accountName, SesAccount sesAccount, String recipient, MessageContent message, String referenceId) {
        Metrics.NOTIFICATIONS_MESSAGE_DESTINATION_SES_ACCOUNT.getCounter().increment();
        SesDestination destination = new SesDestination(accountName, sesAccount.getAwsRegion(), sesAccount.getRoleArn(), sesAccount.getFromAddress(), recipient);
        DestinationMessageResponse status = this.sendMessageThroughSpi((BaseDestination)destination, message, referenceId);
        return new EmailRecipientStatus(recipient, new DeliveryStatus(String.valueOf(status.getStatusCode()), status.getStatusText()));
    }

    private final EventStatus sendSNSMessage(Sns sns, MessageContent message, EventStatus eventStatus, String referenceId) {
        Metrics.NOTIFICATIONS_MESSAGE_DESTINATION_SNS.getCounter().increment();
        SnsDestination destination = new SnsDestination(sns.getTopicArn(), sns.getRoleArn());
        DestinationMessageResponse status = this.sendMessageThroughSpi((BaseDestination)destination, message, referenceId);
        return EventStatus.copy$default((EventStatus)eventStatus, null, null, null, null, (DeliveryStatus)new DeliveryStatus(String.valueOf(status.getStatusCode()), status.getStatusText()), (int)15, null);
    }

    private final DestinationMessageResponse sendMessageThroughSpi(BaseDestination destination, MessageContent message, String referenceId) {
        DestinationMessageResponse destinationMessageResponse;
        try {
            DestinationMessageResponse status = CoreProvider.INSTANCE.getCore().sendMessage(destination, message, referenceId);
            this.getLog().info("notifications:sendMessage:statusCode=" + status.getStatusCode() + ", statusText=" + status.getStatusText());
            destinationMessageResponse = status;
        }
        catch (Exception exception) {
            this.getLog().warn("sendMessage Exception:" + exception);
            destinationMessageResponse = new DestinationMessageResponse(RestStatus.FAILED_DEPENDENCY.getStatus(), "Failed to send notification");
        }
        return destinationMessageResponse;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getChildConfigIds(List<NotificationConfigDocInfo> channels) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = channels;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            NotificationConfigDocInfo it = (NotificationConfigDocInfo)element$iv$iv;
            boolean bl = false;
            if (!(it.getConfigDoc().getConfig().getConfigType() == ConfigType.EMAIL)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List emailConfigs = (List)destination$iv$iv;
        if (!((Collection)emailConfigs).isEmpty()) {
            Set childIds = new LinkedHashSet();
            Iterable $this$forEach$iv = emailConfigs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NotificationConfigDocInfo it = (NotificationConfigDocInfo)element$iv;
                boolean bl = false;
                BaseConfigData baseConfigData = it.getConfigDoc().getConfig().getConfigData();
                Intrinsics.checkNotNull((Object)baseConfigData, (String)"null cannot be cast to non-null type org.opensearch.commons.notifications.model.Email");
                Email email = (Email)baseConfigData;
                childIds.add(email.getEmailAccountID());
                childIds.addAll(email.getEmailGroupIds());
            }
            return childIds;
        }
        return SetsKt.emptySet();
    }

    private final Object getConfigs(Set<String> configIds, Continuation<? super Map<String, NotificationConfigDocInfo>> $completion) {
        switch (configIds.size()) {
            case 0: {
                break;
            }
            case 1: {
                return this.getSingleConfig((String)CollectionsKt.first((Iterable)configIds), $completion);
            }
            default: {
                return this.getAllConfigs(configIds, $completion);
            }
        }
        return MapsKt.emptyMap();
    }

    /*
     * Unable to fully structure code
     */
    private final Object getAllConfigs(Set<String> var1_1, Continuation<? super Map<String, NotificationConfigDocInfo>> var2_2) {
        if (!(var2_2 instanceof getAllConfigs.1)) ** GOTO lbl-1000
        var14_3 = var2_2;
        if ((var14_3.label & -2147483648) != 0) {
            var14_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ SendMessageActionHelper this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SendMessageActionHelper.access$getAllConfigs(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var15_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.getLog().info("notifications:getAllConfigs-get " + configIds);
                v0 = SendMessageActionHelper.configOperations;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"configOperations");
                    v0 = null;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = configIds;
                $continuation.label = 1;
                v1 = v0.getNotificationConfigs(configIds, (Continuation<? super List<NotificationConfigDocInfo>>)$continuation);
                if (v1 == var15_5) {
                    return var15_5;
                }
                ** GOTO lbl29
            }
            case 1: {
                configIds = (Set)$continuation.L$1;
                this = (SendMessageActionHelper)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl29:
                // 2 sources

                configDocs = (List)v1;
                configMap = new LinkedHashMap<K, V>();
                $this$forEach$iv = configIds;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (String)element$iv;
                    $i$a$-forEach-SendMessageActionHelper$getAllConfigs$2 = false;
                    configMap.put(it, null);
                }
                $this$forEach$iv = configDocs;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (NotificationConfigDocInfo)element$iv;
                    $i$a$-forEach-SendMessageActionHelper$getAllConfigs$3 = false;
                    v2 = it.getDocInfo().getId();
                    Intrinsics.checkNotNull((Object)v2);
                    configMap.put(v2, it);
                }
                if (configDocs.size() != configIds.size()) {
                    $this$filterValues$iv = configMap;
                    $i$f$filterValues = false;
                    result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterValues$iv.entrySet()) {
                        it = (NotificationConfigDocInfo)entry$iv.getValue();
                        $i$a$-filterValues-SendMessageActionHelper$getAllConfigs$invalidConfigIds$1 = false;
                        if (!(it == null)) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    invalidConfigIds = ((Map)result$iv).keySet();
                    this.getLog().error("notifications:getAllConfigs " + invalidConfigIds + " not found");
                }
                return configMap;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object getSingleConfig(String var1_1, Continuation<? super Map<String, NotificationConfigDocInfo>> var2_2) {
        if (!(var2_2 instanceof getSingleConfig.1)) ** GOTO lbl-1000
        var5_3 = var2_2;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ SendMessageActionHelper this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SendMessageActionHelper.access$getSingleConfig(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.getLog().info("notifications:getSingleConfig-get " + configId);
                v0 = SendMessageActionHelper.configOperations;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"configOperations");
                    v0 = null;
                }
                $continuation.L$0 = configId;
                $continuation.label = 1;
                v1 = v0.getNotificationConfig(configId, (Continuation<? super NotificationConfigDocInfo>)$continuation);
                if (v1 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl27
            }
            case 1: {
                configId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl27:
                // 2 sources

                configDoc = (NotificationConfigDocInfo)v1;
                return MapsKt.mapOf((Pair)TuplesKt.to((Object)configId, (Object)configDoc));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getJsonString(ToXContent xContent) {
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            XContentBuilder builder = XContentFactory.jsonBuilder((OutputStream)byteArrayOutputStream);
            xContent.toXContent(builder, ToXContent.EMPTY_PARAMS);
            builder.close();
            String string = byteArrayOutputStream.toString("UTF8");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = string;
            return string2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final /* synthetic */ String access$getJsonString(SendMessageActionHelper $this, ToXContent xContent) {
        return $this.getJsonString(xContent);
    }

    public static final /* synthetic */ LegacyDestinationResponse access$sendMessageToLegacyDestination(SendMessageActionHelper $this, LegacyBaseMessage baseMessage) {
        return $this.sendMessageToLegacyDestination(baseMessage);
    }

    public static final /* synthetic */ EventStatus access$sendMessageToChannel(SendMessageActionHelper $this, User user, EventSource eventSource, Map.Entry channelEntry, Map childConfigMap, MessageContent message) {
        return $this.sendMessageToChannel(user, eventSource, channelEntry, childConfigMap, message);
    }

    public static final /* synthetic */ DestinationMessageResponse access$sendMessageThroughSpi(SendMessageActionHelper $this, BaseDestination destination, MessageContent message, String referenceId) {
        return $this.sendMessageThroughSpi(destination, message, referenceId);
    }

    public static final /* synthetic */ Logger access$getLog(SendMessageActionHelper $this) {
        return $this.getLog();
    }

    public static final /* synthetic */ EmailRecipientStatus access$sendEmailFromSmtpAccount(SendMessageActionHelper $this, String accountName, SmtpAccount smtpAccount, String recipient, MessageContent message, String referenceId) {
        return $this.sendEmailFromSmtpAccount(accountName, smtpAccount, recipient, message, referenceId);
    }

    public static final /* synthetic */ EmailRecipientStatus access$sendEmailFromSesAccount(SendMessageActionHelper $this, String accountName, SesAccount sesAccount, String recipient, MessageContent message, String referenceId) {
        return $this.sendEmailFromSesAccount(accountName, sesAccount, recipient, message, referenceId);
    }

    public static final /* synthetic */ Object access$getConfigs(SendMessageActionHelper $this, Set configIds, Continuation $completion) {
        return $this.getConfigs(configIds, (Continuation<? super Map<String, NotificationConfigDocInfo>>)$completion);
    }

    public static final /* synthetic */ Object access$getAllConfigs(SendMessageActionHelper $this, Set configIds, Continuation $completion) {
        return $this.getAllConfigs(configIds, (Continuation<? super Map<String, NotificationConfigDocInfo>>)$completion);
    }

    public static final /* synthetic */ Object access$getSingleConfig(SendMessageActionHelper $this, String configId, Continuation $completion) {
        return $this.getSingleConfig(configId, (Continuation<? super Map<String, NotificationConfigDocInfo>>)$completion);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ConfigType.values().length];
            try {
                nArray[ConfigType.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigType.SLACK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigType.CHIME.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigType.MICROSOFT_TEAMS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigType.WEBHOOK.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigType.EMAIL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigType.SES_ACCOUNT.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigType.SMTP_ACCOUNT.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigType.EMAIL_GROUP.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigType.SNS.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[LegacyDestinationType.values().length];
            try {
                nArray[LegacyDestinationType.LEGACY_SLACK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LegacyDestinationType.LEGACY_CHIME.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LegacyDestinationType.LEGACY_CUSTOM_WEBHOOK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LegacyDestinationType.LEGACY_EMAIL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LegacyDestinationType.LEGACY_SNS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

