/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.agent;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.opensearch.Version;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.CommonValue;
import org.opensearch.ml.common.utils.StringUtils;

public class MLToolSpec
implements ToXContentObject {
    public static final Version MINIMAL_SUPPORTED_VERSION_FOR_TOOL_CONFIG = CommonValue.VERSION_2_18_0;
    public static final String TOOL_TYPE_FIELD = "type";
    public static final String TOOL_NAME_FIELD = "name";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String PARAMETERS_FIELD = "parameters";
    public static final String ATTRIBUTES_FIELD = "attributes";
    public static final String INCLUDE_OUTPUT_IN_AGENT_RESPONSE = "include_output_in_agent_response";
    public static final String CONFIG_FIELD = "config";
    public static final String RUN_TIME_RESOURCES_FIELD = "runtime_resources";
    private String type;
    private String name;
    private String description;
    private Map<String, String> parameters;
    private Map<String, String> attributes;
    private boolean includeOutputInAgentResponse;
    private Map<String, String> configMap;
    private String tenantId;
    private Map<String, Object> runtimeResources;

    public MLToolSpec(String type, String name, String description, Map<String, String> parameters, Map<String, String> attributes, boolean includeOutputInAgentResponse, Map<String, String> configMap, String tenantId, Map<String, Object> runtimeResources) {
        if (type == null) {
            throw new IllegalArgumentException("tool type is null");
        }
        this.type = type;
        this.name = name;
        this.description = description;
        this.parameters = parameters;
        this.attributes = attributes;
        this.includeOutputInAgentResponse = includeOutputInAgentResponse;
        this.configMap = configMap;
        this.tenantId = tenantId;
        this.runtimeResources = runtimeResources;
    }

    public MLToolSpec(StreamInput input) throws IOException {
        Version streamInputVersion = input.getVersion();
        this.type = input.readString();
        this.name = input.readOptionalString();
        this.description = input.readOptionalString();
        if (input.readBoolean()) {
            this.parameters = input.readMap(StreamInput::readString, StreamInput::readOptionalString);
        }
        this.includeOutputInAgentResponse = input.readBoolean();
        if (input.getVersion().onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_TOOL_CONFIG) && input.readBoolean()) {
            this.configMap = input.readMap(StreamInput::readString, StreamInput::readOptionalString);
        }
        String string = this.tenantId = streamInputVersion.onOrAfter(CommonValue.VERSION_2_19_0) ? input.readOptionalString() : null;
        if (input.getVersion().onOrAfter(CommonValue.VERSION_3_0_0)) {
            if (input.available() > 0 && input.readBoolean()) {
                this.attributes = input.readMap(StreamInput::readString, StreamInput::readOptionalString);
            }
            if (input.available() > 0 && input.readBoolean()) {
                this.runtimeResources = input.readMap(StreamInput::readString, StreamInput::readGenericValue);
            }
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        Version streamOutputVersion = out.getVersion();
        out.writeString(this.type);
        out.writeOptionalString(this.name);
        out.writeOptionalString(this.description);
        if (this.parameters != null && !this.parameters.isEmpty()) {
            out.writeBoolean(true);
            out.writeMap(this.parameters, StreamOutput::writeString, StreamOutput::writeOptionalString);
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.includeOutputInAgentResponse);
        if (out.getVersion().onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_TOOL_CONFIG)) {
            if (this.configMap != null) {
                out.writeBoolean(true);
                out.writeMap(this.configMap, StreamOutput::writeString, StreamOutput::writeOptionalString);
            } else {
                out.writeBoolean(false);
            }
        }
        if (streamOutputVersion.onOrAfter(CommonValue.VERSION_2_19_0)) {
            out.writeOptionalString(this.tenantId);
        }
        if (streamOutputVersion.onOrAfter(CommonValue.VERSION_3_0_0)) {
            if (this.attributes != null && !this.attributes.isEmpty()) {
                out.writeBoolean(true);
                out.writeMap(this.attributes, StreamOutput::writeString, StreamOutput::writeOptionalString);
            } else {
                out.writeBoolean(false);
            }
            if (this.runtimeResources != null && !this.runtimeResources.isEmpty()) {
                out.writeBoolean(true);
                out.writeMap(this.runtimeResources, StreamOutput::writeString, StreamOutput::writeGenericValue);
            } else {
                out.writeBoolean(false);
            }
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.type != null) {
            builder.field(TOOL_TYPE_FIELD, this.type);
        }
        if (this.name != null) {
            builder.field(TOOL_NAME_FIELD, this.name);
        }
        if (this.description != null) {
            builder.field(DESCRIPTION_FIELD, this.description);
        }
        if (this.attributes != null && !this.attributes.isEmpty()) {
            builder.field(ATTRIBUTES_FIELD, this.attributes);
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            builder.field(PARAMETERS_FIELD, this.parameters);
        }
        builder.field(INCLUDE_OUTPUT_IN_AGENT_RESPONSE, this.includeOutputInAgentResponse);
        if (this.configMap != null && !this.configMap.isEmpty()) {
            builder.field(CONFIG_FIELD, this.configMap);
        }
        if (this.tenantId != null) {
            builder.field("tenant_id", this.tenantId);
        }
        if (this.runtimeResources != null && !this.runtimeResources.isEmpty()) {
            builder.field(RUN_TIME_RESOURCES_FIELD, this.runtimeResources);
        }
        builder.endObject();
        return builder;
    }

    public static MLToolSpec parse(XContentParser parser) throws IOException {
        String type = null;
        String name = null;
        String description = null;
        Map<String, String> attributes = null;
        Map<String, String> parameters = null;
        boolean includeOutputInAgentResponse = false;
        Map<String, String> configMap = null;
        String tenantId = null;
        Map runtimeResources = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block22: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "type": {
                    type = parser.text();
                    continue block22;
                }
                case "name": {
                    name = parser.text();
                    continue block22;
                }
                case "description": {
                    description = parser.text();
                    continue block22;
                }
                case "attributes": {
                    attributes = StringUtils.getParameterMap(parser.map());
                    continue block22;
                }
                case "parameters": {
                    parameters = StringUtils.getParameterMap(parser.map());
                    continue block22;
                }
                case "include_output_in_agent_response": {
                    includeOutputInAgentResponse = parser.booleanValue();
                    continue block22;
                }
                case "config": {
                    configMap = StringUtils.getParameterMap(parser.map());
                    continue block22;
                }
                case "tenant_id": {
                    tenantId = parser.textOrNull();
                    continue block22;
                }
                case "runtime_resources": {
                    runtimeResources = parser.map();
                }
            }
            parser.skipChildren();
        }
        return MLToolSpec.builder().type(type).name(name).description(description).attributes(attributes).parameters(parameters).includeOutputInAgentResponse(includeOutputInAgentResponse).configMap(configMap).tenantId(tenantId).runtimeResources(runtimeResources).build();
    }

    public static MLToolSpec fromStream(StreamInput in) throws IOException {
        return new MLToolSpec(in);
    }

    public void addRuntimeResource(String key, Object value) {
        if (this.runtimeResources == null) {
            this.runtimeResources = new HashMap<String, Object>();
        }
        this.runtimeResources.put(key, value);
    }

    public Object getRuntimeResource(String key) {
        return this.runtimeResources.get(key);
    }

    @Generated
    public static MLToolSpecBuilder builder() {
        return new MLToolSpecBuilder();
    }

    @Generated
    public MLToolSpecBuilder toBuilder() {
        return new MLToolSpecBuilder().type(this.type).name(this.name).description(this.description).parameters(this.parameters).attributes(this.attributes).includeOutputInAgentResponse(this.includeOutputInAgentResponse).configMap(this.configMap).tenantId(this.tenantId).runtimeResources(this.runtimeResources);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MLToolSpec)) {
            return false;
        }
        MLToolSpec other = (MLToolSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isIncludeOutputInAgentResponse() != other.isIncludeOutputInAgentResponse()) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Map<String, String> this$parameters = this.getParameters();
        Map<String, String> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        Map<String, String> this$attributes = this.getAttributes();
        Map<String, String> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        Map<String, String> this$configMap = this.getConfigMap();
        Map<String, String> other$configMap = other.getConfigMap();
        if (this$configMap == null ? other$configMap != null : !((Object)this$configMap).equals(other$configMap)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        Map<String, Object> this$runtimeResources = this.getRuntimeResources();
        Map<String, Object> other$runtimeResources = other.getRuntimeResources();
        return !(this$runtimeResources == null ? other$runtimeResources != null : !((Object)this$runtimeResources).equals(other$runtimeResources));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MLToolSpec;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isIncludeOutputInAgentResponse() ? 79 : 97);
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Map<String, String> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        Map<String, String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        Map<String, String> $configMap = this.getConfigMap();
        result = result * 59 + ($configMap == null ? 43 : ((Object)$configMap).hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        Map<String, Object> $runtimeResources = this.getRuntimeResources();
        result = result * 59 + ($runtimeResources == null ? 43 : ((Object)$runtimeResources).hashCode());
        return result;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Generated
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Generated
    public boolean isIncludeOutputInAgentResponse() {
        return this.includeOutputInAgentResponse;
    }

    @Generated
    public Map<String, String> getConfigMap() {
        return this.configMap;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public Map<String, Object> getRuntimeResources() {
        return this.runtimeResources;
    }

    @Generated
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public static class MLToolSpecBuilder {
        @Generated
        private String type;
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private Map<String, String> parameters;
        @Generated
        private Map<String, String> attributes;
        @Generated
        private boolean includeOutputInAgentResponse;
        @Generated
        private Map<String, String> configMap;
        @Generated
        private String tenantId;
        @Generated
        private Map<String, Object> runtimeResources;

        @Generated
        MLToolSpecBuilder() {
        }

        @Generated
        public MLToolSpecBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public MLToolSpecBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public MLToolSpecBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public MLToolSpecBuilder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        @Generated
        public MLToolSpecBuilder attributes(Map<String, String> attributes) {
            this.attributes = attributes;
            return this;
        }

        @Generated
        public MLToolSpecBuilder includeOutputInAgentResponse(boolean includeOutputInAgentResponse) {
            this.includeOutputInAgentResponse = includeOutputInAgentResponse;
            return this;
        }

        @Generated
        public MLToolSpecBuilder configMap(Map<String, String> configMap) {
            this.configMap = configMap;
            return this;
        }

        @Generated
        public MLToolSpecBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public MLToolSpecBuilder runtimeResources(Map<String, Object> runtimeResources) {
            this.runtimeResources = runtimeResources;
            return this;
        }

        @Generated
        public MLToolSpec build() {
            return new MLToolSpec(this.type, this.name, this.description, this.parameters, this.attributes, this.includeOutputInAgentResponse, this.configMap, this.tenantId, this.runtimeResources);
        }

        @Generated
        public String toString() {
            return "MLToolSpec.MLToolSpecBuilder(type=" + this.type + ", name=" + this.name + ", description=" + this.description + ", parameters=" + String.valueOf(this.parameters) + ", attributes=" + String.valueOf(this.attributes) + ", includeOutputInAgentResponse=" + this.includeOutputInAgentResponse + ", configMap=" + String.valueOf(this.configMap) + ", tenantId=" + this.tenantId + ", runtimeResources=" + String.valueOf(this.runtimeResources) + ")";
        }
    }
}

