/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.transport;

import java.io.IOException;
import java.util.List;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.broadcast.node.TransportBroadcastByNodeAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.ShardsIterator;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.support.DefaultShardOperationFailedException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.index.Index;
import org.opensearch.index.IndexService;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.IndicesService;
import org.opensearch.knn.index.KNNIndexShard;
import org.opensearch.knn.plugin.transport.ClearCacheRequest;
import org.opensearch.knn.plugin.transport.ClearCacheResponse;
import org.opensearch.transport.TransportService;

public class ClearCacheTransportAction
extends TransportBroadcastByNodeAction<ClearCacheRequest, ClearCacheResponse, TransportBroadcastByNodeAction.EmptyResult> {
    private IndicesService indicesService;

    @Inject
    public ClearCacheTransportAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService) {
        super("cluster:admin/clear_cache_action", clusterService, transportService, actionFilters, indexNameExpressionResolver, ClearCacheRequest::new, "search");
        this.indicesService = indicesService;
    }

    protected TransportBroadcastByNodeAction.EmptyResult readShardResult(StreamInput streamInput) throws IOException {
        return TransportBroadcastByNodeAction.EmptyResult.readEmptyResultFrom((StreamInput)streamInput);
    }

    protected ClearCacheResponse newResponse(ClearCacheRequest request, int totalShards, int successfulShards, int failedShards, List<TransportBroadcastByNodeAction.EmptyResult> emptyResults, List<DefaultShardOperationFailedException> shardFailures, ClusterState clusterState) {
        return new ClearCacheResponse(totalShards, successfulShards, failedShards, shardFailures);
    }

    protected ClearCacheRequest readRequestFrom(StreamInput streamInput) throws IOException {
        return new ClearCacheRequest(streamInput);
    }

    protected TransportBroadcastByNodeAction.EmptyResult shardOperation(ClearCacheRequest request, ShardRouting shardRouting) throws IOException {
        Index index = shardRouting.shardId().getIndex();
        IndexService indexService = this.indicesService.indexServiceSafe(index);
        IndexShard indexShard = indexService.getShard(shardRouting.shardId().id());
        KNNIndexShard knnIndexShard = new KNNIndexShard(indexShard);
        knnIndexShard.clearCache();
        return TransportBroadcastByNodeAction.EmptyResult.INSTANCE;
    }

    protected ShardsIterator shards(ClusterState clusterState, ClearCacheRequest request, String[] concreteIndices) {
        return clusterState.routingTable().allShards(concreteIndices);
    }

    protected ClusterBlockException checkGlobalBlock(ClusterState clusterState, ClearCacheRequest request) {
        return clusterState.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected ClusterBlockException checkRequestBlock(ClusterState clusterState, ClearCacheRequest request, String[] concreteIndices) {
        return clusterState.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, concreteIndices);
    }
}

