/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.ml;

import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.Entity;
import org.opensearch.timeseries.model.FeatureData;
import org.opensearch.timeseries.model.IndexableResult;

public abstract class IntermediateResult<IndexableResultType extends IndexableResult> {
    protected final long totalUpdates;
    protected final double rcfScore;

    public IntermediateResult(long totalUpdates, double rcfScore) {
        this.totalUpdates = totalUpdates;
        this.rcfScore = rcfScore;
    }

    public long getTotalUpdates() {
        return this.totalUpdates;
    }

    public double getRcfScore() {
        return this.rcfScore;
    }

    public int hashCode() {
        return Objects.hash(this.totalUpdates);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntermediateResult other = (IntermediateResult)obj;
        return this.totalUpdates == other.totalUpdates && Double.doubleToLongBits(this.rcfScore) == Double.doubleToLongBits(other.rcfScore);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)super.toString()).append("totalUpdates", this.totalUpdates).append("rcfScore", this.rcfScore).toString();
    }

    public abstract List<IndexableResultType> toIndexableResults(Config var1, Instant var2, Instant var3, Instant var4, Instant var5, List<FeatureData> var6, Optional<Entity> var7, Integer var8, String var9, String var10, String var11);
}

