/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.opensearch.OpenSearchParseException;
import org.opensearch.action.pagination.PageParams;
import org.opensearch.common.Booleans;
import org.opensearch.common.CheckedConsumer;
import org.opensearch.common.Nullable;
import org.opensearch.common.SetOnce;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.http.HttpChannel;
import org.opensearch.http.HttpRequest;
import org.opensearch.rest.RestUtils;

@PublicApi(since="1.0.0")
public class RestRequest
implements ToXContent.Params {
    private static final Pattern TCHAR_PATTERN = Pattern.compile("[a-zA-z0-9!#$%&'*+\\-.\\^_`|~]+");
    private static final AtomicLong requestIdGenerator = new AtomicLong();
    private final NamedXContentRegistry xContentRegistry;
    private final Map<String, String> params;
    private final Map<String, List<String>> headers;
    private final String rawPath;
    private final Set<String> consumedParams = new HashSet<String>();
    private final SetOnce<MediaType> mediaType = new SetOnce();
    private final HttpChannel httpChannel;
    private HttpRequest httpRequest;
    private boolean contentConsumed = false;
    private final long requestId;

    public boolean isContentConsumed() {
        return this.contentConsumed;
    }

    protected RestRequest(NamedXContentRegistry xContentRegistry, Map<String, String> params, String path, Map<String, List<String>> headers, HttpRequest httpRequest, HttpChannel httpChannel) {
        this(xContentRegistry, params, path, headers, httpRequest, httpChannel, requestIdGenerator.incrementAndGet());
    }

    private RestRequest(NamedXContentRegistry xContentRegistry, Map<String, String> params, String path, Map<String, List<String>> headers, HttpRequest httpRequest, HttpChannel httpChannel, long requestId) {
        MediaType mediaType;
        try {
            mediaType = RestRequest.parseContentType(headers.get("Content-Type"));
        }
        catch (IllegalArgumentException e) {
            throw new ContentTypeHeaderException(e);
        }
        if (mediaType != null) {
            this.mediaType.set((Object)mediaType);
        }
        this.xContentRegistry = xContentRegistry;
        this.httpRequest = httpRequest;
        this.httpChannel = httpChannel;
        this.params = params;
        this.rawPath = path;
        this.headers = Collections.unmodifiableMap(headers);
        this.requestId = requestId;
    }

    protected RestRequest(RestRequest restRequest) {
        this(restRequest.getXContentRegistry(), restRequest.params(), restRequest.path(), restRequest.getHeaders(), restRequest.getHttpRequest(), restRequest.getHttpChannel(), restRequest.getRequestId());
    }

    void ensureSafeBuffers() {
        this.httpRequest = this.httpRequest.releaseAndCopy();
    }

    public static RestRequest request(NamedXContentRegistry xContentRegistry, HttpRequest httpRequest, HttpChannel httpChannel) {
        Map<String, String> params = RestRequest.params(httpRequest.uri());
        String path = RestRequest.path(httpRequest.uri());
        return new RestRequest(xContentRegistry, params, path, httpRequest.getHeaders(), httpRequest, httpChannel, requestIdGenerator.incrementAndGet());
    }

    private static Map<String, String> params(String uri) {
        HashMap<String, String> params = new HashMap<String, String>();
        int index = uri.indexOf(63);
        if (index >= 0) {
            try {
                RestUtils.decodeQueryString(uri, index + 1, params);
            }
            catch (IllegalArgumentException e) {
                throw new BadParameterException(e);
            }
        }
        return params;
    }

    private static String path(String uri) {
        int index = uri.indexOf(63);
        if (index >= 0) {
            return uri.substring(0, index);
        }
        return uri;
    }

    public static RestRequest requestWithoutParameters(NamedXContentRegistry xContentRegistry, HttpRequest httpRequest, HttpChannel httpChannel) {
        Map<String, String> params = Collections.emptyMap();
        return new RestRequest(xContentRegistry, params, httpRequest.uri(), httpRequest.getHeaders(), httpRequest, httpChannel, requestIdGenerator.incrementAndGet());
    }

    public Method method() {
        return this.httpRequest.method();
    }

    public String uri() {
        return this.httpRequest.uri();
    }

    public String rawPath() {
        return this.rawPath;
    }

    public final String path() {
        return RestUtils.decodeComponent(this.rawPath());
    }

    public boolean hasContent() {
        return this.content(false).length() > 0;
    }

    public BytesReference content() {
        return this.content(true);
    }

    protected BytesReference content(boolean contentConsumed) {
        this.contentConsumed |= contentConsumed;
        return this.httpRequest.content();
    }

    public final BytesReference requiredContent() {
        if (!this.hasContent()) {
            throw new OpenSearchParseException("request body is required", new Object[0]);
        }
        if (this.mediaType.get() == null) {
            throw new IllegalStateException("unknown content type");
        }
        return this.content();
    }

    public final String header(String name) {
        List<String> values = this.headers.get(name);
        if (values != null && !values.isEmpty()) {
            return values.get(0);
        }
        return null;
    }

    public final List<String> getAllHeaderValues(String name) {
        List<String> values = this.headers.get(name);
        if (values != null) {
            return Collections.unmodifiableList(values);
        }
        return null;
    }

    public final Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public final long getRequestId() {
        return this.requestId;
    }

    @Nullable
    public final MediaType getMediaType() {
        return (MediaType)this.mediaType.get();
    }

    public HttpChannel getHttpChannel() {
        return this.httpChannel;
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public final boolean hasParam(String key) {
        return this.params.containsKey(key);
    }

    public final String param(String key) {
        this.consumedParams.add(key);
        return this.params.get(key);
    }

    public final String param(String key, String defaultValue) {
        this.consumedParams.add(key);
        String value = this.params.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Map<String, String> params() {
        return this.params;
    }

    public List<String> consumedParams() {
        return new ArrayList<String>(this.consumedParams);
    }

    List<String> unconsumedParams() {
        return this.params.keySet().stream().filter(p -> !this.consumedParams.contains(p)).collect(Collectors.toList());
    }

    public float paramAsFloat(String key, float defaultValue) {
        String sValue = this.param(key);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(sValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse float parameter [" + key + "] with value [" + sValue + "]", e);
        }
    }

    public int paramAsInt(String key, int defaultValue) {
        String sValue = this.param(key);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(sValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse int parameter [" + key + "] with value [" + sValue + "]", e);
        }
    }

    public long paramAsLong(String key, long defaultValue) {
        String sValue = this.param(key);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(sValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse long parameter [" + key + "] with value [" + sValue + "]", e);
        }
    }

    public boolean paramAsBoolean(String key, boolean defaultValue) {
        String rawParam = this.param(key);
        if (rawParam != null && rawParam.length() == 0) {
            return true;
        }
        return Booleans.parseBoolean((String)rawParam, (boolean)defaultValue);
    }

    public Boolean paramAsBoolean(String key, Boolean defaultValue) {
        return Booleans.parseBoolean((String)this.param(key), (Boolean)defaultValue);
    }

    public TimeValue paramAsTime(String key, TimeValue defaultValue) {
        return TimeValue.parseTimeValue((String)this.param(key), (TimeValue)defaultValue, (String)key);
    }

    public ByteSizeValue paramAsSize(String key, ByteSizeValue defaultValue) {
        return ByteSizeValue.parseBytesSizeValue((String)this.param(key), (ByteSizeValue)defaultValue, (String)key);
    }

    public String[] paramAsStringArray(String key, String[] defaultValue) {
        String value = this.param(key);
        if (value == null) {
            return defaultValue;
        }
        return Strings.splitStringByCommaToArray((String)value);
    }

    public String[] paramAsStringArrayOrEmptyIfAll(String key) {
        String[] params = this.paramAsStringArray(key, Strings.EMPTY_ARRAY);
        if (Strings.isAllOrWildcard((String[])params)) {
            return Strings.EMPTY_ARRAY;
        }
        return params;
    }

    public NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    public final XContentParser contentParser() throws IOException {
        BytesReference content = this.requiredContent();
        return ((MediaType)this.mediaType.get()).xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)content.streamInput());
    }

    public final void applyContentParser(CheckedConsumer<XContentParser, IOException> applyParser) throws IOException {
        if (this.hasContent()) {
            try (XContentParser parser = this.contentParser();){
                applyParser.accept((Object)parser);
            }
        }
    }

    public final boolean hasContentOrSourceParam() {
        return this.hasContent() || this.hasParam("source");
    }

    public final XContentParser contentOrSourceParamParser() throws IOException {
        Tuple<MediaType, BytesReference> tuple = this.contentOrSourceParam();
        return ((MediaType)tuple.v1()).xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)((BytesReference)tuple.v2()).streamInput());
    }

    public final void withContentOrSourceParamParserOrNull(CheckedConsumer<XContentParser, IOException> withParser) throws IOException {
        block13: {
            if (this.hasContentOrSourceParam()) {
                Tuple<MediaType, BytesReference> tuple = this.contentOrSourceParam();
                BytesReference content = (BytesReference)tuple.v2();
                MediaType mediaType = (MediaType)tuple.v1();
                try (StreamInput stream = content.streamInput();
                     XContentParser parser = mediaType.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);){
                    withParser.accept((Object)parser);
                    break block13;
                }
            }
            withParser.accept(null);
        }
    }

    public final Tuple<MediaType, BytesReference> contentOrSourceParam() {
        if (!this.hasContentOrSourceParam()) {
            throw new OpenSearchParseException("request body or source parameter is required", new Object[0]);
        }
        if (this.hasContent()) {
            return new Tuple((Object)((MediaType)this.mediaType.get()), (Object)this.requiredContent());
        }
        String source = this.param("source");
        String typeParam = this.param("source_content_type");
        if (source == null || typeParam == null) {
            throw new IllegalStateException("source and source_content_type parameters are required");
        }
        BytesArray bytes = new BytesArray(source);
        MediaType mediaType = RestRequest.parseContentType(Collections.singletonList(typeParam));
        if (mediaType == null) {
            throw new IllegalStateException("Unknown value for source_content_type [" + typeParam + "]");
        }
        return new Tuple((Object)mediaType, (Object)bytes);
    }

    public static MediaType parseContentType(List<String> header) {
        if (header == null || header.isEmpty()) {
            return null;
        }
        if (header.size() > 1) {
            throw new IllegalArgumentException("only one Content-Type header should be provided");
        }
        String rawContentType = header.get(0);
        String[] elements = rawContentType.split("[ \t]*;");
        if (elements.length > 0) {
            String[] splitMediaType = elements[0].split("/");
            if (splitMediaType.length == 2 && TCHAR_PATTERN.matcher(splitMediaType[0]).matches() && TCHAR_PATTERN.matcher(splitMediaType[1].trim()).matches()) {
                return MediaType.fromMediaType((String)elements[0]);
            }
            throw new IllegalArgumentException("invalid Content-Type header [" + rawContentType + "]");
        }
        throw new IllegalArgumentException("empty Content-Type header");
    }

    public PageParams parsePaginatedQueryParams(String defaultSortOrder, int defaultPageSize) {
        return new PageParams(this.param("next_token"), this.param("sort", defaultSortOrder), this.paramAsInt("size", defaultPageSize));
    }

    public static class ContentTypeHeaderException
    extends RuntimeException {
        ContentTypeHeaderException(IllegalArgumentException cause) {
            super(cause);
        }
    }

    public static class BadParameterException
    extends RuntimeException {
        BadParameterException(IllegalArgumentException cause) {
            super(cause);
        }
    }

    @PublicApi(since="1.0.0")
    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE,
        OPTIONS,
        HEAD,
        PATCH,
        TRACE,
        CONNECT;

    }
}

