/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.json.parse.impl;

import java.math.BigDecimal;
import java.util.LinkedList;
import org.directwebremoting.json.parse.JsonDecoder;
import org.directwebremoting.json.parse.JsonParseException;

public abstract class StatefulJsonDecoder
implements JsonDecoder {
    protected final LinkedList<Object> stack = new LinkedList();
    protected Object last = null;

    protected abstract Object createObject(Object var1, String var2) throws JsonParseException;

    protected abstract Object createArray(Object var1, String var2) throws JsonParseException;

    protected abstract void addMemberToObject(Object var1, String var2, Object var3) throws JsonParseException;

    protected abstract void addMemberToArray(Object var1, Object var2) throws JsonParseException;

    @Override
    public Object getRoot() throws JsonParseException {
        return this.last;
    }

    @Override
    public void beginObject(String propertyName) throws JsonParseException {
        Object obj = this.createObject(this.stackPeek(), propertyName);
        this.stack.addLast(obj);
    }

    @Override
    public void endObject(String propertyName) throws JsonParseException {
        this.last = this.stack.removeLast();
        if (!this.stack.isEmpty()) {
            this.add(propertyName, this.last);
        }
    }

    @Override
    public void beginArray(String propertyName) throws JsonParseException {
        Object obj = this.createArray(this.stackPeek(), propertyName);
        this.stack.addLast(obj);
    }

    @Override
    public void endArray(String propertyName) throws JsonParseException {
        this.last = this.stack.removeLast();
        if (!this.stack.isEmpty()) {
            this.add(propertyName, this.last);
        }
    }

    public void add(String propertyName, Object value) throws JsonParseException {
        if (propertyName == null) {
            this.addMemberToArray(this.stackPeek(), value);
        } else {
            this.addMemberToObject(this.stackPeek(), propertyName, value);
        }
    }

    @Override
    public void addString(String propertyName, String value) throws JsonParseException {
        this.add(propertyName, value);
    }

    @Override
    public void addNumber(String propertyName, String intPart, String floatPart, String expPart) throws JsonParseException {
        Object value = StatefulJsonDecoder.realizeNumber(intPart, floatPart, expPart);
        this.add(propertyName, value);
    }

    @Override
    public void addBoolean(String propertyName, boolean value) throws JsonParseException {
        this.add(propertyName, value);
    }

    @Override
    public void addNull(String propertyName) throws JsonParseException {
        this.add(propertyName, null);
    }

    protected Object stackPeek() {
        if (this.stack.isEmpty()) {
            return null;
        }
        return this.stack.getLast();
    }

    public static Object realizeNumber(String intPart, String floatPart, String expPart) {
        if (expPart != null) {
            return new BigDecimal(intPart + floatPart + expPart);
        }
        if (floatPart != null) {
            return Double.parseDouble(intPart + floatPart);
        }
        try {
            return Integer.parseInt(intPart);
        }
        catch (NumberFormatException ex) {
            try {
                return Long.parseLong(intPart);
            }
            catch (NumberFormatException ex2) {
                return new BigDecimal(intPart);
            }
        }
    }
}

