/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Computes the directional derivative of an image. The directional
derivative at each pixel location is computed by convolution with a
derivative operator of user-specified order.


SetOrder specifies the order of the derivative.

SetDirection specifies the direction of the derivative with respect to
the coordinate axes of the image.


See:
 Image

 Neighborhood

 NeighborhoodOperator

 NeighborhoodIterator

 itk::simple::Derivative for the procedural interface

 itk::DerivativeImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkDerivativeImageFilter.h
*/
public class DerivativeImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected DerivativeImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.DerivativeImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(DerivativeImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(DerivativeImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::DerivativeImageFilter::~DerivativeImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_DerivativeImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::DerivativeImageFilter::DerivativeImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  DerivativeImageFilter() {
    this(SimpleITKJNI.new_DerivativeImageFilter(), true);
  }

  /**
Self&amp; itk::simple::DerivativeImageFilter::SetDirection(unsigned int Direction)

The output pixel type must be signed. Standard get/set macros for
filter parameters.

*/
public  void setDirection(long Direction) {
    SimpleITKJNI.DerivativeImageFilter_setDirection(swigCPtr, this, Direction);
  }

  /**
unsigned int itk::simple::DerivativeImageFilter::GetDirection() const

The output pixel type must be signed. Standard get/set macros for
filter parameters.

*/
public  long getDirection() {
    return SimpleITKJNI.DerivativeImageFilter_getDirection(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DerivativeImageFilter::SetOrder(unsigned int Order)

The output pixel type must be signed. Standard get/set macros for
filter parameters.

*/
public  void setOrder(long Order) {
    SimpleITKJNI.DerivativeImageFilter_setOrder(swigCPtr, this, Order);
  }

  /**
unsigned int itk::simple::DerivativeImageFilter::GetOrder() const

The output pixel type must be signed. Standard get/set macros for
filter parameters.

*/
public  long getOrder() {
    return SimpleITKJNI.DerivativeImageFilter_getOrder(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DerivativeImageFilter::SetUseImageSpacing(bool UseImageSpacing)

Set/Get whether or not the filter will use the spacing of the input
image in its calculations. Use On to compute the derivatives in
physical space; use Off to ignore the image spacing and to compute the
derivatives in isotropic voxel space. Default is On.

*/
public  void setUseImageSpacing(boolean UseImageSpacing) {
    SimpleITKJNI.DerivativeImageFilter_setUseImageSpacing(swigCPtr, this, UseImageSpacing);
  }

  /**
Self&amp; itk::simple::DerivativeImageFilter::UseImageSpacingOn()

Set the value of UseImageSpacing to true or false respectfully.

*/
public  void useImageSpacingOn() {
    SimpleITKJNI.DerivativeImageFilter_useImageSpacingOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DerivativeImageFilter::UseImageSpacingOff()
*/
public  void useImageSpacingOff() {
    SimpleITKJNI.DerivativeImageFilter_useImageSpacingOff(swigCPtr, this);
  }

  /**
bool itk::simple::DerivativeImageFilter::GetUseImageSpacing() const

Set/Get whether or not the filter will use the spacing of the input
image in its calculations. Use On to compute the derivatives in
physical space; use Off to ignore the image spacing and to compute the
derivatives in isotropic voxel space. Default is On.

*/
public  boolean getUseImageSpacing() {
    return SimpleITKJNI.DerivativeImageFilter_getUseImageSpacing(swigCPtr, this);
  }

  /**
std::string itk::simple::DerivativeImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.DerivativeImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::DerivativeImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.DerivativeImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::DerivativeImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.DerivativeImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
