/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Collapses all labels into the first label.


This filter takes a label map as input and visits the pixels of all
labels and assigns them to the first label of the label map. At the
end of the execution of this filter, the map will contain a single
filter.

This implementation was taken from the Insight Journal paper: https://doi.org/10.54294/q6auw4


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 ShapeLabelObject , RelabelComponentImageFilter

 itk::simple::AggregateLabelMapFilter for the procedural interface

 itk::AggregateLabelMapFilter for the Doxygen on the original ITK class.


C++ includes: sitkAggregateLabelMapFilter.h
*/
public class AggregateLabelMapFilter extends ImageFilter {
  private transient long swigCPtr;

  protected AggregateLabelMapFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.AggregateLabelMapFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(AggregateLabelMapFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(AggregateLabelMapFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::AggregateLabelMapFilter::~AggregateLabelMapFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_AggregateLabelMapFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::AggregateLabelMapFilter::AggregateLabelMapFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  AggregateLabelMapFilter() {
    this(SimpleITKJNI.new_AggregateLabelMapFilter(), true);
  }

  /**
std::string itk::simple::AggregateLabelMapFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.AggregateLabelMapFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::AggregateLabelMapFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.AggregateLabelMapFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::AggregateLabelMapFilter::Execute(Image &amp;&amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.AggregateLabelMapFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
