#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              1.4.0.0
visibility:           public
id:                   lsp-1.4.0.0-IWKgnfRqSYH3KmDInzQNvL
key:                  lsp-1.4.0.0-IWKgnfRqSYH3KmDInzQNvL
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  16ae7f633df1e9ebbd1d8b399fd701ef
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Server,
    Language.LSP.Types from lsp-types-1.4.0.1-2bFsfeZQckWA7adjvuwT2E:Language.LSP.Types,
    Language.LSP.Types.Capabilities from lsp-types-1.4.0.1-2bFsfeZQckWA7adjvuwT2E:Language.LSP.Types.Capabilities,
    Language.LSP.Types.Lens from lsp-types-1.4.0.1-2bFsfeZQckWA7adjvuwT2E:Language.LSP.Types.Lens,
    Language.LSP.VFS from lsp-types-1.4.0.1-2bFsfeZQckWA7adjvuwT2E:Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Core Language.LSP.Server.Control
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-1.4.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-1.4.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-1.4.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp1.4
hs-libraries:         HSlsp-1.4.0.0-IWKgnfRqSYH3KmDInzQNvL
depends:
    aeson-2.1.2.1-Gng3eoGBP2Sj2fbUBsnWH
    async-2.2.5-6FnQWPoSLF0101MXuyNKqJ
    attoparsec-0.14.4-E6IyHj0fKXuH5r9QvhZ8oW base-4.17.2.1
    bytestring-0.11.5.3 containers-0.6.7
    data-default-0.7.1.1-86NXSPgvsmt76HSLrJaFnV exceptions-0.10.5
    hashable-1.4.4.0-D3M5e9EeJxCJTqzfO7ugwa
    hslogger-1.3.1.2-75J7MI6YzGD6y7Q3Mi4pPw
    lens-5.3-8ZK9QDANmBT9CZTQ77OGiP
    lsp-types-1.4.0.1-2bFsfeZQckWA7adjvuwT2E mtl-2.2.2
    network-uri-2.6.4.2-3JlqJJTWpo6F8MNpnCbeng
    random-1.2.1.2-FNtVSr9AyR5Fv650rjDfzJ
    scientific-0.3.7.0-43723I2k3fJ8FjtljY7WIm
    sorted-list-0.2.3.1-G6WNnBDl4fO8Pg47J7xGis stm-2.5.1.0 text-2.0.2
    time-1.12.2 transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-Asw2mvs6LgrELNyeUEam3W
    uuid-1.3.16-Dwhy0JVF1AV9mSE706nnCp

haddock-interfaces:   /usr/share/doc/haskell-lsp1.4/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp1.4/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

