#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              1.6.0.0
visibility:           public
id:                   lsp-1.6.0.0-Co7EnzQRcLkB1nGUK6qxXO
key:                  lsp-1.6.0.0-Co7EnzQRcLkB1nGUK6qxXO
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  fe28450af5e08d0de309869ac73221a5
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Logging,
    Language.LSP.Server,
    Language.LSP.Types from lsp-types-1.6.0.1-FhDct8eUWUx1AZAIgEVg8r:Language.LSP.Types,
    Language.LSP.Types.Capabilities from lsp-types-1.6.0.1-FhDct8eUWUx1AZAIgEVg8r:Language.LSP.Types.Capabilities,
    Language.LSP.Types.Lens from lsp-types-1.6.0.1-FhDct8eUWUx1AZAIgEVg8r:Language.LSP.Types.Lens,
    Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Core Language.LSP.Server.Control
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-1.6.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-1.6.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-1.6.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp
hs-libraries:         HSlsp-1.6.0.0-Co7EnzQRcLkB1nGUK6qxXO
depends:
    aeson-2.1.2.1-Gng3eoGBP2Sj2fbUBsnWH
    async-2.2.5-6FnQWPoSLF0101MXuyNKqJ
    attoparsec-0.14.4-E6IyHj0fKXuH5r9QvhZ8oW base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-BspKaH0gGYBYPLc2Xswpr
    containers-0.6.7 data-default-0.7.1.1-86NXSPgvsmt76HSLrJaFnV
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    hashable-1.4.4.0-D3M5e9EeJxCJTqzfO7ugwa
    lens-5.3-8ZK9QDANmBT9CZTQ77OGiP
    lsp-types-1.6.0.1-FhDct8eUWUx1AZAIgEVg8r mtl-2.2.2
    prettyprinter-1.7.1-G37JwSOM6BFGPcFlHNjXb6
    random-1.2.1.2-FNtVSr9AyR5Fv650rjDfzJ
    sorted-list-0.2.3.1-G6WNnBDl4fO8Pg47J7xGis stm-2.5.1.0
    temporary-1.3-FQWpMYFFv2g2HCDcFkOPeW text-2.0.2
    text-rope-0.3-FOCshUvi4lxJ7LyplGwLkJ transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-Asw2mvs6LgrELNyeUEam3W
    uuid-1.3.16-Dwhy0JVF1AV9mSE706nnCp

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

