#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.1
visibility:           public
id:                   hOpenPGP-2.10.1-DJaciO33aHTAXepvaREXct
key:                  hOpenPGP-2.10.1-DJaciO33aHTAXepvaREXct
license:              MIT
copyright:            2012-2025  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  c45e15180de588e135423c6ca3ca9e09
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Codec.Encryption.OpenPGP.Version Data.Conduit.OpenPGP.Compression
    Data.Conduit.OpenPGP.Decrypt Data.Conduit.OpenPGP.Filter
    Data.Conduit.OpenPGP.Keyring Data.Conduit.OpenPGP.Keyring.Instances
    Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs Paths_hOpenPGP

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.1-DJaciO33aHTAXepvaREXct
depends:
    aeson-2.1.2.1-Gng3eoGBP2Sj2fbUBsnWH
    asn1-encoding-0.9.6-GholD8Ysgt4GmfKSOPwmIn
    attoparsec-0.14.4-E6IyHj0fKXuH5r9QvhZ8oW base-4.17.2.1
    base16-bytestring-1.0.2.0-8y3SyptL8obHk6RuDrxcpW
    bifunctors-5.6.1-EK2RlwLGwBM7rNGJAIWPym binary-0.8.9.1
    binary-conduit-1.3.1-C2dFbfKUAXqAw8QJ7zDSBI bytestring-0.11.5.3
    bz2-1.0.1.1-10z9I8TqkLrEBixTqDMjCk
    conduit-1.3.6.1-CTNxTBwbo3PGCTtXLpLpH4
    conduit-extra-1.3.7-J2dsol3NH8o2F5R2VKU1oH containers-0.6.7
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    crypton-1.0.1-3x2lypkbPAS73y9tSsktrR
    errors-2.3.0-4oft3Ld8KU5HW2zzqsFjYC
    hashable-1.4.4.0-D3M5e9EeJxCJTqzfO7ugwa
    incremental-parser-0.5.1-82YFZNhIOllFlm7Ku7hWol
    ixset-typed-0.5.1.0-6BZJAQ2rH3D7ah3P62PtVr
    lens-5.3-8ZK9QDANmBT9CZTQ77OGiP
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-loops-0.4.3-KaRiS5mJjkQ1zBkxxbNC2Z
    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
    network-uri-2.6.4.2-3JlqJJTWpo6F8MNpnCbeng
    openpgp-asciiarmor-0.1.2-FC5FuYsZ00t2DBVDg9en0W
    prettyprinter-1.7.1-G37JwSOM6BFGPcFlHNjXb6
    resourcet-1.2.6-LvbunWgaFi52yDP9C6hdhe
    split-0.2.5-KlKHd5o1KWaBkefamTdKTk text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2 unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-Asw2mvs6LgrELNyeUEam3W
    zlib-0.7.0.0-3MuK5VyJlvTLS6H6PQyZ9l

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

