#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 flexible-defaults
version:              0.0.3
visibility:           public
id:                   flexible-defaults-0.0.3-6Qz86HuFfIJFfd6l7buttE
key:                  flexible-defaults-0.0.3-6Qz86HuFfIJFfd6l7buttE
license:              LicenseRef-PublicDomain
maintainer:           Peter Simons <simons@cryp.to>
author:               James Cook <mokus@deepbondi.net>
stability:            provisional
homepage:             https://github.com/peti/flexible-defaults
synopsis:
    Generate default function implementations for complex type classes.

description:
    Template Haskell code to implement default implementations
    for type-class functions based on which functions are
    already implemented.  Currently extremely crude but
    still fairly effective.

    When defining a type class with many functions, each
    of which can be implemented based on arbitrary subsets
    of the others, the standard default-implementation
    concept breaks down quite badly.  This library provides
    a system by which more complex rules can be described
    for choosing default implementations based on which
    ones the user supplies.  These implementations can
    additionally be given \"suitability scores\", so that
    when multiple possible choices could be made, the
    library can choose the \"best\" one.

category:             Code Generation, Template Haskell
abi:                  a230903a7005a160fbcfc0a66f4292c4
exposed:              True
exposed-modules:      Language.Haskell.TH.FlexibleDefaults
hidden-modules:
    Language.Haskell.TH.FlexibleDefaults.DSL
    Language.Haskell.TH.FlexibleDefaults.Solve

import-dirs:          /usr/lib/ghc-9.4.8/site-local/flexible-defaults-0.0.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/flexible-defaults-0.0.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/flexible-defaults-0.0.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-flexible-defaults
hs-libraries:         HSflexible-defaults-0.0.3-6Qz86HuFfIJFfd6l7buttE
depends:
    base-4.17.2.1 containers-0.6.7 template-haskell-2.19.0.0
    th-extras-0.0.0.8-22LSa1IBXer5UQXktqUFX2 transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-flexible-defaults/html/flexible-defaults.haddock

haddock-html:         /usr/share/doc/haskell-flexible-defaults/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

