# Fish shell completion for gum
# Generated by gum completion

# disable file completion unless explicitly enabled
complete -c gum -f

# gum
complete -c gum -f -s h -l help -d "Show context-sensitive help."
complete -c gum -f -s v -l version -d "Print the version number"

# choose
complete -c gum -f -n '__fish_use_subcommand' -a choose -d 'Choose an option from a list of choices'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l limit -d "Maximum number of options to pick"
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l no-limit -d "Pick unlimited number of options (ignores limit)"
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l ordered -d "Maintain the order of the selected options"
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l height -d "Height of the list"
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l cursor -d "Prefix to show on item that corresponds to the cursor position"
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l show-help -d "Show help keybinds"
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l timeout -d "Timeout until choose returns selected element"
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l header -d "Header value"
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l cursor-prefix -d "Prefix to show on the cursor item (hidden if limit is 1)"
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l selected-prefix -d "Prefix to show on selected items (hidden if limit is 1)"
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l unselected-prefix -d "Prefix to show on unselected items (hidden if limit is 1)"
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l selected -d "Options that should start as selected (selects all if given *)"
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l select-if-one -d "Select the given option if there is only one"
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l input-delimiter -d "Option delimiter when reading from STDIN"
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l output-delimiter -d "Option delimiter when writing to STDOUT"
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l label-delimiter -d "Allows to set a delimiter, so options can be set as label:value"
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l strip-ansi -d "Strip ANSI sequences when reading from STDIN"
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l cursor.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l cursor.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l header.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l header.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l item.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l item.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l selected.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l selected.background -d "Background Color"

# confirm
complete -c gum -f -n '__fish_use_subcommand' -a confirm -d 'Ask a user to confirm an action'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -l default -d "Default confirmation action"
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -l show-output -d "Print prompt and chosen action to output"
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l affirmative -d "The title of the affirmative action"
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l negative -d "The title of the negative action"
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l prompt.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l prompt.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l selected.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l selected.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l unselected.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l unselected.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -l show-help -d "Show help key binds"
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l timeout -d "Timeout until confirm returns selected value or default if provided"

# file
complete -c gum -f -n '__fish_use_subcommand' -a file -d 'Pick a file from a folder'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -s c -l cursor -d "The cursor character"
complete -c gum -f -n '__fish_seen_subcommand_from file' -s a -l all -d "Show hidden and 'dot' files"
complete -c gum -f -n '__fish_seen_subcommand_from file' -s p -l permissions -d "Show file permissions"
complete -c gum -f -n '__fish_seen_subcommand_from file' -s s -l size -d "Show file size"
complete -c gum -f -n '__fish_seen_subcommand_from file' -l file -d "Allow files selection"
complete -c gum -f -n '__fish_seen_subcommand_from file' -l directory -d "Allow directories selection"
complete -c gum -f -n '__fish_seen_subcommand_from file' -l show-help -d "Show help key binds"
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l timeout -d "Timeout until command aborts without a selection"
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l header -d "Header value"
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l height -d "Maximum number of files to display"
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l cursor.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l cursor.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l symlink.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l symlink.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l directory.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l directory.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l file.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l file.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l permissions.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l permissions.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l selected.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l selected.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l file-size.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l file-size.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l header.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l header.background -d "Background Color"

# filter
complete -c gum -f -n '__fish_use_subcommand' -a filter -d 'Filter items from a list'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l indicator -d "Character for selection"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l indicator.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l indicator.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l limit -d "Maximum number of options to pick"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l no-limit -d "Pick unlimited number of options (ignores limit)"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l select-if-one -d "Select the given option if there is only one"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l selected -d "Options that should start as selected (selects all if given *)"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l show-help -d "Show help keybinds"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l strict -d "Only returns if anything matched. Otherwise return Filter"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l selected-prefix -d "Character to indicate selected items (hidden if limit is 1)"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l selected-indicator.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l selected-indicator.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l unselected-prefix -d "Character to indicate unselected items (hidden if limit is 1)"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l unselected-prefix.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l unselected-prefix.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l header.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l header.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l header -d "Header value"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l text.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l text.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l cursor-text.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l cursor-text.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l match.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l match.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l placeholder -d "Placeholder value"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l prompt -d "Prompt to display"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l prompt.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l prompt.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l placeholder.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l placeholder.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l width -d "Input width"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l height -d "Input height"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l value -d "Initial filter value"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l reverse -d "Display from the bottom of the screen"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l fuzzy -d "Enable fuzzy matching; otherwise match from start of word"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l fuzzy-sort -d "Sort fuzzy results by their scores"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l timeout -d "Timeout until filter command aborts"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l input-delimiter -d "Option delimiter when reading from STDIN"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l output-delimiter -d "Option delimiter when writing to STDOUT"
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l strip-ansi -d "Strip ANSI sequences when reading from STDIN"

# format
complete -c gum -f -n '__fish_use_subcommand' -a format -d 'Format a string using a template'
complete -c gum -f -n '__fish_seen_subcommand_from format' -x -l theme -d "Glamour theme to use for markdown formatting"
complete -c gum -f -n '__fish_seen_subcommand_from format' -x -s l -l language -d "Programming language to parse code"
complete -c gum -f -n '__fish_seen_subcommand_from format' -l strip-ansi -d "Strip ANSI sequences when reading from STDIN"
complete -c gum -f -n '__fish_seen_subcommand_from format' -xa 'markdown template code emoji' -s t -l type -d "Format to use (markdown,template,code,emoji)"

# input
complete -c gum -f -n '__fish_use_subcommand' -a input -d 'Prompt for some input'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l placeholder -d "Placeholder value"
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l prompt -d "Prompt to display"
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l prompt.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l prompt.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l placeholder.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l placeholder.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l cursor.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l cursor.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from input' -xa 'blink hide static' -l cursor.mode -d "Cursor mode"
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l value -d "Initial value (can also be passed via stdin)"
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l char-limit -d "Maximum value length (0 for no limit)"
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l width -d "Input width (0 for terminal width)"
complete -c gum -f -n '__fish_seen_subcommand_from input' -l password -d "Mask input characters"
complete -c gum -f -n '__fish_seen_subcommand_from input' -l show-help -d "Show help keybinds"
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l header -d "Header value"
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l header.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l header.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l timeout -d "Timeout until input aborts"
complete -c gum -f -n '__fish_seen_subcommand_from input' -l strip-ansi -d "Strip ANSI sequences when reading from STDIN"

# join
complete -c gum -f -n '__fish_use_subcommand' -a join -d 'Join text vertically or horizontally'
complete -c gum -f -n '__fish_seen_subcommand_from join' -xa 'left center right bottom middle top' -l align -d "Text alignment"
complete -c gum -f -n '__fish_seen_subcommand_from join' -l horizontal -d "Join (potentially multi-line) strings horizontally"
complete -c gum -f -n '__fish_seen_subcommand_from join' -l vertical -d "Join (potentially multi-line) strings vertically"

# pager
complete -c gum -f -n '__fish_use_subcommand' -a pager -d 'Scroll through a file'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from pager' -l show-line-numbers -d "Show line numbers"
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l line-number.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l line-number.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from pager' -l soft-wrap -d "Soft wrap lines"
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l match.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l match.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l match-highlight.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l match-highlight.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l timeout -d "Timeout until command exits"
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l help.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l help.background -d "Background Color"

# spin
complete -c gum -f -n '__fish_use_subcommand' -a spin -d 'Display spinner while running a command'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -l show-output -d "Show or pipe output of command during execution (shows both STDOUT and STDERR)"
complete -c gum -f -n '__fish_seen_subcommand_from spin' -l show-error -d "Show output of command only if the command fails"
complete -c gum -f -n '__fish_seen_subcommand_from spin' -l show-stdout -d "Show STDOUT output"
complete -c gum -f -n '__fish_seen_subcommand_from spin' -l show-stderr -d "Show STDERR errput"
complete -c gum -f -n '__fish_seen_subcommand_from spin' -xa 'line dot minidot jump pulse points globe moon monkey meter hamburger' -s s -l spinner -d "Spinner type"
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l spinner.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l spinner.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l title -d "Text to display to user while spinning"
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l title.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l title.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from spin' -xa 'left right' -s a -l align -d "Alignment of spinner with regard to the title"
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l timeout -d "Timeout until spin command aborts"

# style
complete -c gum -f -n '__fish_use_subcommand' -a style -d 'Apply coloring, borders, spacing to text'
complete -c gum -f -n '__fish_seen_subcommand_from style' -l trim -d "Trim whitespaces on every input line"
complete -c gum -f -n '__fish_seen_subcommand_from style' -l strip-ansi -d "Strip ANSI sequences when reading from STDIN"
complete -c gum -f -n '__fish_seen_subcommand_from style' -x -l foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from style' -x -l background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from style' -xa 'none hidden normal rounded thick double' -l border -d "Border Style"
complete -c gum -f -n '__fish_seen_subcommand_from style' -x -l border-background -d "Border Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from style' -x -l border-foreground -d "Border Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from style' -xa 'left center right bottom middle top' -l align -d "Text Alignment"
complete -c gum -f -n '__fish_seen_subcommand_from style' -x -l height -d "Text height"
complete -c gum -f -n '__fish_seen_subcommand_from style' -x -l width -d "Text width"
complete -c gum -f -n '__fish_seen_subcommand_from style' -x -l margin -d "Text margin"
complete -c gum -f -n '__fish_seen_subcommand_from style' -x -l padding -d "Text padding"
complete -c gum -f -n '__fish_seen_subcommand_from style' -l bold -d "Bold text"
complete -c gum -f -n '__fish_seen_subcommand_from style' -l faint -d "Faint text"
complete -c gum -f -n '__fish_seen_subcommand_from style' -l italic -d "Italicize text"
complete -c gum -f -n '__fish_seen_subcommand_from style' -l strikethrough -d "Strikethrough text"
complete -c gum -f -n '__fish_seen_subcommand_from style' -l underline -d "Underline text"

# table
complete -c gum -f -n '__fish_use_subcommand' -a table -d 'Render a table of data'
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -s s -l separator -d "Row separator"
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -s c -l columns -d "Column names"
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -s w -l widths -d "Column widths"
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l height -d "Table height"
complete -c gum -f -n '__fish_seen_subcommand_from table' -s p -l print -d "static print"
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -s f -l file -d "file path"
complete -c gum -f -n '__fish_seen_subcommand_from table' -xa 'rounded thick normal hidden double none' -s b -l border -d "border style"
complete -c gum -f -n '__fish_seen_subcommand_from table' -l show-help -d "Show help keybinds"
complete -c gum -f -n '__fish_seen_subcommand_from table' -l hide-count -d "Hide item count on help keybinds"
complete -c gum -f -n '__fish_seen_subcommand_from table' -l lazy-quotes -d "If LazyQuotes is true, a quote may appear in an unquoted field and a non-doubled quote may appear in a quoted field"
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l fields-per-record -d "Sets the number of expected fields per record"
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l border.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l border.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l cell.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l cell.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l header.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l header.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l selected.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l selected.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -s r -l return-column -d "Which column number should be returned instead of whole row as string. Default=0 returns whole Row"
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l timeout -d "Timeout until choose returns selected element"

# write
complete -c gum -f -n '__fish_use_subcommand' -a write -d 'Prompt for long-form text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l width -d "Text area width (0 for terminal width)"
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l height -d "Text area height"
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l header -d "Header value"
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l placeholder -d "Placeholder value"
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l prompt -d "Prompt to display"
complete -c gum -f -n '__fish_seen_subcommand_from write' -l show-cursor-line -d "Show cursor line"
complete -c gum -f -n '__fish_seen_subcommand_from write' -l show-line-numbers -d "Show line numbers"
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l value -d "Initial value (can be passed via stdin)"
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l char-limit -d "Maximum value length (0 for no limit)"
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l max-lines -d "Maximum number of lines (0 for no limit)"
complete -c gum -f -n '__fish_seen_subcommand_from write' -l show-help -d "Show help key binds"
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'blink hide static' -l cursor.mode -d "Cursor mode"
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l timeout -d "Timeout until choose returns selected element"
complete -c gum -f -n '__fish_seen_subcommand_from write' -l strip-ansi -d "Strip ANSI sequences when reading from STDIN"
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l base.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l base.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line-number.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line-number.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l end-of-buffer.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l end-of-buffer.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l line-number.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l line-number.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l header.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l header.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l placeholder.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l placeholder.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l prompt.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l prompt.background -d "Background Color"

# log
complete -c gum -f -n '__fish_use_subcommand' -a log -d 'Log messages to output'
complete -c gum -f -n '__fish_seen_subcommand_from log' -x -s o -l file -d "Log to file"
complete -c gum -f -n '__fish_seen_subcommand_from log' -s f -l format -d "Format message using printf"
complete -c gum -f -n '__fish_seen_subcommand_from log' -xa 'json logfmt text' -l formatter -d "The log formatter to use"
complete -c gum -f -n '__fish_seen_subcommand_from log' -xa 'none debug info warn error fatal' -s l -l level -d "The log level to use"
complete -c gum -f -n '__fish_seen_subcommand_from log' -x -l prefix -d "Prefix to print before the message"
complete -c gum -f -n '__fish_seen_subcommand_from log' -s s -l structured -d "Use structured logging"
complete -c gum -f -n '__fish_seen_subcommand_from log' -x -s t -l time -d "The time format to use (kitchen, layout, ansic, rfc822, etc...)"
complete -c gum -f -n '__fish_seen_subcommand_from log' -x -l min-level -d "Minimal level to show"
complete -c gum -f -n '__fish_seen_subcommand_from log' -x -l level.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from log' -x -l level.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from log' -x -l time.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from log' -x -l time.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from log' -x -l prefix.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from log' -x -l prefix.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from log' -x -l message.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from log' -x -l message.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from log' -x -l key.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from log' -x -l key.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from log' -x -l value.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from log' -x -l value.background -d "Background Color"
complete -c gum -f -n '__fish_seen_subcommand_from log' -x -l separator.foreground -d "Foreground Color"
complete -c gum -f -n '__fish_seen_subcommand_from log' -x -l separator.background -d "Background Color"

# version-check
complete -c gum -f -n '__fish_use_subcommand' -a version-check -d 'Semver check current gum version'

