/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview.plugin.renderers;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.gephi.graph.api.Node;
import org.gephi.preview.api.CanvasSize;
import org.gephi.preview.api.G2DTarget;
import org.gephi.preview.api.Item;
import org.gephi.preview.api.PDFTarget;
import org.gephi.preview.api.PreviewModel;
import org.gephi.preview.api.PreviewProperties;
import org.gephi.preview.api.PreviewProperty;
import org.gephi.preview.api.RenderTarget;
import org.gephi.preview.api.SVGTarget;
import org.gephi.preview.plugin.builders.NodeBuilder;
import org.gephi.preview.plugin.items.NodeItem;
import org.gephi.preview.plugin.renderers.PDFUtils;
import org.gephi.preview.plugin.renderers.SVGUtils;
import org.gephi.preview.spi.ItemBuilder;
import org.gephi.preview.spi.Renderer;
import org.gephi.preview.types.DependantColor;
import org.openide.util.NbBundle;
import org.w3c.dom.Element;

public class NodeRenderer
implements Renderer {
    protected float defaultBorderWidth = 1.0f;
    protected DependantColor defaultBorderColor = new DependantColor(Color.BLACK);
    protected float defaultOpacity = 100.0f;
    protected boolean defaultPerNodeOpacity = false;
    protected boolean defaultFixedNodeBorder = true;
    protected float defaultBorderWidthFactor = 0.16f;

    public void preProcess(PreviewModel previewModel) {
    }

    public void render(Item item, RenderTarget target, PreviewProperties properties) {
        if (target instanceof G2DTarget) {
            this.renderG2D(item, (G2DTarget)target, properties);
        } else if (target instanceof SVGTarget) {
            this.renderSVG(item, (SVGTarget)target, properties);
        } else if (target instanceof PDFTarget) {
            this.renderPDF(item, (PDFTarget)target, properties);
        }
    }

    public void postProcess(PreviewModel previewModel, RenderTarget renderTarget, PreviewProperties properties) {
    }

    public CanvasSize getCanvasSize(Item item, PreviewProperties properties) {
        float x = ((Float)item.getData("x")).floatValue();
        float y = ((Float)item.getData("y")).floatValue();
        float s = ((Float)item.getData("size")).floatValue();
        float r = s / 2.0f;
        int intS = Math.round(s);
        return new CanvasSize((float)Math.round(x - r), (float)Math.round(y - r), (float)intS, (float)intS);
    }

    private float getBorderWidth(PreviewProperties properties, float nodeSize) {
        if (properties.getBooleanValue("node.border.fixed")) {
            return properties.getFloatValue("node.border.width");
        }
        return nodeSize * this.defaultBorderWidthFactor / 2.0f;
    }

    public void renderG2D(Item item, G2DTarget target, PreviewProperties properties) {
        int alpha;
        Float x = (Float)item.getData("x");
        Float y = (Float)item.getData("y");
        Float size = (Float)item.getData("size");
        Color color = (Color)item.getData("color");
        Color borderColor = ((DependantColor)properties.getValue("node.border.color")).getColor(color);
        float borderSize = this.getBorderWidth(properties, size.floatValue());
        int n = alpha = properties.getBooleanValue("node.per.node.opacity") ? color.getAlpha() : (int)(properties.getFloatValue("node.opacity") / 100.0f * 255.0f);
        if (alpha < 0) {
            alpha = 0;
        }
        if (alpha > 255) {
            alpha = 255;
        }
        Graphics2D graphics = target.getGraphics();
        borderSize = Math.min(borderSize, size.floatValue() / 2.0f);
        size = Float.valueOf(size.floatValue() - borderSize);
        x = Float.valueOf(x.floatValue() - size.floatValue() / 2.0f);
        y = Float.valueOf(y.floatValue() - size.floatValue() / 2.0f);
        Ellipse2D.Float ellipse = alpha == 255 ? new Ellipse2D.Float(x.floatValue() + borderSize / 4.0f, y.floatValue() + borderSize / 4.0f, size.floatValue() - borderSize / 2.0f, size.floatValue() - borderSize / 2.0f) : new Ellipse2D.Float(x.floatValue() + borderSize / 2.0f, y.floatValue() + borderSize / 2.0f, size.floatValue() - borderSize, size.floatValue() - borderSize);
        graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha));
        graphics.fill(ellipse);
        if (borderSize > 0.0f) {
            Ellipse2D.Float borderEllipse = new Ellipse2D.Float(x.floatValue(), y.floatValue(), size.floatValue(), size.floatValue());
            graphics.setColor(new Color(borderColor.getRed(), borderColor.getGreen(), borderColor.getBlue(), alpha));
            graphics.setStroke(new BasicStroke(borderSize));
            graphics.draw(borderEllipse);
        }
    }

    public void renderSVG(Item item, SVGTarget target, PreviewProperties properties) {
        Element nodeElem;
        float alpha;
        Node node = (Node)item.getSource();
        Float x = (Float)item.getData("x");
        Float y = (Float)item.getData("y");
        Float size = (Float)item.getData("size");
        Color color = (Color)item.getData("color");
        Color borderColor = ((DependantColor)properties.getValue("node.border.color")).getColor(color);
        float borderSize = this.getBorderWidth(properties, size.floatValue());
        float f = alpha = properties.getBooleanValue("node.per.node.opacity") ? (float)color.getAlpha() / 255.0f : properties.getFloatValue("node.opacity") / 100.0f;
        if (alpha > 1.0f) {
            alpha = 1.0f;
        }
        borderSize = Math.min(borderSize, size.floatValue() / 2.0f);
        Element nodeBorderElem = nodeElem = target.createElement("circle");
        nodeElem.setAttribute("class", SVGUtils.idAsClassAttribute(node.getId()));
        nodeElem.setAttribute("cx", x.toString());
        nodeElem.setAttribute("cy", y.toString());
        nodeElem.setAttribute("fill", target.toHexString(color));
        nodeElem.setAttribute("fill-opacity", "" + alpha);
        if (borderSize > 0.0f) {
            if (alpha < 1.0f) {
                nodeBorderElem = target.createElement("circle");
                nodeBorderElem.setAttribute("cx", x.toString());
                nodeBorderElem.setAttribute("cy", y.toString());
                nodeBorderElem.setAttribute("r", Float.toString(size.floatValue() / 2.0f - borderSize / 2.0f));
                nodeBorderElem.setAttribute("fill", "none");
                nodeElem.setAttribute("r", Float.toString(size.floatValue() / 2.0f - borderSize));
                target.getTopElement("nodes").appendChild(nodeElem);
            } else {
                nodeElem.setAttribute("r", Float.toString((size.floatValue() - borderSize) / 2.0f));
            }
            nodeBorderElem.setAttribute("stroke", target.toHexString(borderColor));
            nodeBorderElem.setAttribute("stroke-width", Float.toString(borderSize * target.getScaleRatio()));
            nodeBorderElem.setAttribute("stroke-opacity", "" + alpha);
        } else {
            nodeElem.setAttribute("r", Float.toString((size.floatValue() - borderSize) / 2.0f));
        }
        target.getTopElement("nodes").appendChild(nodeBorderElem);
    }

    public void renderPDF(Item item, PDFTarget target, PreviewProperties properties) {
        Float x = (Float)item.getData("x");
        Float y = (Float)item.getData("y");
        Float size = (Float)item.getData("size");
        Color color = (Color)item.getData("color");
        Color borderColor = ((DependantColor)properties.getValue("node.border.color")).getColor(color);
        float borderSize = this.getBorderWidth(properties, size.floatValue());
        float alpha = properties.getBooleanValue("node.per.node.opacity") ? (float)color.getAlpha() / 255.0f : properties.getFloatValue("node.opacity") / 100.0f;
        borderSize = Math.min(borderSize, size.floatValue() / 2.0f);
        PDPageContentStream cb = target.getContentStream();
        try {
            cb.setStrokingColor(borderColor);
            cb.setLineWidth(borderSize);
            cb.setNonStrokingColor(color);
            if (alpha < 1.0f) {
                PDExtendedGraphicsState graphicsState = new PDExtendedGraphicsState();
                graphicsState.setStrokingAlphaConstant(Float.valueOf(alpha));
                graphicsState.setNonStrokingAlphaConstant(Float.valueOf(alpha));
                cb.saveGraphicsState();
                cb.setGraphicsStateParameters(graphicsState);
            }
            PDFUtils.drawCircle(cb, x.floatValue(), -y.floatValue(), size.floatValue() / 2.0f - borderSize / 2.0f);
            if (borderSize > 0.0f && alpha == 1.0f) {
                cb.fillAndStroke();
            } else if (borderSize > 0.0f && alpha < 1.0f) {
                cb.stroke();
                PDFUtils.drawCircle(cb, x.floatValue(), -y.floatValue(), size.floatValue() / 2.0f - borderSize);
                cb.fill();
            } else {
                cb.fill();
            }
            if (alpha < 1.0f) {
                cb.restoreGraphicsState();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public PreviewProperty[] getProperties() {
        return new PreviewProperty[]{PreviewProperty.createProperty((Object)this, (String)"node.border.fixed", Boolean.class, (String)NbBundle.getMessage(NodeRenderer.class, (String)"NodeRenderer.property.fixedBorderWidth.displayName"), (String)NbBundle.getMessage(NodeRenderer.class, (String)"NodeRenderer.property.fixedBorderWidth.description"), (String)PreviewProperty.CATEGORY_NODES).setValue((Object)this.defaultFixedNodeBorder), PreviewProperty.createProperty((Object)this, (String)"node.border.width", Float.class, (String)NbBundle.getMessage(NodeRenderer.class, (String)"NodeRenderer.property.borderWidth.displayName"), (String)NbBundle.getMessage(NodeRenderer.class, (String)"NodeRenderer.property.borderWidth.description"), (String)PreviewProperty.CATEGORY_NODES, (String[])new String[]{"node.border.fixed"}).setValue((Object)Float.valueOf(this.defaultBorderWidth)), PreviewProperty.createProperty((Object)this, (String)"node.border.color", DependantColor.class, (String)NbBundle.getMessage(NodeRenderer.class, (String)"NodeRenderer.property.borderColor.displayName"), (String)NbBundle.getMessage(NodeRenderer.class, (String)"NodeRenderer.property.borderColor.description"), (String)PreviewProperty.CATEGORY_NODES).setValue((Object)this.defaultBorderColor), PreviewProperty.createProperty((Object)this, (String)"node.opacity", Float.class, (String)NbBundle.getMessage(NodeRenderer.class, (String)"NodeRenderer.property.opacity.displayName"), (String)NbBundle.getMessage(NodeRenderer.class, (String)"NodeRenderer.property.opacity.description"), (String)PreviewProperty.CATEGORY_NODES).setValue((Object)Float.valueOf(this.defaultOpacity)), PreviewProperty.createProperty((Object)this, (String)"node.per.node.opacity", Boolean.class, (String)NbBundle.getMessage(NodeRenderer.class, (String)"NodeRenderer.property.perNodeOpacity.displayName"), (String)NbBundle.getMessage(NodeRenderer.class, (String)"NodeRenderer.property.perNodeOpacity.description"), (String)PreviewProperty.CATEGORY_NODES).setValue((Object)this.defaultPerNodeOpacity)};
    }

    private boolean showNodes(PreviewProperties properties) {
        return properties.getFloatValue("node.opacity") > 0.0f;
    }

    public boolean isRendererForitem(Item item, PreviewProperties properties) {
        return item instanceof NodeItem && this.showNodes(properties);
    }

    public boolean needsItemBuilder(ItemBuilder itemBuilder, PreviewProperties properties) {
        return itemBuilder instanceof NodeBuilder && this.showNodes(properties);
    }

    public String getDisplayName() {
        return NbBundle.getMessage(NodeRenderer.class, (String)"NodeRenderer.name");
    }
}

