/*
 * Decompiled with CFR 0.152.
 */
package com.bric.swing;

import com.bric.swing.ColorPicker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

class ColorPickerDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    ColorPicker cp;
    int alpha;
    JButton ok = new JButton(ColorPicker.strings.getObject("OK").toString());
    JButton cancel = new JButton(ColorPicker.strings.getObject("Cancel").toString());
    Color returnValue = null;
    ActionListener buttonListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == ColorPickerDialog.this.ok) {
                ColorPickerDialog.this.returnValue = ColorPickerDialog.this.cp.getColor();
            }
            ColorPickerDialog.this.setVisible(false);
        }
    };

    ColorPickerDialog(Frame owner, Color color, boolean includeOpacity) {
        super(owner);
        this.initialize(owner, color, includeOpacity);
        this.initActions();
    }

    ColorPickerDialog(Dialog owner, Color color, boolean includeOpacity) {
        super(owner);
        this.initialize(owner, color, includeOpacity);
        this.initActions();
    }

    private void initActions() {
        this.getRootPane().setDefaultButton(this.ok);
        this.getRootPane().getActionMap().put("cancel", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorPickerDialog.this.cancel.doClick();
            }
        });
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0, false), "cancel");
    }

    private void initialize(Component owner, Color color, boolean includeOpacity) {
        this.cp = new ColorPicker(true, includeOpacity);
        this.setModal(true);
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridwidth = 0;
        c.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.cp, c);
        ++c.gridy;
        c.gridwidth = 1;
        this.getContentPane().add((Component)new JPanel(), c);
        ++c.gridx;
        c.weightx = 0.0;
        this.getContentPane().add((Component)this.cancel, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.getContentPane().add((Component)this.ok, c);
        this.cp.setRGB(color.getRed(), color.getGreen(), color.getBlue());
        this.cp.setOpacity((float)color.getAlpha() / 255.0f);
        this.alpha = color.getAlpha();
        this.pack();
        this.setLocationRelativeTo(owner);
        this.ok.addActionListener(this.buttonListener);
        this.cancel.addActionListener(this.buttonListener);
        this.getRootPane().setDefaultButton(this.ok);
    }

    public Color getColor() {
        return this.returnValue;
    }
}

