/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.ScriptNode;

public final class OptFunctionNode {
    public final FunctionNode fnode;
    private boolean[] numberVarFlags;
    private int directTargetIndex = -1;
    private boolean itsParameterNumberContext;
    boolean itsContainsCalls0;
    boolean itsContainsCalls1;

    OptFunctionNode(FunctionNode functionNode) {
        this.fnode = functionNode;
        functionNode.setCompilerData(this);
    }

    public static OptFunctionNode get(ScriptNode scriptNode, int n) {
        FunctionNode functionNode = scriptNode.getFunctionNode(n);
        return (OptFunctionNode)functionNode.getCompilerData();
    }

    public static OptFunctionNode get(ScriptNode scriptNode) {
        return (OptFunctionNode)scriptNode.getCompilerData();
    }

    public boolean isTargetOfDirectCall() {
        return this.directTargetIndex >= 0;
    }

    public int getDirectTargetIndex() {
        return this.directTargetIndex;
    }

    void setDirectTargetIndex(int n) {
        if (n < 0 || this.directTargetIndex >= 0) {
            Kit.codeBug();
        }
        this.directTargetIndex = n;
    }

    void setParameterNumberContext(boolean bl) {
        this.itsParameterNumberContext = bl;
    }

    public boolean getParameterNumberContext() {
        return this.itsParameterNumberContext;
    }

    public int getVarCount() {
        return this.fnode.getParamAndVarCount();
    }

    public boolean isParameter(int n) {
        return n < this.fnode.getParamCount();
    }

    public boolean isNumberVar(int n) {
        if ((n -= this.fnode.getParamCount()) >= 0 && this.numberVarFlags != null) {
            return this.numberVarFlags[n];
        }
        return false;
    }

    void setIsNumberVar(int n) {
        if ((n -= this.fnode.getParamCount()) < 0) {
            Kit.codeBug();
        }
        if (this.numberVarFlags == null) {
            int n2 = this.fnode.getParamAndVarCount() - this.fnode.getParamCount();
            this.numberVarFlags = new boolean[n2];
        }
        this.numberVarFlags[n] = true;
    }

    public int getVarIndex(Node node) {
        int n = node.getIntProp(7, -1);
        if (n == -1) {
            Node node2;
            int n2 = node.getType();
            if (n2 == 55) {
                node2 = node;
            } else if (n2 == 56 || n2 == 160) {
                node2 = node.getFirstChild();
            } else {
                throw Kit.codeBug();
            }
            n = this.fnode.getIndexForNameNode(node2);
            if (n < 0) {
                throw Kit.codeBug();
            }
            node.putIntProp(7, n);
        }
        return n;
    }
}

