/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.Jump;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.NodeVisitor;

public class BreakStatement
extends Jump {
    private Name breakLabel;
    private AstNode target;

    public BreakStatement() {
        this.type = 124;
    }

    public BreakStatement(int n) {
        this.type = 124;
        this.position = n;
    }

    public BreakStatement(int n, int n2) {
        this.type = 124;
        this.position = n;
        this.length = n2;
    }

    public Name getBreakLabel() {
        return this.breakLabel;
    }

    public void setBreakLabel(Name name) {
        this.breakLabel = name;
        if (name != null) {
            name.setParent(this);
        }
    }

    public AstNode getBreakTarget() {
        return this.target;
    }

    public void setBreakTarget(Jump jump) {
        this.assertNotNull(jump);
        this.target = jump;
        this.setJumpStatement(jump);
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.makeIndent(n));
        stringBuilder.append("break");
        if (this.breakLabel != null) {
            stringBuilder.append(" ");
            stringBuilder.append(this.breakLabel.toSource(0));
        }
        stringBuilder.append(";\n");
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this) && this.breakLabel != null) {
            this.breakLabel.visit(nodeVisitor);
        }
    }
}

