/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.HSLColor;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.HSLColorValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PercentageValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import org.w3c.dom.DOMException;

class HSLColorImpl
extends BaseColor
implements HSLColor {
    private static final long serialVersionUID = 1L;
    private PrimitiveValue hue = null;
    private PrimitiveValue saturation = null;
    private PrimitiveValue lightness = null;

    HSLColorImpl() {
    }

    @Override
    public CSSColorValue.ColorModel getColorModel() {
        return CSSColorValue.ColorModel.HSL;
    }

    @Override
    public PrimitiveValue item(int n) {
        switch (n) {
            case 0: {
                return this.alpha;
            }
            case 1: {
                return this.getHue();
            }
            case 2: {
                return this.getSaturation();
            }
            case 3: {
                return this.getLightness();
            }
        }
        return null;
    }

    @Override
    void setComponent(int n, PrimitiveValue primitiveValue) {
        switch (n) {
            case 0: {
                this.setAlpha(primitiveValue);
                break;
            }
            case 1: {
                this.setHue(primitiveValue);
                break;
            }
            case 2: {
                this.setSaturation(primitiveValue);
                break;
            }
            case 3: {
                this.setLightness(primitiveValue);
            }
        }
    }

    @Override
    public PrimitiveValue getHue() {
        return this.hue;
    }

    public void setHue(PrimitiveValue primitiveValue) {
        this.hue = HSLColorImpl.enforceHueComponent(primitiveValue);
    }

    @Override
    public PrimitiveValue getSaturation() {
        return this.saturation;
    }

    public void setSaturation(PrimitiveValue primitiveValue) {
        this.saturation = HSLColorImpl.enforcePcntOrNumberComponent(primitiveValue);
    }

    @Override
    public PrimitiveValue getLightness() {
        return this.lightness;
    }

    public void setLightness(PrimitiveValue primitiveValue) {
        this.lightness = HSLColorImpl.enforcePcntOrNumberComponent(primitiveValue);
    }

    @Override
    boolean hasConvertibleComponents() {
        return HSLColorImpl.isConvertibleComponent(this.getSaturation()) && HSLColorImpl.isConvertibleComponent(this.getHue()) && HSLColorImpl.isConvertibleComponent(this.getLightness());
    }

    @Override
    void setColorComponents(double[] dArray) {
        NumberValue numberValue = NumberValue.createCSSNumberValue((short)80, (float)dArray[0]);
        numberValue.setSubproperty(true);
        numberValue.setAbsolutizedUnit();
        this.setHue(numberValue);
        PercentageValue percentageValue = new PercentageValue();
        percentageValue.setFloatValue((short)2, (float)dArray[1]);
        percentageValue.setSubproperty(true);
        percentageValue.setAbsolutizedUnit();
        this.setSaturation(percentageValue);
        PercentageValue percentageValue2 = new PercentageValue();
        percentageValue2.setFloatValue((short)2, (float)dArray[2]);
        percentageValue2.setSubproperty(true);
        percentageValue2.setAbsolutizedUnit();
        this.setLightness(percentageValue2);
    }

    @Override
    public double[] toNumberArray() throws DOMException {
        if (!this.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        double[] dArray = new double[]{ColorUtil.hueDegrees((CSSTypedValue)((Object)this.getHue())), ColorUtil.floatPercent((CSSTypedValue)((Object)this.getSaturation())), ColorUtil.floatPercent((CSSTypedValue)((Object)this.getLightness()))};
        return dArray;
    }

    @Override
    double[] toSRGB(boolean bl) {
        if (!this.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        double d = ColorUtil.hueDegrees((CSSTypedValue)((Object)this.getHue())) / 360.0;
        float f = ColorUtil.fraction((CSSTypedValue)((Object)this.getSaturation()));
        float f2 = ColorUtil.fraction((CSSTypedValue)((Object)this.getLightness()));
        double[] dArray = new double[3];
        HSLColorImpl.hslToSRGB(d, f, f2, dArray);
        return dArray;
    }

    private static void hslToSRGB(double d, float f, float f2, double[] dArray) {
        if (d > 1.0) {
            d -= Math.floor(d);
        } else if (d < 0.0) {
            d = d - Math.floor(d) + 1.0;
        }
        float f3 = f2 <= 0.5f ? f2 * (f + 1.0f) : f2 + f - f2 * f;
        float f4 = f2 * 2.0f - f3;
        dArray[0] = HSLColorImpl.hueToRgb(f4, f3, d + 0.3333333333333333);
        dArray[1] = HSLColorImpl.hueToRgb(f4, f3, d);
        dArray[2] = HSLColorImpl.hueToRgb(f4, f3, d - 0.3333333333333333);
    }

    private static double hueToRgb(float f, float f2, double d) {
        if (d < 0.0) {
            d += 1.0;
        } else if (d > 1.0) {
            d -= 1.0;
        }
        if (d * 6.0 < 1.0) {
            return (double)f + (double)(f2 - f) * d * 6.0;
        }
        if (d * 2.0 < 1.0) {
            return f2;
        }
        if (d * 3.0 < 2.0) {
            return (double)f + (double)(f2 - f) * (0.6666666666666666 - d) * 6.0;
        }
        return f;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    String toString(boolean bl) {
        boolean bl2 = this.isNonOpaque();
        if (bl) {
            return this.oldString(bl2);
        }
        return this.newString(bl2);
    }

    private String oldString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(22);
        if (bl) {
            stringBuilder.append("hsla(");
        } else {
            stringBuilder.append("hsl(");
        }
        this.appendHue(stringBuilder, this.hue);
        stringBuilder.append(", ").append(this.saturation.getCssText()).append(", ").append(this.lightness.getCssText());
        if (bl) {
            stringBuilder.append(", ");
            this.appendAlphaChannel(stringBuilder);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private String newString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(20);
        stringBuilder.append("hsl(");
        this.appendHue(stringBuilder, this.hue);
        stringBuilder.append(' ').append(this.saturation.getCssText()).append(' ').append(this.lightness.getCssText());
        if (bl) {
            stringBuilder.append(" / ");
            this.appendAlphaChannel(stringBuilder);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public String toMinifiedString() {
        return this.toMinifiedString(true);
    }

    String toMinifiedString(boolean bl) {
        boolean bl2 = this.isNonOpaque();
        if (bl) {
            return this.oldMinifiedString(bl2);
        }
        return this.minifiedString(bl2);
    }

    private String oldMinifiedString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(21);
        if (bl) {
            stringBuilder.append("hsla(");
        } else {
            stringBuilder.append("hsl(");
        }
        this.appendMinifiedHue(stringBuilder, this.hue);
        stringBuilder.append(',').append(this.saturation.getMinifiedCssText("color")).append(',').append(this.lightness.getMinifiedCssText("color"));
        if (bl) {
            stringBuilder.append(',');
            this.appendAlphaChannelMinified(stringBuilder);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private String minifiedString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(20);
        stringBuilder.append("hsl(");
        this.appendMinifiedHue(stringBuilder, this.hue);
        stringBuilder.append(' ').append(this.saturation.getMinifiedCssText("color")).append(' ').append(this.lightness.getMinifiedCssText("color"));
        if (bl) {
            stringBuilder.append('/');
            this.appendAlphaChannelMinified(stringBuilder);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.hue == null ? 0 : this.hue.hashCode());
        n2 = 31 * n2 + (this.lightness == null ? 0 : this.lightness.hashCode());
        n2 = 31 * n2 + (this.saturation == null ? 0 : this.saturation.hashCode());
        n2 = 31 * n2 + this.alpha.hashCode();
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HSLColorImpl hSLColorImpl = (HSLColorImpl)object;
        if (this.hue == null ? hSLColorImpl.hue != null : !this.hue.equals(hSLColorImpl.hue)) {
            return false;
        }
        if (this.lightness == null ? hSLColorImpl.lightness != null : !this.lightness.equals(hSLColorImpl.lightness)) {
            return false;
        }
        if (this.saturation == null ? hSLColorImpl.saturation != null : !this.saturation.equals(hSLColorImpl.saturation)) {
            return false;
        }
        return this.alpha.equals(hSLColorImpl.alpha);
    }

    @Override
    public ColorValue packInValue() {
        return new HSLColorValue(this);
    }

    @Override
    public HSLColorImpl clone() {
        HSLColorImpl hSLColorImpl = new HSLColorImpl();
        hSLColorImpl.alpha = this.alpha.clone();
        if (this.hue != null) {
            hSLColorImpl.hue = this.hue.clone();
        }
        if (this.saturation != null) {
            hSLColorImpl.saturation = this.saturation.clone();
        }
        if (this.lightness != null) {
            hSLColorImpl.lightness = this.lightness.clone();
        }
        return hSLColorImpl;
    }
}

