/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.AngleFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.LexicalUnitImpl;
import io.sf.carte.doc.style.css.parser.MultiArgScalingFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.PowFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.RoundFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.ScalingFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.SqrtFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.UnitlessFunctionUnitImpl;
import java.util.HashMap;
import java.util.Map;

class FunctionFactories {
    private static final Map<String, CSSParser.LexicalUnitFactory> factories = FunctionFactories.createFactoryMap();

    FunctionFactories() {
    }

    private static Map<String, CSSParser.LexicalUnitFactory> createFactoryMap() {
        HashMap<String, CSSParser.LexicalUnitFactory> hashMap = new HashMap<String, CSSParser.LexicalUnitFactory>(45);
        hashMap.put("calc", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.CALC);
            }
        });
        hashMap.put("attr", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.ATTR);
            }
        });
        hashMap.put("type", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.TYPE_FUNCTION);
            }
        });
        hashMap.put("var", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.VAR);
            }
        });
        hashMap.put("url", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.URI);
            }
        });
        hashMap.put("src", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.SRC);
            }
        });
        hashMap.put("element", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.ELEMENT_REFERENCE);
            }
        });
        hashMap.put("rect", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.RECT_FUNCTION);
            }
        });
        hashMap.put("counter", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.COUNTER_FUNCTION);
            }
        });
        hashMap.put("counters", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.COUNTERS_FUNCTION);
            }
        });
        hashMap.put("cubic-bezier", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.CUBIC_BEZIER_FUNCTION);
            }
        });
        hashMap.put("steps", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.STEPS_FUNCTION);
            }
        });
        CSSParser.LexicalUnitFactory lexicalUnitFactory = new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.RGBCOLOR);
            }
        };
        hashMap.put("rgb", lexicalUnitFactory);
        hashMap.put("rgba", lexicalUnitFactory);
        CSSParser.LexicalUnitFactory lexicalUnitFactory2 = new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.HSLCOLOR);
            }
        };
        hashMap.put("hsl", lexicalUnitFactory2);
        hashMap.put("hsla", lexicalUnitFactory2);
        hashMap.put("lab", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.LABCOLOR);
            }
        });
        hashMap.put("lch", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.LCHCOLOR);
            }
        });
        hashMap.put("oklab", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.OKLABCOLOR);
            }
        });
        hashMap.put("oklch", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.OKLCHCOLOR);
            }
        });
        hashMap.put("hwb", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.HWBCOLOR);
            }
        });
        hashMap.put("color", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.COLOR_FUNCTION);
            }
        });
        hashMap.put("color-mix", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new LexicalUnitImpl(LexicalUnit.LexicalType.COLOR_MIX);
            }
        });
        hashMap.put("abs", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new ScalingFunctionUnitImpl(0);
            }
        });
        hashMap.put("clamp", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new MultiArgScalingFunctionUnitImpl(1);
            }
        });
        hashMap.put("max", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new MultiArgScalingFunctionUnitImpl(2);
            }
        });
        hashMap.put("min", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new MultiArgScalingFunctionUnitImpl(3);
            }
        });
        hashMap.put("round", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new RoundFunctionUnitImpl(4);
            }
        });
        hashMap.put("mod", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new MultiArgScalingFunctionUnitImpl(5);
            }
        });
        hashMap.put("rem", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new MultiArgScalingFunctionUnitImpl(6);
            }
        });
        hashMap.put("hypot", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new MultiArgScalingFunctionUnitImpl(7);
            }
        });
        hashMap.put("hypot2", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new MultiArgScalingFunctionUnitImpl(8);
            }
        });
        hashMap.put("log", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new UnitlessFunctionUnitImpl(9);
            }
        });
        hashMap.put("exp", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new UnitlessFunctionUnitImpl(10);
            }
        });
        hashMap.put("sqrt", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new SqrtFunctionUnitImpl(11);
            }
        });
        hashMap.put("pow", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new PowFunctionUnitImpl(12);
            }
        });
        hashMap.put("sign", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new UnitlessFunctionUnitImpl(13);
            }
        });
        hashMap.put("sin", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new UnitlessFunctionUnitImpl(14);
            }
        });
        hashMap.put("cos", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new UnitlessFunctionUnitImpl(15);
            }
        });
        hashMap.put("tan", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new UnitlessFunctionUnitImpl(16);
            }
        });
        hashMap.put("asin", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new AngleFunctionUnitImpl(17);
            }
        });
        hashMap.put("acos", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new AngleFunctionUnitImpl(18);
            }
        });
        hashMap.put("atan", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new AngleFunctionUnitImpl(19);
            }
        });
        hashMap.put("atan2", new CSSParser.LexicalUnitFactory(){

            @Override
            public LexicalUnitImpl createUnit() {
                return new AngleFunctionUnitImpl(20);
            }
        });
        return hashMap;
    }

    public static CSSParser.LexicalUnitFactory getFactory(String string) {
        return factories.get(string);
    }
}

