/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.echosvg.css.engine.value.ColorValue;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.ImmutableRGBColorValue;
import io.sf.carte.echosvg.css.engine.value.ImmutableUnitValue;
import io.sf.carte.echosvg.css.engine.value.NumericValue;
import io.sf.carte.echosvg.css.engine.value.svg.SVGValueConstants;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.w3c.api.DOMSyntaxException;
import org.w3c.css.om.typed.CSSNumericValue;
import org.w3c.css.om.typed.CSSRGB;
import org.w3c.css.om.unit.CSSUnit;
import org.w3c.dom.DOMException;

public class RGBColorValue
extends ColorValue
implements CSSRGB {
    private static final long serialVersionUID = 1L;
    NumericValue red;
    NumericValue green;
    NumericValue blue;
    private transient boolean pcntSpecified;
    private transient boolean alphaPcntSpecified;

    public RGBColorValue(NumericValue numericValue, NumericValue numericValue2, NumericValue numericValue3) throws DOMSyntaxException {
        this(numericValue, numericValue2, numericValue3, SVGValueConstants.NUMBER_1.clone());
    }

    public RGBColorValue(NumericValue numericValue, NumericValue numericValue2, NumericValue numericValue3, NumericValue numericValue4) throws DOMSyntaxException {
        super(numericValue4);
        this.setRGB(numericValue, numericValue2, numericValue3);
    }

    void setRGB(NumericValue numericValue, NumericValue numericValue2, NumericValue numericValue3) {
        this.setR(numericValue);
        this.setG(numericValue2);
        this.setB(numericValue3);
    }

    public RGBColorValue(float[] fArray) {
        super(new FloatValue(0, fArray[3]));
        this.red = new FloatValue(0, fArray[0]);
        this.componentize(this.red);
        this.green = new FloatValue(0, fArray[1]);
        this.componentize(this.green);
        this.blue = new FloatValue(0, fArray[2]);
        this.componentize(this.blue);
    }

    public static RGBColorValue createConstant(NumericValue numericValue, NumericValue numericValue2, NumericValue numericValue3) throws DOMSyntaxException, IllegalArgumentException {
        numericValue = RGBColorValue.constantLegacyRange(numericValue);
        numericValue2 = RGBColorValue.constantLegacyRange(numericValue2);
        numericValue3 = RGBColorValue.constantLegacyRange(numericValue3);
        return new ImmutableRGBColorValue(numericValue, numericValue2, numericValue3);
    }

    public static RGBColorValue createConstant(NumericValue numericValue, NumericValue numericValue2, NumericValue numericValue3, NumericValue numericValue4) throws DOMSyntaxException, IllegalArgumentException {
        numericValue = RGBColorValue.constantLegacyRange(numericValue);
        numericValue2 = RGBColorValue.constantLegacyRange(numericValue2);
        numericValue3 = RGBColorValue.constantLegacyRange(numericValue3);
        return new ImmutableRGBColorValue(numericValue, numericValue2, numericValue3, numericValue4);
    }

    public static RGBColorValue createLegacy(NumericValue numericValue, NumericValue numericValue2, NumericValue numericValue3) throws DOMSyntaxException, IllegalArgumentException {
        numericValue = RGBColorValue.legacyRange(numericValue);
        numericValue2 = RGBColorValue.legacyRange(numericValue2);
        numericValue3 = RGBColorValue.legacyRange(numericValue3);
        RGBColorValue rGBColorValue = new RGBColorValue(numericValue, numericValue2, numericValue3);
        rGBColorValue.pcntSpecified = numericValue.getUnitType() == 2 || numericValue2.getUnitType() == 2 || numericValue3.getUnitType() == 2;
        return rGBColorValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static NumericValue constantLegacyRange(NumericValue numericValue) throws DOMSyntaxException, IllegalArgumentException {
        if (numericValue.getUnitType() == 0) {
            if (numericValue.getPrimitiveType() != CSSValue.Type.NUMERIC) throw new IllegalArgumentException("Cannot normalize value to [0,1] now: " + numericValue.getCssText());
            numericValue = new ImmutableUnitValue(0, numericValue.getFloatValue() / 255.0f);
        } else if (numericValue.getUnitType() != 2) {
            throw new DOMSyntaxException("RGB component must be a number or percentage, not a " + CSSUnit.dimensionUnitString((short)numericValue.getUnitType()) + '.');
        }
        if (numericValue.handler == null) return numericValue;
        return new ImmutableUnitValue(numericValue.getUnitType(), numericValue.getFloatValue());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static NumericValue legacyRange(NumericValue numericValue) throws DOMSyntaxException, IllegalArgumentException {
        if (numericValue.getUnitType() == 0) {
            if (numericValue.getPrimitiveType() != CSSValue.Type.NUMERIC) throw new IllegalArgumentException("Cannot normalize value to [0,1] now: " + numericValue.getCssText());
            numericValue.setFloatValue(numericValue.getFloatValue() / 255.0f);
            return numericValue;
        } else {
            if (numericValue.getUnitType() == 2) return numericValue;
            throw new DOMSyntaxException("RGB component must be a number or percentage, not a " + CSSUnit.dimensionUnitString((short)numericValue.getUnitType()) + '.');
        }
    }

    void setSpecifiedAsPercentage(boolean bl) {
        this.pcntSpecified = bl;
    }

    void setAlphaSpecifiedAsPercentage(boolean bl) {
        this.alphaPcntSpecified = bl;
    }

    @Override
    public String getCSSColorSpace() {
        return "rgb";
    }

    public String getCssText() {
        Object object;
        DecimalFormat decimalFormat = null;
        if (!this.pcntSpecified || !this.alphaPcntSpecified) {
            object = new DecimalFormatSymbols(Locale.ROOT);
            decimalFormat = new DecimalFormat("#.#", (DecimalFormatSymbols)object);
            decimalFormat.setMinimumFractionDigits(0);
            decimalFormat.setMaximumFractionDigits(3);
        }
        object = this.rgbComponentText(this.red, decimalFormat);
        String string = this.rgbComponentText(this.green, decimalFormat);
        String string2 = this.rgbComponentText(this.blue, decimalFormat);
        StringBuilder stringBuilder = new StringBuilder(((String)object).length() + string.length() + string2.length() + 16);
        boolean bl = this.isOpaque();
        if (bl) {
            stringBuilder.append("rgb(");
        } else {
            stringBuilder.append("rgba(");
        }
        stringBuilder.append((String)object).append(", ").append(string).append(", ").append(string2);
        if (!bl) {
            stringBuilder.append(", ").append(this.alphaComponentText(this.alpha, decimalFormat));
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private String rgbComponentText(NumericValue numericValue, DecimalFormat decimalFormat) {
        if (this.pcntSpecified) {
            return numericValue.getCssText();
        }
        float f = numericValue.getUnitType() == 0 ? numericValue.getFloatValue() * 255.0f : numericValue.getFloatValue() * 2.55f;
        return decimalFormat.format(f);
    }

    private String alphaComponentText(NumericValue numericValue, DecimalFormat decimalFormat) {
        if (this.alphaPcntSpecified || numericValue.getUnitType() == 0) {
            return numericValue.getCssText();
        }
        return decimalFormat.format(numericValue.getFloatValue() * 0.01f);
    }

    @Override
    public RGBColorValue getColorValue() {
        return this;
    }

    public NumericValue getR() {
        return this.red;
    }

    public NumericValue getG() {
        return this.green;
    }

    public NumericValue getB() {
        return this.blue;
    }

    public NumericValue getRed() {
        return this.red;
    }

    public NumericValue getGreen() {
        return this.green;
    }

    public NumericValue getBlue() {
        return this.blue;
    }

    public void setR(double d) {
        this.red = new FloatValue(2, (float)d * 100.0f);
        this.pcntSpecified = true;
        this.componentize(this.red);
        this.componentChanged(this.red);
    }

    public void setR(CSSNumericValue cSSNumericValue) throws DOMSyntaxException {
        this.red = this.component(cSSNumericValue);
        this.componentChanged(this.red);
        this.pcntSpecified = this.red.getUnitType() == 2;
    }

    private NumericValue component(CSSNumericValue cSSNumericValue) throws DOMSyntaxException {
        NumericValue numericValue = (NumericValue)cSSNumericValue;
        if (numericValue.getUnitType() != 2 && numericValue.getUnitType() != 0) {
            throw new DOMSyntaxException("RGB component must be a number or percentage, not a " + CSSUnit.dimensionUnitString((short)numericValue.getUnitType()) + '.');
        }
        if (numericValue.handler != null) {
            numericValue = numericValue.clone();
        }
        this.componentize(numericValue);
        return numericValue;
    }

    public void setG(double d) {
        this.green = new FloatValue(2, (float)d * 100.0f);
        this.pcntSpecified = true;
        this.componentize(this.green);
        this.componentChanged(this.green);
    }

    public void setG(CSSNumericValue cSSNumericValue) throws DOMSyntaxException {
        this.green = this.component(cSSNumericValue);
        this.componentChanged(this.green);
    }

    public void setB(double d) {
        this.blue = new FloatValue(2, (float)d * 100.0f);
        this.pcntSpecified = true;
        this.componentize(this.blue);
        this.componentChanged(this.blue);
    }

    public void setB(CSSNumericValue cSSNumericValue) throws DOMSyntaxException {
        this.blue = this.component(cSSNumericValue);
        this.componentChanged(this.blue);
    }

    @Override
    public int getLength() throws DOMException {
        return 4;
    }

    @Override
    public NumericValue item(int n) throws DOMException {
        switch (n) {
            case 0: {
                return this.getR();
            }
            case 1: {
                return this.getG();
            }
            case 2: {
                return this.getB();
            }
            case 3: {
                return this.getAlpha();
            }
        }
        return null;
    }

    @Override
    public RGBColorValue clone() {
        RGBColorValue rGBColorValue = (RGBColorValue)super.clone();
        rGBColorValue.red = this.red.clone();
        rGBColorValue.green = this.green.clone();
        rGBColorValue.blue = this.blue.clone();
        rGBColorValue.pcntSpecified = this.pcntSpecified;
        rGBColorValue.alphaPcntSpecified = this.alphaPcntSpecified;
        return rGBColorValue;
    }
}

