/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.value.PendingValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class StyleMap {
    public static final int IMPORTANT_MASK = 1;
    public static final int COMPUTED_MASK = 2;
    public static final int NULL_CASCADED_MASK = 4;
    public static final int INHERITED_MASK = 8;
    public static final int LINE_HEIGHT_RELATIVE_MASK = 16;
    public static final int FONT_SIZE_RELATIVE_MASK = 32;
    public static final int COLOR_RELATIVE_MASK = 64;
    public static final int PARENT_RELATIVE_MASK = 128;
    public static final int BLOCK_WIDTH_RELATIVE_MASK = 256;
    public static final int BLOCK_HEIGHT_RELATIVE_MASK = 512;
    public static final int BOX_RELATIVE_MASK = 1024;
    public static final int ROOT_LINE_HEIGHT_RELATIVE_MASK = 2048;
    public static final int ROOT_FONT_SIZE_RELATIVE_MASK = 4096;
    public static final int VIEWPORT_RELATIVE_MASK = 8192;
    public static final int CUSTOM_PTY_RELATIVE_MASK = 16384;
    public static final int ATTR_TAINTED_MASK = 32768;
    public static final int ORIGIN_MASK = -536870912;
    public static final int USER_AGENT_ORIGIN = 0;
    public static final int USER_ORIGIN = 0x20000000;
    public static final int NON_CSS_ORIGIN = 0x40000000;
    public static final int AUTHOR_ORIGIN = 0x60000000;
    public static final int INLINE_AUTHOR_ORIGIN = Integer.MIN_VALUE;
    public static final int OVERRIDE_ORIGIN = -1610612736;
    protected Value[] values;
    protected int[] masks;
    private Map<String, LexicalUnit> customProperties = null;
    protected boolean fixedCascadedValues;

    public StyleMap(int n) {
        this.values = new Value[n];
        this.masks = new int[n];
    }

    public boolean hasFixedCascadedValues() {
        return this.fixedCascadedValues;
    }

    public void setFixedCascadedStyle(boolean bl) {
        this.fixedCascadedValues = bl;
    }

    public Value getValue(int n) {
        return this.values[n];
    }

    public int getMask(int n) {
        return this.masks[n];
    }

    public boolean isImportant(int n) {
        return (this.masks[n] & 1) != 0;
    }

    public boolean isComputed(int n) {
        return (this.masks[n] & 2) != 0;
    }

    public boolean isNullCascaded(int n) {
        return (this.masks[n] & 4) != 0;
    }

    public boolean isInherited(int n) {
        return (this.masks[n] & 8) != 0;
    }

    public int getOrigin(int n) {
        return this.masks[n] & 0xE0000000;
    }

    public boolean isColorRelative(int n) {
        return (this.masks[n] & 0x40) != 0;
    }

    public boolean isParentRelative(int n) {
        return (this.masks[n] & 0x80) != 0;
    }

    public boolean isLineHeightRelative(int n) {
        return (this.masks[n] & 0x10) != 0;
    }

    public boolean isFontSizeRelative(int n) {
        return (this.masks[n] & 0x20) != 0;
    }

    public boolean isRootLineHeightRelative(int n) {
        return (this.masks[n] & 0x800) != 0;
    }

    public boolean isRootFontSizeRelative(int n) {
        return (this.masks[n] & 0x1000) != 0;
    }

    public boolean isBlockWidthRelative(int n) {
        return (this.masks[n] & 0x100) != 0;
    }

    public boolean isBlockHeightRelative(int n) {
        return (this.masks[n] & 0x200) != 0;
    }

    public boolean isViewportRelative(int n) {
        return (this.masks[n] & 0x2000) != 0;
    }

    public boolean isCustomPtyRelative(int n) {
        return (this.masks[n] & 0x4000) != 0;
    }

    public boolean isAttrTainted(int n) {
        return (this.masks[n] & 0x8000) != 0;
    }

    public void putValue(int n, Value value) {
        this.values[n] = value;
    }

    public void putMask(int n, int n2) {
        this.masks[n] = n2;
    }

    public void putImportant(int n, boolean bl) {
        if (bl) {
            int n2 = n;
            this.masks[n2] = this.masks[n2] | 1;
        } else {
            int n3 = n;
            this.masks[n3] = this.masks[n3] & 0xFFFFFFFE;
        }
    }

    public void putOrigin(int n, int n2) {
        int n3 = n;
        this.masks[n3] = this.masks[n3] & 0x1FFFFFFF;
        int n4 = n;
        this.masks[n4] = this.masks[n4] | n2 & 0xE0000000;
    }

    public void putComputed(int n, boolean bl) {
        if (bl) {
            int n2 = n;
            this.masks[n2] = this.masks[n2] | 2;
        } else {
            int n3 = n;
            this.masks[n3] = this.masks[n3] & 0xFFFFFFFD;
        }
    }

    public void putNullCascaded(int n, boolean bl) {
        if (bl) {
            int n2 = n;
            this.masks[n2] = this.masks[n2] | 4;
        } else {
            int n3 = n;
            this.masks[n3] = this.masks[n3] & 0xFFFFFFFB;
        }
    }

    public void putInherited(int n, boolean bl) {
        if (bl) {
            int n2 = n;
            this.masks[n2] = this.masks[n2] | 8;
        } else {
            int n3 = n;
            this.masks[n3] = this.masks[n3] & 0xFFFFFFF7;
        }
    }

    public void putColorRelative(int n, boolean bl) {
        if (bl) {
            int n2 = n;
            this.masks[n2] = this.masks[n2] | 0x40;
        } else {
            int n3 = n;
            this.masks[n3] = this.masks[n3] & 0xFFFFFFBF;
        }
    }

    public void putParentRelative(int n, boolean bl) {
        if (bl) {
            int n2 = n;
            this.masks[n2] = this.masks[n2] | 0x80;
        } else {
            int n3 = n;
            this.masks[n3] = this.masks[n3] & 0xFFFFFF7F;
        }
    }

    public void putLineHeightRelative(int n, boolean bl) {
        if (bl) {
            int n2 = n;
            this.masks[n2] = this.masks[n2] | 0x10;
        } else {
            int n3 = n;
            this.masks[n3] = this.masks[n3] & 0xFFFFFFEF;
        }
    }

    public void putFontSizeRelative(int n, boolean bl) {
        if (bl) {
            int n2 = n;
            this.masks[n2] = this.masks[n2] | 0x20;
        } else {
            int n3 = n;
            this.masks[n3] = this.masks[n3] & 0xFFFFFFDF;
        }
    }

    public void putRootLineHeightRelative(int n, boolean bl) {
        if (bl) {
            int n2 = n;
            this.masks[n2] = this.masks[n2] | 0x800;
        } else {
            int n3 = n;
            this.masks[n3] = this.masks[n3] & 0xFFFFF7FF;
        }
    }

    public void putRootFontSizeRelative(int n, boolean bl) {
        if (bl) {
            int n2 = n;
            this.masks[n2] = this.masks[n2] | 0x1000;
        } else {
            int n3 = n;
            this.masks[n3] = this.masks[n3] & 0xFFFFEFFF;
        }
    }

    public void putBlockWidthRelative(int n, boolean bl) {
        if (bl) {
            int n2 = n;
            this.masks[n2] = this.masks[n2] | 0x100;
        } else {
            int n3 = n;
            this.masks[n3] = this.masks[n3] & 0xFFFFFEFF;
        }
    }

    public void putBlockHeightRelative(int n, boolean bl) {
        if (bl) {
            int n2 = n;
            this.masks[n2] = this.masks[n2] | 0x200;
        } else {
            int n3 = n;
            this.masks[n3] = this.masks[n3] & 0xFFFFFDFF;
        }
    }

    public void putViewportRelative(int n, boolean bl) {
        if (bl) {
            int n2 = n;
            this.masks[n2] = this.masks[n2] | 0x2000;
        } else {
            int n3 = n;
            this.masks[n3] = this.masks[n3] & 0xFFFFDFFF;
        }
    }

    public void putCustomPtyRelative(int n, boolean bl) {
        if (bl) {
            int n2 = n;
            this.masks[n2] = this.masks[n2] | 0x4000;
        } else {
            int n3 = n;
            this.masks[n3] = this.masks[n3] & 0xFFFFBFFF;
        }
    }

    public void putAttrTainted(int n, boolean bl) {
        if (bl) {
            int n2 = n;
            this.masks[n2] = this.masks[n2] | 0x8000;
        } else {
            int n3 = n;
            this.masks[n3] = this.masks[n3] & 0xFFFF7FFF;
        }
    }

    public void putCustomProperty(String string, LexicalUnit lexicalUnit) {
        if (this.customProperties == null) {
            this.customProperties = new HashMap<String, LexicalUnit>();
        }
        this.customProperties.put(string, lexicalUnit);
    }

    public LexicalUnit getCustomProperty(String string) {
        return this.customProperties != null ? this.customProperties.get(string) : null;
    }

    public String toString(CSSEngine cSSEngine) {
        HashSet<String> hashSet = null;
        int n = this.values.length;
        StringBuilder stringBuilder = new StringBuilder(n * 8 + 32);
        for (int i = 0; i < n; ++i) {
            PendingValue pendingValue;
            String string;
            Value object = this.values[i];
            if (object == null) continue;
            if (object.getPrimitiveType() != CSSValue.Type.INTERNAL) {
                stringBuilder.append(cSSEngine.getPropertyName(i));
                stringBuilder.append(": ");
                stringBuilder.append(object);
                if (this.isImportant(i)) {
                    stringBuilder.append(" !important");
                }
                stringBuilder.append(";\n");
                continue;
            }
            if (hashSet == null) {
                hashSet = new HashSet<String>();
            }
            if (!hashSet.add(string = (pendingValue = (PendingValue)object).getShorthandName())) continue;
            stringBuilder.append(string);
            stringBuilder.append(": ");
            stringBuilder.append(pendingValue.getLexicalUnit().toString());
            if (this.isImportant(i)) {
                stringBuilder.append(" !important");
            }
            stringBuilder.append(";\n");
        }
        if (this.customProperties != null) {
            for (Map.Entry<String, LexicalUnit> entry : this.customProperties.entrySet()) {
                stringBuilder.append(entry.getKey());
                stringBuilder.append(": ");
                stringBuilder.append(entry.getValue().toString());
                stringBuilder.append(";\n");
            }
        }
        return stringBuilder.toString();
    }
}

