/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.util;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.concurrent.locks.ReentrantLock;

public class CleanerThread
extends Thread {
    private static long queueTimeoutMs = 45000L;
    private static final ReentrantLock queueLock = new ReentrantLock();
    private static ReferenceQueue<Object> queue = null;
    private static volatile CleanerThread thread = null;
    private static volatile boolean newCaller = false;

    public static ReferenceQueue<Object> getReferenceQueue() {
        newCaller = true;
        queueLock.lock();
        try {
            if (thread == null) {
                if (queue == null) {
                    queue = new ReferenceQueue();
                }
                thread = new CleanerThread();
                thread.start();
            }
        }
        finally {
            queueLock.unlock();
        }
        return queue;
    }

    protected CleanerThread() {
        super("EchoSVG CleanerThread");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        long l = 0L;
        while (thread != null) {
            newCaller = false;
            try {
                Reference<Object> reference;
                try {
                    reference = queue.remove(l);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                if (reference == null) {
                    if (!newCaller) {
                        CleanerThread.shutdownMe(this);
                        break;
                    }
                    l = 0L;
                    continue;
                }
                if (reference instanceof ReferenceCleared) {
                    ReferenceCleared referenceCleared = (ReferenceCleared)((Object)reference);
                    referenceCleared.cleared();
                }
                l = queueTimeoutMs;
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void shutdown() {
        queueLock.lock();
        try {
            if (thread != null) {
                thread.interrupt();
                thread = null;
            }
            queue = null;
        }
        finally {
            queueLock.unlock();
        }
    }

    private static void shutdownMe(CleanerThread cleanerThread) {
        queueLock.lock();
        try {
            if (thread == cleanerThread) {
                thread = null;
            }
        }
        finally {
            queueLock.unlock();
        }
    }

    public static void setTimeout(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative timeout value");
        }
        queueTimeoutMs = l;
    }

    public static abstract class PhantomReferenceCleared<T>
    extends PhantomReference<T>
    implements ReferenceCleared {
        public PhantomReferenceCleared(T t) {
            super(t, CleanerThread.getReferenceQueue());
        }
    }

    public static interface ReferenceCleared {
        public void cleared();
    }

    public static abstract class SoftReferenceCleared<T>
    extends SoftReference<T>
    implements ReferenceCleared {
        public SoftReferenceCleared(T t) {
            super(t, CleanerThread.getReferenceQueue());
        }
    }

    public static abstract class WeakReferenceCleared<T>
    extends WeakReference<T>
    implements ReferenceCleared {
        public WeakReferenceCleared(T t) {
            super(t, CleanerThread.getReferenceQueue());
        }
    }
}

