/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.security.AccessControlException;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.text.View;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeCss;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.ZoomableLabelUI;

public class ZoomableLabel
extends JLabel {
    public static final String CUSTOM_CSS = "customCss";
    private static final String TEXT_RENDERING_ICON = "TextRenderingIcon";
    protected static final Graphics2D fmg = new BufferedImage(1, 1, 2).createGraphics();
    private int minimumWidth;
    private int maximumWidth;
    private String css = "";

    public int getZoomedIconWidth() {
        Icon icon = this.getIcon();
        if (icon == null) {
            return 0;
        }
        return this.getMap().getZoomed(icon.getIconWidth());
    }

    public int getZoomedIconTextGap() {
        int iconTextGap = this.getIconTextGap();
        return iconTextGap == 0 ? 0 : this.getMap().getZoomed(iconTextGap);
    }

    public NodeView getNodeView() {
        return (NodeView)SwingUtilities.getAncestorOfClass(NodeView.class, this);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getZoomableLabelPreferredZize();
    }

    private Dimension getZoomableLabelPreferredZize() {
        if (this.isPreferredSizeSet()) {
            Dimension preferredSize = super.getPreferredSize();
            return preferredSize;
        }
        return this.getUI().getPreferredSize(this);
    }

    protected float getZoom() {
        float zoom = this.getMap().getZoom();
        return zoom;
    }

    protected MapView getMap() {
        return this.getNodeView().getMap();
    }

    @Override
    public void paint(Graphics g) {
        switch (this.getMap().getPaintingMode()) {
            case CLOUDS: {
                return;
            }
        }
        super.paint(g);
    }

    protected void updateText(String text) {
        try {
            this.updateTextUnsafe(text);
        }
        catch (Exception e1) {
            if (e1 instanceof AccessControlException) {
                LogUtils.warn(e1.getMessage());
            } else {
                LogUtils.severe(e1);
            }
            String localizedMessage = e1.getLocalizedMessage();
            if (text.length() > 603) {
                text = text.substring(0, 600) + "...";
            }
            try {
                this.updateTextUnsafe(localizedMessage + '\n' + text);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTextUnsafe(String nodeText) throws Exception {
        String[] lines;
        NodeView node = (NodeView)SwingUtilities.getAncestorOfClass(NodeView.class, this);
        MapView map = node.getMap();
        if (map == null || nodeText == null) {
            return;
        }
        boolean isHtml = HtmlUtils.isHtml(nodeText);
        boolean widthMustBeRestricted = !this.areInsetsFixed();
        boolean isLong = false;
        if (!isHtml) {
            lines = nodeText.split("\n");
            for (int line = 0; line < lines.length && !widthMustBeRestricted; ++line) {
                this.setText(lines[line]);
                int oldMaximumWidth = this.getMaximumWidth();
                try {
                    ModeController modeController = map.getModeController();
                    NodeStyleController nsc = NodeStyleController.getController(modeController);
                    double maxNodeWidth = nsc.getMaxWidth(node.getNode(), node.getStyleOption()).toBaseUnits();
                    this.setMaximumWidth(Integer.MAX_VALUE);
                    widthMustBeRestricted = this.getZoomableLabelPreferredZize().width > map.getZoomed(maxNodeWidth);
                    continue;
                }
                finally {
                    this.setMaximumWidth(oldMaximumWidth);
                }
            }
            boolean bl = isLong = widthMustBeRestricted || lines.length > 1;
        }
        if (isHtml) {
            String htmlLongNodeHead;
            if (nodeText.indexOf("<img") >= 0 && nodeText.indexOf("<base ") < 0) {
                nodeText = "<html><base href=\"" + map.getMap().getURL() + "\">" + nodeText.substring(6);
            }
            if ((htmlLongNodeHead = ResourceController.getResourceController().getProperty("html_long_node_head")) != null && !htmlLongNodeHead.equals("")) {
                nodeText = nodeText.matches("(?ims).*<head>.*") ? nodeText.replaceFirst("(?ims).*<head>.*", "<head>" + htmlLongNodeHead) : nodeText.replaceFirst("(?ims)<html>", "<html><head>" + htmlLongNodeHead + "</head>");
            }
            this.setText(nodeText);
        } else if (nodeText.startsWith("<table>")) {
            lines = nodeText.split("\n");
            lines[0] = lines[0].substring(7);
            int startingLine = lines[0].matches("\\s*") ? 1 : 0;
            String text = "<html><table border=1 style=\"border-color: white\">";
            for (int line = startingLine; line < lines.length; ++line) {
                text = text + "<tr><td style=\"border-color: white;\">" + HtmlUtils.toXMLEscapedText(lines[line]).replaceAll("\t", "<td style=\"border-color: white\">");
            }
            this.setText(text);
        } else if (isLong) {
            String text = HtmlUtils.plainToHTML(nodeText);
            this.setText(text);
        } else {
            this.setText(nodeText);
        }
    }

    public void setStyleSheet(String css, StyleSheet styleSheet) {
        if (!this.css.equals(css)) {
            StyleSheet old = (StyleSheet)this.getClientProperty(StyleSheet.class);
            this.putClientProperty(StyleSheet.class, styleSheet);
            this.css = css;
            this.firePropertyChange(CUSTOM_CSS, old, styleSheet);
            this.revalidate();
            this.repaint();
        }
    }

    public StyleSheet getStyleSheet() {
        StyleSheet s = (StyleSheet)this.getClientProperty(StyleSheet.class);
        return s != null ? s : NodeCss.EMPTY.getStyleSheet();
    }

    protected boolean areInsetsFixed() {
        return true;
    }

    public ZoomableLabel() {
        this.setUI(ZoomableLabelUI.createUI(this));
    }

    @Override
    public void updateUI() {
    }

    @Override
    public ZoomableLabelUI getUI() {
        return (ZoomableLabelUI)this.ui;
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        try {
            if (!this.useFractionalMetrics()) {
                return super.getFontMetrics(font);
            }
            fmg.setFont(font);
            FontMetrics fontMetrics = fmg.getFontMetrics();
            return fontMetrics;
        }
        catch (Exception e) {
            return super.getFontMetrics(font);
        }
    }

    protected boolean useFractionalMetrics() {
        MapView map = this.getMap();
        if (map.isPrinting()) {
            return true;
        }
        float zoom = map.getZoom();
        return 1.0f != zoom;
    }

    protected FontMetrics getFontMetrics() {
        if (!this.useFractionalMetrics()) {
            return super.getFontMetrics(this.getFont());
        }
        fmg.setFont(this.getFont());
        FontMetrics fontMetrics = fmg.getFontMetrics();
        return fontMetrics;
    }

    public String getLink(Point p) {
        View view = (View)this.getClientProperty("html");
        if (view == null) {
            return null;
        }
        Rectangle textR = this.getUI().getTextR(this);
        if (textR == null) {
            return null;
        }
        if (!textR.contains(p)) {
            return null;
        }
        float zoom = this.getZoom();
        int x = (int)((float)p.x / zoom);
        int y = (int)((float)p.y / zoom);
        int pos = view.viewToModel(x, y, textR);
        HTMLDocument document = (HTMLDocument)view.getDocument();
        String linkURL = HtmlUtils.getURLOfExistingLink(document, pos);
        return linkURL;
    }

    public Insets getZoomedInsets() {
        Insets unzoomedInsets = this.getInsets();
        float zoom = this.getZoom();
        Insets zoomedInsets = new Insets((int)((float)unzoomedInsets.top * zoom), (int)((float)unzoomedInsets.left * zoom), (int)((float)unzoomedInsets.bottom * zoom), (int)((float)unzoomedInsets.right * zoom));
        return zoomedInsets;
    }

    public int getMinimumWidth() {
        return this.minimumWidth;
    }

    public int getMaximumWidth() {
        return this.maximumWidth;
    }

    public void setMaximumWidth(int maximumWidth) {
        this.maximumWidth = maximumWidth;
    }

    public void setMinimumWidth(int minimumWidth) {
        this.minimumWidth = minimumWidth;
    }

    protected int limitWidth(int width, int borderWidth) {
        int minimumWidth = this.getMinimumWidth() + 2 * borderWidth;
        int maximumWidth = this.getMaximumWidth();
        if (width < minimumWidth) {
            return Math.min(minimumWidth, maximumWidth);
        }
        if (width > maximumWidth) {
            return maximumWidth;
        }
        return width;
    }

    protected double limitWidth(double width, int borderWidth) {
        int minimumWidth = this.getMinimumWidth() + 2 * borderWidth;
        int maximumWidth = this.getMaximumWidth();
        if (width < (double)minimumWidth) {
            return Math.min(minimumWidth, maximumWidth);
        }
        if (width > (double)maximumWidth) {
            return maximumWidth;
        }
        return width;
    }

    public Color getUnselectedForeground() {
        return super.getForeground();
    }

    public Icon getTextRenderingIcon() {
        return (Icon)this.getClientProperty(TEXT_RENDERING_ICON);
    }

    public void setTextRenderingIcon(Icon icon) {
        this.putClientProperty(TEXT_RENDERING_ICON, icon);
    }

    public int getEffectiveHorizontalTextPosition() {
        return this.effectiveHorizontalPosition(this.getHorizontalTextPosition());
    }

    public int getEffectiveHorizontalAlignment() {
        return this.effectiveHorizontalPosition(this.getHorizontalAlignment());
    }

    private int effectiveHorizontalPosition(int position) {
        switch (position) {
            case 10: {
                return this.getComponentOrientation().isLeftToRight() ? 2 : 4;
            }
            case 11: {
                return this.getComponentOrientation().isLeftToRight() ? 4 : 2;
            }
        }
        return position;
    }

    public void preserveLayout(Dimension size) {
        this.setPreferredSize(size);
        ZoomableLabelUI ui = this.getUI();
        if (size != null) {
            this.setSize(size);
            ui.preserveLayout(this);
        } else {
            ui.releaseLayout(this);
        }
    }

    static {
        fmg.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }
}

