/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter;

import java.util.List;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import javax.swing.Icon;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.features.filter.FilterInfo;
import org.freeplane.features.filter.condition.ICondition;
import org.freeplane.features.filter.hidden.NodeVisibility;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

public class Filter
implements IExtension {
    private final ICondition condition;
    final int options;
    private FilterInfoAccessor accessor;
    private final boolean hidesMatchingElements;
    private final boolean appliesToVisibleElementsOnly;
    private final Filter baseFilter;
    private final FilteredElement filteredElement;
    private static Icon filterIcon;

    public static Filter createTransparentFilter() {
        ResourceController resourceController = ResourceController.getResourceController();
        FilteredElement filteredElement = resourceController.getEnumProperty("filter.filteredElement", FilteredElement.NODE);
        return new Filter(null, false, resourceController.getBooleanProperty("filter.showAncestors"), resourceController.getBooleanProperty("filter.showDescendants"), false, filteredElement, null);
    }

    public static Filter createFilter(ICondition condition, boolean areAncestorsShown, boolean areDescendantsShown, boolean appliesToVisibleElementsOnly, Filter baseFilter) {
        return new Filter(condition, false, areAncestorsShown, areDescendantsShown, appliesToVisibleElementsOnly, baseFilter);
    }

    public Filter(ICondition condition, boolean hidesMatchingElements, boolean areAncestorsShown, boolean areDescendantsShown, boolean appliesToVisibleElementsOnly, Filter baseFilter) {
        this(condition, hidesMatchingElements, areAncestorsShown, areDescendantsShown, appliesToVisibleElementsOnly, FilteredElement.NODE, baseFilter);
    }

    public Filter(ICondition condition, boolean hidesMatchingElements, boolean areAncestorsShown, boolean areDescendantsShown, boolean appliesToVisibleElementsOnly, FilteredElement filteredElement, Filter baseFilter) {
        int options;
        this.condition = condition;
        this.hidesMatchingElements = hidesMatchingElements;
        this.appliesToVisibleElementsOnly = appliesToVisibleElementsOnly;
        this.filteredElement = filteredElement;
        this.accessor = new FilterInfoAccessor();
        if (hidesMatchingElements) {
            options = 16;
            if (areAncestorsShown) {
                options += 32;
            }
            if (areDescendantsShown) {
                options += 64;
            }
        } else {
            options = 2;
            if (areAncestorsShown) {
                options += 4;
            }
            if (areDescendantsShown) {
                options += 8;
            }
        }
        this.options = options;
        this.baseFilter = baseFilter;
    }

    void addFilterResult(NodeModel node, int flags) {
        this.getFilterInfo(node).add(flags);
    }

    void setFilterResult(NodeModel node, int flags) {
        this.getFilterInfo(node).set(flags);
    }

    protected boolean appliesToVisibleElementsOnly() {
        return this.appliesToVisibleElementsOnly;
    }

    void displayFilterStatus() {
        if (filterIcon == null) {
            filterIcon = ResourceController.getResourceController().getIcon("ShowFilterToolbarAction.icon");
        }
        if (this.getCondition() != null) {
            Controller.getCurrentController().getViewController().addStatusInfo("filter", null, filterIcon);
        } else {
            Controller.getCurrentController().getViewController().removeStatus("filter");
        }
    }

    public void calculateFilterResults(MapModel map) {
        this.accessor = new FilterInfoAccessor();
        NodeModel root = map.getRootNode();
        this.resetFilter(root);
        int ownStateAsAncestor = this.checkNode(root) ? 8 : 64;
        this.addFilterResult(root, this.filterChildrenGetDescendantState(root, ownStateAsAncestor));
    }

    public void calculateFilterResults(NodeModel root) {
        this.accessor = new FilterInfoAccessor();
        this.applyFilterGetDescendantState(root, 0);
    }

    private int filterChildrenGetDescendantState(NodeModel node, int state) {
        int descendantState = 0;
        for (NodeModel child : this.children(node)) {
            descendantState = this.applyFilterGetDescendantState(child, state) | descendantState;
        }
        return descendantState;
    }

    private int applyFilterGetDescendantState(NodeModel node, int ancestorState) {
        boolean matchesCombinedFilter = this.checkNode(node);
        int ownStateAsAncestor = ancestorState != 0 || !node.isRoot() ? (matchesCombinedFilter ? 8 : 64) : 0;
        int childrenAncestorState = ancestorState | ownStateAsAncestor;
        int descendantState = this.filterChildrenGetDescendantState(node, childrenAncestorState);
        this.setFilterResult(node, ancestorState | descendantState | (matchesCombinedFilter ? 2 : 16));
        int ownStateAsDescendant = matchesCombinedFilter ? 4 : 32;
        return descendantState | ownStateAsDescendant;
    }

    public boolean areAncestorsShown() {
        return 0 != (this.options & 0x24);
    }

    boolean areMatchingElementsHidden() {
        return this.hidesMatchingElements;
    }

    public boolean areDescendantsShown() {
        return 0 != (this.options & 0x48);
    }

    public FilteredElement getFilteredElement() {
        return this.filteredElement;
    }

    private boolean checkNode(NodeModel node) {
        return this.condition == null || !this.shouldRemainInvisible(node) && this.condition.checkNode(node);
    }

    private boolean shouldRemainInvisible(NodeModel node) {
        return this.condition != null && this.appliesToVisibleElementsOnly() && (node.isHiddenSummary() || !this.baseFilter.accepts(node));
    }

    protected List<NodeModel> children(NodeModel node) {
        return node.getChildren();
    }

    public ICondition getCondition() {
        return this.condition;
    }

    public boolean canUseFilterResultsFrom(Filter oldFilter) {
        return (!oldFilter.appliesToVisibleElementsOnly || this.appliesToVisibleElementsOnly) && Objects.equals(this.condition, oldFilter.getCondition());
    }

    public void useFilterResultsFrom(Filter oldFilter) {
        this.accessor = oldFilter.accessor;
    }

    public boolean isVisible(NodeModel node) {
        return this.filteredElement == FilteredElement.CONNECTOR && !NodeVisibility.isHidden(node) || this.accepts(node);
    }

    public boolean isVisible(ConnectorModel connector) {
        return this.filteredElement == FilteredElement.NODE || this.accepts(connector.getSource()) && this.accepts(connector.getTarget());
    }

    public boolean accepts(NodeModel source) {
        return this.accepts(source, this.options);
    }

    public boolean isFoldable(NodeModel node) {
        return this.filteredElement == FilteredElement.CONNECTOR || (this.hidesMatchingElements ? this.accepts(node, this.options | 0x20) : this.accepts(node, this.options | 4));
    }

    private boolean accepts(NodeModel node, int options) {
        if (NodeVisibility.isHidden(node)) {
            return false;
        }
        if (this.condition == null || node.isRoot()) {
            return true;
        }
        FilterInfo filterInfo = this.getFilterInfo(node);
        return filterInfo.isNotChecked() || filterInfo.matches(options);
    }

    void resetFilter(NodeModel node) {
        this.getFilterInfo(node).reset();
    }

    public FilterInfo getFilterInfo(NodeModel node) {
        return node != null ? this.accessor.getFilterInfo(node) : new FilterInfo();
    }

    public void showAsMatched(NodeModel node) {
        FilterInfo filterInfo = this.getFilterInfo(node);
        if (!filterInfo.matches(2)) {
            filterInfo.add(2);
            if (!filterInfo.matches(4)) {
                this.showAncestors(node);
            }
            if (!filterInfo.matches(8)) {
                this.showDescendants(node);
            }
        }
    }

    private void showAncestors(NodeModel node) {
        NodeModel parent = node.getParentNode();
        if (parent == null) {
            return;
        }
        FilterInfo filterInfo = this.getFilterInfo(parent);
        if (!filterInfo.matches(4)) {
            filterInfo.add(4);
            this.showAncestors(parent);
        }
    }

    private void showDescendants(NodeModel node) {
        for (NodeModel child : this.children(node)) {
            FilterInfo filterInfo = this.getFilterInfo(child);
            filterInfo.add(8);
            this.showDescendants(child);
        }
    }

    public void updateFilterResults(NodeModel node, Consumer<NodeModel> callbackOnUpdate) {
        if (this.condition == null) {
            return;
        }
        boolean matches = this.checkNode(node);
        FilterInfo filterInfo = this.getFilterInfo(node);
        filterInfo.set(matches ? 2 : 16);
        this.updateFilterResultsAndAncestors(node, callbackOnUpdate);
        this.updateDescendantResults(node, matches ? 8 : 64, callbackOnUpdate);
    }

    private void updateFilterResultsAndAncestors(NodeModel node, Consumer<NodeModel> callbackOnUpdate) {
        FilterInfo filterInfo = this.getFilterInfo(node);
        NodeModel parentNode = node.getParentNode();
        FilterInfo parentFilterInfo = this.getFilterInfo(parentNode);
        if (!filterInfo.isNotChecked()) {
            boolean matches = filterInfo.isMatched();
            boolean wasVisible = this.isVisible(node);
            int ownState = matches ? 2 : 16;
            int ancestorState = parentFilterInfo.isMatched() ? 8 : parentFilterInfo.get(72);
            int descendantState = node.getChildren().stream().map(this::getFilterInfo).mapToInt(x -> x.get(54)).reduce(0, (m, n) -> m | n);
            if ((descendantState & 2) != 0) {
                descendantState &= 0xFFFFFFFD;
                descendantState |= 4;
            }
            if ((descendantState & 0x10) != 0) {
                descendantState &= 0xFFFFFFEF;
                descendantState |= 0x20;
            }
            filterInfo.set(ancestorState | ownState | descendantState);
            if (wasVisible != this.isVisible(node)) {
                callbackOnUpdate.accept(node);
            }
        }
        if (parentNode != null) {
            this.updateFilterResultsAndAncestors(parentNode, callbackOnUpdate);
        }
    }

    private void updateDescendantResults(NodeModel node, int options, Consumer<NodeModel> callbackOnUpdate) {
        for (NodeModel child : node.getChildren()) {
            FilterInfo childInfo = this.getFilterInfo(child);
            if (childInfo.matches(options)) continue;
            if (childInfo.isNotChecked()) {
                this.updateDescendantResults(child, options, callbackOnUpdate);
                continue;
            }
            boolean wasVisible = this.isVisible(child);
            if (childInfo.add(options) && wasVisible != this.isVisible(child)) {
                callbackOnUpdate.accept(child);
            }
            this.updateDescendantResults(child, options, callbackOnUpdate);
        }
    }

    public void reset(NodeModel node) {
        this.getFilterInfo(node).reset();
    }

    public static enum FilteredElement {
        NODE,
        CONNECTOR,
        NODE_AND_CONNECTOR;

    }

    static class FilterInfoAccessor {
        private final WeakHashMap<NodeModel, FilterInfo> filterInfos = new WeakHashMap();

        FilterInfoAccessor() {
        }

        FilterInfo getFilterInfo(NodeModel node) {
            return this.filterInfos.computeIfAbsent(node, x -> new FilterInfo());
        }
    }
}

