/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.clipboard;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class HtmlSelection
implements Transferable {
    private static List<DataFlavor> htmlFlavors = new ArrayList<DataFlavor>(3);
    private String html;

    public HtmlSelection(String html) {
        this.html = html;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return htmlFlavors.toArray(new DataFlavor[htmlFlavors.size()]);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return htmlFlavors.contains(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (String.class.equals(flavor.getRepresentationClass())) {
            return this.html;
        }
        if (Reader.class.equals(flavor.getRepresentationClass())) {
            return new StringReader(this.html);
        }
        if (InputStream.class.equals(flavor.getRepresentationClass())) {
            try {
                return new ByteArrayInputStream(this.html.getBytes("UTF-8"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new UnsupportedFlavorException(flavor);
    }

    static {
        try {
            htmlFlavors.add(new DataFlavor("text/html;class=java.lang.String"));
            htmlFlavors.add(new DataFlavor("text/html;class=java.io.Reader"));
            htmlFlavors.add(new DataFlavor("text/html;charset=unicode;class=java.io.InputStream"));
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
    }
}

