/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.presentations.mindmapmode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.DisjunctConditions;
import org.freeplane.features.filter.condition.ICondition;
import org.freeplane.features.filter.condition.SelectedViewSnapshotCondition;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.presentations.mindmapmode.NamedElement;
import org.freeplane.features.presentations.mindmapmode.SlideChangeEvent;
import org.freeplane.features.presentations.mindmapmode.SlideChangeListener;
import org.freeplane.features.ui.IMapViewManager;

public class Slide
implements NamedElement<Slide> {
    static final String PRESENTATION_SLOW_MOTION_KEY = "presentation.slowMotion";
    private static final IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
    private String name;
    private boolean changesZoom;
    private String rootNodeId;
    private String placedNodeId;
    private IMapSelection.NodePosition placedNodePosition;
    private float zoom;
    private boolean showsOnlySpecificNodes;
    private boolean showsAncestors;
    private boolean showsDescendants;
    private ASelectableCondition filterCondition;
    private Set<String> selectedNodeIds;
    private Set<String> foldedNodeIds;
    private final ArrayList<SlideChangeListener> slideChangeListeners;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Slide create(String name) {
        return new Slide(name, this.rootNodeId, new LinkedHashSet<String>(), this.placedNodeId != null ? "" : null, this.placedNodePosition, this.changesZoom, this.zoom, this.showsOnlySpecificNodes, this.showsAncestors, this.showsDescendants, null);
    }

    @Override
    public Slide saveAs(String name) {
        return new Slide(name, this.rootNodeId, new LinkedHashSet<String>(this.selectedNodeIds), this.placedNodeId, this.placedNodePosition, this.changesZoom, this.zoom, this.showsOnlySpecificNodes, this.showsAncestors, this.showsDescendants, this.filterCondition);
    }

    public Slide(String name) {
        this(name, null, new LinkedHashSet<String>(), null, IMapSelection.NodePosition.CENTER, false, 1.0f, false, false, false, null);
    }

    private Slide(String name, String rootNodeId, Set<String> selectedNodeIds, String placesNodeId, IMapSelection.NodePosition placedNodePosition, boolean changeZoom, float zoom, boolean showOnlySpecificNodes, boolean showAncestors, boolean showDescendants, ASelectableCondition filterCondition) {
        this.name = name;
        this.rootNodeId = rootNodeId;
        this.selectedNodeIds = selectedNodeIds;
        this.placedNodeId = placesNodeId;
        this.placedNodePosition = placedNodePosition;
        this.changesZoom = changeZoom;
        this.zoom = zoom;
        this.showsOnlySpecificNodes = showOnlySpecificNodes;
        this.showsAncestors = showAncestors;
        this.showsDescendants = showDescendants;
        this.filterCondition = filterCondition;
        this.slideChangeListeners = new ArrayList();
        this.foldedNodeIds = null;
    }

    public Set<String> getSelectedNodeIds() {
        return this.selectedNodeIds;
    }

    public void setSelectedNodeIds(Set<String> selectedNodeIds) {
        if (this.selectedNodeIds != selectedNodeIds) {
            this.selectedNodeIds = new LinkedHashSet<String>(selectedNodeIds);
            this.fireSlideChangeEvent();
        }
    }

    public void addSelectedNodeIds(Collection<String> selectedNodeIds) {
        if (this.selectedNodeIds.addAll(selectedNodeIds)) {
            this.fireSlideChangeEvent();
        }
    }

    public void removeSelectedNodeIds(Collection<String> selectedNodeIds) {
        if (this.selectedNodeIds.removeAll(selectedNodeIds)) {
            this.fireSlideChangeEvent();
        }
    }

    public Set<String> getFoldedNodeIds() {
        return this.foldedNodeIds;
    }

    public boolean isNodeFolded(NodeModel node) {
        return this.foldsNodes() && this.foldedNodeIds.contains(node.getID()) && !node.getID().equals(this.rootNodeId);
    }

    public boolean foldsNodes() {
        return this.foldedNodeIds != null;
    }

    public void unsetFoldsNodes() {
        if (this.foldedNodeIds != null) {
            this.foldedNodeIds = null;
            this.fireSlideChangeEvent();
        }
    }

    public Collection<String> getCurrentFoldedNodeIds() {
        return this.createNodeIterator().getCurrentFoldedNodeIds();
    }

    public void setFoldedNodeIDs(Collection<String> foldedNodeIds) {
        if (this.foldedNodeIds != foldedNodeIds) {
            this.foldedNodeIds = new LinkedHashSet<String>(foldedNodeIds);
            this.fireSlideChangeEvent();
        }
    }

    public boolean isNodeVisible(NodeModel node) {
        String id = node.createID();
        return id.equals(this.rootNodeId) || this.rootNodeId == null && node.isRoot() || this.selectedNodeIds.contains(id);
    }

    public String getRootNodeId() {
        return this.rootNodeId;
    }

    public void setRootNodeId(String rootNodeId) {
        if (!Objects.equals(this.rootNodeId, rootNodeId)) {
            this.rootNodeId = rootNodeId;
            this.fireSlideChangeEvent();
        }
    }

    public String getPlacedNodeId() {
        return this.placedNodeId;
    }

    public void setPlacedNodeId(String placedNodeId) {
        if (this.placedNodeId != placedNodeId) {
            this.placedNodeId = placedNodeId;
            this.fireSlideChangeEvent();
        }
    }

    public IMapSelection.NodePosition getPlacedNodePosition() {
        return this.placedNodePosition;
    }

    public void setPlacedNodePosition(IMapSelection.NodePosition placedNodePosition) {
        if (this.placedNodePosition != placedNodePosition) {
            this.placedNodePosition = Objects.requireNonNull(placedNodePosition);
            this.fireSlideChangeEvent();
        }
    }

    public boolean changesZoom() {
        return this.changesZoom;
    }

    public void setChangesZoom(boolean changeZoom) {
        if (this.changesZoom != changeZoom) {
            this.changesZoom = changeZoom;
            this.fireSlideChangeEvent();
        }
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setZoom(float zoom) {
        if (this.zoom != zoom) {
            this.zoom = zoom;
            this.fireSlideChangeEvent();
        }
    }

    public boolean showsOnlySpecificNodes() {
        return this.showsOnlySpecificNodes;
    }

    public void setShowsOnlySpecificNodes(boolean showOnlySpecificNodes) {
        if (this.showsOnlySpecificNodes != showOnlySpecificNodes) {
            this.showsOnlySpecificNodes = showOnlySpecificNodes;
            this.fireSlideChangeEvent();
        }
    }

    public boolean showsAncestors() {
        return this.showsAncestors;
    }

    public void setShowsAncestors(boolean showAncestors) {
        if (this.showsAncestors != showAncestors) {
            this.showsAncestors = showAncestors;
            this.fireSlideChangeEvent();
        }
    }

    public boolean showsDescendants() {
        return this.showsDescendants;
    }

    public void setShowsDescendants(boolean showDescendants) {
        if (this.showsDescendants != showDescendants) {
            this.showsDescendants = showDescendants;
            this.fireSlideChangeEvent();
        }
    }

    public ASelectableCondition getFilterCondition() {
        return this.filterCondition;
    }

    public void setFilterCondition(ASelectableCondition filterCondition) {
        if (this.filterCondition != filterCondition) {
            this.filterCondition = filterCondition;
            this.fireSlideChangeEvent();
        }
    }

    public void addSlideChangeListener(SlideChangeListener slideChangeListener) {
        this.slideChangeListeners.add(slideChangeListener);
    }

    public void removeSlideChangeListener(SlideChangeListener slideChangeListener) {
        this.slideChangeListeners.remove(slideChangeListener);
    }

    private void fireSlideChangeEvent() {
        for (SlideChangeListener slideChangeListener : this.slideChangeListeners) {
            slideChangeListener.onSlideModelChange(SlideChangeEvent.of(this));
        }
    }

    void replaceCurrentSelection() {
        ArrayList<NodeModel> selectedNodes = this.getSelectedNodes(true);
        if (!selectedNodes.isEmpty()) {
            NodeModel[] nodes;
            for (NodeModel node : nodes = selectedNodes.toArray(new NodeModel[0])) {
                this.displayOnCurrentView(node);
            }
            Controller.getCurrentController().getSelection().replaceSelection(nodes);
        }
    }

    private ArrayList<NodeModel> getSelectedNodes(boolean onlyVisible) {
        MapModel map = this.getMap();
        ArrayList<NodeModel> selectedNodes = new ArrayList<NodeModel>(this.selectedNodeIds.size());
        NodeModel slideRootNode = this.getSlideRootNode();
        for (String id : this.selectedNodeIds) {
            NodeModel node = map.getNodeForID(id);
            if (node == null || onlyVisible && (!slideRootNode.isRoot() && !node.isDescendantOf(slideRootNode) || !node.isVisible(Controller.getCurrentController().getSelection().getFilter()))) continue;
            selectedNodes.add(node);
        }
        return selectedNodes;
    }

    void apply(float zoomFactor) {
        this.applyRoot();
        this.applyFilter();
        this.applySelection();
        this.foldNodes();
        this.applyZoom(zoomFactor);
        this.placeSelectedNode();
        this.scrollMapToSelectedNode();
    }

    private void scrollMapToSelectedNode() {
        Controller controller;
        IMapSelection selection;
        if (this.placedNodeId == null && (selection = (controller = Controller.getCurrentController()).getSelection()) != null) {
            NodeModel selected = selection.getSelected();
            controller.getMapViewManager().scrollNodeToVisible(selected);
        }
    }

    public NodeIterator createNodeIterator() {
        return new NodeIterator();
    }

    private void foldNodes() {
        this.createNodeIterator().foldNodes();
    }

    private void applyZoom(float zoomFactor) {
        if (this.changesZoom) {
            Controller.getCurrentController().getMapViewManager().setZoom(this.zoom * zoomFactor);
        }
    }

    private boolean displaysAllSlideNodes() {
        return ResourceController.getResourceController().getBooleanProperty("presentation.slideDisplaysAllNodes");
    }

    private void applyRoot() {
        NodeModel currentRootNode = this.getSlideRootNode();
        Controller currentController = Controller.getCurrentController();
        if (currentController.getSelection().getSelectionRoot() != currentRootNode) {
            currentRootNode.setChildNodeSidesAsNow();
            currentController.getMapViewManager().setViewRoot(currentRootNode);
        }
    }

    private void applySelection() {
        boolean replacesSelectionBySelectedNodes;
        if (this.selectedNodeIds.isEmpty()) {
            return;
        }
        ArrayList<NodeModel> selectedNodes = this.getSelectedNodes(true);
        if (selectedNodes.isEmpty()) {
            return;
        }
        boolean displaysAllSlideNodes = this.displaysAllSlideNodes();
        boolean selectsAllVisibleNodes = displaysAllSlideNodes && this.showsOnlySpecificNodes && mapViewManager.isSpotlightEnabled();
        boolean bl = replacesSelectionBySelectedNodes = !selectsAllVisibleNodes && !this.showsOnlySpecificNodes && !selectedNodes.isEmpty();
        if (!replacesSelectionBySelectedNodes && !this.foldsNodes() && displaysAllSlideNodes) {
            for (NodeModel node : selectedNodes) {
                this.displayOnCurrentView(node);
                if (!this.showsDescendants) continue;
                this.displayDescendantsOnCurrentView(node);
            }
        }
        IMapSelection selection = Controller.getCurrentController().getSelection();
        if (replacesSelectionBySelectedNodes) {
            NodeModel[] nodes = selectedNodes.toArray(new NodeModel[0]);
            selection.replaceSelection(nodes);
        }
        if (this.showsOnlySpecificNodes) {
            NodeModel firstNode = selectedNodes.get(0);
            selection.selectAsTheOnlyOneSelected(firstNode);
        }
        if (selectsAllVisibleNodes) {
            if (this.showsAncestors) {
                NodeModel rootNode = selection.getSelected().getMap().getRootNode();
                selection.selectBranch(rootNode, true);
            } else {
                for (NodeModel node : selectedNodes) {
                    selection.selectBranch(node, true);
                }
            }
        }
    }

    private void displayDescendantsOnCurrentView(NodeModel node) {
        mapViewManager.setFoldedOnCurrentView(node, false);
        for (NodeModel child : node.getChildren()) {
            this.displayDescendantsOnCurrentView(child);
        }
    }

    private void placeSelectedNode() {
        if (this.placedNodeId != null) {
            boolean slowMotion;
            NodeModel placedNode = this.getCurrentPlacedNode();
            IMapSelection selection = Controller.getCurrentController().getSelection();
            if (placedNode != null && placedNode != selection.getSelected()) {
                this.displayOnCurrentView(placedNode);
            }
            if (slowMotion = ResourceController.getResourceController().getBooleanProperty(PRESENTATION_SLOW_MOTION_KEY, false)) {
                selection.slowlyMoveNodeTo(placedNode, this.placedNodePosition);
            } else {
                selection.moveNodeTo(placedNode, this.placedNodePosition);
            }
        }
    }

    public NodeModel getSlideRootNode() {
        NodeModel rootNode = this.getCurrentNode(this.rootNodeId);
        return rootNode != null ? rootNode : this.getMap().getRootNode();
    }

    public NodeModel getCurrentPlacedNode() {
        return this.getCurrentNode(this.placedNodeId);
    }

    private NodeModel getCurrentNode(String nodeId) {
        if (nodeId != null) {
            MapModel map = this.getMap();
            NodeModel currentNode = map.getNodeForID(nodeId);
            return currentNode;
        }
        return null;
    }

    private MapModel getMap() {
        return Controller.getCurrentController().getMap();
    }

    private void applyFilter() {
        ICondition condition = this.getEffectiveFilterCondition();
        Filter filter = new Filter(condition, false, this.showsAncestors, this.showsDescendants, false, null);
        FilterController.getCurrentFilterController().applyFilter(false, filter);
    }

    public ICondition getEffectiveFilterCondition() {
        SelectedViewSnapshotCondition condition;
        if (this.showsOnlySpecificNodes && this.filterCondition != null) {
            SelectedViewSnapshotCondition selectedViewSnapshotCondition = this.getFilterConditionForSelectedNodes();
            condition = DisjunctConditions.combine((ASelectableCondition[])new ASelectableCondition[]{selectedViewSnapshotCondition, this.filterCondition});
        } else if (this.showsOnlySpecificNodes && this.filterCondition == null) {
            condition = this.getFilterConditionForSelectedNodes();
        } else if (!this.showsOnlySpecificNodes && this.filterCondition != null) {
            condition = this.filterCondition;
        } else {
            return null;
        }
        return condition;
    }

    private SelectedViewSnapshotCondition getFilterConditionForSelectedNodes() {
        ArrayList<NodeModel> selectedNodes = this.getSelectedNodes(false);
        SelectedViewSnapshotCondition selectedViewSnapshotCondition = new SelectedViewSnapshotCondition(selectedNodes);
        return selectedViewSnapshotCondition;
    }

    private boolean isFoldedOnCurrentView(NodeModel node) {
        return mapViewManager.isFoldedOnCurrentView(node);
    }

    private void displayOnCurrentView(NodeModel node) {
        mapViewManager.displayOnCurrentView(node);
    }

    private void setFoldedOnCurrentView(NodeModel node, boolean folded) {
        mapViewManager.setFoldedOnCurrentView(node, folded);
    }

    private class NodeIterator {
        private Filter filter;

        private NodeIterator() {
        }

        public Set<String> getCurrentFoldedNodeIds() {
            this.filter = this.calculateFilterResults();
            Set<String> foldedNodeIds = this.calculateCurrentFoldedNodeIds();
            this.filter = null;
            return foldedNodeIds;
        }

        private Set<String> calculateCurrentFoldedNodeIds() {
            MapModel map = Slide.this.getMap();
            HashSet<String> nodeIds = new HashSet<String>();
            this.addCurrentFoldedNodeIds(map.getRootNode(), nodeIds);
            return nodeIds;
        }

        private Filter calculateFilterResults() {
            MapModel map = Slide.this.getMap();
            ICondition condition = Slide.this.getEffectiveFilterCondition();
            Filter filter = Filter.createFilter((ICondition)condition, (boolean)true, (boolean)Slide.this.showsDescendants, (boolean)false, null);
            filter.calculateFilterResults(map);
            return filter;
        }

        private void addCurrentFoldedNodeIds(NodeModel node, HashSet<String> nodeIds) {
            if (Slide.this.isFoldedOnCurrentView(node)) {
                if (this.filter.isVisible(node)) {
                    nodeIds.add(node.getID());
                }
                return;
            }
            if (this.filter.isVisible(node)) {
                for (NodeModel child : node.getChildren()) {
                    this.addCurrentFoldedNodeIds(child, nodeIds);
                }
            }
        }

        public void foldNodes() {
            if (Slide.this.foldsNodes()) {
                this.filter = new Filter(Slide.this.getEffectiveFilterCondition(), false, true, Slide.this.showsDescendants, false, null);
                this.foldNodes(Slide.this.getMap().getRootNode());
                this.filter = null;
            }
        }

        private void foldNodes(NodeModel node) {
            if (this.filter.isVisible(node)) {
                if (Slide.this.foldedNodeIds.contains(node.getID())) {
                    Slide.this.setFoldedOnCurrentView(node, true);
                    return;
                }
                mapViewManager.setFoldedOnCurrentView(node, false);
                for (NodeModel child : node.getChildren()) {
                    this.foldNodes(child);
                }
            }
        }
    }
}

