%% Generated by the Erlang ASN.1 BER compiler. Version: 5.4.1
%% Purpose: Encoding and decoding of the types in PKIXCRMF-2009.

-module('PKIXCRMF-2009').
-moduledoc false.
-compile(nowarn_unused_vars).
-dialyzer(no_improper_lists).
-dialyzer(no_match).
-include("PKIXCRMF-2009.hrl").
-asn1_info([{vsn,'5.4.1'},
            {module,'PKIXCRMF-2009'},
            {options,[{i,"/build/erlang/src/otp/lib/public_key/asn1/../src"},
 warnings,ber,errors,
 {cwd,"/build/erlang/src/otp/lib/public_key/asn1"},
 {outdir,"/build/erlang/src/otp/lib/public_key/asn1/../src"},
 der,noobj,asn1config,
 {i,"."},
 {i,"/build/erlang/src/otp/lib/public_key/asn1"}]}]).

-export([encoding_rule/0,maps/0,bit_string_format/0,
         legacy_erlang_types/0]).
-export(['dialyzer-suppressions'/1]).
-export([
enc_CertReqMessages/2,
enc_CertReqMsg/2,
enc_CertRequest/2,
enc_CertTemplate/2,
enc_OptionalValidity/2,
enc_Controls/2,
enc_ProofOfPossession/2,
enc_POPOSigningKey/2,
enc_POPOSigningKeyInput/2,
enc_PKMACValue/2,
enc_PBMParameter/2,
enc_POPOPrivKey/2,
enc_SubsequentMessage/2,
enc_EncKeyWithID/2,
enc_PrivateKeyInfo/2,
enc_Attributes/2,
enc_RegToken/2,
enc_Authenticator/2,
enc_PKIPublicationInfo/2,
enc_SinglePubInfo/2,
enc_PKIArchiveOptions/2,
enc_EncryptedKey/2,
enc_EncryptedValue/2,
enc_KeyGenParameters/2,
enc_OldCertId/2,
enc_CertId/2,
enc_ProtocolEncrKey/2,
enc_UTF8Pairs/2,
enc_CertReq/2
]).

-export([
dec_CertReqMessages/2,
dec_CertReqMsg/2,
dec_CertRequest/2,
dec_CertTemplate/2,
dec_OptionalValidity/2,
dec_Controls/2,
dec_ProofOfPossession/2,
dec_POPOSigningKey/2,
dec_POPOSigningKeyInput/2,
dec_PKMACValue/2,
dec_PBMParameter/2,
dec_POPOPrivKey/2,
dec_SubsequentMessage/2,
dec_EncKeyWithID/2,
dec_PrivateKeyInfo/2,
dec_Attributes/2,
dec_RegToken/2,
dec_Authenticator/2,
dec_PKIPublicationInfo/2,
dec_SinglePubInfo/2,
dec_PKIArchiveOptions/2,
dec_EncryptedKey/2,
dec_EncryptedValue/2,
dec_KeyGenParameters/2,
dec_OldCertId/2,
dec_CertId/2,
dec_ProtocolEncrKey/2,
dec_UTF8Pairs/2,
dec_CertReq/2
]).

-export([
'enc_ct-encKeyWithID'/3,
'enc_regCtrl-regToken'/3,
'enc_regCtrl-authenticator'/3,
'enc_regCtrl-pkiPublicationInfo'/3,
'enc_regCtrl-pkiArchiveOptions'/3,
'enc_regCtrl-oldCertID'/3,
'enc_regCtrl-protocolEncrKey'/3,
'enc_regInfo-utf8Pairs'/3,
'enc_regInfo-certReq'/3
]).

-export([
'dec_ct-encKeyWithID'/3,
'dec_regCtrl-regToken'/3,
'dec_regCtrl-authenticator'/3,
'dec_regCtrl-pkiPublicationInfo'/3,
'dec_regCtrl-pkiArchiveOptions'/3,
'dec_regCtrl-oldCertID'/3,
'dec_regCtrl-protocolEncrKey'/3,
'dec_regInfo-utf8Pairs'/3,
'dec_regInfo-certReq'/3
]).

-export([
'getenc_Password-MACAlgorithms'/1,
getenc_DigestAlgorithms/1,
getenc_MACAlgorithms/1,
getenc_PrivateKeyAttributes/1,
getenc_RegControlSet/1,
getenc_RegInfoSet/1,
getenc_internal_object_set_argument_59/1,
getenc_internal_object_set_argument_57/1,
getenc_internal_object_set_argument_56/1,
getenc_internal_object_set_argument_54/1,
getenc_internal_object_set_argument_52/1,
getenc_internal_object_set_argument_50/1,
getenc_internal_object_set_argument_63/1,
getenc_internal_object_set_argument_61/1,
getenc_internal_object_set_argument_8/1,
getenc_internal_object_set_argument_7/1,
getenc_internal_object_set_argument_6/1,
getenc_internal_object_set_argument_2/1,
getenc_internal_object_set_argument_12/1,
getenc_internal_object_set_argument_10/1
]).

-export([
'getdec_Password-MACAlgorithms'/1,
getdec_DigestAlgorithms/1,
getdec_MACAlgorithms/1,
getdec_PrivateKeyAttributes/1,
getdec_RegControlSet/1,
getdec_RegInfoSet/1,
getdec_internal_object_set_argument_59/1,
getdec_internal_object_set_argument_57/1,
getdec_internal_object_set_argument_56/1,
getdec_internal_object_set_argument_54/1,
getdec_internal_object_set_argument_52/1,
getdec_internal_object_set_argument_50/1,
getdec_internal_object_set_argument_63/1,
getdec_internal_object_set_argument_61/1,
getdec_internal_object_set_argument_8/1,
getdec_internal_object_set_argument_7/1,
getdec_internal_object_set_argument_6/1,
getdec_internal_object_set_argument_2/1,
getdec_internal_object_set_argument_12/1,
getdec_internal_object_set_argument_10/1
]).

-export([
'id-pkip'/0,
'id-smime'/0,
'id-ct'/0,
'id-PasswordBasedMac'/0,
'id-ct-encKeyWithID'/0,
'id-regCtrl'/0,
'id-regCtrl-regToken'/0,
'id-regCtrl-authenticator'/0,
'id-regCtrl-pkiPublicationInfo'/0,
'id-regCtrl-pkiArchiveOptions'/0,
'id-regCtrl-oldCertID'/0,
'id-regCtrl-protocolEncrKey'/0,
'id-regInfo'/0,
'id-regInfo-utf8Pairs'/0,
'id-regInfo-certReq'/0
]).

-export([info/0]).

-export([encode/2,decode/2]).

encoding_rule() -> ber.

maps() -> false.

bit_string_format() -> bitstring.

legacy_erlang_types() -> false.

encode(Type, Data) ->
try iolist_to_binary(element(1, encode_disp(Type, Data))) of
  Bytes ->
    {ok,Bytes}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.


decode(Type, Data) ->
try
   Result = decode_disp(Type, element(1, ber_decode_nif(Data))),
   {ok,Result}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

encode_disp('CertReqMessages', Data) -> enc_CertReqMessages(Data);
encode_disp('CertReqMsg', Data) -> enc_CertReqMsg(Data);
encode_disp('CertRequest', Data) -> enc_CertRequest(Data);
encode_disp('CertTemplate', Data) -> enc_CertTemplate(Data);
encode_disp('OptionalValidity', Data) -> enc_OptionalValidity(Data);
encode_disp('Controls', Data) -> enc_Controls(Data);
encode_disp('ProofOfPossession', Data) -> enc_ProofOfPossession(Data);
encode_disp('POPOSigningKey', Data) -> enc_POPOSigningKey(Data);
encode_disp('POPOSigningKeyInput', Data) -> enc_POPOSigningKeyInput(Data);
encode_disp('PKMACValue', Data) -> enc_PKMACValue(Data);
encode_disp('PBMParameter', Data) -> enc_PBMParameter(Data);
encode_disp('POPOPrivKey', Data) -> enc_POPOPrivKey(Data);
encode_disp('SubsequentMessage', Data) -> enc_SubsequentMessage(Data);
encode_disp('EncKeyWithID', Data) -> enc_EncKeyWithID(Data);
encode_disp('PrivateKeyInfo', Data) -> enc_PrivateKeyInfo(Data);
encode_disp('Attributes', Data) -> enc_Attributes(Data);
encode_disp('RegToken', Data) -> enc_RegToken(Data);
encode_disp('Authenticator', Data) -> enc_Authenticator(Data);
encode_disp('PKIPublicationInfo', Data) -> enc_PKIPublicationInfo(Data);
encode_disp('SinglePubInfo', Data) -> enc_SinglePubInfo(Data);
encode_disp('PKIArchiveOptions', Data) -> enc_PKIArchiveOptions(Data);
encode_disp('EncryptedKey', Data) -> enc_EncryptedKey(Data);
encode_disp('EncryptedValue', Data) -> enc_EncryptedValue(Data);
encode_disp('KeyGenParameters', Data) -> enc_KeyGenParameters(Data);
encode_disp('OldCertId', Data) -> enc_OldCertId(Data);
encode_disp('CertId', Data) -> enc_CertId(Data);
encode_disp('ProtocolEncrKey', Data) -> enc_ProtocolEncrKey(Data);
encode_disp('UTF8Pairs', Data) -> enc_UTF8Pairs(Data);
encode_disp('CertReq', Data) -> enc_CertReq(Data);
encode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

decode_disp('CertReqMessages', Data) -> dec_CertReqMessages(Data);
decode_disp('CertReqMsg', Data) -> dec_CertReqMsg(Data);
decode_disp('CertRequest', Data) -> dec_CertRequest(Data);
decode_disp('CertTemplate', Data) -> dec_CertTemplate(Data);
decode_disp('OptionalValidity', Data) -> dec_OptionalValidity(Data);
decode_disp('Controls', Data) -> dec_Controls(Data);
decode_disp('ProofOfPossession', Data) -> dec_ProofOfPossession(Data);
decode_disp('POPOSigningKey', Data) -> dec_POPOSigningKey(Data);
decode_disp('POPOSigningKeyInput', Data) -> dec_POPOSigningKeyInput(Data);
decode_disp('PKMACValue', Data) -> dec_PKMACValue(Data);
decode_disp('PBMParameter', Data) -> dec_PBMParameter(Data);
decode_disp('POPOPrivKey', Data) -> dec_POPOPrivKey(Data);
decode_disp('SubsequentMessage', Data) -> dec_SubsequentMessage(Data);
decode_disp('EncKeyWithID', Data) -> dec_EncKeyWithID(Data);
decode_disp('PrivateKeyInfo', Data) -> dec_PrivateKeyInfo(Data);
decode_disp('Attributes', Data) -> dec_Attributes(Data);
decode_disp('RegToken', Data) -> dec_RegToken(Data);
decode_disp('Authenticator', Data) -> dec_Authenticator(Data);
decode_disp('PKIPublicationInfo', Data) -> dec_PKIPublicationInfo(Data);
decode_disp('SinglePubInfo', Data) -> dec_SinglePubInfo(Data);
decode_disp('PKIArchiveOptions', Data) -> dec_PKIArchiveOptions(Data);
decode_disp('EncryptedKey', Data) -> dec_EncryptedKey(Data);
decode_disp('EncryptedValue', Data) -> dec_EncryptedValue(Data);
decode_disp('KeyGenParameters', Data) -> dec_KeyGenParameters(Data);
decode_disp('OldCertId', Data) -> dec_OldCertId(Data);
decode_disp('CertId', Data) -> dec_CertId(Data);
decode_disp('ProtocolEncrKey', Data) -> dec_ProtocolEncrKey(Data);
decode_disp('UTF8Pairs', Data) -> dec_UTF8Pairs(Data);
decode_disp('CertReq', Data) -> dec_CertReq(Data);
decode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

info() ->
   case ?MODULE:module_info(attributes) of
     Attributes when is_list(Attributes) ->
       case lists:keyfind(asn1_info, 1, Attributes) of
         {_,Info} when is_list(Info) ->
           Info;
         _ ->
           []
       end;
     _ ->
       []
   end.


%%================================
%%  CertReqMessages
%%================================
enc_CertReqMessages(Val) ->
    enc_CertReqMessages(Val, [<<48>>]).

enc_CertReqMessages(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_CertReqMessages_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_CertReqMessages_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_CertReqMessages_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_CertReqMsg'(H, [<<48>>]),
   'enc_CertReqMessages_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_CertReqMessages(Tlv) ->
   dec_CertReqMessages(Tlv, [16]).

dec_CertReqMessages(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_CertReqMsg'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  CertReqMsg
%%================================
enc_CertReqMsg(Val) ->
    enc_CertReqMsg(Val, [<<48>>]).

enc_CertReqMsg(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute certReq(1)   External PKIXCRMF-2009:CertRequest
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_CertRequest'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute popo(2)   External PKIXCRMF-2009:ProofOfPossession OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_ProofOfPossession'(Cindex2, [])
       end,

%%-------------------------------------------------
%% attribute regInfo(3) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_CertReqMsg_regInfo'(Cindex3, [<<48>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  CertReqMsg_regInfo
%%================================
enc_CertReqMsg_regInfo(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_CertReqMsg_regInfo_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_CertReqMsg_regInfo_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_CertReqMsg_regInfo_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_CertReqMsg_regInfo_SingleAttribute'(H, [<<48>>]),
   'enc_CertReqMsg_regInfo_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  CertReqMsg_regInfo_SingleAttribute
%%================================
enc_CertReqMsg_regInfo_SingleAttribute(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objtype = 
   'PKIXCRMF-2009':'getenc_internal_object_set_argument_50'(                                   Cindex1),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute value(2) with type typefieldType
%%-------------------------------------------------
   {TmpBytes2,_} = Objtype('Type', Cindex2, []),
   {EncBytes2,EncLen2} = encode_open_type(TmpBytes2, [])
,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_CertReqMsg(Tlv) ->
   dec_CertReqMsg(Tlv, [16]).

dec_CertReqMsg(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute certReq(1)   External PKIXCRMF-2009:CertRequest
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_CertRequest'(V1, [16]),

%%-------------------------------------------------
%% attribute popo(2)   External PKIXCRMF-2009:ProofOfPossession OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[V2 = {131072,_}|TempTlv3] ->
    {'dec_ProofOfPossession'(V2, []), TempTlv3};
[V2 = {131073,_}|TempTlv3] ->
    {'dec_ProofOfPossession'(V2, []), TempTlv3};
[V2 = {131074,_}|TempTlv3] ->
    {'dec_ProofOfPossession'(V2, []), TempTlv3};
[V2 = {131075,_}|TempTlv3] ->
    {'dec_ProofOfPossession'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute regInfo(3) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{16,V3}|TempTlv4] ->
    {'dec_CertReqMsg_regInfo'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'CertReqMsg',Term1,Term2,Term3},
Res1.
'dec_CertReqMsg_regInfo'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_CertReqMsg_regInfo_SingleAttribute'(V1, [16]) || V1 <- Tlv1].


'dec_CertReqMsg_regInfo_SingleAttribute'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute value(2) with type typefieldType
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 

  Tmpterm1 = decode_open_type(V2, []),

DecObjtypeTerm1 =
   'PKIXCRMF-2009':'getdec_internal_object_set_argument_50'(Term1),
Term2 = 
   case (catch DecObjtypeTerm1('Type', Tmpterm1, [])) of
      {'EXIT', Reason1} ->
         exit({'Type not compatible with table constraint',Reason1});
      Tmpterm2 ->
         Tmpterm2
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'SingleAttribute',Term1,Term2},
Res1.


%%================================
%%  CertRequest
%%================================
enc_CertRequest(Val) ->
    enc_CertRequest(Val, [<<48>>]).

enc_CertRequest(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute certReqId(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute certTemplate(2)   External PKIXCRMF-2009:CertTemplate
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_CertTemplate'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute controls(3)   External PKIXCRMF-2009:Controls OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Controls'(Cindex3, [<<48>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_CertRequest(Tlv) ->
   dec_CertRequest(Tlv, [16]).

dec_CertRequest(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute certReqId(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_integer(V1, [2]),

%%-------------------------------------------------
%% attribute certTemplate(2)   External PKIXCRMF-2009:CertTemplate
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_CertTemplate'(V2, [16]),

%%-------------------------------------------------
%% attribute controls(3)   External PKIXCRMF-2009:Controls OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{16,V3}|TempTlv4] ->
    {'dec_Controls'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'CertRequest',Term1,Term2,Term3},
Res1.


%%================================
%%  CertTemplate
%%================================
enc_CertTemplate(Val) ->
    enc_CertTemplate(Val, [<<48>>]).

enc_CertTemplate(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5,Cindex6,Cindex7,Cindex8,Cindex9,Cindex10} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex1, [{v1,0},{v2,1},{v3,2}], [<<128>>])
       end,

%%-------------------------------------------------
%% attribute serialNumber(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex2, [<<129>>])
       end,

%%-------------------------------------------------
%% attribute signingAlg(3) with type SEQUENCE OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_CertTemplate_signingAlg'(Cindex3, [<<162>>])
       end,

%%-------------------------------------------------
%% attribute issuer(4)   External PKIX1Explicit-2009:Name OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'PKIX1Explicit-2009':'enc_Name'(Cindex4, [<<163>>])
       end,

%%-------------------------------------------------
%% attribute validity(5)   External PKIXCRMF-2009:OptionalValidity OPTIONAL
%%-------------------------------------------------
   {EncBytes5,EncLen5} =  case Cindex5 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_OptionalValidity'(Cindex5, [<<164>>])
       end,

%%-------------------------------------------------
%% attribute subject(6)   External PKIX1Explicit-2009:Name OPTIONAL
%%-------------------------------------------------
   {EncBytes6,EncLen6} =  case Cindex6 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'PKIX1Explicit-2009':'enc_Name'(Cindex6, [<<165>>])
       end,

%%-------------------------------------------------
%% attribute publicKey(7)   External PKIX1Explicit-2009:SubjectPublicKeyInfo OPTIONAL
%%-------------------------------------------------
   {EncBytes7,EncLen7} =  case Cindex7 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'PKIX1Explicit-2009':'enc_SubjectPublicKeyInfo'(Cindex7, [<<166>>])
       end,

%%-------------------------------------------------
%% attribute issuerUID(8) with type BIT STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes8,EncLen8} =  case Cindex8 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_unnamed_bit_string(Cindex8, [<<135>>])
       end,

%%-------------------------------------------------
%% attribute subjectUID(9) with type BIT STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes9,EncLen9} =  case Cindex9 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_unnamed_bit_string(Cindex9, [<<136>>])
       end,

%%-------------------------------------------------
%% attribute extensions(10) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes10,EncLen10} =  case Cindex10 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_CertTemplate_extensions'(Cindex10, [<<169>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6, EncBytes7, EncBytes8, EncBytes9, EncBytes10],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6 + EncLen7 + EncLen8 + EncLen9 + EncLen10,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  CertTemplate_signingAlg
%%================================
enc_CertTemplate_signingAlg(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKIXCRMF-2009':'getenc_internal_object_set_argument_2'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  CertTemplate_extensions
%%================================
enc_CertTemplate_extensions(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_CertTemplate_extensions_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_CertTemplate_extensions_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_CertTemplate_extensions_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_CertTemplate_extensions_Extension'(H, [<<48>>]),
   'enc_CertTemplate_extensions_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  CertTemplate_extensions_Extension
%%================================
enc_CertTemplate_extensions_Extension(Val, TagIn) ->
   {_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case is_default_1(Cindex2) of
true -> {[],0};
false ->
encode_boolean(Cindex2, [<<1>>])
       end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_restricted_string(Cindex3, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_CertTemplate(Tlv) ->
   dec_CertTemplate(Tlv, [16]).

dec_CertTemplate(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {begin
Val1 = decode_integer(V1, []),
number2name(Val1, [{v1,0},{v2,1},{v3,2}])
end
, TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute serialNumber(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {decode_integer(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute signingAlg(3) with type SEQUENCE OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {'dec_CertTemplate_signingAlg'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute issuer(4)   External PKIX1Explicit-2009:Name OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131075,V4}|TempTlv5] ->
    {'PKIX1Explicit-2009':'dec_Name'(V4, []), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

%%-------------------------------------------------
%% attribute validity(5)   External PKIXCRMF-2009:OptionalValidity OPTIONAL
%%-------------------------------------------------
{Term5,Tlv6} = case Tlv5 of
[{131076,V5}|TempTlv6] ->
    {'dec_OptionalValidity'(V5, []), TempTlv6};
    _ ->
        { asn1_NOVALUE, Tlv5}
end,

%%-------------------------------------------------
%% attribute subject(6)   External PKIX1Explicit-2009:Name OPTIONAL
%%-------------------------------------------------
{Term6,Tlv7} = case Tlv6 of
[{131077,V6}|TempTlv7] ->
    {'PKIX1Explicit-2009':'dec_Name'(V6, []), TempTlv7};
    _ ->
        { asn1_NOVALUE, Tlv6}
end,

%%-------------------------------------------------
%% attribute publicKey(7)   External PKIX1Explicit-2009:SubjectPublicKeyInfo OPTIONAL
%%-------------------------------------------------
{Term7,Tlv8} = case Tlv7 of
[{131078,V7}|TempTlv8] ->
    {'PKIX1Explicit-2009':'dec_SubjectPublicKeyInfo'(V7, []), TempTlv8};
    _ ->
        { asn1_NOVALUE, Tlv7}
end,

%%-------------------------------------------------
%% attribute issuerUID(8) with type BIT STRING OPTIONAL
%%-------------------------------------------------
{Term8,Tlv9} = case Tlv8 of
[{131079,V8}|TempTlv9] ->
    {decode_native_bit_string(V8, []), TempTlv9};
    _ ->
        { asn1_NOVALUE, Tlv8}
end,

%%-------------------------------------------------
%% attribute subjectUID(9) with type BIT STRING OPTIONAL
%%-------------------------------------------------
{Term9,Tlv10} = case Tlv9 of
[{131080,V9}|TempTlv10] ->
    {decode_native_bit_string(V9, []), TempTlv10};
    _ ->
        { asn1_NOVALUE, Tlv9}
end,

%%-------------------------------------------------
%% attribute extensions(10) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term10,Tlv11} = case Tlv10 of
[{131081,V10}|TempTlv11] ->
    {'dec_CertTemplate_extensions'(V10, []), TempTlv11};
    _ ->
        { asn1_NOVALUE, Tlv10}
end,

case Tlv11 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv11}}}) % extra fields not allowed
end,
Res1 = {'CertTemplate',Term1,Term2,Term3,Term4,Term5,Term6,Term7,Term8,Term9,Term10},
Res1.
'dec_CertTemplate_signingAlg'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKIXCRMF-2009':'getdec_internal_object_set_argument_2'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'CertTemplate_signingAlg',Term1,Term2},
Res1.
'dec_CertTemplate_extensions'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_CertTemplate_extensions_Extension'(V1, [16]) || V1 <- Tlv1].


'dec_CertTemplate_extensions_Extension'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{1,V2}|TempTlv3] ->
    {decode_boolean(V2, []), TempTlv3};
    _ ->
        {false,Tlv2}
end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_octet_string(V3, [4]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'Extension',Term1,Term2,Term3},
Res1.


%%================================
%%  OptionalValidity
%%================================
enc_OptionalValidity(Val) ->
    enc_OptionalValidity(Val, [<<48>>]).

enc_OptionalValidity(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute notBefore(1)   External PKIX1Explicit-2009:Time OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'PKIX1Explicit-2009':'enc_Time'(Cindex1, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute notAfter(2)   External PKIX1Explicit-2009:Time OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'PKIX1Explicit-2009':'enc_Time'(Cindex2, [<<161>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_OptionalValidity(Tlv) ->
   dec_OptionalValidity(Tlv, [16]).

dec_OptionalValidity(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute notBefore(1)   External PKIX1Explicit-2009:Time OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'PKIX1Explicit-2009':'dec_Time'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute notAfter(2)   External PKIX1Explicit-2009:Time OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'PKIX1Explicit-2009':'dec_Time'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'OptionalValidity',Term1,Term2},
Res1.


%%================================
%%  Controls
%%================================
enc_Controls(Val) ->
    enc_Controls(Val, [<<48>>]).

enc_Controls(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_Controls_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_Controls_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_Controls_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Controls_SingleAttribute'(H, [<<48>>]),
   'enc_Controls_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  Controls_SingleAttribute
%%================================
enc_Controls_SingleAttribute(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objtype = 
   'PKIXCRMF-2009':'getenc_internal_object_set_argument_8'(                                   Cindex1),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute value(2) with type typefieldType
%%-------------------------------------------------
   {TmpBytes2,_} = Objtype('Type', Cindex2, []),
   {EncBytes2,EncLen2} = encode_open_type(TmpBytes2, [])
,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_Controls(Tlv) ->
   dec_Controls(Tlv, [16]).

dec_Controls(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_Controls_SingleAttribute'(V1, [16]) || V1 <- Tlv1].


'dec_Controls_SingleAttribute'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute value(2) with type typefieldType
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 

  Tmpterm1 = decode_open_type(V2, []),

DecObjtypeTerm1 =
   'PKIXCRMF-2009':'getdec_internal_object_set_argument_8'(Term1),
Term2 = 
   case (catch DecObjtypeTerm1('Type', Tmpterm1, [])) of
      {'EXIT', Reason1} ->
         exit({'Type not compatible with table constraint',Reason1});
      Tmpterm2 ->
         Tmpterm2
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'SingleAttribute',Term1,Term2},
Res1.


%%================================
%%  ProofOfPossession
%%================================
enc_ProofOfPossession(Val) ->
    enc_ProofOfPossession(Val, []).

enc_ProofOfPossession(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      raVerified ->
         encode_null(element(2,Val), [<<128>>]);
      signature ->
         'enc_POPOSigningKey'(element(2,Val), [<<161>>]);
      keyEncipherment ->
         'enc_POPOPrivKey'(element(2,Val), [<<162>>]);
      keyAgreement ->
         'enc_POPOPrivKey'(element(2,Val), [<<163>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_ProofOfPossession(Tlv) ->
   dec_ProofOfPossession(Tlv, []).

dec_ProofOfPossession(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'raVerified'
    {131072, V1} -> 
        {raVerified, decode_null(V1, [])};


%% 'signature'
    {131073, V1} -> 
        {signature, 'dec_POPOSigningKey'(V1, [])};


%% 'keyEncipherment'
    {131074, V1} -> 
        {keyEncipherment, 'dec_POPOPrivKey'(V1, [])};


%% 'keyAgreement'
    {131075, V1} -> 
        {keyAgreement, 'dec_POPOPrivKey'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  POPOSigningKey
%%================================
enc_POPOSigningKey(Val) ->
    enc_POPOSigningKey(Val, [<<48>>]).

enc_POPOSigningKey(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute poposkInput(1)   External PKIXCRMF-2009:POPOSigningKeyInput OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_POPOSigningKeyInput'(Cindex1, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute algorithmIdentifier(2) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_POPOSigningKey_algorithmIdentifier'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_unnamed_bit_string(Cindex3, [<<3>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  POPOSigningKey_algorithmIdentifier
%%================================
enc_POPOSigningKey_algorithmIdentifier(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKIXCRMF-2009':'getenc_internal_object_set_argument_12'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_POPOSigningKey(Tlv) ->
   dec_POPOSigningKey(Tlv, [16]).

dec_POPOSigningKey(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute poposkInput(1)   External PKIXCRMF-2009:POPOSigningKeyInput OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'dec_POPOSigningKeyInput'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute algorithmIdentifier(2) with type SEQUENCE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_POPOSigningKey_algorithmIdentifier'(V2, [16]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_native_bit_string(V3, [3]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'POPOSigningKey',Term1,Term2,Term3},
Res1.
'dec_POPOSigningKey_algorithmIdentifier'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKIXCRMF-2009':'getdec_internal_object_set_argument_12'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'POPOSigningKey_algorithmIdentifier',Term1,Term2},
Res1.


%%================================
%%  POPOSigningKeyInput
%%================================
enc_POPOSigningKeyInput(Val) ->
    enc_POPOSigningKeyInput(Val, [<<48>>]).

enc_POPOSigningKeyInput(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute authInfo(1) with type CHOICE
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_POPOSigningKeyInput_authInfo'(Cindex1, []),

%%-------------------------------------------------
%% attribute publicKey(2)   External PKIX1Explicit-2009:SubjectPublicKeyInfo
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'PKIX1Explicit-2009':'enc_SubjectPublicKeyInfo'(Cindex2, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  POPOSigningKeyInput_authInfo
%%================================
enc_POPOSigningKeyInput_authInfo(Val, TagIn) ->
      {EncBytes,EncLen} = case element(1,Val) of
      sender ->
         'PKIX1Implicit-2009':'enc_GeneralName'(element(2,Val), [<<160>>]);
      publicKeyMAC ->
         'enc_PKMACValue'(element(2,Val), [<<48>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_POPOSigningKeyInput(Tlv) ->
   dec_POPOSigningKeyInput(Tlv, [16]).

dec_POPOSigningKeyInput(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute authInfo(1) with type CHOICE
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_POPOSigningKeyInput_authInfo'(V1, []),

%%-------------------------------------------------
%% attribute publicKey(2)   External PKIX1Explicit-2009:SubjectPublicKeyInfo
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'PKIX1Explicit-2009':'dec_SubjectPublicKeyInfo'(V2, [16]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'POPOSigningKeyInput',Term1,Term2},
Res1.
'dec_POPOSigningKeyInput_authInfo'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'sender'
    {131072, V1} -> 
        {sender, 'PKIX1Implicit-2009':'dec_GeneralName'(V1, [])};


%% 'publicKeyMAC'
    {16, V1} -> 
        {publicKeyMAC, 'dec_PKMACValue'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  PKMACValue
%%================================
enc_PKMACValue(Val) ->
    enc_PKMACValue(Val, [<<48>>]).

enc_PKMACValue(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute algId(1) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_PKMACValue_algId'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute value(2) with type BIT STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_unnamed_bit_string(Cindex2, [<<3>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  PKMACValue_algId
%%================================
enc_PKMACValue_algId(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKIXCRMF-2009':'getenc_internal_object_set_argument_10'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_PKMACValue(Tlv) ->
   dec_PKMACValue(Tlv, [16]).

dec_PKMACValue(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algId(1) with type SEQUENCE
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_PKMACValue_algId'(V1, [16]),

%%-------------------------------------------------
%% attribute value(2) with type BIT STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_native_bit_string(V2, [3]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PKMACValue',Term1,Term2},
Res1.
'dec_PKMACValue_algId'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKIXCRMF-2009':'getdec_internal_object_set_argument_10'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PKMACValue_algId',Term1,Term2},
Res1.


%%================================
%%  PBMParameter
%%================================
enc_PBMParameter(Val) ->
    enc_PBMParameter(Val, [<<48>>]).

enc_PBMParameter(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute salt(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<4>>]),

%%-------------------------------------------------
%% attribute owf(2) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_PBMParameter_owf'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute iterationCount(3) with type INTEGER
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_integer(Cindex3, [<<2>>]),

%%-------------------------------------------------
%% attribute mac(4) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes4,EncLen4} = 'enc_PBMParameter_mac'(Cindex4, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  PBMParameter_owf
%%================================
enc_PBMParameter_owf(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKIXCRMF-2009':'getenc_internal_object_set_argument_52'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  PBMParameter_mac
%%================================
enc_PBMParameter_mac(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKIXCRMF-2009':'getenc_internal_object_set_argument_54'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_PBMParameter(Tlv) ->
   dec_PBMParameter(Tlv, [16]).

dec_PBMParameter(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute salt(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_octet_string(V1, [4]),

%%-------------------------------------------------
%% attribute owf(2) with type SEQUENCE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_PBMParameter_owf'(V2, [16]),

%%-------------------------------------------------
%% attribute iterationCount(3) with type INTEGER
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_integer(V3, [2]),

%%-------------------------------------------------
%% attribute mac(4) with type SEQUENCE
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = 'dec_PBMParameter_mac'(V4, [16]),

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'PBMParameter',Term1,Term2,Term3,Term4},
Res1.
'dec_PBMParameter_owf'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKIXCRMF-2009':'getdec_internal_object_set_argument_52'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PBMParameter_owf',Term1,Term2},
Res1.
'dec_PBMParameter_mac'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKIXCRMF-2009':'getdec_internal_object_set_argument_54'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PBMParameter_mac',Term1,Term2},
Res1.


%%================================
%%  POPOPrivKey
%%================================
enc_POPOPrivKey(Val) ->
    enc_POPOPrivKey(Val, []).

enc_POPOPrivKey(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      thisMessage ->
         encode_unnamed_bit_string(element(2,Val), [<<128>>]);
      subsequentMessage ->
         encode_integer(element(2,Val), [{encrCert,0},{challengeResp,1}], [<<129>>]);
      dhMAC ->
         encode_unnamed_bit_string(element(2,Val), [<<130>>]);
      agreeMAC ->
         'enc_PKMACValue'(element(2,Val), [<<163>>]);
      encryptedKey ->
         'CryptographicMessageSyntax-2009':'enc_EnvelopedData'(element(2,Val), [<<164>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_POPOPrivKey(Tlv) ->
   dec_POPOPrivKey(Tlv, []).

dec_POPOPrivKey(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'thisMessage'
    {131072, V1} -> 
        {thisMessage, decode_native_bit_string(V1, [])};


%% 'subsequentMessage'
    {131073, V1} -> 
        {subsequentMessage, begin
Val1 = decode_integer(V1, []),
number2name(Val1, [{encrCert,0},{challengeResp,1}])
end
};


%% 'dhMAC'
    {131074, V1} -> 
        {dhMAC, decode_native_bit_string(V1, [])};


%% 'agreeMAC'
    {131075, V1} -> 
        {agreeMAC, 'dec_PKMACValue'(V1, [])};


%% 'encryptedKey'
    {131076, V1} -> 
        {encryptedKey, 'CryptographicMessageSyntax-2009':'dec_EnvelopedData'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  SubsequentMessage
%%================================
enc_SubsequentMessage(Val) ->
    enc_SubsequentMessage(Val, [<<2>>]).

enc_SubsequentMessage(Val, TagIn) ->
encode_integer(Val, [{encrCert,0},{challengeResp,1}], TagIn).


dec_SubsequentMessage(Tlv) ->
   dec_SubsequentMessage(Tlv, [2]).

dec_SubsequentMessage(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
number2name(Val1, [{encrCert,0},{challengeResp,1}])
end
.



%%================================
%%  EncKeyWithID
%%================================
enc_EncKeyWithID(Val) ->
    enc_EncKeyWithID(Val, [<<48>>]).

enc_EncKeyWithID(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute privateKey(1)   External PKIXCRMF-2009:PrivateKeyInfo
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_PrivateKeyInfo'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute identifier(2) with type CHOICE OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_EncKeyWithID_identifier'(Cindex2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  EncKeyWithID_identifier
%%================================
enc_EncKeyWithID_identifier(Val, TagIn) ->
      {EncBytes,EncLen} = case element(1,Val) of
      string ->
         encode_UTF8_string(element(2,Val), [<<12>>]);
      generalName ->
         'PKIX1Implicit-2009':'enc_GeneralName'(element(2,Val), []);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_EncKeyWithID(Tlv) ->
   dec_EncKeyWithID(Tlv, [16]).

dec_EncKeyWithID(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute privateKey(1)   External PKIXCRMF-2009:PrivateKeyInfo
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_PrivateKeyInfo'(V1, [16]),

%%-------------------------------------------------
%% attribute identifier(2) with type CHOICE OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[V2 = {12,_}|TempTlv3] ->
    {'dec_EncKeyWithID_identifier'(V2, []), TempTlv3};
[V2 = {131072,_}|TempTlv3] ->
    {'dec_EncKeyWithID_identifier'(V2, []), TempTlv3};
[V2 = {131073,_}|TempTlv3] ->
    {'dec_EncKeyWithID_identifier'(V2, []), TempTlv3};
[V2 = {131074,_}|TempTlv3] ->
    {'dec_EncKeyWithID_identifier'(V2, []), TempTlv3};
[V2 = {131075,_}|TempTlv3] ->
    {'dec_EncKeyWithID_identifier'(V2, []), TempTlv3};
[V2 = {131076,_}|TempTlv3] ->
    {'dec_EncKeyWithID_identifier'(V2, []), TempTlv3};
[V2 = {131077,_}|TempTlv3] ->
    {'dec_EncKeyWithID_identifier'(V2, []), TempTlv3};
[V2 = {131078,_}|TempTlv3] ->
    {'dec_EncKeyWithID_identifier'(V2, []), TempTlv3};
[V2 = {131079,_}|TempTlv3] ->
    {'dec_EncKeyWithID_identifier'(V2, []), TempTlv3};
[V2 = {131080,_}|TempTlv3] ->
    {'dec_EncKeyWithID_identifier'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'EncKeyWithID',Term1,Term2},
Res1.
'dec_EncKeyWithID_identifier'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'string'
    {12, V1} -> 
        {string, decode_UTF8_string(V1, [])};


%% 'generalName'
    V1 = {131072,_} -> 
        {generalName, 'PKIX1Implicit-2009':'dec_GeneralName'(V1, [])};

    V1 = {131073,_} -> 
        {generalName, 'PKIX1Implicit-2009':'dec_GeneralName'(V1, [])};

    V1 = {131074,_} -> 
        {generalName, 'PKIX1Implicit-2009':'dec_GeneralName'(V1, [])};

    V1 = {131075,_} -> 
        {generalName, 'PKIX1Implicit-2009':'dec_GeneralName'(V1, [])};

    V1 = {131076,_} -> 
        {generalName, 'PKIX1Implicit-2009':'dec_GeneralName'(V1, [])};

    V1 = {131077,_} -> 
        {generalName, 'PKIX1Implicit-2009':'dec_GeneralName'(V1, [])};

    V1 = {131078,_} -> 
        {generalName, 'PKIX1Implicit-2009':'dec_GeneralName'(V1, [])};

    V1 = {131079,_} -> 
        {generalName, 'PKIX1Implicit-2009':'dec_GeneralName'(V1, [])};

    V1 = {131080,_} -> 
        {generalName, 'PKIX1Implicit-2009':'dec_GeneralName'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  PrivateKeyInfo
%%================================
enc_PrivateKeyInfo(Val) ->
    enc_PrivateKeyInfo(Val, [<<48>>]).

enc_PrivateKeyInfo(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute privateKeyAlgorithm(2) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_PrivateKeyInfo_privateKeyAlgorithm'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute privateKey(3) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_restricted_string(Cindex3, [<<4>>]),

%%-------------------------------------------------
%% attribute attributes(4)   External PKIXCRMF-2009:Attributes OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Attributes'(Cindex4, [<<160>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  PrivateKeyInfo_privateKeyAlgorithm
%%================================
enc_PrivateKeyInfo_privateKeyAlgorithm(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKIXCRMF-2009':'getenc_internal_object_set_argument_56'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_PrivateKeyInfo(Tlv) ->
   dec_PrivateKeyInfo(Tlv, [16]).

dec_PrivateKeyInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_integer(V1, [2]),

%%-------------------------------------------------
%% attribute privateKeyAlgorithm(2) with type SEQUENCE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_PrivateKeyInfo_privateKeyAlgorithm'(V2, [16]),

%%-------------------------------------------------
%% attribute privateKey(3) with type OCTET STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_octet_string(V3, [4]),

%%-------------------------------------------------
%% attribute attributes(4)   External PKIXCRMF-2009:Attributes OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131072,V4}|TempTlv5] ->
    {'dec_Attributes'(V4, []), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'PrivateKeyInfo',Term1,Term2,Term3,Term4},
Res1.
'dec_PrivateKeyInfo_privateKeyAlgorithm'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKIXCRMF-2009':'getdec_internal_object_set_argument_56'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PrivateKeyInfo_privateKeyAlgorithm',Term1,Term2},
Res1.


%%================================
%%  Attributes
%%================================
enc_Attributes(Val) ->
    enc_Attributes(Val, [<<49>>]).

enc_Attributes(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_Attributes_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_Attributes_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_Attributes_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Attributes_AttributeSet'(H, [<<48>>]),
   'enc_Attributes_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  Attributes_AttributeSet
%%================================
enc_Attributes_AttributeSet(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objtype = 
   'PKIXCRMF-2009':'getenc_internal_object_set_argument_57'(                                   Cindex1),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute values(2) with type SET OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_Attributes_AttributeSet_values'(Cindex2, [<<49>>], Objtype),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  Attributes_AttributeSet_values
%%================================
enc_Attributes_AttributeSet_values(Val, TagIn, ObjFun) ->
      {EncBytes,EncLen} = 'enc_Attributes_AttributeSet_values_components'(Val, ObjFun,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_Attributes_AttributeSet_values_components'([], _, AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_Attributes_AttributeSet_values_components'([H|T], ObjFun,AccBytes, AccLen) ->
   {TmpBytes,_} = ObjFun('Type', H, []),
   {EncBytes,EncLen} = encode_open_type(TmpBytes, [])
,
   'enc_Attributes_AttributeSet_values_components'(T, ObjFun,[EncBytes|AccBytes], AccLen + EncLen).



dec_Attributes(Tlv) ->
   dec_Attributes(Tlv, [17]).

dec_Attributes(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_Attributes_AttributeSet'(V1, [16]) || V1 <- Tlv1].


'dec_Attributes_AttributeSet'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),
ObjFun = 'PKIXCRMF-2009':'getdec_internal_object_set_argument_57'(Term1),

%%-------------------------------------------------
%% attribute values(2) with type SET OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_Attributes_AttributeSet_values'(V2, [17], ObjFun),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'AttributeSet',Term1,Term2},
Res1.
'dec_Attributes_AttributeSet_values'(Tlv, TagIn, ObjFun) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[
      begin
         Tmptlv1 = decode_open_type(V1, []),
         case (catch ObjFun('Type', Tmptlv1, [])) of
            {'EXIT',Reason1} ->
               exit({'Type not compatible with table constraint', Reason1});
            Tmpterm1 ->
               Tmpterm1
         end
      end
 || V1 <- Tlv1].




%%================================
%%  RegToken
%%================================
enc_RegToken(Val) ->
    enc_RegToken(Val, [<<12>>]).

enc_RegToken(Val, TagIn) ->
encode_UTF8_string(Val, TagIn).


dec_RegToken(Tlv) ->
   dec_RegToken(Tlv, [12]).

dec_RegToken(Tlv, TagIn) ->
decode_UTF8_string(Tlv, TagIn).



%%================================
%%  Authenticator
%%================================
enc_Authenticator(Val) ->
    enc_Authenticator(Val, [<<12>>]).

enc_Authenticator(Val, TagIn) ->
encode_UTF8_string(Val, TagIn).


dec_Authenticator(Tlv) ->
   dec_Authenticator(Tlv, [12]).

dec_Authenticator(Tlv, TagIn) ->
decode_UTF8_string(Tlv, TagIn).



%%================================
%%  PKIPublicationInfo
%%================================
enc_PKIPublicationInfo(Val) ->
    enc_PKIPublicationInfo(Val, [<<48>>]).

enc_PKIPublicationInfo(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute action(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [{dontPublish,0},{pleasePublish,1}], [<<2>>]),

%%-------------------------------------------------
%% attribute pubInfos(2) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_PKIPublicationInfo_pubInfos'(Cindex2, [<<48>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  PKIPublicationInfo_pubInfos
%%================================
enc_PKIPublicationInfo_pubInfos(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_PKIPublicationInfo_pubInfos_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_PKIPublicationInfo_pubInfos_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_PKIPublicationInfo_pubInfos_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_SinglePubInfo'(H, [<<48>>]),
   'enc_PKIPublicationInfo_pubInfos_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_PKIPublicationInfo(Tlv) ->
   dec_PKIPublicationInfo(Tlv, [16]).

dec_PKIPublicationInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute action(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{dontPublish,0},{pleasePublish,1}])
end
,

%%-------------------------------------------------
%% attribute pubInfos(2) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{16,V2}|TempTlv3] ->
    {'dec_PKIPublicationInfo_pubInfos'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PKIPublicationInfo',Term1,Term2},
Res1.
'dec_PKIPublicationInfo_pubInfos'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_SinglePubInfo'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  SinglePubInfo
%%================================
enc_SinglePubInfo(Val) ->
    enc_SinglePubInfo(Val, [<<48>>]).

enc_SinglePubInfo(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute pubMethod(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [{dontCare,0},{x500,1},{web,2},{ldap,3}], [<<2>>]),

%%-------------------------------------------------
%% attribute pubLocation(2)   External PKIX1Implicit-2009:GeneralName OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'PKIX1Implicit-2009':'enc_GeneralName'(Cindex2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_SinglePubInfo(Tlv) ->
   dec_SinglePubInfo(Tlv, [16]).

dec_SinglePubInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute pubMethod(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{dontCare,0},{x500,1},{web,2},{ldap,3}])
end
,

%%-------------------------------------------------
%% attribute pubLocation(2)   External PKIX1Implicit-2009:GeneralName OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[V2 = {131072,_}|TempTlv3] ->
    {'PKIX1Implicit-2009':'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131073,_}|TempTlv3] ->
    {'PKIX1Implicit-2009':'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131074,_}|TempTlv3] ->
    {'PKIX1Implicit-2009':'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131075,_}|TempTlv3] ->
    {'PKIX1Implicit-2009':'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131076,_}|TempTlv3] ->
    {'PKIX1Implicit-2009':'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131077,_}|TempTlv3] ->
    {'PKIX1Implicit-2009':'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131078,_}|TempTlv3] ->
    {'PKIX1Implicit-2009':'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131079,_}|TempTlv3] ->
    {'PKIX1Implicit-2009':'dec_GeneralName'(V2, []), TempTlv3};
[V2 = {131080,_}|TempTlv3] ->
    {'PKIX1Implicit-2009':'dec_GeneralName'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'SinglePubInfo',Term1,Term2},
Res1.


%%================================
%%  PKIArchiveOptions
%%================================
enc_PKIArchiveOptions(Val) ->
    enc_PKIArchiveOptions(Val, []).

enc_PKIArchiveOptions(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      encryptedPrivKey ->
         'enc_EncryptedKey'(element(2,Val), [<<160>>]);
      keyGenParameters ->
         encode_restricted_string(element(2,Val), [<<129>>]);
      archiveRemGenPrivKey ->
         encode_boolean(element(2,Val), [<<130>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_PKIArchiveOptions(Tlv) ->
   dec_PKIArchiveOptions(Tlv, []).

dec_PKIArchiveOptions(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'encryptedPrivKey'
    {131072, V1} -> 
        {encryptedPrivKey, 'dec_EncryptedKey'(V1, [])};


%% 'keyGenParameters'
    {131073, V1} -> 
        {keyGenParameters, decode_octet_string(V1, [])};


%% 'archiveRemGenPrivKey'
    {131074, V1} -> 
        {archiveRemGenPrivKey, decode_boolean(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  EncryptedKey
%%================================
enc_EncryptedKey(Val) ->
    enc_EncryptedKey(Val, []).

enc_EncryptedKey(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      encryptedValue ->
         'enc_EncryptedValue'(element(2,Val), [<<48>>]);
      envelopedData ->
         'CryptographicMessageSyntax-2009':'enc_EnvelopedData'(element(2,Val), [<<160>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_EncryptedKey(Tlv) ->
   dec_EncryptedKey(Tlv, []).

dec_EncryptedKey(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'encryptedValue'
    {16, V1} -> 
        {encryptedValue, 'dec_EncryptedValue'(V1, [])};


%% 'envelopedData'
    {131072, V1} -> 
        {envelopedData, 'CryptographicMessageSyntax-2009':'dec_EnvelopedData'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  EncryptedValue
%%================================
enc_EncryptedValue(Val) ->
    enc_EncryptedValue(Val, [<<48>>]).

enc_EncryptedValue(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5,Cindex6} = Val,

%%-------------------------------------------------
%% attribute intendedAlg(1) with type SEQUENCE OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_EncryptedValue_intendedAlg'(Cindex1, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute symmAlg(2) with type SEQUENCE OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_EncryptedValue_symmAlg'(Cindex2, [<<161>>])
       end,

%%-------------------------------------------------
%% attribute encSymmKey(3) with type BIT STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_unnamed_bit_string(Cindex3, [<<130>>])
       end,

%%-------------------------------------------------
%% attribute keyAlg(4) with type SEQUENCE OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_EncryptedValue_keyAlg'(Cindex4, [<<163>>])
       end,

%%-------------------------------------------------
%% attribute valueHint(5) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes5,EncLen5} =  case Cindex5 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex5, [<<132>>])
       end,

%%-------------------------------------------------
%% attribute encValue(6) with type BIT STRING
%%-------------------------------------------------
   {EncBytes6,EncLen6} = encode_unnamed_bit_string(Cindex6, [<<3>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  EncryptedValue_intendedAlg
%%================================
enc_EncryptedValue_intendedAlg(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKIXCRMF-2009':'getenc_internal_object_set_argument_59'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  EncryptedValue_symmAlg
%%================================
enc_EncryptedValue_symmAlg(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKIXCRMF-2009':'getenc_internal_object_set_argument_61'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  EncryptedValue_keyAlg
%%================================
enc_EncryptedValue_keyAlg(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKIXCRMF-2009':'getenc_internal_object_set_argument_63'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_EncryptedValue(Tlv) ->
   dec_EncryptedValue(Tlv, [16]).

dec_EncryptedValue(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute intendedAlg(1) with type SEQUENCE OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'dec_EncryptedValue_intendedAlg'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute symmAlg(2) with type SEQUENCE OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'dec_EncryptedValue_symmAlg'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute encSymmKey(3) with type BIT STRING OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {decode_native_bit_string(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute keyAlg(4) with type SEQUENCE OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131075,V4}|TempTlv5] ->
    {'dec_EncryptedValue_keyAlg'(V4, []), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

%%-------------------------------------------------
%% attribute valueHint(5) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term5,Tlv6} = case Tlv5 of
[{131076,V5}|TempTlv6] ->
    {decode_octet_string(V5, []), TempTlv6};
    _ ->
        { asn1_NOVALUE, Tlv5}
end,

%%-------------------------------------------------
%% attribute encValue(6) with type BIT STRING
%%-------------------------------------------------
[V6|Tlv7] = Tlv6, 
Term6 = decode_native_bit_string(V6, [3]),

case Tlv7 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv7}}}) % extra fields not allowed
end,
Res1 = {'EncryptedValue',Term1,Term2,Term3,Term4,Term5,Term6},
Res1.
'dec_EncryptedValue_intendedAlg'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKIXCRMF-2009':'getdec_internal_object_set_argument_59'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'EncryptedValue_intendedAlg',Term1,Term2},
Res1.
'dec_EncryptedValue_symmAlg'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKIXCRMF-2009':'getdec_internal_object_set_argument_61'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'EncryptedValue_symmAlg',Term1,Term2},
Res1.
'dec_EncryptedValue_keyAlg'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKIXCRMF-2009':'getdec_internal_object_set_argument_63'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'EncryptedValue_keyAlg',Term1,Term2},
Res1.


%%================================
%%  KeyGenParameters
%%================================
enc_KeyGenParameters(Val) ->
    enc_KeyGenParameters(Val, [<<4>>]).

enc_KeyGenParameters(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_KeyGenParameters(Tlv) ->
   dec_KeyGenParameters(Tlv, [4]).

dec_KeyGenParameters(Tlv, TagIn) ->
decode_octet_string(Tlv, TagIn).



%%================================
%%  OldCertId
%%================================
enc_OldCertId(Val) ->
    enc_OldCertId(Val, [<<48>>]).

enc_OldCertId(Val, TagIn) ->
   enc_CertId(Val, TagIn).


dec_OldCertId(Tlv) ->
   dec_OldCertId(Tlv, [16]).

dec_OldCertId(Tlv, TagIn) ->
'dec_CertId'(Tlv, TagIn).



%%================================
%%  CertId
%%================================
enc_CertId(Val) ->
    enc_CertId(Val, [<<48>>]).

enc_CertId(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute issuer(1)   External PKIX1Implicit-2009:GeneralName
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'PKIX1Implicit-2009':'enc_GeneralName'(Cindex1, []),

%%-------------------------------------------------
%% attribute serialNumber(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_CertId(Tlv) ->
   dec_CertId(Tlv, [16]).

dec_CertId(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute issuer(1)   External PKIX1Implicit-2009:GeneralName
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'PKIX1Implicit-2009':'dec_GeneralName'(V1, []),

%%-------------------------------------------------
%% attribute serialNumber(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_integer(V2, [2]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'CertId',Term1,Term2},
Res1.


%%================================
%%  ProtocolEncrKey
%%================================
enc_ProtocolEncrKey(Val) ->
    enc_ProtocolEncrKey(Val, [<<48>>]).

enc_ProtocolEncrKey(Val, TagIn) ->
   'PKIX1Explicit-2009':enc_SubjectPublicKeyInfo(Val, TagIn).


dec_ProtocolEncrKey(Tlv) ->
   dec_ProtocolEncrKey(Tlv, [16]).

dec_ProtocolEncrKey(Tlv, TagIn) ->
'PKIX1Explicit-2009':'dec_SubjectPublicKeyInfo'(Tlv, TagIn).



%%================================
%%  UTF8Pairs
%%================================
enc_UTF8Pairs(Val) ->
    enc_UTF8Pairs(Val, [<<12>>]).

enc_UTF8Pairs(Val, TagIn) ->
encode_UTF8_string(Val, TagIn).


dec_UTF8Pairs(Tlv) ->
   dec_UTF8Pairs(Tlv, [12]).

dec_UTF8Pairs(Tlv, TagIn) ->
decode_UTF8_string(Tlv, TagIn).



%%================================
%%  CertReq
%%================================
enc_CertReq(Val) ->
    enc_CertReq(Val, [<<48>>]).

enc_CertReq(Val, TagIn) ->
   enc_CertRequest(Val, TagIn).


dec_CertReq(Tlv) ->
   dec_CertReq(Tlv, [16]).

dec_CertReq(Tlv, TagIn) ->
'dec_CertRequest'(Tlv, TagIn).

'id-pkip'() ->
{1,3,6,1,5,5,7,5}.

'id-smime'() ->
{1,2,840,113549,1,9,16}.

'id-ct'() ->
{1,2,840,113549,1,9,16,1}.

'id-PasswordBasedMac'() ->
{1,2,840,113533,7,66,13}.

'id-ct-encKeyWithID'() ->
{1,2,840,113549,1,9,16,1,21}.

'id-regCtrl'() ->
{1,3,6,1,5,5,7,5,1}.

'id-regCtrl-regToken'() ->
{1,3,6,1,5,5,7,5,1,1}.

'id-regCtrl-authenticator'() ->
{1,3,6,1,5,5,7,5,1,2}.

'id-regCtrl-pkiPublicationInfo'() ->
{1,3,6,1,5,5,7,5,1,3}.

'id-regCtrl-pkiArchiveOptions'() ->
{1,3,6,1,5,5,7,5,1,4}.

'id-regCtrl-oldCertID'() ->
{1,3,6,1,5,5,7,5,1,5}.

'id-regCtrl-protocolEncrKey'() ->
{1,3,6,1,5,5,7,5,1,6}.

'id-regInfo'() ->
{1,3,6,1,5,5,7,5,2}.

'id-regInfo-utf8Pairs'() ->
{1,3,6,1,5,5,7,5,2,1}.

'id-regInfo-certReq'() ->
{1,3,6,1,5,5,7,5,2,2}.




%%================================
%%  ct-encKeyWithID
%%================================
'enc_ct-encKeyWithID'('Type', Val, _RestPrimFieldName) ->
   enc_EncKeyWithID(Val, [<<48>>]).


'dec_ct-encKeyWithID'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_EncKeyWithID(Tlv, [16]).

tlv_format(Bytes) when is_binary(Bytes) ->
  {Tlv,_} = ber_decode_nif(Bytes),
  Tlv;
tlv_format(Bytes) ->
  Bytes.



%%================================
%%  regCtrl-regToken
%%================================
'enc_regCtrl-regToken'('Type', Val, _RestPrimFieldName) ->
   enc_RegToken(Val, [<<12>>]);
'enc_regCtrl-regToken'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_regCtrl-regToken'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_RegToken(Tlv, [12]);
'dec_regCtrl-regToken'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  regCtrl-authenticator
%%================================
'enc_regCtrl-authenticator'('Type', Val, _RestPrimFieldName) ->
   enc_Authenticator(Val, [<<12>>]);
'enc_regCtrl-authenticator'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_regCtrl-authenticator'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_Authenticator(Tlv, [12]);
'dec_regCtrl-authenticator'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  regCtrl-pkiPublicationInfo
%%================================
'enc_regCtrl-pkiPublicationInfo'('Type', Val, _RestPrimFieldName) ->
   enc_PKIPublicationInfo(Val, [<<48>>]);
'enc_regCtrl-pkiPublicationInfo'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_regCtrl-pkiPublicationInfo'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_PKIPublicationInfo(Tlv, [16]);
'dec_regCtrl-pkiPublicationInfo'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  regCtrl-pkiArchiveOptions
%%================================
'enc_regCtrl-pkiArchiveOptions'('Type', Val, _RestPrimFieldName) ->
   enc_PKIArchiveOptions(Val, []);
'enc_regCtrl-pkiArchiveOptions'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_regCtrl-pkiArchiveOptions'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_PKIArchiveOptions(Tlv, []);
'dec_regCtrl-pkiArchiveOptions'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  regCtrl-oldCertID
%%================================
'enc_regCtrl-oldCertID'('Type', Val, _RestPrimFieldName) ->
   enc_OldCertId(Val, [<<48>>]);
'enc_regCtrl-oldCertID'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_regCtrl-oldCertID'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_OldCertId(Tlv, [16]);
'dec_regCtrl-oldCertID'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  regCtrl-protocolEncrKey
%%================================
'enc_regCtrl-protocolEncrKey'('Type', Val, _RestPrimFieldName) ->
   enc_ProtocolEncrKey(Val, [<<48>>]);
'enc_regCtrl-protocolEncrKey'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_regCtrl-protocolEncrKey'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_ProtocolEncrKey(Tlv, [16]);
'dec_regCtrl-protocolEncrKey'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  regInfo-utf8Pairs
%%================================
'enc_regInfo-utf8Pairs'('Type', Val, _RestPrimFieldName) ->
   enc_UTF8Pairs(Val, [<<12>>]);
'enc_regInfo-utf8Pairs'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_regInfo-utf8Pairs'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_UTF8Pairs(Tlv, [12]);
'dec_regInfo-utf8Pairs'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  regInfo-certReq
%%================================
'enc_regInfo-certReq'('Type', Val, _RestPrimFieldName) ->
   enc_CertReq(Val, [<<48>>]);
'enc_regInfo-certReq'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_regInfo-certReq'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_CertReq(Tlv, [16]);
'dec_regInfo-certReq'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  Password-MACAlgorithms
%%================================
'getenc_Password-MACAlgorithms'({1,2,840,113533,7,66,13}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Params' ->
            'enc_PBMParameter'(Val)
      end
   end;
'getenc_Password-MACAlgorithms'(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_Password-MACAlgorithms'({1,2,840,113533,7,66,13}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Params' ->
            'dec_PBMParameter'(Bytes)
      end
   end;
'getdec_Password-MACAlgorithms'(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  DigestAlgorithms
%%================================
getenc_DigestAlgorithms(Id) when Id =:= {1,3,14,3,2,26} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_mda-sha1'(T,V,O) end;
getenc_DigestAlgorithms(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_DigestAlgorithms(Id) when Id =:= {1,3,14,3,2,26} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_mda-sha1'(T,V,O) end;
getdec_DigestAlgorithms(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  MACAlgorithms
%%================================
getenc_MACAlgorithms(Id) when Id =:= {1,3,6,1,5,5,8,1,2} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'enc_maca-hMAC-SHA1'(T,V,O) end;
getenc_MACAlgorithms(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_MACAlgorithms(Id) when Id =:= {1,3,6,1,5,5,8,1,2} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'dec_maca-hMAC-SHA1'(T,V,O) end;
getdec_MACAlgorithms(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  PrivateKeyAttributes
%%================================
getenc_PrivateKeyAttributes(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_PrivateKeyAttributes(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  RegControlSet
%%================================
getenc_RegControlSet(Id) when Id =:= {1,3,6,1,5,5,7,5,1,1} ->
    fun 'enc_regCtrl-regToken'/3;
getenc_RegControlSet(Id) when Id =:= {1,3,6,1,5,5,7,5,1,2} ->
    fun 'enc_regCtrl-authenticator'/3;
getenc_RegControlSet(Id) when Id =:= {1,3,6,1,5,5,7,5,1,3} ->
    fun 'enc_regCtrl-pkiPublicationInfo'/3;
getenc_RegControlSet(Id) when Id =:= {1,3,6,1,5,5,7,5,1,4} ->
    fun 'enc_regCtrl-pkiArchiveOptions'/3;
getenc_RegControlSet(Id) when Id =:= {1,3,6,1,5,5,7,5,1,5} ->
    fun 'enc_regCtrl-oldCertID'/3;
getenc_RegControlSet(Id) when Id =:= {1,3,6,1,5,5,7,5,1,6} ->
    fun 'enc_regCtrl-protocolEncrKey'/3;
getenc_RegControlSet(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_RegControlSet(Id) when Id =:= {1,3,6,1,5,5,7,5,1,1} ->
    fun 'dec_regCtrl-regToken'/3;
getdec_RegControlSet(Id) when Id =:= {1,3,6,1,5,5,7,5,1,2} ->
    fun 'dec_regCtrl-authenticator'/3;
getdec_RegControlSet(Id) when Id =:= {1,3,6,1,5,5,7,5,1,3} ->
    fun 'dec_regCtrl-pkiPublicationInfo'/3;
getdec_RegControlSet(Id) when Id =:= {1,3,6,1,5,5,7,5,1,4} ->
    fun 'dec_regCtrl-pkiArchiveOptions'/3;
getdec_RegControlSet(Id) when Id =:= {1,3,6,1,5,5,7,5,1,5} ->
    fun 'dec_regCtrl-oldCertID'/3;
getdec_RegControlSet(Id) when Id =:= {1,3,6,1,5,5,7,5,1,6} ->
    fun 'dec_regCtrl-protocolEncrKey'/3;
getdec_RegControlSet(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  RegInfoSet
%%================================
getenc_RegInfoSet(Id) when Id =:= {1,3,6,1,5,5,7,5,2,1} ->
    fun 'enc_regInfo-utf8Pairs'/3;
getenc_RegInfoSet(Id) when Id =:= {1,3,6,1,5,5,7,5,2,2} ->
    fun 'enc_regInfo-certReq'/3;
getenc_RegInfoSet(ErrV) ->
   fun(C,V,_) ->
exit({'Type not compatible with table constraint',{component,C},{value,V}, {unique_name_and_value,id, ErrV}}) end.

getdec_RegInfoSet(Id) when Id =:= {1,3,6,1,5,5,7,5,2,1} ->
    fun 'dec_regInfo-utf8Pairs'/3;
getdec_RegInfoSet(Id) when Id =:= {1,3,6,1,5,5,7,5,2,2} ->
    fun 'dec_regInfo-certReq'/3;
'getdec_RegInfoSet'(ErrV) ->
  fun(C,V,_) -> exit({{component,C},{value,V},{unique_name_and_value,id, ErrV}}) end.





%%================================
%%  internal_object_set_argument_59
%%================================
getenc_internal_object_set_argument_59(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_59(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_57
%%================================
getenc_internal_object_set_argument_57(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_57(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_56
%%================================
getenc_internal_object_set_argument_56(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_56(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_54
%%================================
getenc_internal_object_set_argument_54(Id) when Id =:= {1,3,6,1,5,5,8,1,2} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'enc_maca-hMAC-SHA1'(T,V,O) end;
getenc_internal_object_set_argument_54(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_54(Id) when Id =:= {1,3,6,1,5,5,8,1,2} ->
   fun(T,V,O) -> 'CryptographicMessageSyntaxAlgorithms-2009':'dec_maca-hMAC-SHA1'(T,V,O) end;
getdec_internal_object_set_argument_54(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_52
%%================================
getenc_internal_object_set_argument_52(Id) when Id =:= {1,3,14,3,2,26} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_mda-sha1'(T,V,O) end;
getenc_internal_object_set_argument_52(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_52(Id) when Id =:= {1,3,14,3,2,26} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_mda-sha1'(T,V,O) end;
getdec_internal_object_set_argument_52(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_50
%%================================
getenc_internal_object_set_argument_50(Id) when Id =:= {1,3,6,1,5,5,7,5,2,1} ->
    fun 'enc_regInfo-utf8Pairs'/3;
getenc_internal_object_set_argument_50(Id) when Id =:= {1,3,6,1,5,5,7,5,2,2} ->
    fun 'enc_regInfo-certReq'/3;
getenc_internal_object_set_argument_50(ErrV) ->
   fun(C,V,_) ->
exit({'Type not compatible with table constraint',{component,C},{value,V}, {unique_name_and_value,id, ErrV}}) end.

getdec_internal_object_set_argument_50(Id) when Id =:= {1,3,6,1,5,5,7,5,2,1} ->
    fun 'dec_regInfo-utf8Pairs'/3;
getdec_internal_object_set_argument_50(Id) when Id =:= {1,3,6,1,5,5,7,5,2,2} ->
    fun 'dec_regInfo-certReq'/3;
'getdec_internal_object_set_argument_50'(ErrV) ->
  fun(C,V,_) -> exit({{component,C},{value,V},{unique_name_and_value,id, ErrV}}) end.





%%================================
%%  internal_object_set_argument_63
%%================================
getenc_internal_object_set_argument_63(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_63(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_61
%%================================
getenc_internal_object_set_argument_61(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_61(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_8
%%================================
getenc_internal_object_set_argument_8(Id) when Id =:= {1,3,6,1,5,5,7,5,1,1} ->
    fun 'enc_regCtrl-regToken'/3;
getenc_internal_object_set_argument_8(Id) when Id =:= {1,3,6,1,5,5,7,5,1,2} ->
    fun 'enc_regCtrl-authenticator'/3;
getenc_internal_object_set_argument_8(Id) when Id =:= {1,3,6,1,5,5,7,5,1,3} ->
    fun 'enc_regCtrl-pkiPublicationInfo'/3;
getenc_internal_object_set_argument_8(Id) when Id =:= {1,3,6,1,5,5,7,5,1,4} ->
    fun 'enc_regCtrl-pkiArchiveOptions'/3;
getenc_internal_object_set_argument_8(Id) when Id =:= {1,3,6,1,5,5,7,5,1,5} ->
    fun 'enc_regCtrl-oldCertID'/3;
getenc_internal_object_set_argument_8(Id) when Id =:= {1,3,6,1,5,5,7,5,1,6} ->
    fun 'enc_regCtrl-protocolEncrKey'/3;
getenc_internal_object_set_argument_8(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_8(Id) when Id =:= {1,3,6,1,5,5,7,5,1,1} ->
    fun 'dec_regCtrl-regToken'/3;
getdec_internal_object_set_argument_8(Id) when Id =:= {1,3,6,1,5,5,7,5,1,2} ->
    fun 'dec_regCtrl-authenticator'/3;
getdec_internal_object_set_argument_8(Id) when Id =:= {1,3,6,1,5,5,7,5,1,3} ->
    fun 'dec_regCtrl-pkiPublicationInfo'/3;
getdec_internal_object_set_argument_8(Id) when Id =:= {1,3,6,1,5,5,7,5,1,4} ->
    fun 'dec_regCtrl-pkiArchiveOptions'/3;
getdec_internal_object_set_argument_8(Id) when Id =:= {1,3,6,1,5,5,7,5,1,5} ->
    fun 'dec_regCtrl-oldCertID'/3;
getdec_internal_object_set_argument_8(Id) when Id =:= {1,3,6,1,5,5,7,5,1,6} ->
    fun 'dec_regCtrl-protocolEncrKey'/3;
getdec_internal_object_set_argument_8(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_7
%%================================
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,9} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-SubjectDirectoryAttributes'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,14} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-SubjectKeyIdentifier'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,15} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-KeyUsage'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,16} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-PrivateKeyUsagePeriod'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,17} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-SubjectAltName'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,18} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-IssuerAltName'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,19} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-BasicConstraints'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,30} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-NameConstraints'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,31} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-CRLDistributionPoints'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,32} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-CertificatePolicies'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,33} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-PolicyMappings'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,35} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-AuthorityKeyIdentifier'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,36} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-PolicyConstraints'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,37} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-ExtKeyUsage'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,46} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-FreshestCRL'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,54} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-InhibitAnyPolicy'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {1,3,6,1,5,5,7,1,1} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-AuthorityInfoAccess'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {1,3,6,1,5,5,7,1,11} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-SubjectInfoAccessSyntax'(T,V,O) end;
getenc_internal_object_set_argument_7(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,9} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-SubjectDirectoryAttributes'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,14} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-SubjectKeyIdentifier'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,15} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-KeyUsage'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,16} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-PrivateKeyUsagePeriod'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,17} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-SubjectAltName'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,18} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-IssuerAltName'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,19} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-BasicConstraints'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,30} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-NameConstraints'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,31} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-CRLDistributionPoints'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,32} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-CertificatePolicies'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,33} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-PolicyMappings'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,35} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-AuthorityKeyIdentifier'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,36} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-PolicyConstraints'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,37} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-ExtKeyUsage'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,46} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-FreshestCRL'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,54} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-InhibitAnyPolicy'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {1,3,6,1,5,5,7,1,1} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-AuthorityInfoAccess'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {1,3,6,1,5,5,7,1,11} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-SubjectInfoAccessSyntax'(T,V,O) end;
getdec_internal_object_set_argument_7(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_6
%%================================
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,9} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-SubjectDirectoryAttributes'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,14} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-SubjectKeyIdentifier'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,15} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-KeyUsage'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,16} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-PrivateKeyUsagePeriod'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,17} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-SubjectAltName'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,18} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-IssuerAltName'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,19} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-BasicConstraints'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,30} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-NameConstraints'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,31} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-CRLDistributionPoints'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,32} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-CertificatePolicies'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,33} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-PolicyMappings'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,35} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-AuthorityKeyIdentifier'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,36} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-PolicyConstraints'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,37} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-ExtKeyUsage'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,46} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-FreshestCRL'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,54} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-InhibitAnyPolicy'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {1,3,6,1,5,5,7,1,1} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-AuthorityInfoAccess'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {1,3,6,1,5,5,7,1,11} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-SubjectInfoAccessSyntax'(T,V,O) end;
getenc_internal_object_set_argument_6(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,9} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-SubjectDirectoryAttributes'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,14} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-SubjectKeyIdentifier'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,15} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-KeyUsage'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,16} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-PrivateKeyUsagePeriod'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,17} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-SubjectAltName'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,18} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-IssuerAltName'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,19} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-BasicConstraints'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,30} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-NameConstraints'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,31} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-CRLDistributionPoints'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,32} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-CertificatePolicies'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,33} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-PolicyMappings'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,35} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-AuthorityKeyIdentifier'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,36} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-PolicyConstraints'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,37} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-ExtKeyUsage'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,46} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-FreshestCRL'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,54} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-InhibitAnyPolicy'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {1,3,6,1,5,5,7,1,1} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-AuthorityInfoAccess'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {1,3,6,1,5,5,7,1,11} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-SubjectInfoAccessSyntax'(T,V,O) end;
getdec_internal_object_set_argument_6(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_2
%%================================
getenc_internal_object_set_argument_2(Id) when Id =:= {1,2,840,10040,4,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-dsaWithSHA1'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {1,2,840,10045,4,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA1'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {1,2,840,10045,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA224'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {1,2,840,10045,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA256'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {1,2,840,10045,4,3,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA384'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {1,2,840,10045,4,3,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA512'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {1,2,840,113549,1,1,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithMD2'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {1,2,840,113549,1,1,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithMD5'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {1,2,840,113549,1,1,5} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithSHA1'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {1,2,840,113549,1,1,10} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'enc_sa-rsaSSA-PSS'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {2,16,840,1,101,3,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-dsaWithSHA224'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {2,16,840,1,101,3,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-dsaWithSHA256'(T,V,O) end;
getenc_internal_object_set_argument_2(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_2(Id) when Id =:= {1,2,840,10040,4,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-dsaWithSHA1'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {1,2,840,10045,4,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA1'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {1,2,840,10045,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA224'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {1,2,840,10045,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA256'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {1,2,840,10045,4,3,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA384'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {1,2,840,10045,4,3,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA512'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {1,2,840,113549,1,1,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithMD2'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {1,2,840,113549,1,1,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithMD5'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {1,2,840,113549,1,1,5} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithSHA1'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {1,2,840,113549,1,1,10} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'dec_sa-rsaSSA-PSS'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {2,16,840,1,101,3,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-dsaWithSHA224'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {2,16,840,1,101,3,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-dsaWithSHA256'(T,V,O) end;
getdec_internal_object_set_argument_2(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_12
%%================================
getenc_internal_object_set_argument_12(Id) when Id =:= {1,2,840,10040,4,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-dsaWithSHA1'(T,V,O) end;
getenc_internal_object_set_argument_12(Id) when Id =:= {1,2,840,10045,4,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA1'(T,V,O) end;
getenc_internal_object_set_argument_12(Id) when Id =:= {1,2,840,10045,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA224'(T,V,O) end;
getenc_internal_object_set_argument_12(Id) when Id =:= {1,2,840,10045,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA256'(T,V,O) end;
getenc_internal_object_set_argument_12(Id) when Id =:= {1,2,840,10045,4,3,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA384'(T,V,O) end;
getenc_internal_object_set_argument_12(Id) when Id =:= {1,2,840,10045,4,3,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA512'(T,V,O) end;
getenc_internal_object_set_argument_12(Id) when Id =:= {1,2,840,113549,1,1,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithMD2'(T,V,O) end;
getenc_internal_object_set_argument_12(Id) when Id =:= {1,2,840,113549,1,1,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithMD5'(T,V,O) end;
getenc_internal_object_set_argument_12(Id) when Id =:= {1,2,840,113549,1,1,5} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithSHA1'(T,V,O) end;
getenc_internal_object_set_argument_12(Id) when Id =:= {1,2,840,113549,1,1,10} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'enc_sa-rsaSSA-PSS'(T,V,O) end;
getenc_internal_object_set_argument_12(Id) when Id =:= {2,16,840,1,101,3,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-dsaWithSHA224'(T,V,O) end;
getenc_internal_object_set_argument_12(Id) when Id =:= {2,16,840,1,101,3,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-dsaWithSHA256'(T,V,O) end;
getenc_internal_object_set_argument_12(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_12(Id) when Id =:= {1,2,840,10040,4,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-dsaWithSHA1'(T,V,O) end;
getdec_internal_object_set_argument_12(Id) when Id =:= {1,2,840,10045,4,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA1'(T,V,O) end;
getdec_internal_object_set_argument_12(Id) when Id =:= {1,2,840,10045,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA224'(T,V,O) end;
getdec_internal_object_set_argument_12(Id) when Id =:= {1,2,840,10045,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA256'(T,V,O) end;
getdec_internal_object_set_argument_12(Id) when Id =:= {1,2,840,10045,4,3,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA384'(T,V,O) end;
getdec_internal_object_set_argument_12(Id) when Id =:= {1,2,840,10045,4,3,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA512'(T,V,O) end;
getdec_internal_object_set_argument_12(Id) when Id =:= {1,2,840,113549,1,1,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithMD2'(T,V,O) end;
getdec_internal_object_set_argument_12(Id) when Id =:= {1,2,840,113549,1,1,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithMD5'(T,V,O) end;
getdec_internal_object_set_argument_12(Id) when Id =:= {1,2,840,113549,1,1,5} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithSHA1'(T,V,O) end;
getdec_internal_object_set_argument_12(Id) when Id =:= {1,2,840,113549,1,1,10} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'dec_sa-rsaSSA-PSS'(T,V,O) end;
getdec_internal_object_set_argument_12(Id) when Id =:= {2,16,840,1,101,3,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-dsaWithSHA224'(T,V,O) end;
getdec_internal_object_set_argument_12(Id) when Id =:= {2,16,840,1,101,3,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-dsaWithSHA256'(T,V,O) end;
getdec_internal_object_set_argument_12(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_10
%%================================
getenc_internal_object_set_argument_10({1,2,840,113533,7,66,13}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Params' ->
            'enc_PBMParameter'(Val)
      end
   end;
getenc_internal_object_set_argument_10(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_internal_object_set_argument_10'({1,2,840,113533,7,66,13}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Params' ->
            'dec_PBMParameter'(Bytes)
      end
   end;
getdec_internal_object_set_argument_10(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.



%%%
%%% Run-time functions.
%%%

'dialyzer-suppressions'(Arg) ->
    ok.

is_default_1(asn1_DEFAULT) ->
true;
is_default_1(Def) when Def =:= false ->
true;
is_default_1(_) ->
false.


ber_decode_nif(B) ->
    asn1rt_nif:decode_ber_tlv(B).

ber_encode([Tlv]) ->
    ber_encode(Tlv);
ber_encode(Tlv) when is_binary(Tlv) ->
    Tlv;
ber_encode(Tlv) ->
    asn1rt_nif:encode_ber_tlv(Tlv).

collect_parts(TlvList) ->
    collect_parts(TlvList, []).

collect_parts([{_, L} | Rest], Acc) when is_list(L) ->
    collect_parts(Rest, [collect_parts(L) | Acc]);
collect_parts([{3, <<Unused,Bits/binary>>} | Rest], _Acc) ->
    collect_parts_bit(Rest, [Bits], Unused);
collect_parts([{_T, V} | Rest], Acc) ->
    collect_parts(Rest, [V | Acc]);
collect_parts([], Acc) ->
    list_to_binary(lists:reverse(Acc)).

collect_parts_bit([{3, <<Unused,Bits/binary>>} | Rest], Acc, Uacc) ->
    collect_parts_bit(Rest, [Bits | Acc], Unused + Uacc);
collect_parts_bit([], Acc, Uacc) ->
    list_to_binary([Uacc | lists:reverse(Acc)]).

dec_subidentifiers(<<>>, _Av, Al) ->
    lists:reverse(Al);
dec_subidentifiers(<<1:1,H:7,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, Av bsl 7 + H, Al);
dec_subidentifiers(<<H,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, 0, [Av bsl 7 + H | Al]).

decode_UTF8_string(Tlv, TagsIn) ->
    Val = match_tags(Tlv, TagsIn),
    case Val of
        [_ | _] = PartList ->
            collect_parts(PartList);
        Bin ->
            Bin
    end.

decode_boolean(Tlv, TagIn) ->
    Val = match_tags(Tlv, TagIn),
    case Val of
        <<0:8>> ->
            false;
        <<_:8>> ->
            true;
        _ ->
            exit({error, {asn1, {decode_boolean, Val}}})
    end.

decode_integer(Tlv, TagIn) ->
    Bin = match_tags(Tlv, TagIn),
    Len = byte_size(Bin),
    <<Int:Len/signed-unit:8>> = Bin,
    Int.

decode_native_bit_string(Buffer, Tags) ->
    case match_and_collect(Buffer, Tags) of
        <<0>> ->
            <<>>;
        <<Unused,Bits/binary>> ->
            Size = bit_size(Bits) - Unused,
            <<Val:Size/bitstring,_:Unused/bitstring>> = Bits,
            Val
    end.

decode_null(Tlv, Tags) ->
    Val = match_tags(Tlv, Tags),
    case Val of
        <<>> ->
            'NULL';
        _ ->
            exit({error, {asn1, {decode_null, Val}}})
    end.

decode_object_identifier(Tlv, Tags) ->
    Val = match_tags(Tlv, Tags),
    [AddedObjVal | ObjVals] = dec_subidentifiers(Val, 0, []),
    {Val1, Val2} =
        if
            AddedObjVal < 40 ->
                {0, AddedObjVal};
            AddedObjVal < 80 ->
                {1, AddedObjVal - 40};
            true ->
                {2, AddedObjVal - 80}
        end,
    list_to_tuple([Val1, Val2 | ObjVals]).

decode_octet_string(Tlv, TagsIn) ->
    Bin = match_and_collect(Tlv, TagsIn),
    binary:copy(Bin).

decode_open_type(Tlv, TagIn) ->
    case match_tags(Tlv, TagIn) of
        Bin when is_binary(Bin) ->
            {InnerTlv, _} = ber_decode_nif(Bin),
            InnerTlv;
        TlvBytes ->
            TlvBytes
    end.

dynamicsort_SETOF(ListOfEncVal) ->
    BinL =
        lists:map(fun(L) when is_list(L) ->
                         list_to_binary(L);
                     (B) ->
                         B
                  end,
                  ListOfEncVal),
    lists:sort(BinL).

e_object_identifier({'OBJECT IDENTIFIER', V}) ->
    e_object_identifier(V);
e_object_identifier(V) when is_tuple(V) ->
    e_object_identifier(tuple_to_list(V));
e_object_identifier([E1, E2 | Tail]) ->
    Head = 40 * E1 + E2,
    {H, Lh} = mk_object_val(Head),
    {R, Lr} = lists:mapfoldl(fun enc_obj_id_tail/2, 0, Tail),
    {[H | R], Lh + Lr}.

enc_obj_id_tail(H, Len) ->
    {B, L} = mk_object_val(H),
    {B, Len + L}.

encode_UTF8_string(UTF8String, TagIn) when is_binary(UTF8String) ->
    encode_tags(TagIn, UTF8String, byte_size(UTF8String));
encode_UTF8_string(UTF8String, TagIn) ->
    encode_tags(TagIn, UTF8String, length(UTF8String)).

encode_boolean(true, TagIn) ->
    encode_tags(TagIn, [255], 1);
encode_boolean(false, TagIn) ->
    encode_tags(TagIn, [0], 1);
encode_boolean(X, _) ->
    exit({error, {asn1, {encode_boolean, X}}}).

encode_integer(Val) ->
    Bytes =
        if
            Val >= 0 ->
                encode_integer_pos(Val, []);
            true ->
                encode_integer_neg(Val, [])
        end,
    {Bytes, length(Bytes)}.

encode_integer(Val, NamedNumberList, Tag) when is_atom(Val) ->
    case lists:keyfind(Val, 1, NamedNumberList) of
        {_, NewVal} ->
            encode_tags(Tag, encode_integer(NewVal));
        _ ->
            exit({error, {asn1, {encode_integer_namednumber, Val}}})
    end;
encode_integer(Val, _NamedNumberList, Tag) ->
    encode_tags(Tag, encode_integer(Val)).

encode_integer(Val, Tag) when is_integer(Val) ->
    encode_tags(Tag, encode_integer(Val));
encode_integer(Val, _Tag) ->
    exit({error, {asn1, {encode_integer, Val}}}).

encode_integer_neg(-1, [B1 | _T] = L) when B1 > 127 ->
    L;
encode_integer_neg(N, Acc) ->
    encode_integer_neg(N bsr 8, [N band 255 | Acc]).

encode_integer_pos(0, [B | _Acc] = L) when B < 128 ->
    L;
encode_integer_pos(N, Acc) ->
    encode_integer_pos(N bsr 8, [N band 255 | Acc]).

encode_length(L) when L =< 127 ->
    {[L], 1};
encode_length(L) ->
    Oct = minimum_octets(L),
    Len = length(Oct),
    if
        Len =< 126 ->
            {[128 bor Len | Oct], Len + 1};
        true ->
            exit({error, {asn1, too_long_length_oct, Len}})
    end.

encode_null(_Val, TagIn) ->
    encode_tags(TagIn, [], 0).

encode_object_identifier(Val, TagIn) ->
    encode_tags(TagIn, e_object_identifier(Val)).

encode_open_type(Val, T) when is_list(Val) ->
    encode_open_type(list_to_binary(Val), T);
encode_open_type(Val, Tag) ->
    encode_tags(Tag, Val, byte_size(Val)).

encode_restricted_string(OctetList, TagIn) when is_binary(OctetList) ->
    encode_tags(TagIn, OctetList, byte_size(OctetList));
encode_restricted_string(OctetList, TagIn) when is_list(OctetList) ->
    encode_tags(TagIn, OctetList, length(OctetList)).

encode_tags(TagIn, {BytesSoFar, LenSoFar}) ->
    encode_tags(TagIn, BytesSoFar, LenSoFar).

encode_tags([Tag | Trest], BytesSoFar, LenSoFar) ->
    {Bytes2, L2} = encode_length(LenSoFar),
    encode_tags(Trest,
                [Tag, Bytes2 | BytesSoFar],
                LenSoFar + byte_size(Tag) + L2);
encode_tags([], BytesSoFar, LenSoFar) ->
    {BytesSoFar, LenSoFar}.

encode_unnamed_bit_string(Bits, TagIn) ->
    Unused = (8 - bit_size(Bits) band 7) band 7,
    Bin = <<Unused,Bits/bitstring,0:Unused>>,
    encode_tags(TagIn, Bin, byte_size(Bin)).

match_and_collect(Tlv, TagsIn) ->
    Val = match_tags(Tlv, TagsIn),
    case Val of
        [_ | _] = PartList ->
            collect_parts(PartList);
        Bin when is_binary(Bin) ->
            Bin
    end.

match_tags({T, V}, [T]) ->
    V;
match_tags({T, V}, [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, V}], [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, _V} | _] = Vlist, [T]) ->
    Vlist;
match_tags(Tlv, []) ->
    Tlv;
match_tags({Tag, _V} = Tlv, [T | _Tt]) ->
    exit({error, {asn1, {wrong_tag, {{expected, T}, {got, Tag, Tlv}}}}}).

minimum_octets(0, Acc) ->
    Acc;
minimum_octets(Val, Acc) ->
    minimum_octets(Val bsr 8, [Val band 255 | Acc]).

minimum_octets(Val) ->
    minimum_octets(Val, []).

mk_object_val(0, Ack, Len) ->
    {Ack, Len};
mk_object_val(Val, Ack, Len) ->
    mk_object_val(Val bsr 7, [Val band 127 bor 128 | Ack], Len + 1).

mk_object_val(Val) when Val =< 127 ->
    {[255 band Val], 1};
mk_object_val(Val) ->
    mk_object_val(Val bsr 7, [Val band 127], 1).

number2name(Int, NamedNumberList) ->
    case lists:keyfind(Int, 2, NamedNumberList) of
        {NamedVal, _} ->
            NamedVal;
        _ ->
            Int
    end.
