define(["exports","./../dom.js"],function(_exports,_dom){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,(_exports.default=function(){return babelHelpers.createClass(function TinyGesture(element,options){babelHelpers.classCallCheck(this,TinyGesture),this.element=element,this.touchStartX=null,this.touchStartY=null,this.touchEndX=null,this.touchEndY=null,this.touchMoveX=null,this.touchMoveY=null,this.velocityX=null,this.velocityY=null,this.longPressTimer=null,this.doubleTapTimer=null,this.doubleTapWaiting=!1,this.thresholdX=0,this.thresholdY=0,this.disregardVelocityThresholdX=0,this.disregardVelocityThresholdY=0,this.swipingHorizontal=!1,this.swipingVertical=!1,this.swipingDirection=null,this.swipedHorizontal=!1,this.swipedVertical=!1,this.handlers={touchstart:[],panstart:[],panmove:[],panend:[],swipeleft:[],swiperight:[],swipeup:[],swipedown:[],tap:[],doubletap:[],longpress:[]},this._onTouchStart=this.onTouchStart.bind(this),this._onTouchMove=this.onTouchMove.bind(this),this._onTouchEnd=this.onTouchEnd.bind(this),this.opts=Object.assign({},TinyGesture.defaults,options),_dom.default.addEventListener(this.element,"touchstart",this._onTouchStart,{passive:!0}),this.element.addEventListener("touchmove",this._onTouchMove),_dom.default.addEventListener(this.element,"touchend",this._onTouchEnd,{passive:!0})},[{key:"destroy",value:function(){var _a;_dom.default.removeEventListener(this.element,"touchstart",this._onTouchStart,{passive:!0}),this.element.removeEventListener("touchmove",this._onTouchMove),_dom.default.removeEventListener(this.element,"touchend",this._onTouchEnd,{passive:!0}),clearTimeout(null!=(_a=this.longPressTimer)?_a:void 0),clearTimeout(null!=(_a=this.doubleTapTimer)?_a:void 0)}},{key:"on",value:function(type,fn){var _this=this;if(this.handlers[type])return this.handlers[type].push(fn),{type:type,fn:fn,cancel:function(){return _this.off(type,fn)}}}},{key:"off",value:function(type,fn){this.handlers[type]&&-1!==(fn=this.handlers[type].indexOf(fn))&&this.handlers[type].splice(fn,1)}},{key:"fire",value:function(type,event){for(var i=0;i<this.handlers[type].length;i++)this.handlers[type][i](event)}},{key:"onTouchStart",value:function(event){var _this2=this;this.fire("touchstart",event),this.thresholdX=this.opts.threshold("x",this),this.thresholdY=this.opts.threshold("y",this),this.disregardVelocityThresholdX=this.opts.disregardVelocityThreshold("x",this),this.disregardVelocityThresholdY=this.opts.disregardVelocityThreshold("y",this),this.touchStartX=("mousedown"===event.type?event:event.changedTouches[0]).screenX,this.touchStartY=("mousedown"===event.type?event:event.changedTouches[0]).screenY,this.touchMoveX=null,this.touchMoveY=null,this.touchEndX=null,this.touchEndY=null,this.swipingDirection=null,this.longPressTimer=setTimeout(function(){return _this2.fire("longpress",event)},this.opts.longPressTime),this.fire("panstart",event)}},{key:"onTouchMove",value:function(event){var _b,_a;("mousemove"!==event.type||this.touchStartX&&null===this.touchEndX)&&(_a=("mousemove"===event.type?event:event.changedTouches[0]).screenX-(null!=(_a=this.touchStartX)?_a:0),this.velocityX=_a-(null!=(_b=this.touchMoveX)?_b:0),this.touchMoveX=_a,_a=("mousemove"===event.type?event:event.changedTouches[0]).screenY-(null!=(_b=this.touchStartY)?_b:0),this.velocityY=_a-(null!=(_b=this.touchMoveY)?_b:0),this.touchMoveY=_a,_b=Math.abs(this.touchMoveX),_a=Math.abs(this.touchMoveY),this.swipingHorizontal=_b>this.thresholdX,this.swipingVertical=_a>this.thresholdY,this.swipingDirection=_a<_b?this.swipingHorizontal?"horizontal":"pre-horizontal":this.swipingVertical?"vertical":"pre-vertical",Math.max(_b,_a)>this.opts.pressThreshold&&clearTimeout(null!=(_b=this.longPressTimer)?_b:void 0),this.fire("panmove",event))}},{key:"onTouchEnd",value:function(event){var _d,_a,absX,_c,absY,_this3=this;("mouseup"!==event.type||this.touchStartX&&null===this.touchEndX)&&(this.touchEndX=("mouseup"===event.type?event:event.changedTouches[0]).screenX,this.touchEndY=("mouseup"===event.type?event:event.changedTouches[0]).screenY,this.fire("panend",event),clearTimeout(null!=(_a=this.longPressTimer)?_a:void 0),_a=this.touchEndX-(null!=(_a=this.touchStartX)?_a:0),absX=Math.abs(_a),_c=this.touchEndY-(null!=(_c=this.touchStartY)?_c:0),absY=Math.abs(_c),absX>this.thresholdX||absY>this.thresholdY?(this.swipedHorizontal=this.opts.diagonalSwipes?Math.abs(_a/_c)<=this.opts.diagonalLimit:absY<=absX&&absX>this.thresholdX,this.swipedVertical=this.opts.diagonalSwipes?Math.abs(_c/_a)<=this.opts.diagonalLimit:absX<absY&&absY>this.thresholdY,this.swipedHorizontal&&(_a<0?((null!=(_d=this.velocityX)?_d:0)<-this.opts.velocityThreshold||_a<-this.disregardVelocityThresholdX)&&this.fire("swipeleft",event):((null!=(_d=this.velocityX)?_d:0)>this.opts.velocityThreshold||_a>this.disregardVelocityThresholdX)&&this.fire("swiperight",event)),this.swipedVertical&&(_c<0?((null!=(_d=this.velocityY)?_d:0)<-this.opts.velocityThreshold||_c<-this.disregardVelocityThresholdY)&&this.fire("swipeup",event):((null!=(_a=this.velocityY)?_a:0)>this.opts.velocityThreshold||_c>this.disregardVelocityThresholdY)&&this.fire("swipedown",event))):absX<this.opts.pressThreshold&&absY<this.opts.pressThreshold&&(this.doubleTapWaiting?(this.doubleTapWaiting=!1,clearTimeout(null!=(_d=this.doubleTapTimer)?_d:void 0),this.fire("doubletap",event)):(this.doubleTapWaiting=!0,this.doubleTapTimer=setTimeout(function(){return _this3.doubleTapWaiting=!1},this.opts.doubleTapTime),this.fire("tap",event))))}}])}()).defaults={threshold:function(type,_self){return Math.max(25,Math.floor(.15*("x"===type?_dom.default.getWindowSize().innerWidth:_dom.default.getWindowSize().innerHeight)))},velocityThreshold:10,disregardVelocityThreshold:function(type,self){return Math.floor(.5*("x"===type?self.element.clientWidth:self.element.clientHeight))},pressThreshold:8,diagonalSwipes:!1,diagonalLimit:Math.tan(.375*Math.PI),longPressTime:500,doubleTapTime:300}});