/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPTransactionIsolation;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.impl.AbstractDataSourceInfo;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCTransactionIsolation;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Version;

public class JDBCDataSourceInfo
extends AbstractDataSourceInfo {
    private static final Log log = Log.getLog(JDBCDataSourceInfo.class);
    public static final String TERM_SCHEMA = ModelMessages.model_jdbc_Schema;
    public static final String TERM_PROCEDURE = ModelMessages.model_jdbc_Procedure;
    public static final String TERM_CATALOG = ModelMessages.model_jdbc_Database;
    private final JDBCDataSource dataSource;
    private boolean readOnly;
    private boolean readOnlyData;
    private boolean readOnlyMetaData;
    private String databaseProductName;
    private String databaseProductVersion;
    private String driverName;
    private String driverVersion;
    private String schemaTerm;
    private String procedureTerm;
    private String catalogTerm;
    private boolean supportsTransactions;
    private final List<DBPTransactionIsolation> supportedIsolations;
    private boolean supportsReferences = true;
    private boolean supportsIndexes = true;
    private boolean supportsStoredCode = true;
    private boolean supportsBatchUpdates = false;
    private boolean supportsScroll;
    private boolean supportsViews = true;

    public JDBCDataSourceInfo(DBPDataSourceContainer container) {
        this.dataSource = (JDBCDataSource)container.getDataSource();
        this.readOnly = false;
        this.databaseProductName = "?";
        this.databaseProductVersion = "";
        this.driverName = container.getDriver().getName();
        this.driverVersion = "?";
        this.schemaTerm = TERM_SCHEMA;
        this.procedureTerm = TERM_PROCEDURE;
        this.catalogTerm = TERM_CATALOG;
        this.supportsBatchUpdates = false;
        this.supportsTransactions = false;
        this.supportedIsolations = new ArrayList<DBPTransactionIsolation>();
        this.supportedIsolations.add(0, JDBCTransactionIsolation.NONE);
        this.supportsScroll = true;
    }

    public JDBCDataSourceInfo(JDBCDatabaseMetaData metaData) {
        this.dataSource = metaData.getDataSource();
        if (!this.isIgnoreReadOnlyFlag()) {
            try {
                this.readOnly = metaData.isReadOnly();
            }
            catch (Throwable e) {
                JDBCDataSourceInfo.debugError(e);
                this.readOnly = false;
            }
        } else {
            this.readOnly = false;
        }
        try {
            this.databaseProductName = metaData.getDatabaseProductName();
        }
        catch (Throwable e) {
            JDBCDataSourceInfo.debugError(e);
            this.databaseProductName = "?";
        }
        try {
            this.databaseProductVersion = metaData.getDatabaseProductVersion();
        }
        catch (Throwable e) {
            JDBCDataSourceInfo.debugError(e);
        }
        try {
            String name = metaData.getDriverName();
            if (name != null) {
                this.driverName = name;
            }
        }
        catch (Throwable e) {
            JDBCDataSourceInfo.debugError(e);
            this.driverName = "?";
        }
        try {
            this.driverVersion = metaData.getDriverVersion();
        }
        catch (Throwable e) {
            JDBCDataSourceInfo.debugError(e);
            this.driverVersion = "?";
        }
        try {
            this.schemaTerm = this.makeTermString(metaData.getSchemaTerm(), TERM_SCHEMA);
        }
        catch (Throwable e) {
            JDBCDataSourceInfo.debugError(e);
            this.schemaTerm = TERM_SCHEMA;
        }
        try {
            this.procedureTerm = this.makeTermString(metaData.getProcedureTerm(), TERM_PROCEDURE);
        }
        catch (Throwable e) {
            JDBCDataSourceInfo.debugError(e);
            this.procedureTerm = TERM_PROCEDURE;
        }
        try {
            this.catalogTerm = this.makeTermString(metaData.getCatalogTerm(), TERM_CATALOG);
        }
        catch (Throwable e) {
            JDBCDataSourceInfo.debugError(e);
            this.catalogTerm = TERM_CATALOG;
        }
        try {
            this.supportsBatchUpdates = metaData.supportsBatchUpdates();
        }
        catch (Throwable e) {
            JDBCDataSourceInfo.debugError(e);
        }
        try {
            this.supportsTransactions = metaData.supportsTransactions();
        }
        catch (Throwable e) {
            JDBCDataSourceInfo.debugError(e);
            this.supportsTransactions = true;
        }
        this.supportedIsolations = new ArrayList<DBPTransactionIsolation>();
        if (this.supportsTransactions) {
            try {
                JDBCTransactionIsolation[] jDBCTransactionIsolationArray = JDBCTransactionIsolation.values();
                int n = jDBCTransactionIsolationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    JDBCTransactionIsolation txi = jDBCTransactionIsolationArray[n2];
                    if (metaData.supportsTransactionIsolationLevel(txi.getCode())) {
                        this.supportedIsolations.add(txi);
                    }
                    ++n2;
                }
            }
            catch (Throwable e) {
                JDBCDataSourceInfo.debugError(e);
            }
            if (!this.supportedIsolations.contains((Object)JDBCTransactionIsolation.NONE)) {
                this.supportedIsolations.add(0, JDBCTransactionIsolation.NONE);
            }
            this.addCustomTransactionIsolationLevels(this.supportedIsolations);
        }
        this.supportsScroll = true;
    }

    protected void addCustomTransactionIsolationLevels(List<DBPTransactionIsolation> isolations) {
    }

    protected boolean isIgnoreReadOnlyFlag() {
        return true;
    }

    private String makeTermString(String term, String defTerm) {
        return CommonUtils.isEmpty((String)term) ? defTerm : CommonUtils.capitalizeWord((String)term.toLowerCase());
    }

    public boolean isReadOnlyData() {
        return this.readOnly || this.readOnlyData;
    }

    protected void setReadOnlyData(boolean readOnly) {
        this.readOnlyData = readOnly;
    }

    public boolean isReadOnlyMetaData() {
        return this.readOnly || this.readOnlyMetaData;
    }

    protected void setReadOnlyMetaData(boolean readOnlyMetaData) {
        this.readOnlyMetaData = readOnlyMetaData;
    }

    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    public String getDatabaseProductVersion() {
        Version databaseVersion;
        if (CommonUtils.isEmpty((String)this.databaseProductVersion) && (databaseVersion = this.getDatabaseVersion()) != null) {
            return databaseVersion.toString();
        }
        return this.databaseProductVersion;
    }

    public Version getDatabaseVersion() {
        return this.dataSource.getDatabaseServerVersion();
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public String getSchemaTerm() {
        return this.schemaTerm;
    }

    public String getProcedureTerm() {
        return this.procedureTerm;
    }

    public String getCatalogTerm() {
        return this.catalogTerm;
    }

    public boolean supportsTransactions() {
        return this.supportsTransactions;
    }

    public boolean supportsSavepoints() {
        return false;
    }

    public boolean supportsReferentialIntegrity() {
        return this.supportsReferences;
    }

    public void setSupportsReferences(boolean supportsReferences) {
        this.supportsReferences = supportsReferences;
    }

    public boolean supportsIndexes() {
        return this.supportsIndexes;
    }

    public void setSupportsIndexes(boolean supportsIndexes) {
        this.supportsIndexes = supportsIndexes;
    }

    public boolean supportsViews() {
        return this.supportsViews;
    }

    public void setSupportsViews(boolean supportsViews) {
        this.supportsViews = supportsViews;
    }

    public boolean supportsStoredCode() {
        return this.supportsStoredCode;
    }

    public void setSupportsStoredCode(boolean supportsStoredCode) {
        this.supportsStoredCode = supportsStoredCode;
    }

    public Collection<DBPTransactionIsolation> getSupportedTransactionsIsolation() {
        return this.supportedIsolations;
    }

    public boolean supportsResultSetLimit() {
        return true;
    }

    public boolean supportsResultSetScroll() {
        return this.supportsScroll;
    }

    public boolean isDynamicMetadata() {
        return false;
    }

    public boolean supportsMultipleResults() {
        return false;
    }

    public boolean isMultipleResultsFetchBroken() {
        return false;
    }

    public DBSObjectType[] getSupportedObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE, RelationalObjectType.TYPE_VIEW, RelationalObjectType.TYPE_TABLE_COLUMN, RelationalObjectType.TYPE_VIEW_COLUMN, RelationalObjectType.TYPE_INDEX, RelationalObjectType.TYPE_CONSTRAINT, RelationalObjectType.TYPE_PROCEDURE, RelationalObjectType.TYPE_SEQUENCE, RelationalObjectType.TYPE_TRIGGER, RelationalObjectType.TYPE_DATA_TYPE};
    }

    public boolean supportsStatementBinding() {
        return true;
    }

    public void setSupportsResultSetScroll(boolean supportsScroll) {
        this.supportsScroll = supportsScroll;
    }

    public boolean supportsBatchUpdates() {
        return this.supportsBatchUpdates;
    }

    private static void debugError(Throwable e) {
        if (e.getMessage() == null) {
            log.debug((Object)e.getClass().getName());
        } else {
            log.debug((Object)(e.getClass().getName() + ": " + e.getMessage()));
        }
    }
}

