# (c) Copyright 2011, 2015. CodeWeavers, Inc.

import cxobjc

# for localization
from cxutils import cxgettext as _

class BottleWrapperBase(cxobjc.Proxy):

    STATUS_IMPORT = _(u"Needs import")

    def __init__(self, inName):
        cxobjc.Proxy.__init__(self)
        self._change_delegates = []
        self._bottle_info_ready = True
        self._property_dict = {}
        self.current_description = ""
        self.bottletemplate = ""
        self.up_to_date = False
        self.wine_prefix = None
        self.is_default = False
        self.control_panel_table = []
        self.installed_packages = {}

        self._control_panel_ready = True
        self._control_panel_table = []
        self._control_panel_off_thread_table = []

        self.name = inName
        self.changeablename = inName

        self._installed_packages = {}
        self.installedPackageValues = []
        self._installed_packages_off_thread = {}
        self._installed_packages_ready = True

        self.status = self.STATUS_IMPORT
        self.status_overrides = []

        self.is_managed = False
        self.marked_for_death = False

    # This is a special initializer for objc. It must always be called
    #  explicitly on the mac.
    def initWithName_(self, inName):
        self = cxobjc.Proxy.nsobject_init(self)
        if self is not None:
            self.__init__(inName)
        return self

    #pylint: disable=W0613
    def get_needs_update(self, updating=False):
        return False

    needs_update = property(get_needs_update)

    def get_can_edit(self):
        return False

    can_edit = property(get_can_edit)

    def get_can_run_commands(self):
        return False

    can_run_commands = property(get_can_run_commands)

    def get_needs_import(self):
        return True

    needs_import = property(get_needs_import)

    def get_is_active(self):
        return False

    is_active = property(get_is_active)

    # For ObjC:
    def is_running(self):
        return False

    def quit(self):
        return True

    def refresh_up_to_date(self):
        pass

    def force_quit(self):
        return True

    # Cancel shutdown is called to restore the status of a bottle
    #  to a non-deleting, non-dying, non-shutting-down status.
    def cancelShutdown(self):
        pass

    @cxobjc.python_method
    def add_change_delegate(self, delegate):
        self._change_delegates.append(delegate)

    @cxobjc.python_method
    def remove_change_delegate(self, delegate):
        self._change_delegates.remove(delegate)

    @cxobjc.python_method
    def get_bottle_info_ready(self):
        return self._bottle_info_ready

    @cxobjc.python_method
    def set_bottle_info_ready(self, inBool):
        self._bottle_info_ready = inBool
        for delegate in self._change_delegates:
            delegate.bottleChanged(self)

    bottle_info_ready = property(get_bottle_info_ready, set_bottle_info_ready)

    def _get_scope(self):
        if self.is_managed:
            return _("Published")
        return _("Private")


    scope = property(_get_scope)

    @cxobjc.python_method
    def get_control_panel_ready(self):
        return self._control_panel_ready

    @cxobjc.python_method
    def set_control_panel_ready(self, inBool):
        self._control_panel_ready = inBool
        for delegate in self._change_delegates:
            delegate.bottleChanged(self)

    control_panel_ready = property(get_control_panel_ready, set_control_panel_ready)

    @cxobjc.python_method
    def get_installed_packages_ready(self):
        return self._installed_packages_ready

    @cxobjc.python_method
    def set_installed_packages_ready(self, inBool):
        self._installed_packages_ready = inBool
        for delegate in self._change_delegates:
            delegate.bottleChanged(self)

    installed_packages_ready = property(get_installed_packages_ready, set_installed_packages_ready)

    def canInstall(self):
        return False

    @cxobjc.namedSelector(b'preLoadControlPanelInfo', b'v@:')
    def pre_load_control_panel_info(self):
        pass

    @cxobjc.namedSelector(b'loadControlPanelInfo', b'v@:')
    def load_control_panel_info(self):
        pass

    @cxobjc.namedSelector(b'preLoadInstalledApplications', b'v@:')
    def pre_load_installed_applications(self):
        pass

    @cxobjc.namedSelector(b'loadInstalledApplications', b'v@:')
    def load_installed_applications(self):
        pass

    @cxobjc.namedSelector(b'postLoadInstalledApplications', b'v@:')
    def post_load_installed_applications(self):
        pass

    @cxobjc.namedSelector(b'postLoadControlPanelInfo', b'v@:')
    def post_load_control_panel_info(self):
        pass
